extern q GC_wakeup_g_new();

/*
  datas for general utility with consumer object
*/

/****************
  suspension_reason

  shows result of the processing for consumer object.

  0: normal;
  1: GC request;
  other: the process is suspended. pointer of the reason of the prosess.
******************/
extern q suspension_reason;

/************
  rest_of_stream

  indicates the next hooked term. This variable is meaningful
  just `suspension_reason' is 0.

  0: normal;
  other: the next hooked term
**************/
extern q rest_of_stream;

/* 
  this function has replaced by G_suspend
  make new hook for object for gmethod.c
q make_new_hook_for_gobj();
*/

/*
  this function has not already used
struct goalrec *call_generic_new();
*/

extern q method_result;

#define GC_rappend(pref) G_rappend0(GC_CLASS_NAME(),pref)
#define GC_body(fa) G_body0(GC_CLASS_NAME(),fa)

extern q GC_MAKE_HOOK_VAR();

#ifdef __STDC__
#define GC_method_table1(class) class##_data_method_table
#else
#define GC_method_table1(class) class/**/_data_method_table
#endif

#define GC_method_table0(class) GC_method_table1(class)

#define GC_method_table GC_method_table0(GC_CLASS_NAME())

#define    GC_FAIL(errmsg)    fatal(errmsg)
#define    GC_SUCCEEDED       GENERIC_SUCCEEDED
#define    GC_GCREQUEST       GENERIC_GCREQUEST
#define    GC_RETURN      { method_result = 0; return(g_qp); }
#define    GC_RETURN_WITH_HOOK(x) \
     { \
       method_result = GC_SUCCEEDED; \
       rest_of_stream = x; \
       return(g_qp); \
      } 
#define    GC_RETURN_FROM_GENERIC \
     { if (G_ISREF(GC_TERM)) {GC_RETURN_WITH_HOOK(GC_TERM);} \
       else if (G_ISREF(G_CDR_OF(GC_TERM))) \
         {GC_RETURN_WITH_HOOK(G_CDR_OF(GC_TERM));} \
       else if (G_CDR_OF(GC_TERM) == NILATOM) { GC_TERMINATE;} \
       else { fatal("Illegal data"); } \
      }

#define GC_TERMINATE \
     { \
       method_result = GC_SUCCEEDED;\
       rest_of_stream = 0; \
       return(g_qp); \
      } 

#define GC_SUSPEND(var) \
     { \
       q newvar, tmp; \
       q argv[2]; \
       method_result = GC_SUCCEEDED; \
       G_MAKE_VAR(newvar); \
       rest_of_stream = newvar; \
       argv[0] = GC_TERM; \
       argv[1] = newvar; \
       tmp = GC_wakeup_g_new(2,argv,g_allocp); \
       GC_KL1_UNIFY(var,tmp); \
       return(g_qp); \
     }

/**************************************************/

#define GC_DEREF_AND_TEST(x, susp) \
{ \
  q temp0 = derefone(x); \
  if(!isref(temp0) || (x) != derefone(temp0)) { \
    (x) = temp0; \
  } else { \
    goto susp; \
  } \
}


#define GC_SWITCH_ON_TERM(cons,atomic,funct,dobj,susp) \
{ \
  while (1) { \
    if (!isstruct(GC_TERM)) { \
      if (atomicnotref(GC_TERM)) { \
	goto atomic; \
      } else { \
	q temp0 = derefone(GC_TERM); \
	if(isref(temp0) && (GC_TERM) == derefone(temp0)) { \
	  goto susp; \
	} else { \
	  (GC_TERM) = temp0; \
	} \
      } \
    } else if(functnotcons(GC_TERM)) {\
	if(isref(functor_of(GC_TERM))) { \
	  goto dobj; \
	} else {\
           goto funct; \
        } \
    } else goto cons; \
  } \
}

#define GC_SWITCH_ON_METHOD_BEFORE(atomic,list,functor,generic,susp,illegal_data) \
 while (1) {\
 switch(ptagof(GC_TERM)) { \
 case CONS: \
  { \
   q g_car = G_CAR_OF(GC_TERM); \
   switch(ptagof(g_car)) { \
   case ATOMIC: goto atomic; \
   case CONS: goto list; \
   case FUNCTOR: \
     if (isref(G_FUNCTOR_OF(g_car))) goto generic; \
     else goto functor; \
   default: \
     GC_SUSPEND(g_car); \
   } \
  } \
 case ATOMIC: \
  if (GC_TERM == NILATOM) { \
      GC_TERMINATE; \
  } else goto illegal_data; \
 case FUNCTOR: goto functor; \
 case VARREF: \
    GC_DEREF_AND_TEST(GC_TERM, susp); \
 default: goto illegal_data; \
 } \
}

#define GC_SWITCH_ON_ATOM_METHOD switch((unsigned long)(G_CAR_OF(GC_TERM)))

#define GC_ATOM_METHOD_CASE(atom) \
   case G_MAKESYM(atom): \
     { q g_car = G_CAR_OF(G_atom(GC_TERM)); \
         g_qp = GC_body(g_car) (GC_SELF,g_car,g_qp,g_allocp); \
       if (method_result) GC_SUSPEND(method_result); \
       GC_RETURN; \
     }

#define GC_SWITCH_ON_FUNCTOR_METHOD \
          switch((long)G_FUNCTOR_OF(G_CAR_OF(GC_TERM)))

#define GC_FUNCTOR_METHOD_CASE(fa) \
   case (long)G_MAKESYM(G_functor(fa)): \
     { q g_car = G_CAR_OF(GC_TERM); \
       g_qp = GC_body(fa) (GC_SELF,g_car,g_qp,g_allocp); \
       if (method_result) GC_SUSPEND(method_result); \
       break; \
     }

/***************************************************************************/

/* q x;*/
#define GC_GDEREF(x) \
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
          return(x); \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}

#define GC_method_goal &(predicate_consumer_xmethod_4)

#define GC_DEREF(x) \
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
	  method_result = x; \
	  return g_qp; \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}


#define GC_ALLOC_AREA(new,type,size) \
{ \
  q res; \
  G_HEAPALLOC_WITH_CHECK(new,size,type,g_allocp,res); \
  if(GD_GCREQUEST == res){ \
    struct goalrec *goal; \
    GC_MAKE_GENERIC_GOAL(&goal,new,g_method_functor,GC_ARGV,g_allocp); \
    G_PUSH_GOAL(goal); \
    GC_RETURN; \
  } \
}


#define GC_UNIFY(x,y)  g_qp = (struct goalrec *)do_unify(g_qp,x,y,g_allocp)

/**************************************************************************/

#define GCset_myself_for_new \
  q (*g_myself)() = GC_rappend(new)

#define GC_STD_DECL_FOR_NEW \
  G_STD_DECL; \
  GCset_myself_for_new


#define GCDEF_NEW() \
  q \
  GC_rappend(new) (GC_ARGC,GC_ARGV,g_allocp) \
    long GC_ARGC; \
    q GC_ARGV[]; \
    q *g_allocp;

#define GC_DEREF_FOR_NEW(x) \
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
          q var; \
          struct goalrec *goal; \
       	  G_MAKE_THE_NEW_GOAL(&var,&goal,g_myself,GC_ARGC,GC_ARGV,g_allocp); \
          G_SUSPEND((x),goal); \
          return(var); \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}


#define GCSET_NEWOBJ_FOR_NEW(newgobj,size) \
  { \
    q res; \
    G_HEAPALLOC_WITH_CHECK(newgobj,size,(GC_OBJ_TYPE *),g_allocp,res); \
    if(GC_GCREQUEST == res){ \
        q var; \
        struct goalrec *goal; \
        G_MAKE_THE_NEW_GOAL(&var,&goal,g_myself,GC_ARGC,GC_ARGV,g_allocp); \
        G_PUSH_GOAL_TO_SPECIAL_QUEUE(goal); \
        return(var); \
      } \
  newgobj->method_table = &GC_method_table; \
 }

#define GC_RETURN_FROM_NEW(x) return(x);


/****************************************************/
#define GC_SWITCH_ON_METHOD switch(g_method_functor)

#define GC_METHOD_CASE(fa) \
  case (long) G_functor(fa): \
  g_qp = (struct goalrec *) GC_body(fa) (GC_SELF,g_method_functor,GC_ARGV,g_qp,g_allocp); \
  break

#define GC_METHOD_CASE_DEFAULT \
  default: fatal("undefined method")

#define GCDEF_FUNCTOR_METHOD(fa) \
  static \
  struct goalrec * \
  GC_body(fa) (GC_SELF,GC_TERM,g_qp,g_allocp) \
    GC_OBJ_TYPE *GC_SELF; \
    q GC_TERM; \
    struct goalrec *g_qp; \
    q *g_allocp;

#define GCSET_NEWOBJ(newgobj) \
  { \
    GD_ALLOC_AREA(newgobj,(GC_OBJ_TYPE *),GC_OBJ_SIZE(GC_SELF)); \
    newgobj->method_table = GC_SELF->method_table; \
  }

#define GC_SUSPEND_GOAL(var,goal) GC_suspend_goal(var,goal,g_qp,g_allocp)
#define GCSET_UNIFY_GOAL(goalp,x,y) GC_make_unify_goal(goalp,x,y,g_allocp) 

#define GC_GSUCCESS GENERIC_SUCCEEDED
#define GC_GFAILURE    GENERIC_FAILED

#define GC_GRETURN(x) return((q) x)

#define GC_GFAIL return((q) GC_GFAILURE)
#define GC_GSUCCEED return((q) GC_GSUCCESS)

/**********************************************************************/

#define GCDEF_UNIFY() \
  static \
  struct goalrec *\
  GC_rappend(active_unify) (GC_SELF,GC_TERM,g_qp,g_allocp) \
    GC_OBJ_TYPE *GC_SELF; \
    q GC_TERM; \
    struct goalrec *g_qp; \
    q *g_allocp;

#define GCDEF_SEND() \
  static \
  struct goalrec *\
  GC_rappend(active_unify) (GC_SELF,GC_TERM,g_qp,g_allocp) \
    GC_OBJ_TYPE *GC_SELF; \
    q GC_TERM; \
    struct goalrec *g_qp; \
    q *g_allocp;

#ifdef  __STDC__
#define GC_PRINT(x) fprintf(g_fp,##x##)
#else
#define GC_PRINT(x) fprintf(g_fp,/**/x/**/)
#endif

#define GC_PUTC(x) fputc(x,g_fp)

#define GC_RETURN_FROM_PRINT return(1L)

#define GCDEF_PRINT() \
  static \
  long \
  GC_rappend(print) (GC_SELF,g_fp,g_depth,g_length) \
    GC_OBJ_TYPE *GC_SELF; \
    FILE *g_fp; \
    unsigned long g_depth; \
    unsigned long g_length;

#define GC_PRINT_KL1_TERMS(x,b,s) \
{ \
  int i; \
  general_print((((q *)(x))+(b)),g_fp,g_depth,g_length); \
  for(i=(b)+1; i<(b)+(s); i++){ \
    fprintf(g_fp,","); \
    general_print((((q *)(x))+i),g_fp,g_depth,g_length); \
  } \
}

/******************************************************************/

#define GCDEF_GC() \
 static \
  q * \
  GC_rappend(gc) (GC_SELF,g_allocp,g_sp) \
    GC_OBJ_TYPE *GC_SELF; \
    q *g_allocp; \
    q **g_sp;

#define GCSET_NEWOBJ_IN_NEWGEN(newobj) \
  { \
    unsigned long size = GC_OBJ_SIZE(GC_SELF); \
    if(g_allocp+size > heaplimit) fatal("not enough space collected"); \
    *g_allocp = (q) GC_SELF->method_table; \
    newobj = (GC_OBJ_TYPE *) g_allocp; \
    g_allocp += size; \
  }

#define GC_RETURN_FROM_GC(newgobj) \
{ \
  gcsp  = g_sp; \
  heapp = g_allocp; \
  return(((q *)(newgobj))); \
}

#define GCDEF_REGIST() \
  static \
  long \
  GC_rappend(regist) (GC_SELF,g_allocp) \
    GC_OBJ_TYPE *GC_SELF; \
    q *g_allocp;

#define GCDEF_DEALLOCATE() \
  static \
  long \
  GC_rappend(deallocate) (GC_SELF) \
    GC_OBJ_TYPE *GC_SELF;

#define GCDEF_CLOSE() \
  static \
  struct goalrec * \
  GC_rappend(close) (GC_SELF,g_qp) \
    GC_OBJ_TYPE *GC_SELF; \
    struct goalrec *g_qp;

#define GCDEF_GENERIC() \
static \
struct goalrec * \
 GC_rappend(active_unify) (GC_SELF,GC_TERM,g_qp,g_allocp) \
    GC_OBJ_TYPE *GC_SELF; \
    q GC_TERM; \
    struct goalrec *g_qp; \
    q *g_allocp;

/*******************************************/

#define GCSET_INTARG_FOR_NEW(var,argv_i) \
{ \
  GC_DEREF_FOR_NEW(argv_i); \
  if(!G_ISINT(argv_i)) GC_FAIL("not integer"); \
  (var) = G_INTVAL(argv_i); \
}

#define GCSET_INTARG(var,argv_i) \
{ \
  GC_DEREF(argv_i); \
  if(!G_ISINT(argv_i)) GC_FAIL("not integer"); \
  (var) = G_INTVAL(argv_i); \
}

#define GCSET_INTARG_WITHIN_RANGE(var,argv_i,llim,ulim) \
{ \
  GC_DEREF(argv_i); \
  if(!G_ISINT(argv_i)) GC_FAIL("not integer"); \
  (var) = G_INTVAL(argv_i); \
  if( (llim>(var)) || ((var)>=ulim) ) GC_FAIL("out of range"); \
}

#define GCSET_GINTARG_WITHIN_RANGE(var,x,from,to) \
{ \
  GC_GCEREF(x); \
  if(!G_ISINT(x)) GC_GFAIL; \
  var = G_INTVAL(x); \
  if( ((from)>var) || (var>=(to)) ) GC_GFAIL; \
}

#define GCSET_NEW_CONS(var)  heapalloc(var,2,makecons)

#define GCSET_VAR(self) self = G_MAKEREF(&self)

extern struct goalrec *do_unify();
#define GC_KL1_UNIFY(x,y) g_qp = do_unify(g_qp,(q)(x),(q)(y),g_allocp)
