%  (C)1992 Institute for New Generation Computer Technology
%  $BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B
%  (Read COPYRIGHT for detailed information)

:- op(700,xfx,:=).
:- op(700,xfx,\=).
:- op(100,yfx,@).

% If append is not a system defined predicate,
% then the following is necessary.
%
% append([],Y,Y):- !.
% append([A|X],Y,[A|Z]):- !, append(X,Y,Z).

rev(X,Y):- !, rev(X,[],Y).
rev([],D,D):- !.
rev([E|X],D,ND):- !, rev(X,[E|D],ND).

p2l(X,Y):-
    nonvar(X),
    X = (A,B),
    !,
    Y = [A|L1],
    p2l(B,L1).
p2l(A,[A]):-
    !.

l2p([A],A):-
    !.
l2p([A,B|X],(A,Y1)):-
    !,
    l2p([B|X],Y1).

l2v([],Y):-
    !,
    Y = {}.
l2v([A|X],Y):-
    !,
    l2p([A|X],YP),
    Y =..[{},YP].

v2l({},Y):-
    !,
    Y = [].
v2l(X,Y):-
    X =.. [{},XP],
    !,
    p2l(XP,Y).

eq_member(X,[Y|_]):- X == Y,!.
eq_member(X,[_|R]):- !, eq_member(X,R).


gcompile(InFile,OutFile,KL1OutFile):-
        gcompile([],InFile,OutFile,KL1OutFile).

gcompile(PSW,InFile,OutFile,KL1OutFile):-
    see(InFile),
    assert(gcomp(def,init,-1,0)),       % PName Arity RelClauseNo
    assert(gid(0)),
    repeat,
       read(X),
       r_proc(PSW,X),
    !,
    seen,
    tell(OutFile),
    write((:- module)),put(" "),write(user), put("."),nl,
    write((:- with_macro)),put(" "),write(pimos),put("."),nl,
    w_proc_head,
    nl,nl,
    repeat,
       w_proc,
    told,
    retract(gid(_)),
    tell(KL1OutFile),
    repeat,
       w_proc_kl1,
    told.

w_proc_head:-
    gdecl(clausedb(X,_,_)),
%   gdecl(clausedb(X,Y,_)),
    writeq((:- public X/12)),put("."),nl,
    fail.
w_proc_head.

w_proc:-
    retract(gcomp(clause,Formula)),
    !,
    p_clause(Formula),nl,
    fail.
w_proc.

w_proc_kl1:-
%   retract(gdecl(clausedb(X,_,Q))),
    retract(gdecl(clausedb(X,Y,Q))),
    !,
    writeq(clausedb(X,Y,Q)),put("."),nl,
    fail.
w_proc_kl1.


r_proc(PSW,end_of_file):-
    !,
    r_procz(PSW).
r_proc(PSW,(H:-G|B)):-
    p_clause((H:-G|B)),nl,
    !,
    r_proc2(PSW,H,G,B),
    !,
    fail.
r_proc(_,X):-
    write(X), nl,
    !,
    fail.

r_procz(PSW):-
    retract(gcomp(def,X,Y,Z)),
    r_procz_cond(PSW,X,Y,Z).

r_proc2(PSW,H,G,B):-
    functor(H,PName,PArity),
    retract(gcomp(def,X,Y,Z)),
    r_proc2_cond(PSW,X,Y,Z,PName,PArity,H,G,B).


r_procz_cond(_,_,-1,_):-
    !.
r_procz_cond(PSW,X,Y,Z):-
    conditional_compile(PSW,X,Y,Z).
%    parent_clause(X,Y,Z).
    

r_proc2_cond(_,X,Y,Z,X,Y,H,G,B):-               % defined clause
    !,
    Z1 is Z+1,
    assert(gcomp(def,X,Y,Z1)),
    assertz(gproc(X,Y,Z,H,G,B)).
%    comp_clause(X,Y,Z,H,G,B).
r_proc2_cond(_,_,-1,_,PName,PArity,H,G,B):-     % initial start
    !,
    assert(gcomp(def,PName,PArity,1)),
    assertz(gproc(PName,PArity,0,H,G,B)).
%    comp_clause(PName,PArity,0,H,G,B).
r_proc2_cond(PSW,X,Y,Z,PName,PArity,H,G,B):-    % new defined a clause
    !,
    conditional_compile(PSW,X,Y,Z),
%    parent_clause(X,Y,Z),
    assert(gcomp(def,PName,PArity,1)),
    assertz(gproc(PName,PArity,0,H,G,B)).
%    comp_clause(PName,PArity,0,H,G,B).

conditional_compile(PSW,X,Y,Z):-
        pre_check_clauses(PSW,X,Y),
        comp_proc,
        parent_clause(X,Y,Z),
        post_check_clauses,
        !,
        retract_all(gproc(_,_,_,_,_,_)),
        reassert_gcomp_clause,
        !.
conditional_compile(_,X,Y,Z):-
        comp_proc_indirect,
        parent_clause_indirect(X,Y,Z),
        retract_all(gproc(_,_,_,_,_,_)),
        !.

comp_proc:-
        gproc(X,Y,Z,H,G,B),
        comp_clause(X,Y,Z,H,G,B),
        fail.
comp_proc.

comp_proc_indirect:-
        gproc(X,Y,Z,H,G,B),
        comp_clause_indirect(X,Y,Z,H,G,B),
        fail.
comp_proc_indirect.

pre_check_clauses(PSW,PName,PArity):-
        eq_member(PName/PArity,PSW),
        !,
        fail.
pre_check_clauses(_,_,_).

post_check_clauses.
%post_check_clauses(PSW):-
%       gcomp(tentative,Formula),
%       var_classification(Formula,_,NONUNI),
%       list_len(NONUNI,MainOccurVarNum),
%       post_check_clauses_2(MainOccurVarNum,PSW),
%       !,
%       fail.
%post_check_clauses(_).
%
%post_check_clauses_2(MainOccurVarNum,PSW):-
%       MainOccurVarNum < PSW,
%       !,
%       fail.
%post_check_clauses_2(_,_).

retract_all(X):-
        retract(X),
        fail.
retract_all(_).

reassert_gcomp_clause:-
        retract(gcomp(tentative,Formula)),
        assertz(gcomp(clause,Formula)),
        fail.
reassert_gcomp_clause.
%%%
parent_clause(X,Y,Z):-
    pred_name(X,Z,NX),
    CHead=..[NX,PRes,ORes,OBody,ArgVect,Count,Result,GoalNx,
             BodyHead,BodyTail,Mem,NewMem,VP,NewVP,Load,PI],
    Formula0 =
    ( CHead :- ORes = true,
               OBody = body(VarL,GNum,GxHead,GxTail,LCount) |
               Result = true,
               Count = LCount,
               GoalNx = GNum,
               BodyHead = GxHead,
               BodyTail = GxTail,
               guard:activate_var(VarL,Mem,NewMem,VP,NewVP,PI) ),
    Formula01 =
    ( CHead :- PRes = false, ORes = false |
               Result = false,
               GoalNx = 0,
               Mem = NewMem,
               BodyHead = [],
               BodyTail = [],
               VP = NewVP ),
    Formula1 = otherwise,
    Formula2 =
    ( CHead :- true |
               Result = suspend,
               guard:susp_trans_top(X,Y,ArgVect,GoalNx,
               BodyHead,BodyTail,Mem,NewMem,VP,NewVP,PI) ),
    CHeadx =..[X,ArgVect,Count,Result,GNx,
               BodyH,BodyT,Mem,NewMem,VP,NewVP,Load,PI],
    pred_name(X,0,X0),
    CGoalx=..[X0,false,false,[],ArgVect,Count,Result,GNx,
              BodyH,BodyT,Mem,NewMem,VP,NewVP,Load,PI],
    Formula3 = (CHeadx :- true | CGoalx),
    assertz(gcomp(tentative,Formula0)),
    assertz(gcomp(tentative,Formula01)),
    assertz(gcomp(tentative,Formula1)),
    assertz(gcomp(tentative,Formula2)),
    assertz(gcomp(tentative,Formula3)),
    cl_decl(X,Y),
    !.
%%%

cl_decl(X,Y):-
    retract(gid(OQid)),
    Qid is OQid+1,
    assert(gid(Qid)),
    assertz(gdecl(clausedb(X,Y,OQid))),
    !.

comp_clause(X,Y,Z,H,G,B):-
        pred_name(X,Z,NX),
        p2l(G,GL),
% G wo List ni suru
        p2l(B,BL),
% B wo List ni suru
        initg(GL,GL2),
        init_ar(GL2,BL,GL_2,BL1),
        sep_id_var(H,H2,[],HVar,EqH,EqT),
%head ni uniq na variable ha HVar dearu.
        H2=..[_|H2_AList],
        head_wrap_list(H2_AList,H3_AList),
%H wo wrap suru. and variable ha param(_) de replace sareru.
%result ha H3_AList dearu.
        sep_var_body(B,HVar,[],OVList,[],_),
%B ni uniq na hensuu ha OVList to site erareru.
        wrap_pred_list(GL_2,WGL),
        EqT = WGL,
%G no list wo wrap suru.
        wrap_pred_list(BL1,WBL),
%B no list wo wrap suru.
        ov2refv(OVList,VDeclList,PI),
        list_len(WBL,NumG),
        body_goal_conv_list(WBL,Ct,GWBH,GWBT),
%WB no conversion
        l2v(H3_AList,H3_AVect),
        CHead=..[NX,PRes,ORes,OBody,V_arg,Count,Result,GoalNx,
                 BodyHead,BodyTail,Mem,NewMem,VP,NewVP,Load,PI],
        var_extract(EqH,[],GVar),
        new_param_adjust(H3_AVect,H4_AVect,GVar,PaVar,[]),
        body_adjust(EqH,PaVar,NewEqH),
        Z_1 is Z+1,
        pred_name(X,Z_1,NX1),
        CGoal_susp=..
        [NX1,suspend,Res,body(VDeclList,NumG,GWBH,GWBT,Ct),V_argII,
                 Count,Result,GoalNx,
                 BodyHead,BodyTail,Mem1,NewMem,VP,NewVP,Load,PI],
        CGoal_false=..[NX1,false,Res,body(VDeclList,NumG,GWBH,GWBT,Ct),V_argII,
                 Count,Result,GoalNx,
                 BodyHead,BodyTail,Mem1,NewMem,VP,NewVP,Load,PI],
        Formula0 =
        ( CHead :- ORes = true,
          OBody = body(VarL,GNum,GxHead,GxTail,LCount) |
          Result = true,
          Count = LCount,
          GNum = GoalNx,
          BodyHead = GxHead,
          BodyTail = GxTail,
          guard:activate_var(VarL,Mem,NewMem,VP,NewVP,PI) ),
        Formula01 =
        ( CHead :- PRes = false, ORes = false |
          guard:gsolve(Y,
          V_arg,
          H4_AVect,
          V_argII,
          NewEqH,Res,Mem,Mem1,Load,PI),
          CGoal_false ),
        Formula1 = otherwise,
        Formula2 =
        ( CHead :- true |
          guard:gsolve(Y,
          V_arg,
          H4_AVect,
          V_argII,
          NewEqH,Res,Mem,Mem1,Load,PI),
          CGoal_susp ),
        ( Z == 0,!,
        assertz(gcomp(tentative,Formula01));
        assertz(gcomp(tentative,Formula0)),
        assertz(gcomp(tentative,Formula01)),
        assertz(gcomp(tentative,Formula1)),
        assertz(gcomp(tentative,Formula2)) ),
        !.

new_param_adjust(X,Y,GV,VDH,VDT):-
        atom(X) ,!,
        Y = X, VDH = VDT.
new_param_adjust(X,Y,GV,VDH,VDT):-
        integer(X) ,!,
        Y = X, VDH = VDT.
new_param_adjust(param(X),Y,GV,VDH,VDT):-
        eq_member(X,GV),
        !,
        Y = param(Q,X), VDH = [var(X,Q)|VDT].
new_param_adjust(param(X),Y,GV,VDH,VDT):-
        !,
        Y = param(X), VDH = VDT.
new_param_adjust(X,Y,GV,VDH,VDT):-
        !,
        X =.. L,
        new_param_adjust_list(L,NL,GV,VDH,VDT),
        Y =.. NL.

new_param_adjust_list([],NL,GV,VDH,VDT):-
        !,
        NL = [], VDH = VDT.
new_param_adjust_list([A|X],NL,GV,VDH,VDT):-
        new_param_adjust(A,NA,GV,VDH,VDM),
        !,
        new_param_adjust_list(X,NX,GV,VDM,VDT),
        NL = [NA|NX].

parent_clause_indirect(X,Y,Z):-
    pred_name(X,Z,NX),
    CHead=..[NX,PRes,ORes,OBody,ArgVect,Count,Result,GoalNx,
             BodyHead,BodyTail,Mem,NewMem,VP,NewVP,Load,PI],
    Formula0 =
    ( CHead :- ORes = true,
               OBody = body(AreaSize,VarL,GNum,GxHead,LCount) |
               Result = true,
               Count = LCount,
               GoalNx = GNum,
               guard:indirect_activate_var(AreaSize,VarL,GxHead,
	       BodyHead,BodyTail,Mem,NewMem,VP,NewVP,PI) ),
    Formula01 =
    ( CHead :- PRes = false, ORes = false |
               Result = false,
               GoalNx = 0,
               Mem = NewMem,
               BodyHead = [],
               BodyTail = [],
               VP = NewVP ),
    Formula1 = otherwise,
    Formula2 =
    ( CHead :- true |
               Result = suspend,
               guard:susp_trans_top(X,Y,ArgVect,GoalNx,
               BodyHead,BodyTail,Mem,NewMem,VP,NewVP,PI) ),
    CHeadx =..[X,ArgVect,Count,Result,GNx,
               BodyH,BodyT,Mem,NewMem,VP,NewVP,Load,PI],
    pred_name(X,0,X0),
    CGoalx=..[X0,false,false,[],ArgVect,Count,Result,GNx,
              BodyH,BodyT,Mem,NewMem,VP,NewVP,Load,PI],
    Formula3 = (CHeadx :- true | CGoalx),
    assertz(gcomp(clause,Formula0)),
    assertz(gcomp(clause,Formula01)),
    assertz(gcomp(clause,Formula1)),
    assertz(gcomp(clause,Formula2)),
    assertz(gcomp(clause,Formula3)),
    cl_decl(X,Y),
    !.

comp_clause_indirect(X,Y,Z,H,G,B):-
        pred_name(X,Z,NX),
        p2l(G,GL),
% G wo List ni suru
        p2l(B,BL),
% B wo List ni suru
        initg(GL,GL2),
        init_ar(GL2,BL,GL_2,BL1),
        sep_id_var(H,H2,[],HVar,EqH,EqT),
%head ni uniq na variable ha HVar dearu.
        H2=..[_|H2_AList],
        head_wrap_list(H2_AList,H3_AList),
%H wo wrap suru. and variable ha param(_) de replace sareru.
%result ha H3_AList dearu.
        sep_var_body(B,HVar,[],OVList,[],_),
%B ni uniq na hensuu ha OVList to site erareru.
        wrap_pred_list(GL_2,WGL),
        EqT = WGL,
%G no list wo wrap suru.
        wrap_pred_list(BL1,WBL),
%B no list wo wrap suru.
        ov2refv(OVList,VDeclList,PI),
        list_len(WBL,NumG),
        body_goal_conv_list(WBL,Ct,GWBH,GWBT),
%WB no conversion
        l2v(H3_AList,H3_AVect),
        CHead=..[NX,PRes,ORes,OBody,V_arg,Count,Result,GoalNx,
                 BodyHead,BodyTail,Mem,NewMem,VP,NewVP,Load,PI],
        var_extract(EqH,[],GVar),
        new_param_adjust(H3_AVect,H4_AVect,GVar,PaVar,[]),
        body_adjust(EqH,PaVar,NewEqH),
        Z_1 is Z+1,
        pred_name(X,Z_1,NX1),!,
	ivset(VDeclList,Array,0,AreaSize),
	GWBT = [],
        CGoal_susp=..
        [NX1,suspend,Res,body(AreaSize,Array,NumG,GWBH,Ct),V_argII,
                 Count,Result,GoalNx,
                 BodyHead,BodyTail,Mem1,NewMem,VP,NewVP,Load,PI],
        CGoal_false=..[NX1,false,Res,body(AreaSize,Array,NumG,GWBH,Ct),V_argII,
                 Count,Result,GoalNx,
                 BodyHead,BodyTail,Mem1,NewMem,VP,NewVP,Load,PI],
        Formula0 =
        ( CHead :- ORes = true,
	OBody = body(ASz,Arry,GNum,GxHead,LCount) |
          Result = true,
          Count = LCount,
          GNum = GoalNx,
          guard:indirect_activate_var(ASz,Arry,GxHead,
	  BodyHead,BodyTail,Mem,NewMem,VP,NewVP,PI) ),
        Formula01 =
        ( CHead :- PRes = false, ORes = false |
          guard:gsolve(Y,
          V_arg,
          H4_AVect,
          V_argII,
          NewEqH,Res,Mem,Mem1,Load,PI),
          CGoal_false ),
        Formula1 = otherwise,
        Formula2 =
        ( CHead :- true |
          guard:gsolve(Y,
          V_arg,
          H4_AVect,
          V_argII,
          NewEqH,Res,Mem,Mem1,Load,PI),
          CGoal_susp ),
        ( Z == 0,!,
        assertz(gcomp(clause,Formula01));
        assertz(gcomp(clause,Formula0)),
        assertz(gcomp(clause,Formula01)),
        assertz(gcomp(clause,Formula1)),
        assertz(gcomp(clause,Formula2)) ),
        !.

ivset([],[],0,0):- !.
ivset([V|X],Array,Num,AreaSize):- !,
	ivset0([V|X],Array,Num,AreaSize).

ivset0([],_,Num,AreaSize):-
	!,
	AreaSize = Num.
ivset0([V|X],Array,Num,AreaSize):-
	!,
	V = indirect(Array,Num),
	Num1 is Num+1,
	ivset0(X,Array,Num1,AreaSize).

%%%%
extract_arg_to_indx([],Y):-
        !,
        Y = [].
extract_arg_to_indx([indirect(_,I)|X],[I|Y]):-
        !,
        extract_arg_to_indx(X,Y).

make_new_var_arg([],[],_,_):-
        !.
make_new_var_arg([A|X],[B|Y],TL,TL2):-
        eq_member(A,TL),
        !,
        make_new_var_arg_ident(TL,TL2,A,B),
        !,
        make_new_var_arg(X,Y,TL,TL2).
make_new_var_arg([A|X],[A|Y],TL,TL2):-
        !,
        make_new_var_arg(X,Y,TL,TL2).

make_new_var_arg_ident([],[],_,_):-
        !,
        fail.
make_new_var_arg_ident([U|_],[V|_],A,B):-
        U == A,
        !,
        B = V.
make_new_var_arg_ident([_|X],[_|Y],A,B):-
        !,
        make_new_var_arg_ident(X,Y,A,B).

gen_tag_to_arg(_,[],Y):-
        !,
        Y = [].
gen_tag_to_arg(I,[E|X],[num(I,E)|Y]):-
        I1 is I+1,!,
        gen_tag_to_arg(I1,X,Y).
        
vcheck([],_,E):-
        !,
        E = [].
vcheck([num(I,V)|X],A,E):-
        eq_member(V,A),
        E=[num(I,V)|Y],
        !,
        vcheck(X,A,Y).
vcheck([_|X],A,E):-
        !,
        vcheck(X,A,E).

tran_guard_vect_op([],_):-
        !.
tran_guard_vect_op([num(I,V)|X],A):-
        V = indirect(A,I),
        !,
        tran_guard_vect_op(X,A).

body_adjust(X,P,Y):-
        var(X),!,
        search_mem(var(X,Y),P,0,I),
        ( I == -1, !, true; X = Y ),
        !.
body_adjust(X,P,Y):-
        X=..[H|XL],!,
        map_body_adjust(XL,P,YL),
        Y=..[H|YL].

map_body_adjust([],_,Y):-
        !, Y = [].
map_body_adjust([Ex|X],P,[Ey|Y]):-
        body_adjust(Ex,P,Ey),!,
        map_body_adjust(X,P,Y).

param_adjust(X,Y,VDH,VDT):-
        var(X) ,!,
    Y = X, VDH = VDT.
param_adjust(X,Y,VDH,VDT):-
        atom(X) ,!,
    Y = X, VDH = VDT.
param_adjust(X,Y,VDH,VDT):-
        integer(X) ,!,
    Y = X, VDH = VDT.
param_adjust(param(X),Y,VDH,VDT):-
        !,
    Y = param(X,Q), VDH = [var(X,Q)|VDT].
param_adjust(X,Y,VDH,VDT):-
        !,
        X =.. L,
        param_adjust_list(L,NL,VDH,VDT),
        Y =.. NL.

param_adjust_list([],NL,VDH,VDT):-
        !,
        NL = [], VDH = VDT.
param_adjust_list([A|X],NL,VDH,VDT):-
        param_adjust(A,NA,VDH,VDM),
        !,
        param_adjust_list(X,NX,VDM,VDT),
        NL = [NA|NX].

body_var_adjust([],_,Y):-
        !,
        Y = [].
body_var_adjust([V|X],PaVar,Y):-
        search_mem(var(V,NewV),PaVar,0,I),
        ( I == -1,!,Y = [NewV|Y1]; Y = [V|Y1] ),
        !,
        body_var_adjust(X,PaVar,Y1).

search_mem(var(X,Name),[var(A,B)|_],_,I):-
        X == A,!, Name = B, I = -1.
search_mem(var(X,Name),[_|R],C,I):-
        C1 is C+1,!,search_mem(var(X,Name),R,C1,I).
search_mem(var(_,_),[],C,C).

var_list(0,[]):- !.
var_list(N,[_|R]):- N1 is N-1,!,var_list(N1,R).

list_len([],0):- !.
list_len([_|R],N):- !,list_len(R,N1),N is N1+1.

reduce_par([],[],_,[],[]):-
        !.
reduce_par([param(X)|Y],[X|V],GV,A,B):-
        eq_member(X,GV),
        A = [param(X)|A1], B = [X|B1],
        !,
        reduce_par(Y,V,GV,A1,B1).
reduce_par([param(X)|Y],[X|V],GV,A,B):-
        !,
        reduce_par(Y,V,GV,A,B).
reduce_par([X|Y],[U|V],GV,[X|A],[U|B]):-
        !,
        reduce_par(Y,V,GV,A,B).

% $1 is O_PName, $2 is Nat, $3 is N_PName
pred_name(X,Z,NX):-
    !,
    name(X,Xs), name(Z,Zs),
    name(tmp,Ls),
    append(Ls,[95|Xs],LXs),
    append(LXs,[95|Zs],NXs),
    name(NX,NXs).


initg([],        Y):-                  !, Y = [].
initg([true|X],  Y):-                  !, initg(X,Y ).
initg([A = A|X], Y):-                  !, initg(X,Y ).
initg([A < B|X], Y):- Y = [B > A|Y1],  !, initg(X,Y1).
initg([A =< B|X],Y):- Y = [B >= A|Y1], !, initg(X,Y1).
initg([E|X],     Y):- Y = [E|Y1],      !, initg(X,Y1).

init_ar(X,Y,Z,W):- !, X = Z, Y = W.

sep_id_var(X,Y,H,T):-
    sep_id_var(X,Y,[],_,H,T).

sep_id_var(X,Y,D,ND,H,T):-
    var(X),
    !,
    sep_id_var_2(X,Y,D,ND,H,T).
sep_id_var(X,Y,D,ND,H,T):-
    atom(X),
    !,
    Y = X, D = ND, H = T.
sep_id_var(X,Y,D,ND,H,T):-
    integer(X),
    !,
    Y = X, D = ND, H = T.
sep_id_var(X,Y,D,ND,H,T):-
    X =..[P|A],
    !,
    sep_id_var_list(A,NA,D,ND,H,T),
    Y =..[P|NA].

sep_id_var_list([],Y,D,ND,H,T):-
    !,
    Y = [], D = ND, H = T.
sep_id_var_list([A|X],Y,D,ND,H,T):-
    !,
    sep_id_var(A,NA,D,NDM,H,HM),
    sep_id_var_list(X,Y1,NDM,ND,HM,T),
    Y = [NA|Y1].

sep_id_var_2(X,Y,D,ND,H,T):-
    eq_member(X,D),
    !,
    H = [eq(X,Y)|T],
    D = ND.
sep_id_var_2(X,X,D,[X|D],H,H).


head_wrap(X,Y):-
    var(X),
    !,
    Y = param(X).
head_wrap(X,Y):-
    atom(X),
    !,
    Y = atom(X).
head_wrap(X,Y):-
    integer(X),
    !,
    Y = integer(X).
head_wrap([A|B],Y):-
    !,
    Y = list([NA|NB]),
    head_wrap(A,NA),
    !,
    head_wrap(B,NB).
head_wrap(X,Y):-
    X=..[{},A],
    !,
    Y = vector(NX),
    p2l(A,LA),
    head_wrap_list(LA,NLA),
    l2p(NLA,PNLA),
    NX=..[{},PNLA].
head_wrap(X,Y):-
    X=..[H|A],
    !,
    Y=vector(NX),
    head_wrap_list(A,NA),
    l2p([atom(H)|NA],PNA),
    NX=..[{},PNA].

head_wrap_list([],Y):- !, Y = [].
head_wrap_list([A|X],[NA|Y]):-
    head_wrap(A,NA),
    !,
    head_wrap_list(X,Y).


sep_var_body(X,HV,D,ND,B,NB):-
    var(X),
    !,
    sep_var_body_2(X,HV,D,ND,B,NB).
sep_var_body(X,_,D,ND,B,NB):-
    atom(X),
    !,
    D = ND, B = NB.
sep_var_body(X,HV,D,ND,B,NB):-
    X=..[_|A],
    !,
    sep_var_body_list(A,HV,D,ND,B,NB).

sep_var_body_list([],_,D,D,B,B):- !.
sep_var_body_list([A|L],HV,D,ND,B,NB):-
    sep_var_body(A,HV,D,DM,B,MB),
    !,
    sep_var_body_list(L,HV,DM,ND,MB,NB).

sep_var_body_2(X,HV,D,ND,B,NB):-
    eq_member(X,HV),
    !,
    D = ND,
    sep_var_body_3(X,B,NB).
sep_var_body_2(X,_,D,ND,B,B):-
    !,
    sep_var_body_3(X,D,ND).

sep_var_body_3(X,D,ND):-
    eq_member(X,D),
    !,
    D = ND.
sep_var_body_3(X,D,[X|D]).


wrap_pred_list([],Y):-
    !,
    Y = [].
wrap_pred_list([true|R],Y):-
    !,
    wrap_pred_list(R,Y).
wrap_pred_list([X|R],Y):-
    atom(X),
    !,
    Y = [X|Y1],
    wrap_pred_list(R,Y1).
wrap_pred_list([X@node(N)|R],Y):-
    atom(X),
    !,
    wrap(N,WN),
    Y = [X@node(WN)|Y1],
    wrap_pred_list(R,Y1).
wrap_pred_list([X@node(N)|R],Y):-
    X=..[P|A],
    wrap_list(A,NA),
    NX=..[P|NA],
    wrap(N,WN),
    Y = [NX@node(WN)|Y1],
    !,
    wrap_pred_list(R,Y1).
wrap_pred_list([X|R],Y):-
    X=..[P|A],
    wrap_list(A,NA),
    NX=..[P|NA],
    Y = [NX|Y1],
    !,
    wrap_pred_list(R,Y1).


wrap(X,Y):- var(X),!,Y = X.
wrap(X,Y):- atom(X),!, Y = atom(X).
wrap(X,Y):- integer(X),!, Y = integer(X).
wrap([A|B],Y):-
        !,
        Y = list([NA|NB]),
        wrap(A,NA),
        !,
        wrap(B,NB).
wrap(X,Y):-
        X=..[{},A],
        !,
        Y = vector(NX),
        p2l(A,LA),
        wrap_list(LA,NLA),
        l2p(NLA,PNLA),
        NX=..[{},PNLA].
wrap(X,Y):-
        X=..[H|A],
        !,
        Y=vector(NX),
        wrap_list(A,NA),
        l2p([atom(H)|NA],PNA),
        NX=..[{},PNA].

wrap_list([],Y):- !, Y = [].
wrap_list([A|X],[NA|Y]):-
        wrap(A,NA),
        !,
        wrap_list(X,Y).


ov2refv([],Y,_):-
    !,
    Y = [].
ov2refv([G|X],Y,PI):-
    !,
    G = ref(V,PI),
    Y = [V|Y1],
    ov2refv(X,Y1,PI).


body_goal_conv_list([],_,GWBH,GWBT):-
    !,
    GWBH = GWBT.
body_goal_conv_list([X = Y|R],Ct,GWBH,GWBT):-
    GWBH = [X = Y|GWBM],
    !,
    body_goal_conv_list(R,Ct,GWBM,GWBT).
body_goal_conv_list([X := Y|R],Ct,GWBH,GWBT):-
    GWBH = [X := Y|GWBM],
    !,
    body_goal_conv_list(R,Ct,GWBM,GWBT).
body_goal_conv_list([X@node(No)|R],Ct,GWBH,GWBT):-
    atom(X),
    GWBH = [goal(Ct,X,0,{},No)|GWBM],
    !,
    body_goal_conv_list(R,Ct,GWBM,GWBT).
body_goal_conv_list([X@node(No)|R],Ct,GWBH,GWBT):-
    X =..[_|Arg],
    functor(X,PName,Arity),
    l2v(Arg,ArgVect),
    GWBH = [goal(Ct,PName,Arity,ArgVect,No)|GWBM],
    !,
    body_goal_conv_list(R,Ct,GWBM,GWBT).
body_goal_conv_list([X|R],Ct,GWBH,GWBT):-
    atom(X),
    GWBH = [goal(Ct,X,0,{})|GWBM],
    !,
    body_goal_conv_list(R,Ct,GWBM,GWBT).
body_goal_conv_list([X|R],Ct,GWBH,GWBT):-
    X =..[_|Arg],
    functor(X,PName,Arity),
    l2v(Arg,ArgVect),
    GWBH = [goal(Ct,PName,Arity,ArgVect)|GWBM],
    !,
    body_goal_conv_list(R,Ct,GWBM,GWBT).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% uniquue variable is out of use !!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%var_classification(X,Uni,NonUni)

var_classification(X,Uni,NonUni):-
        !,
        var_extract(X,[],Vs),
        var_count(Vs,[],[],Uni,NonUni).

var_extract(X,D,ND):- var(X), !, ND = [X|D].
var_extract(X,D,ND):-
        X=..[_|XL],!,
        var_extract_list(XL,D,ND).
var_extract_list([],D,ND):-
        !,
        D = ND.
var_extract_list([X|Y],D,ND):-
        var_extract(X,D,MD),
        !,
        var_extract_list(Y,MD,ND).

var_count([],A,B,NA,NB):-
        !,
        var_uniq(B,[],NB2),
        rev(NB2,NB),
        var_diff(A,NB,[],NA).
var_count([X|Y],A,B,NA,NB):-
        eq_member(X,A),!,
        var_count(Y,A,[X|B],NA,NB).
var_count([X|Y],A,B,NA,NB):-
        !,
        var_count(Y,[X|A],B,NA,NB).

var_uniq([],A,B):-
        !,
        A = B.
var_uniq([X|Y],A,B):-
        eq_member(X,A),!,
        var_uniq(Y,A,B).
var_uniq([X|Y],A,B):-
        !,
        var_uniq(Y,[X|A],B).

var_diff([],_,B,NB):-
        !,
        NB = B.
var_diff([X|Y],A,B,NB):-
        eq_member(X,A),!,
        var_diff(Y,A,B,NB).
var_diff([X|Y],A,B,NB):-
        !,
        var_diff(Y,A,[X|B],NB).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% p_clause(i)::output 1st arg as any term
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
p_clause((H:-G|B)):-
        var_classification((H:-G|B),UNI,NONUNI),
        outp(H,UNI,NONUNI), tab(3), put(":"), put("-"),
        nl, p2l(G,GL), outp_pred_list(GL,UNI,NONUNI,3),
        tab(3), put("|"), nl, p2l(B,BL),
        outp_pred_list(BL,UNI,NONUNI,7), put("."), nl, !.
p_clause(H):-
        var_classification(H,UNI,NONUNI),
        outp(H,UNI,NONUNI), put("."), nl, !.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% outp(i,i,o)::output 1st arg as any term
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
outp(X,D,ND):- var(X),!,outp_cond(X,D,ND).
outp(X,_,_):- atom(X),!,writeq(X).
outp(X,_,_):- integer(X),!,write(X).
outp([A|X],D,ND):- put("["),outp_list([A|X],D,ND), put("]"), !.
outp(X,D,ND):-
    X=..[{},P], put("{"), para_outp(P,D,ND), put("}"), !.
outp(X=Y,D,ND):- outp(X,D,ND),tab(1),write(=),tab(1),outp(Y,D,ND),!.
outp(X:=Y,D,ND):- outp(X,D,ND),tab(1),write(:=),tab(1),outp(Y,D,ND),!.
outp(X,D,ND):- X=..[P|A], writeq(P), put("("),
    outp_list(A,D,ND), put(")"), !.
    
outp_list([A|X],D,ND):- var(X),!,outp(A,D,ND), put("|"), outp_cond(X,D,ND), !.
outp_list([A,B|X],D,ND):- outp(A,D,ND), put(","), outp_list([B|X],D,ND), !.
outp_list([A],D,ND):- outp(A,D,ND), !.
outp_list([A|X],D,ND):- outp(A,D,ND), put("|"), outp(X,D,ND), !.

para_outp(X,D,ND):- nonvar(X),X = (A,B),outp(A,D,ND),put(","),!,para_outp(B,D,ND).
para_outp(A,D,ND):- outp(A,D,ND), !.

outp_cond(X,D,_):-
        eq_member(X,D),!,
        write('_').
outp_cond(X,_,ND):-
        search_index(X,ND,0,Ix),!,
        name(Ix,Ns),append("X",Ns,XNs),name(Name,XNs),
        write(Name),!.

search_index(X,[E|_],C,I):-
        X == E,
        !,
        C = I.
search_index(X,[_|ND],C,I):-
        C1 is C+1,
        !,
        search_index(X,ND,C1,I).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% outp_clause(i,i,o)::output 1st arg as a clause,
%                     where 1st arg is (H:-G|B)
%                     2nd arg is var list, 3rd arg is new var list
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
outp_clause((H:-G|B),D,ND):-
    outp(H,D,ND), tab(3), put(":"), put("-"),
    nl, p2l(G,GL), outp_pred_list(GL,D,ND,3),
    tab(3), put("|"), nl, p2l(B,BL),
    outp_pred_list(BL,D,ND,7), put("."), nl, !.
outp_clause(H,D,ND):-
    outp(H,D,ND), put("."), nl, !.

outp_pred_list([A:B@P,C|X],D,ND,Tab):-
    tab(Tab),
    outp(A,D,ND), put(":"), outp(B,D,ND), put("@"),
    outp(P,D,ND), put(","),nl,
    !,
    outp_pred_list([C|X],D,ND,Tab).
outp_pred_list([A:B,C|X],D,ND,Tab):-
    tab(Tab),
    outp(A,D,ND), put(":"), outp(B,D,ND), put(","),nl,
    !,
    outp_pred_list([C|X],D,ND,Tab).
outp_pred_list([B@P,C|X],D,ND,Tab):-
    tab(Tab),
    outp(B,D,ND), put("@"), outp(P,D,ND), put(","), nl,
    !,
    outp_pred_list([C|X],D,ND,Tab).
outp_pred_list([B,C|X],D,ND,Tab):-
    tab(Tab),
    outp(B,D,ND), put(","), nl,
    !,
    outp_pred_list([C|X],D,ND,Tab).
outp_pred_list([A:B@P],D,ND,Tab):-
    tab(Tab),
    outp(A,D,ND), put(":"), outp(B,D,ND), put("@"),
    outp(P,D,ND), !.
outp_pred_list([A:B],D,ND,Tab):-
    tab(Tab),
    outp(A,D,ND), put(":"), outp(B,D,ND), !.
outp_pred_list([B@P],D,ND,Tab):-
    tab(Tab),
    outp(B,D,ND), put("@"),
    outp(P,D,ND), !.
outp_pred_list([A],D,ND,Tab):-
    tab(Tab),
    outp(A,D,ND), !.
