%----------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%-----------------------------------------------------------

%
%					*** KLIB UTILITIES ***
%
setenv klib:dutil_files = [
	"buffer.kl1","clist.kl1","dbm.kl1","list.kl1","lstack.kl1",
	"misc.kl1","pimosx.mac","random.kl1","short_circuit.kl1",
	"stream_list.kl1","stream_vector.kl1","vector.kl1","wclist.kl1"].
setenv klib:dutil_modules = [
	buffer,clist,dbm,list,lstack,
	misc,pimosx,random,short_circuit,stream_list,
	stream_vector,vector,wclist].

setenv klib:macro_files = ["loop.mac","xia.mac","klib.mac"].
setenv klib:macro_modules = [loop,xia,klib].

setenv klib:uutil_files  = ["combine.kl1","map.kl1","split.kl1"].
setenv klib:uutil_modules  = [combine,map,split].

%
%					*** KLIB FILES & MODULES ***
%
setenv klib:klib_files = [
	"LD_dhash.kl1","LD_network.kl1","LD_pa.kl1","LD_pm.kl1",
	"LD_srtc.kl1","LD_stb.kl1","LD_bb.kl1"
	].
setenv klib:klib_modules = [
	bb,dhash,network,pa,pm,srtc,stb
	].

%
%					*** SAMPLE PROBLEM FILES & MODULES ***
%
setenv klib:prob_files = [
	"p_queens.kl1","p_bt.kl1","p_inc.kl1","p_incdec.kl1",
	"p_8p.kl1","p_8pm.kl1","p_15p.kl1","p_15pm.kl1"
	].
setenv klib:prob_modules = [
	p_queens,p_bt,p_inc,p_incdec,p_8p,p_8pm,p_15p,p_15pm
	].

%
%					*** TEST FILES & MODULES ***
%
setenv klib:test_files = [
	"tdhash_1.kl1","tstb_queens.kl1","tbb_bt.kl1","tpa_inc.kl1",
	"tpa_incdec.kl1","tpa_8pm.kl1","tpa_15pm.kl1","tpm_0.kl1",
	"tpm_1.kl1","tsrtc_8p.kl1","tsrtc_15p.kl1"
	].
setenv klib:test_modules = [
	tdhash_1,tstb_queens,tbb_bt,tpa_inc,
	tpa_incdec,tpa_8pm,tpa_15pm,tpm_0,
	tpm_1,tsrtc_8p,tsrtc_15p
	].

alias(klib_compile(X),	(
	getenv(klib:X, normal(Y)),
	compile(Y))).
alias(klib_unload(X,Z),	(
	getenv(klib:X, normal(Y)),
	unload(Y,Z))).

alias(compile_UTIL,	(
	klib_compile(dutil_files);
	klib_compile(macro_files);
	klib_compile(uutil_files)
	)).
alias(unload_UTIL,	(
	getenv(klib:dutil_modules,normal(DUM)),
	getenv(klib:macro_modules,normal(FM)),
	getenv(klib:uutil_modules,normal(UUM)),
	list:append(DUM,FM,L1), list:append(L1,UUM,L2),
	unload(L2,"UTIL")
	)).
alias(load_UTIL,	load("UTIL")).

alias(compile_KLIB,	klib_compile(klib_files)).
alias(unload_KLIB,	klib_unload(klib_modules,"KLIB")).
alias(load_KLIB,	load("KLIB")).

alias(compile_PROB,	klib_compile(prob_files)).
alias(unload_PROB,	klib_unload(prob_modules,"PROB")).
alias(load_PROB,	load("PROB")).

alias(compile_TEST,	klib_compile(test_files)).
alias(unload_TEST,	klib_unload(test_modules,"TEST")).
alias(load_TEST,	load("TEST")).

%
%					*** COMPILE ALL ***
%
alias(compile_all,	(
	compile_UTIL;
	compile_KLIB;
	compile_PROB;
	compile_TEST)).

%
%					*** UNLOAD ALL ***
%
alias(unload_all,	(
	unload_UTIL;
	unload_KLIB;
	unload_PROB;
	unload_TEST)).

%
%					*** LOAD ALL ***
%
alias(load_all,	(
	load_UTIL;
	load_KLIB;
	load_PROB;
	load_TEST)).

