% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public variable/1.
:- mode variable(+).
variable([]) :- !,fail.
variable(X) :- atom(X),!,X\==t,!,X\==f,!,\+bottom_object(X),!,\+abbrev_(X,_),!.

:- public var_in_term/2.
%:- mode var_in_term(?,+).
var_in_term(V,V) :- variable(V).
%var_in_term(V,{X}) :- var_in_pterm(V,X).
var_in_term(V,[_|As]) :- var_in_args(V,As).

:- public var_in_args/2.
:- mode var_in_args(?,+).
var_in_args(V,[A|_]) :- var_in_term(V,A).
var_in_args(V,[_|As]) :- var_in_args(V,As).

:- mode var_in_pterm(?,+).
var_in_pterm(V,V) :- variable(V).
var_in_pterm(V,T) :- T=..[_|A], var_in_pterm_args(V,A).

:- mode var_in_pterm_args(?,+).
var_in_pterm_args(V,[A|_]) :- var_in_pterm(V,A).
var_in_pterm_args(V,[_|As]) :- var_in_pterm_args(V,As).

:- public vars_in_term/2.
:- mode	vars_in_term(+,?).
vars_in_term(X,[X]) :- variable(X),!.
vars_in_term([_|As],V) :- map_vars_in_term(As,V),!.
vars_in_term(_,[]).

:- public map_vars_in_term/2.
:- mode map_vars_in_term(+,?).
map_vars_in_term([H|T],V) :-
	vars_in_term(H,HV),
	map_vars_in_term(T,TV),
	union(HV,TV,V),!.
map_vars_in_term([],[]).

:- public distinct_variables/1.
:- mode distinct_variables(+).
distinct_variables([V|Vs]) :- (variable(V); var(V)),!,\+member(V,Vs),!, 
	distinct_variables(Vs),!.
distinct_variables([]).

:- public prolog_vars/1.
:- mode prolog_vars(+).
prolog_vars([V|Vs]) :- var(V),!,prolog_vars(Vs),!.
prolog_vars([]).

:- public new_vars/2.
:- mode new_vars(+,-).
new_vars(X,Y) :- assert(hack(X)), retract(hack(Y)),!.

:- public instantiate/2.
:- mode instantiate(+,-).
instantiate(X,Y) :- assert(hack(X)), retract(hack(Y)),!.

:- public p_vars/4.
:- mode p_vars(+,+,-,-).
p_vars(X,Y,U,V) :- length(X,N), generate_vars(1,N,U),!, p_vars0(X,Y,U,V),!.

:- mode p_vars0(+,+,+,-).
p_vars0(_,Y,_,Y) :- var(Y),!.
p_vars0(X,Y,U,V) :- atomic(Y),!, p_vars1(X,Y,U,V),!.
p_vars0(X,Y1:Y2,U,V1:V2) :- p_vars0(X,Y1,U,V1), p_vars0(X,Y2,U,V2),!.
p_vars0(X,Y1-Y2,U,V1-V2) :- p_vars0(X,Y1,U,V1), p_vars0(X,Y2,U,V2),!.
p_vars0(X,Y1=Y2,U,V1=V2) :- p_vars0(X,Y1,U,V1), p_vars0(X,Y2,U,V2),!.
p_vars0(X,(Y1->Y2),U,(V1->V2)) :- p_vars0(X,Y1,U,V1), p_vars0(X,Y2,U,V2),!.
p_vars0(_,[pack,X],_,[pack,X]).
p_vars0(X,[YA|YD],U,[VA|VD]) :- p_vars0(X,YA,U,VA),!, p_vars0(X,YD,U,VD),!.
p_vars0(_,[],_,[]) :- !.
p_vars0(X,{Y},U,{V}) :- Y=..[F|A], p_vars0(X,A,U,B), V=..[F|B],!.
p_vars0(X,Y,U,V) :- Y=..[F|A], p_vars0(X,A,U,B), V=..[F|B],!.
p_vars0(_,Y,_,Y) :- !.

:- mode p_vars1(+,+,+,-).
p_vars1([X|_],X,[U|_],U) :- !.
p_vars1([_|X],Y,[_|U],V) :- !, p_vars1(X,Y,U,V),!.
p_vars1(_,Y,_,Y) :- !.

:- public generate_vars/3.
:- mode generate_vars(+,+,-).
generate_vars(N,M,[_|Xs]) :- N=<M, !, N1 is N+1, generate_vars(N1,M,Xs),!.
generate_vars(_,_,[]) :- !.

:- public gen_var/1, gen_vars/2.
:- mode gen_var(?), gen_vars(+,-).
gen_var(V) :- next_var(VS), name(V,VS),
	\+bottom_object(V), V\==t, V\==f, \+abbrev_(V,_),
	\+used_variable(V),
	assertz(used_variable(V)),!.
gen_var(V) :- gen_var(V).

:- mode next_var(-).
next_var([V]) :- retract(var_seed([V])),
	((V1 is V+1, V1=<90, asserta(var_seed([V1])));
	 asserta(var_seed([66,49]))),!.
next_var([VS,VN]) :- retract(var_seed([VS,VN])),
	((VS1 is VS+1, VS1=<90, asserta(var_seed([VS1,VN])));
	 (VN1 is VN+1, asserta(var_seed([66,VN1])))),!.
next_var([65]) :- asserta(var_seed([65])),!.

gen_vars(0,[]) :- !.
gen_vars(N,[Vn|V]) :- gen_var(Vn), N1 is N-1, gen_vars(N1,V),!.

:- public rep_var/4.
:- mode rep_var(+,+,+,?).
rep_var(X,T,X,T):-!.
rep_var(X,T,[F|Args],[F|NewArgs]):- !,replace_var(X,T,Args,NewArgs).
rep_var(_,_,T,T).

:- public replace_var/4.
:- mode replace_var(+,+,+,?).
replace_var(X,T,[Top|Rest],[NewTop|NewRest]):-
	rep_var(X,T,Top,NewTop),
	replace_var(X,T,Rest,NewRest).
replace_var(_,_,[],[]).

% EOF var.pl
