% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public type_set/3.
:- mode type_set(+,-,+).

type_set(X,TS,Ass) :- ts_assumed(X,TS,Ass),!.

	:- mode ts_assumed(+,-,+).
	ts_assumed(X,TS,[X=TS|_]).
	ts_assumed(X,TS,[_|Ass]) :- ts_assumed(X,TS,Ass),!.

type_set([equal,_,_],3,_) :- !.
type_set(X,TS,Ass) :-
	(recognizer_constructor([R,X]);
	 recognizer_bottom([R,X]);
	 type_of_A([R,X]);
	 R=[X];
	 (rewrite_lemma([R,X],t,P,no,_,_),
	  establish(P,[Ass,[],[],0,tf],[],_,[],_,[],_))),
	bit_place(R,TS),!.

type_set(X,TS,Ass) :-
	rewrite_lemma([or,[R1,X]|Y],t,P,no,_,_),
	establish(P,[Ass,[],[],0,tf],[],_,[],_,[],_),
	tsa([[R1,X]|Y],0,X,TS),!.

:- public tsa/4.
:- mode tsa(+,+,+,-).
tsa([[R1,X]|Y],TSin,X,TS) :-
	bit_place(R1,TS1),
	ts_union(TSin,TS1,TSout),
	tsa(Y,TSout,X,TS),!.
tsa([],TS,_,TS).
	
type_set([if,T,L,R],TS,Ass) :- !,
	ts_assumption(T,Mustbe,Ass),!,
	((Mustbe=t,!,type_set(L,TS,Ass));
	 (Mustbe=f,!,type_set(R,TS,Ass));
	 (Mustbe=or(L_Ass,R_Ass),!,
		type_set(L,L_TS,L_Ass),!,
		type_set(R,R_TS,R_Ass),!,
		ts_union(L_TS,R_TS,TS))),!.

type_set(X,TS,Ass) :- recognizer(X),!,
	X=[R,Y],!,
	(bit_place(R,RTS);
	 (recognizer_constructor([R,C]), bit_place([C],RTS))),!,
	type_set(Y,YTS,Ass),!,
	((RTS=YTS,!,TS=2);
	 (ts_intersection(RTS,YTS,0),!,TS=1);
	 TS=3),!.
%			[implies,[R,X],[not,[R',X]]]

type_set([F|Args],TS,Ass) :-
	type_prescription([F|Args],tp(TS_F,Terms)),!,
	ts_args(Terms,TS_F,TS,Ass),!.

	:- mode ts_args(+,+,-,+).
	ts_args([T1|Terms],TSp,TS,Ass) :-
		type_set(T1,TS1,Ass),!,
		ts_union(TSp,TS1,TSn),!,
		ts_args(Terms,TSn,TS,Ass),!.
	ts_args([],TS,TS,_).

type_set(_,8'377777,_).

%
%	Assuming Expressions true or false
%

:- mode ts_assumption(+,-,+).

ts_assumption([not,X],A,Ass) :- !,ts_assumption(X,B,Ass),!,
	((B=t,!,A=f);
	 (B=f,!,A=t);
	 (B=or(L,R),!,A=or(R,L))),!.

ts_assumption(X,A,Ass) :- type_set(X,S,Ass), 
	((S=1,!,A=f) ; (S=2,!,A=t)),!.

ts_assumption([equal,T1,T2],Mustbe,Ass) :- !,
	type_set(T1,S1,Ass),!,
	type_set(T2,S2,Ass),!,
	ts_intersection(S1,S2,S),!,
	((S=0,!,Mustbe=f);
	 (S1=S2,bit_place([_],S),!,Mustbe=t);
	 (add_ts_assumption([[equal,T1,T2]=2,[equal,T2,T1]=2,T1=S,T2=S],
		Ass,L_Ass),!,
	  ((S1=S,bit_place([_],S),!,
	    ts_difference(S2,S1,S21),!,
	    add_ts_assumption([[equal,T1,T2]=1,[equal,T2,T1]=1,T2=S21],
		 	Ass,R_Ass)) ;
	   (S2=S,bit_place([_],S),!,
	    ts_difference(S1,S2,S12),!,
	    add_ts_assumption([[equal,T1,T2]=1,[equal,T2,T1]=1,T1=S12],
		 	Ass,R_Ass)) ;
	   add_ts_assumption([[equal,T1,T2]=1,[equal,T2,T1]=1],
			Ass,R_Ass)),
	  Mustbe=or(L_Ass,R_Ass))),!.

ts_assumption(X,Mustbe,Ass) :- recognizer(X),!,
	X=[R,Y],!,
	(bit_place(R,RTS);
	 (recognizer_constructor([R,C]), bit_place([C],RTS))),!,
	type_set(Y,YTS,Ass),!,
	((RTS=YTS,!,Mustbe=t);
	 (ts_intersection(RTS,YTS,0),!,Mustbe=f);
	 (ts_difference(YTS,RTS,Sd),!,
	  add_ts_assumption([Y=RTS],Ass,L_Ass),!,
	  add_ts_assumption([Y=Sd],Ass,R_Ass),!,
	  Mustbe=or(L_Ass,R_Ass))),!.

ts_assumption(X,Mustbe,Ass) :-
	type_set(X,S,Ass),!,
	((S=1,!,Mustbe=f);
	 (ts_intersection(S,1,0),!,Mustbe=t);
	 (ts_difference(S,1,Sd),!,
	  add_ts_assumption([X=Sd],Ass,L),!,
	  add_ts_assumption([X=1],Ass,R),!,
	  Mustbe=or(L,R))),!.

:- public add_ts_assumption/3.
:- mode add_ts_assumption(+,+,-).
add_ts_assumption([A1|As],Ass,NewAss) :-
	add_ass1(A1,Ass,N1),!,
	add_ts_assumption(As,N1,NewAss),!.
add_ts_assumption([],A,A).

	:- mode add_ass1(+,+,-).
	add_ass1(T=New,[T=_|Ass],[T=New|Ass]).
	add_ass1(A,[A1|Ass],[A1|Newass]) :- add_ass1(A,Ass,Newass),!.
	add_ass1(A,[],[A]).

:- public ts_subset/2.
:- mode ts_subset(+,+).
ts_subset(X,Y) :- XY is X/\Y,!,X=XY,!.

:- public ts_union/3.
:- mode ts_union(+,+,?).
ts_union(X,Y,Z) :- XY is X\/Y,!,Z=XY,!.

:- public ts_intersection/3.
:- mode ts_intersection(+,+,?).
ts_intersection(X,Y,Z) :-  XY is X/\Y,!,Z=XY,!.

:- public ts_difference/3.
:- mode ts_difference(+,+,?).
ts_difference(X,Y,Z) :- XY is X-(X/\Y),!,Z=XY,!.

:- public boolean/2.
:- mode boolean(+,?).
boolean(Term,Ass) :- type_set(Term,Y,Ass),!,(Y=1;Y=2).

% EOF type.pl
