% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public time/1, time/4.

time(P) :- statistics(runtime,[_,_]),call(P),
	statistics(runtime,[_,E]),time(E,Min,Sec,MSec),
	write_time(Min,Sec,MSec).

:- mode time(+,-,-,-).
time(xwd(T1,T2),Min,Sec,MSec) :- T2 < 0,!,
	T1new is T1 + 1,!,
	time_posi(xwd(T1new,0),Min1,Sec1,MSec1),!,
	T2new is T2 * -1,!,
	time_posi(xwd(0,T2new),Min2,Sec2,MSec2),!,
	time_diff(Min1,Sec1,MSec1,Min2,Sec2,MSec2,Min,Sec,MSec).
time(xwd(T1,T2),Min,Sec,MSec) :- !,time_posi(xwd(T1,T2),Min,Sec,MSec),!.
time(E,Min,Sec,MSec) :- S1 is E/1000,
	Min is S1/60, Sec is S1 mod 60, MSec is E mod 1000,!.

:- mode time_posi(+,-,-,-).
time_posi(xwd(T1,T2),Min,Sec,MSec) :- !,
	T3 is T2 mod 1000,
	T4 is 144*T1+T3,
	MSec is T4 mod 1000,
	S1 is 22*T1+T2/1000+T4/1000,
	Sec is S1 mod 60,
	Min is 4*T1 + S1/60.

:- mode time_diff(+,+,+,+,+,+,-,-,-).
time_diff(Min1,Sec1,MSec1,Min2,Sec2,MSec2,Min,Sec,MSec) :-
	MSec1 >= MSec2,!,
	MSec is MSec1 - MSec2,
	time_diff1(Min1,Sec1,Min2,Sec2,Min,Sec).
time_diff(Min1,Sec1,MSec1,Min2,Sec2,MSec2,Min,Sec,MSec) :-
	MSec is MSec1 + 1000 - MSec2,
	Sec2new is Sec2 + 1,
	time_diff1(Min1,Sec1,Min2,Sec2new,Min,Sec).

:- mode time_diff1(+,+,+,+,-,-).
time_diff1(Min1,Sec1,Min2,Sec2,Min,Sec) :-
	Sec1 >= Sec2,!,
	Sec is Sec1 - Sec2,
	Min is Min1 - Min2.
time_diff1(Min1,Sec1,Min2,Sec2,Min,Sec) :-
	Sec is Sec1 + 1000 - Sec2,
	Min is Min1 - Min2 - 1.

:- mode write_time(+,+,+).
write_time(0,Sec,MSec) :-
	nl,write('                             '),
	write(Sec),write('.'),
	write_MSec(MSec),
	write('  seconds'),nl,!.

write_time(Min,Sec,MSec) :- 
	nl,write('                '),
	write(Min),write('  minuites  '),
	write(Sec),write('.'),
	write_MSec(MSec),
	write('  seconds'),nl,!.

:- mode write_MSec(+).
write_MSec(MS) :- MS>99,write(MS).
write_MSec(MS) :- MS>9,write(0),write(MS).
write_MSec(MS) :- write(00),write(MS).

% EOF time.pl
