% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public explicit_value/1.
:- mode explicit_value(+).
explicit_value(t).
explicit_value(f).
explicit_value([`,_]).
explicit_value(X) :- bottom_object(X),!.
explicit_value(X) :- constructor_TRs(X,TRs),!,X=[_|As],!,satisfy_TR(TRs,As),!.

:- public explicit_values/1.
:- mode explicit_values(+).
explicit_values([V|Vs]) :- explicit_value(V),!,explicit_values(Vs),!.
explicit_values([]).

:- mode satisfy_TR(+,+).
satisfy_TR([R|TRs],[X|Xs]) :-
	((recognizer_constructor([R,X]),!,
	  constructor_TRs(X,TRs1),!,X=[_|As1],!,satisfy_TR(TRs1,As1),!);
	 recognizer_bottom([R,X])),!,
	satisfy_TR(TRs,Xs),!.
satisfy_TR([],[]).

:- mode explicit_value_templates(+).
explicit_value_templates([A|As]) :-
	(variable(A); explicit_value_template(A)),!,
	explicit_value_templates(As),!.
explicit_value_templates([]).

:- public explicit_value_template/1.
:- mode explicit_value_template(+).
explicit_value_template(X) :- bottom_object(X),!.
explicit_value_template(X) :- constructor(X),!,X=[_|As],!,
	explicit_value_templates(As),!.

:- public call_in_terms/2.
call_in_terms(_,T) :- var(T),!,fail.
call_in_terms(X,[T|_]) :- call_in_term(X,T).
call_in_terms(X,[_|Ts]) :- call_in_terms(X,Ts).

:- public call_in_term/2.
call_in_term(_,T) :- var(T),!,fail.
call_in_term([F|Ts],[F|Ts]).
call_in_term(X,[_|Ts]) :- call_in_terms(X,Ts).

:- public recursive_calls/3.
:- mode recursive_calls(+,+,-).
recursive_calls(F,X,R) :- setof(C,recursive_call(F,X,C),R),!.
recursive_calls(_,_,[]).

:- public recursive_call/3.
:- mode	recursive_call(+,+,-).
recursive_call(_,X,_) :- var(X),!,fail.
recursive_call(_,[pack,_],_) :- !,fail.
recursive_call(_,[quote,_],_) :- !,fail.
recursive_call(F/N,[F|As],[F|As]) :- length(As,N).
recursive_call(F,[_|As],C) :- recursive_call_args(F,As,C).

:- mode	recursive_call_args(+,+,-).
recursive_call_args(F,[A|_],C) :- recursive_call(F,A,C).
recursive_call_args(F,[_|As],C) :- recursive_call_args(F,As,C).

%
%	mtos(+M_expression,-S_expression).
%

:- public mtos/2.
:- mode mtos(?,-).
mtos(X,X) :- var(X),!.
mtos("nil",nil).
mtos([X|Y],[pack,N]) :- name(N,[X|Y]),!.
mtos(`X,[`,X]).
mtos({X},{X}).
mtos(X,Z) :- abbrev_(X=Y), mtos(Y,Z),!.
mtos(M,[F|AS]) :- M=..[F,A1|A], map_mtos([A1|A],AS),!.
mtos(X,X).

:- mode map_mtos(+,-).
map_mtos([A1|A],[A1S|AS]) :- mtos(A1,A1S),!, map_mtos(A,AS),!.
map_mtos([],[]).

:- public mtos1/2.
:- mode mtos1(?,-).
mtos1(X,X) :- var(X),!.
mtos1({X},{X}).
mtos1(M,[F|AS]) :- M=..[F,A1|A], map_mtos1([A1|A],AS),!.
mtos1(X,X).

:- mode map_mtos1(+,-).
map_mtos1([A1|A],[A1S|AS]) :- mtos1(A1,A1S),!, map_mtos1(A,AS),!.
map_mtos1([],[]).

%
%	stom(+S_expression,-M_expression).
%

:- public stom/2.
:- mode stom(?,-).
stom(X,X) :- var(X),!.
stom({X},{X}).
stom([F|A],M) :- map_stom(A,AM),!, M=..[F|AM],!.
stom(X,X).

:- mode map_stom(+,-).
map_stom([A1|A],[A1M|AM]) :- stom(A1,A1M),!, map_stom(A,AM),!.
map_stom([],[]).

% EOF term.pl
