% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public simplify/0.
simplify :- retract(pool(simplification,X)),!,
	pp_clause(X,'Simplifying...'),
	simplify_clause(X),!.
simplify.

:- mode simplify_clause(+).
simplify_clause([ID|Path]:Clause) :-
	((Clause=[_],!,C2=Clause);
	 (delete_notequal([],Clause,[],C1,_),!,reverse(C1,C2))),
	setof(C,call_in_terms(C,C2),Terms),
	asserta(rewrite_env(Path:Terms)),
	simplify_step([],C2,C3),!,
	abolish(rewrite_env,1),
	cleanup(C3,C4),!,
	((C4=f,!,fail);
%	 (C4=t,(dumbly; nl,wwrite('The conjecture is true.',bold),nl));
	 (C4=t,(dumbly;
		(nl,wwrite('Conjecture ',bold),pp_path(11,[ID]),nl,
		 nl,wwrite('    is true.'),nl)));
	 (C4=[Clause],
	  pool_(heuristics,[ID|Path]:[Clause],z));
	 pool_(simplification,[s(ID)|Path]:C4,a)),!.

:- mode	delete_notequal(+,+,+,-,-).
delete_notequal(H,[[not,[equal|LR]]|Cl],T,NH,NT) :-
	(LR=[X,Y]; LR=[Y,X]), variable(X), \+var_in_term(X,Y),!,
	replace_var(X,Y,[['H'|H],['C'|Cl],['T'|T]],HCT),!,
	HCT=[['H'|NewH],['C'|NewCl],['T'|NewT]],!,
	delete_notequal(NewH,NewCl,NewT,NH,NT),!.
delete_notequal(H,[Top|Cl],T,NH,NT) :- delete_notequal([Top|H],Cl,T,NH,NT),!.
delete_notequal(H,[],T,H,T).

:- mode simplify_step(+,+,-).
simplify_step(Head,[L1|Tail],Result) :-
	assume_false(Head,Tail,NewHead,NewTail,XT,[],Hyp,[],TS_alist),!,
	((XT=(_=t),
	  nl,wwrite(trivial),nl,
	  Result=t);
	 (
	  (((expl_expand;expl_rewrite),pp_hyp(Hyp),nl,
	     wwrite('rewriting '),pp(10,L1),nl); true),!,
	  rewrite(L1,NewL1,[TS_alist,[],[],0,tf],[],_,[],_,[],W),!,
	  (((expl_expand;expl_rewrite),wwrite('
-------------------------------------------------------------------------------
')); true),!,
	  expl_simp_step(Hyp,L1,NewL1,W),!,
	  ((NewL1=t,!,Result=t);
	   (NewL1=f,!,simplify_step(NewHead,NewTail,Result));
	   (formula_to_clauses(NewL1,Cls),!,
	    ((Cls=[[L]],!,
	      simplify_step([L|NewHead],NewTail,Result));
	     map_simplify_step(NewHead,Cls,NewTail,t,Result)))))),!.
simplify_step(X,[],[Y]) :- !,reverse(X,Y),!.

:- mode assume_false(+,+,-,-,-,+,-,+,-).
assume_false([X|H],T,NH,NT,XT,Hin,Hout,ASin,TS_alist) :-
	assume_false1(X,A,ASin),!,
	((A=t,!,XT=(X=t),!,TS_alist=[]);
	 (A=f,!,assume_false(H,T,NH,NT,XT,Hin,Hout,ASin,TS_alist));
	 (A=or(_,AS1),!,add_ts_assumption(AS1,ASin,AS2),!,
	  NH=[X|NH1],!,Hout=[X|H1],!,
	  assume_false(H,T,NH1,NT,XT,Hin,H1,AS2,TS_alist))),!.
assume_false([],[],[],[],[],H,H,A,A).
assume_false([],T,[],NT,XT,Hin,Hout,ASin,TS_alist) :-
	assume_false(T,[],NT,_,XT,Hin,Hout,ASin,TS_alist),!.

:- mode assume_false1(+,-,+).
assume_false1([not,X],A,Ass) :- !,assume_true1(X,B,Ass),!,
	((B=t,!,A=f); (B=f,!,A=t); (B=or(L,R),!,A=or(R,L))),!.
assume_false1(X,A,Ass) :- ts_assumption(X,A,Ass),!.

:- mode assume_true1(+,-,+).
assume_true1([not,X],A,Ass) :- !,assume_false1(X,B,Ass),!,
	((B=t,!,A=f); (B=f,!,A=t); (B=or(L,R),!,A=or(R,L))),!.
assume_true1(X,A,Ass) :- ts_assumption(X,A,Ass),!.

:- mode map_simplify_step(+,+,+,+,-).
map_simplify_step(Head,[Cl|Cls],Tail,R0,Result) :-
	delete_notequal(Head,Cl,Tail,Head1,Tail1),!,
	simplify_step(Head1,Tail1,R1),!,
	((R1=f,!,fail);
	 (((R0=t,R2=R1); (R1=t,R2=R0); append(R0,R1,R2)),!,
	  map_simplify_step(Head,Cls,Tail,R2,Result))),!.
map_simplify_step(_,[],_,R,R).

:- mode expl_simplify_step(+,+,+,+).
expl_simp_step(_,_,_,_) :- dumbly,!.
expl_simp_step(Hyp,L1,NewL1,W) :- L1\==NewL1,brk,
	pp_hyp(Hyp),
	(W=[]; (nl,reverse(W,W1),pp_W(W1))),
	(( NewL1=t,
	  nl,wwrite('literal'),nl,
	  nl,tab(8),pp(8,L1),nl,
	  nl,wwrite('    is true.'),nl) ;
	 ( NewL1=f,
	  nl,wwrite('literal'),nl,
	  nl,tab(8),pp(8,L1),nl,
	  nl,wwrite('    is false.'),nl) ;
	 (nl,wwrite('we rewrite literal'),nl,
	  nl,tab(8),pp(8,L1),
	  nl,wwrite('    to'),
	  nl,tab(8),pp(8,NewL1),nl)),!.
expl_simp_step(_,_,_,_).

:- mode pp_hyp(+).
pp_hyp(Hyp) :- neg_all(Hyp,NHyp),!,
	( NHyp=[] ;
	  (NHyp=[NH],nl,wwrite('Under the assumption'),nl,
	   nl,tab(8),pp(8,NH),nl) ;
	  (nl,wwrite('Under the assumption'),nl,
	   nl,tab(8),pp(8,[and|NHyp]),nl) ),!.

:- mode pp_W(+).
pp_W([e(L,X)|W]) :- I is L*4+4,tab(I),
	wwrite('expanding '),I1 is I+10,pp(I1,X),nl,
	pp_W(W),!.
pp_W([r(L,T,N)|W]) :- I is L*4+4,tab(I),
	wwrite('applying '),wwrite(T),
	wwrite(': '),wwrite(N),nl,pp_W(W),!.
pp_W([]).

% EOF simp.pl
