% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- dynamic pp_wid/1.

:- public pp_width/1.
pp_width(W) :- var(W),!, (pp_wid(W); (assert(pp_wid(70)),pp_wid(W))),!.
pp_width(W) :- abolish(pp_wid,1), asserta(pp_wid(W)),!.

:- public pp/1, pp/2.
:- mode	pp(+), pp(+,+).
pp(X) :- pp(0,X),!.
pp(Indent,X) :- pp(0,Indent,X),!.

:- mode pp(+,+,+).
pp(Level,Indent,T) :- 
	fold_abbrev(T,Term),
	pp_term_length(Term,TL),
	pp_width(Width),
	Space is Width-Level-Indent,
	pp(Level,Indent,Term,TL,Space),!.

:- mode fold_abbrev(+,-).
fold_abbrev(X,Y) :- abbrev__(Y=X),!.
fold_abbrev([A|B],[X|Y]) :- fold_abbrev(A,X), fold_abbrev(B,Y),!.
fold_abbrev(X,X).

:- mode pp(+,+,+,+,+).
pp(_,_,{X},_,_) :- wwrite({X}),!.
pp(_,_,[F],TL,Space) :- integer(TL), TL =< Space,!,
	wwrite(F,reverse),!.
pp(_,_,Term,TL,Space) :- integer(TL), TL =< Space,!,
	((Term=[`,X], wwrite(`X,reverse)); wwrite(Term,reverse)),!.
pp(_,_,[`,List],_=TL,Space) :- TL+1 =< Space,!,
	wwrite(`List,reverse),!.
pp(Level,Indent,[`,List],(AT=M)=_,Space) :- M+3 =< Space,!,
	wwrite('`[',reverse),
		Indent2 is Indent+2,
		Space2 is Space-3,
		pp_list_args(Level,Indent2,List,AT,Space2),!,
		wwrite(']',reverse),!.
pp(Level,Indent,[F|Args],(FL,AT=_)=TL,Space) :- F\==(`), TL =< Space,!,
	wwrite(F,reverse), wwrite('(',reverse),
	Indent2 is Indent+FL+1, Space2 is Space-FL-1,
	pp_args(Level,Indent2,Args,AT,Space2),!.
pp(Level,Indent,[F|Args],(FL,AT=ATL)=_,Space) :- F\==(`), FL+2+ATL =< Space,!,
	wwrite(F,reverse),wwrite('(',reverse),
		Indent2 is Indent+FL+1,
		Space2 is Space-FL-2,
		pp_args_nl(Level,Indent2,Args,AT,Space2),!,
		wwrite(')',reverse),!.
pp(Level,Indent,[F|Args],(FL,AT=_)=_,Space) :- F\==(`), FL+1 =< Space,!,
	wwrite(F,reverse),wwrite('(',reverse),
		Indent2 is Indent+3,
		(FL<3;(nl, pp_level(Level), tab(Indent2))),
		Space2 is Space-4,
		pp_args_nl(Level,Indent2,Args,AT,Space2),!,
		wwrite(')',reverse),!.
pp(Level,Indent,T,TL,Space) :- nl,
	Level1 is Level+1,
	Space1 is Space+Indent-4,
	pp_level(Level1), tab(3),
	pp(Level1,3,T,TL,Space1),!.

:- mode pp_args(+,+,+,+,+).
pp_args(Level,Indent,[A],[AT],Space) :-
	pp(Level,Indent,A,AT,Space), wwrite(')',reverse),!.
pp_args(Level,Indent,[A|Args],[AT|ATs],Space) :-
	pp(Level,Indent,A,AT,Space), wwrite(',',reverse),
	(AT=(_=L); AT=L),
	Indent2 is Indent+L+1, Space2 is Space-L-1,
	pp_args(Level,Indent2,Args,ATs,Space2),!.

:- mode pp_args_nl(+,+,+,+,+).
pp_args_nl(Level,Indent,[A],[AT],Space) :- !,pp(Level,Indent,A,AT,Space),!.
pp_args_nl(Level,Indent,[A|Args],[AT|ATs],Space) :-
	pp(Level,Indent,A,AT,Space), wwrite(',',reverse),nl,
	pp_level(Level), tab(Indent),
	pp_args_nl(Level,Indent,Args,ATs,Space),!.

:- mode pp_list(+,+,+,+,+).
pp_list(_,_,Term,TL,Space) :- integer(TL), TL =< Space,!,
	wwrite(Term,reverse),!.
pp_list(_,_,List,_=TL,Space) :- TL =< Space,!,
	wwrite(List,reverse),!.
pp_list(Level,Indent,List,(AT=M)=_,Space) :- M+2 =< Space,!,
	wwrite('[',reverse),
		Indent2 is Indent+1,
		nl, pp_level(Level), tab(Indent2),
		Space2 is Space-2,
		pp_list_args(Level,Indent2,List,AT,Space2),!,
		wwrite(']',reverse),!.
pp_list(Level,Indent,List,TL,Space) :- nl,
	Level1 is Level+1,
	Space1 is Space+Indent-4,
	pp_level(Level1), tab(3),
	pp_list(Level1,3,List,TL,Space1),!.

:- mode pp_list_args(+,+,+,+,+).
pp_list_args(Level,Indent,Args,N,Space) :-
	integer(N), pp_list(Level,Indent,Args,N,Space),!.
pp_list_args(Level,Indent,[A],[AT],Space) :- !,
	pp_list(Level,Indent,A,AT,Space),!.
pp_list_args(Level,Indent,[A|Args],[AT|ATs],Space) :-
	pp_list(Level,Indent,A,AT,Space), wwrite(',',reverse),nl,
	pp_level(Level), tab(Indent),
	pp_list_args(Level,Indent,Args,ATs,Space),!.

:- mode pp_level(+).
pp_level(0).
pp_level(L) :- wwrite('|'), L1 is L-1, pp_level(L1),!.

:- mode pp_term_length(+,-).
pp_term_length({_},0).
pp_term_length([`,X],AT) :- pp_term_length_list(X,Y),!,
	((Y=((T=M)=N), N1 is N+1, AT=((T=M)=N1));
	 AT is Y+1),!.
pp_term_length([F],N) :- name(F,M), length(M,N),!.
pp_term_length([F|A],(N1,AT=M)=N) :- F\==(`),
	pp_term_length(F,N1),!,
	pp_term_length_args(A,AT,M,N2),!,
	N is N1+N2+1,!.
pp_term_length(X,N) :- name(X,XN),!,length(XN,N),!.

:- mode pp_terms_length_args(+,+,-,-).
pp_term_length_args([A|As],[AX|ATs],Max,Total) :-
	pp_term_length(A,AX),
	(AX=(_=AN); AN=AX), 
	pp_term_length_args(As,ATs,Max1,ANs),
	((Max1 >= AN, Max is Max1); Max is AN),
	Total is AN+ANs+1.
pp_term_length_args([],[],0,0).

:- mode pp_terms_length_list(+,-).
pp_term_length_list(X,N) :- atomic(X), name(X,M), length(M,N),!.
pp_term_length_list([],3).
pp_term_length_list([X|Y],N) :- atomic(Y), name(X,XN), name(Y,YN),
	length(XN,XNN), length(YN,YNN), N is XNN+YNN+3,!.
pp_term_length_list([X|Y],(AT=M)=N1) :-
	pp_term_length_list_args([X|Y],AT,M,N),!,
	N1 is N+1,!.

:- mode pp_terms_length_list_args(+,+,-,-).
pp_term_length_list_args([A|As],[AX|ATs],Max,Total) :-
	pp_term_length_list(A,AX),
	(AX=(_=AN); AN=AX), 
	pp_term_length_list_args(As,ATs,Max1,ANs),
	((Max1 >= AN, Max is Max1); Max is AN),
	Total is AN+ANs+1.
pp_term_length_list_args([],[],0,0).

% EOF pp.pl
