% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public append/3.
:- mode append(+,+,-).
append([H|A],B,[H|C]) :- append(A,B,C),!.
append([],B,B).

:- public reverse/2.
:- mode reverse(+,-), rev_(+,+,-).
reverse(X,Y) :- rev_(X,[],Y),!.

	rev_([A|X],Y,Z) :- rev_(X,[A|Y],Z),!.
	rev_([],X,X).

:- public member/2.
:- mode member(+,+).
member(A,[B|C]) :- var(A),!,var(B),!,(A==B; member(A,C)),!.
member(A,[A|_]).
member(A,[_|C]) :- member(A,C),!.

:- public one_of/2.
:- mode one_of(?,+).
one_of(A,[A|_]).
one_of(A,[_|C]) :- one_of(A,C).

:- public delete/3.
:- mode delete(+,+,-).
delete(X,[X|L],L) :- !.
delete(X,[Y|L],[Y|M]) :- delete(X,L,M),!.
delete(_,[],[]).

:- public one_and_rest/3.
:- mode one_and_rest(+,-,-).
one_and_rest([X|L],X,L).
one_and_rest([Y|L],X,[Y|M]) :- one_and_rest(L,X,M).

:- mode qsort(+,+,-).
qsort([X|L],R0,R) :-
   partition(L,X,L1,L2),
   qsort(L2,R0,R1),
   qsort(L1,[X|R1],R).
qsort([],R,R).

:- mode partition(+,+,-,-).
partition([X|L],Y,[X|L1],L2) :- size(X,M), size(Y,N), M < N, !,
   partition(L,Y,L1,L2).
partition([X|L],Y,[X|L1],L2) :- size(X,M), size(Y,N), M = N, !, X @< Y,
   partition(L,Y,L1,L2).
partition([X|L],Y,L1,[X|L2]) :- !,
   partition(L,Y,L1,L2).
partition([],_,[],[]).

:- mode size(+,-).
size([A|B],L) :- size(A,M), size(B,N), L is M+N,!.
size(_,1).

% EOF list.pl
