% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public induction/0.
induction :- retract(pool(induction,X)),!,
	pp_clause(X,'Trying induction...'),!,
	induction(X),!.
induction.
	
:- mode	induction(+).
induction(Path:Clause) :-
	abolish(scheme,1), abolish(changeables,3),
	collect_schemes(Clause),
%listing(scheme),
	sift_schemes,
	perform_induction(Path:Clause),
	abolish(scheme,1), abolish(changeables,3),!.
induction(X) :-
	abolish(scheme,1), abolish(changeables,3),!,
	assertz(pool(fail,X)),!.

%
%	Collecting Induction Schemes for a Clause
%

:- mode collect_schemes(+).
collect_schemes(Clause) :-
	setof([Call,Template,UC,Cases],
		(call_in_terms(Call,Clause),
		 induction_template(Call,Template),
		 applies(Template,Call,UC),
		 delete_illegal_pairs(Template,UC,Cases),
		 make_scheme(Call,Cases,UC)),
	_),!.

%
%	applies(+Template,+Term,-Unchangeables) :-
%
%	A Template applies to a Term
%	and return Unchangeables w.r.t. the Term and the Template
%

:- public applies/3.
:- mode	applies(+,+,-).
applies(template(X/MS,Cases),Call,UC) :-
	setof(Subst,subst_in_cases(Subst,Cases),Substs),
%nl,write(Substs),nl,
	transpose([MS|Substs],S),
	scan_substs(S,C,UC),
	assertz(changeables(Call,template(X/MS,Cases),C)),
	distinct_variables(C),
	\+setof(V,X^(one_of(X,UC),var_in_term(V,X),member(V,C)),UC),!.

:- public subst_in_cases/2.
:- mode subst_in_cases(-,+).
subst_in_cases(Subst,[(_->S)|_]) :- subst_in_cases(Subst,S).
subst_in_cases(Subst,[_/Subst|_]).
subst_in_cases(Subst,[_|S]) :- subst_in_cases(Subst,S).

:- mode transpose(+,-).
transpose([[]|_],[]).
transpose(A,[AT|B]) :- cars(A,AT), cdrs(A,AD), transpose(AD,B),!.

:- mode cars(+,-).
cars([[A|_]|B],[A|C]) :- cars(B,C),!.
cars([],[]).

:- mode cdrs(+.-).
cdrs([[_|D]|B],[D|C]) :- cdrs(B,C),!.
cdrs([],[]).

:- mode scan_substs(+,-,-).
scan_substs([[X|Xs]|S],C,[X|UC]) :- unchangeable(X,Xs),
	scan_substs(S,C,UC),!.
scan_substs([[X|_]|S],[X|C],UC) :-
	scan_substs(S,C,UC),!.
scan_substs([],[],[]).

:- mode unchangeable(+,+).
unchangeable(X,[X|Xs]) :- unchangeable(X,Xs),!.
unchangeable(_,[]).

%
%	Deleting Illegal Substitution Pairs
%

:- public delete_illegal_pairs/3.
:- mode delete_illegal_pairs(+,+,-).
delete_illegal_pairs(template(Actuals/MS,[(T->S)|SS]),UC,[(T->SD)|SSD]) :-
	delete_illegal_pairs(Actuals/MS,S,UC,SD),
	delete_illegal_pairs(template(Actuals/MS,SS),UC,SSD),!.
delete_illegal_pairs(template(_,[]),_,[]).

:- mode delete_illegal_pairs(+,+,+,-).
delete_illegal_pairs(Actuals/MS,[Subst/_|S],UC,[AD1|SD]) :-
	delete_illegal_pairs1(Actuals,Subst,UC,AD),
	delete_ambiguous_pairs(AD,MS,AD1),
	delete_illegal_pairs(Actuals/MS,S,UC,SD),!.
delete_illegal_pairs(_,[],_,[]).

:- mode delete_illegal_pairs1(+,+,+,-).
delete_illegal_pairs1([A|Actuals],[S|Subst],UC,[(A->S)|AD]) :-
	variable(A), \+member(A,UC), A\==S,
	delete_illegal_pairs1(Actuals,Subst,UC,AD),!.
delete_illegal_pairs1([_|Actuals],[_|Subst],UC,AD) :-
	delete_illegal_pairs1(Actuals,Subst,UC,AD),!.
delete_illegal_pairs1([],_,_,[]).

:- mode delete_ambiguous_pairs(+,+,-).
delete_ambiguous_pairs([(X->_)|AD],MS,AD1) :-
	ambiguous(X,AD), \+member(X,MS),
	delete_ambiguous_pairs(AD,MS,AD1),!.
delete_ambiguous_pairs([S|AD],MS,[S|AD1]) :-
	delete_ambiguous_pairs(AD,MS,AD1),!.
delete_ambiguous_pairs([],_,[]).

:- mode ambiguous(+,+).
ambiguous(X,[(X->_)|_]).
ambiguous(X,[_|Y]) :- ambiguous(X,Y).

%
%	Composing an Induction Scheme
%

:- public make_scheme/3.
:- mode make_scheme(+,+,+).
%make_scheme([F|Args],Cases,UC) :-
make_scheme([F|Args],Cases,_) :-
	setof(CV,changing_variable(CV,Cases),CVs),
	(setof(UCV,(var_in_term(UCV,[F|Args]),\+member(UCV,CVs)),UCVs);
	 UCVs=[]),
	length(Args,D),
	max_subst_length(Cases,0,N),
	assertz(scheme([Cases,[[F|Args]],CVs,UCVs,N/D])),!.

:- public changing_variable/2.
:- mode changing_variable(-,+).
changing_variable(CV,[(_->S)|_]) :- changing_variable1(CV,S).
changing_variable(CV,[_|S]) :- changing_variable(CV,S).

:- mode changing_variable1(-,+).
changing_variable1(CV,[S|_]) :- changing_variable2(CV,S).
changing_variable1(CV,[_|S]) :- changing_variable1(CV,S).

:- mode changing_variable2(-,+).
changing_variable2(CV,[(CV->_)|_]).
changing_variable2(CV,[_|S]) :- changing_variable2(CV,S).

:- mode max_subst_length(+,+,-).
max_subst_length([(_->S)|HS],N,M) :- max_subst_length1(S,0,M1),
	max([N,M1],M2),
	max_subst_length(HS,M2,M),!.
max_subst_length([],M,M).

:- mode max_subst_length1(+,+,-).
max_subst_length1([S|SS],N,M) :- length(S,M1),
	max([N,M1],M2),
	max_subst_length1(SS,M2,M),!.
max_subst_length1([],M,M).

:- mode max(+,-).
max([N1|Ns],M) :- max(Ns,M1), (N1>=M1, M=N1; M=M1),!.
max([N],N).

%
%	Sifting Induction Scheme Candidates
%

sift_schemes :-	
	scheme(S1), scheme(S2), S1\==S2,
	subsume_scheme(S1,S2,S3),
	retract(scheme(S1)), retract(scheme(S2)), asserta(scheme(S3)),
	sift_schemes,!.
sift_schemes :-	
	scheme(S1), scheme(S2), S1\==S2,
	merge_scheme(S1,S2,S3),
	retract(scheme(S1)), retract(scheme(S2)), asserta(scheme(S3)),
	sift_schemes,!.
sift_schemes :-	flaw_check,!,sift_schemes,!.
sift_schemes :-
	scheme(S1), scheme(S2), S1\==S2,
	has_heigher_score(S1,S2),
	retract(scheme(S2)),
	sift_schemes,!.
sift_schemes :-
	scheme(S1), scheme(S2), S1\==S2,
	has_nastier_terms(S1,S2),
	retract(scheme(S2)),
	sift_schemes,!.
sift_schemes.

%
%	subsume_scheme(+S1,+S2,-S3) :-
%
%	S2 subsumes S1 to give a new scheme S3
%

:- mode subsume_scheme(+,+,-).
subsume_scheme(Sc1,Sc2,Sc3) :-
	Sc1=[S1,T1,CV1,UCV1,P1],
	Sc2=[S2,T2,CV2,UCV2,P2],
	subsetp(CV1,CV2),
	subsetp(UCV1,UCV2),
	abolish(subsume_C,2),
	setof([C1,C2],(one_of(C1,S1),one_of(C2,S2),
		subsume_case(C1,C2),assertz(subsume_C(C1,C2))),_),
	subsume_C_check1(S1),
	subsume_C_check2(S2),
	abolish(subsume_C,2),
	union(T1,T2,T3),
	add_score(P1,P2,P3),
	Sc3=[S2,T3,CV2,UCV2,P3],
	expl_subsume(Sc1,Sc2,Sc3),!.
subsume(_,_,_) :-
	abolish(subsume_C,2),!,fail.

:- mode subsume_C_check1(+).
subsume_C_check1([C1|C]) :- subsume_C(C1,_), subsume_C_check1(C),!.
subsume_C_check1([]).

:- mode subsume_C_check2(+).
subsume_C_check2([C1|_]) :- subsume_C(C2,C1), subsume_C(C3,C1), C2\==C3,!,fail.
subsume_C_check2([_|C]) :- subsume_C_check2(C),!.
subsume_C_check2([]).

:- public subsume_case/2.
:- mode subsume_case(+,+).
subsume_case((T1->S1),(T2->S2)) :-
	subsetp(T1,T2),
	abolish(subsume_S,2),
	setof([C1,C2],(one_of(C1,S1),one_of(C2,S2),
		subsume_subst(C1,C2),assertz(subsume_S(C1,C2))),_),
	subsume_S_check1(S1),
	subsume_S_check2(S2),
	abolish(subsume_S,2),!.
subsume_case(_,_) :-
	abolish(subsume_S,2),!,fail.

:- mode subsume_S_check1(+).
subsume_S_check1([S1|S]) :- subsume_S(S1,_), subsume_S_check1(S),!.
subsume_S_check1([]).

:- mode subsume_S_check2(+).
subsume_S_check2([S1|_]) :- subsume_S(S2,S1), subsume_S(S3,S1), S2\==S3,!,fail.
subsume_S_check2([_|S]) :- subsume_S_check2(S),!.
subsume_S_check2([]).

:- public subsume_subst/2.
:- mode subsume_subst(+,+).
subsume_subst([S1_1|S1s],S2) :-
	subsume_subst1(S1_1,S2),
	subsume_subst(S1s,S2),!.
subsume_subst([],_).

:- mode subsume_subst1(+,+).
subsume_subst1((V->T1),[(V->T2)|_]) :- occur(T1,T2).
subsume_subst1(S1,[_|S2]) :- subsume_subst1(S1,S2).

:- mode occur(+,+).
occur(T,T).
occur(T1,[_|T2]) :- occur_in_args(T1,T2).

:- mode occur_in_args(+,+).
occur_in_args(T1,[T2|_]) :- occur(T1,T2).
occur_in_args(T1,[_|T2]) :- occur_in_args(T1,T2).

:- mode expl_subsume(+,+,+).
expl_subsume(_,_,_) :- !.
expl_subsume(_,_,_) :- dumbly,!.
expl_subsume(S1,S2,S3) :-
	nl,write('The scheme:'),
	nl,pp_scheme(S2),nl,
	nl,write('is subsumed by the scheme:'),
	nl,pp_scheme(S1),nl,
	nl,write('getting a new scheme:'),
	nl,pp_scheme(S3),nl,brk,!.

%
%	merge_scheme(+S1,+S2,-S3) :-
%
%	merge S1 and S2 into S3
%

:- mode merge_scheme(+,+,-).
merge_scheme(Sc1,Sc2,Sc3) :-
	Sc1=[S1,T1,CV1,UCV1,P1],
	Sc2=[S2,T2,CV2,UCV2,P2],
	intersection(CV1,CV2,X), X\==[],
	intersection(UCV1,CV2,Y), Y=[],
	intersection(CV1,UCV2,Z), Z=[],
	abolish(merge_C,3),
	setof([C1,C2,C3],(one_of(C1,S1),one_of(C2,S2),
		merge_case(C1,C2,C3),assertz(merge_C(C1,C2,C3))),_),
	merge_C_check1(S1),
	merge_C_check2(S2,S3),
	union(CV1,CV2,CV3),
	union(UCV1,UCV2,UCV3),
	union(T1,T2,T3),
	add_score(P1,P2,P3),
	abolish(merge_C,3),
	Sc3=[S3,T3,CV3,UCV3,P3],
	expl_merge(Sc1,Sc2,Sc3),!.
merge_scheme(_,_,_) :-
	abolish(merge_C,3),!,fail.

:- mode merge_C_check1(+).
merge_C_check1([C1|C]) :- merge_C(C1,_,_), merge_C_check1(C),!.
merge_C_check1([]).

:- mode merge_C_check2(+,-).
merge_C_check2([C1|_],_) :- merge_C(C2,C1,_), merge_C(C3,C1,_), C2\==C3,!,fail.
merge_C_check2([C1|C],[C2|C3]) :- merge_C(_,C1,C2), merge_C_check2(C,C3),!.
merge_C_check2([C1|C],[C1|C3]) :- merge_C_check2(C,C3),!.
merge_C_check2([],[]).

:- public merge_case/3.
:- mode merge_case(+,+,-).
merge_case((T1->S1),(T2->S2),(T3->S3)) :-
	abolish(merge_S,3),
	setof([C1,C2,C3],(one_of(C1,S1),one_of(C2,S2),
		merge_subst(C1,C2,C3),assertz(merge_S(C1,C2,C3))),_),
	merge_S_check1(S1),
	merge_S_check2(S2,S3),
	union(T1,T2,T12),
	cleanup(T12,T3),
	abolish(merge_S,3),!.
merge_case(_,_,_) :-
	abolish(merge_S,3),!,fail.

:- mode merge_S_check1(+).
merge_S_check1([S1|S]) :- merge_S(S1,_,_), merge_S_check1(S),!.
merge_S_check1([]).

:- mode merge_S_check2(+,-).
merge_S_check2([S1|_],_) :- merge_S(S2,S1,_), merge_S(S3,S1,_), S2\==S3,!,fail.
merge_S_check2([S1|S],[S2|S3]) :- merge_S(_,S1,S2), merge_S_check2(S,S3),!.
merge_S_check2([S1|S],[S1|S3]) :- merge_S_check2(S,S3),!.
merge_S_check2([],[]).

:- public merge_subst/3.
:- mode merge_subst(+,+,-).
merge_subst(S1,S2,S3) :-
	setof([C1,C2],(one_of(C1,S1),one_of(C2,S2),common_var(C1,C2)),CS),
	check_CS(CS),
	union(S1,S2,S3),!.

:- public common_var/2.
:- mode common_var(+,+).
common_var((V->_),(V->_)).

:- mode check_CS(+).
check_CS([[S,S]|CS]) :- check_CS(CS),!.
check_CS([]).

:- mode expl_merge(+,+,+).
%expl_merge(_,_,_) :- !.
%expl_merge(_,_,_) :- dumbly,!.
expl_merge(S1,S2,S3) :-
	nl,write('The scheme:'),
	nl,pp_scheme(S2),nl,
	nl,write('and the scheme:'),
	nl,pp_scheme(S1),nl,
	nl,write('are merged into a new scheme:'),
	nl,pp_scheme(S3),nl,brk,!.

%
%	flawed_scheme(+S2,+S1) :-
%
%	scheme S1 is flawed by S2
%

flaw_check :- setof([S1,S2],
	(scheme(S1), scheme(S2), S1\==S2, flawed_scheme(S1,S2)),
	FS),!,
	setof(Sc1,Y^one_of([Sc1,Y],FS),S1s),
	setof(Sc2,scheme(Sc2),S2s),
	\+set_equalp(S1s,S2s),
	setof(S,(one_of(S,S1s),retract(scheme(S)),expl_flawed(scheme(S))),_),!.

:- mode flawed_scheme(+,+).
flawed_scheme([_,_,CV2,UCV2,_],[_,T1,_,_,_]) :-
	induction_variable(IV1,T1),
	(member(IV1,CV2); member(IV1,UCV2)).

:- mode induction_variable(-,+).
%induction_variable(IV,T) :- one_of(Term,T), changeables(Term,Temp,C),
induction_variable(IV,T) :- one_of(Term,T), changeables(Term,_,C),
	one_of(IV,C).

:- mode expl_flawed(+).
expl_flawed(_) :- !.
expl_flawed(_) :- dumbly,!.
expl_flawed(S) :-
	nl,write('The scheme:'),
	nl,pp_scheme(S),nl,
	nl,write('is flawed'),nl,brk,!.

%
%	Tie Breaking among Remaining Induction Scheme Candidates
%

:- mode has_heigher_score(+,+).
has_heigher_score([_,_,_,_,P1],[_,_,_,_,P2]) :-
	heigher_score(P1,P2).

:- mode heigher_score(+,+).
heigher_score(N1/D1,N2/D2) :- M1 is N1*D2, M2 is N2*D1, M1>M2.

:- mode add_score(+,+,-).
add_score(N1/D1,N2/D2,N3/D3) :-
	D3 is D1*D2, N31 is N1*D2, N32 is N2*D1, N3 is N31+N32.

:- mode has_nastier_terms(+,+).
has_nastier_terms([_,T1,_,_,_],[_,T2,_,_,_]) :-
	nastiness(T1,0,N1), nastiness(T2,0,N2), N1>N2.

:- mode nastiness(+,+,-).
nastiness([X|R],N,M) :-
	nasty_function(X), N1 is N+1, nastiness(R,N1,M).
nastiness([_|R],N,M) :- nastiness(R,N,M).
nastiness([],N,N).

%
%	Performing Induction Rewrite
%

:- mode perform_induction(+).
perform_induction([ID|Path]:Clause) :-
	scheme([M,Terms,CV,_,_]),
	superimpose_machine(M,S),
	(dumbly;
	 (nl,write('We will induct according to the following scheme:'),nl,
	  pp_scheme([S,Terms,CV,_,_]),nl)),
	base_case(S,[ID|Path]:Clause),
	((S=[C],induction_step(C,[i(ID)|Path]:Clause));
	 ( S=SS,%reverse(S,SS),
	   induction_steps(SS,[i(ID)-1|Path]:Clause))),!.

:- mode superimpose_machine(+,-).
superimpose_machine([(T->S)|M],[C|Ms]) :-
	superimpose_machine1((T->S),M,C,M1),
	superimpose_machine(M1,Ms),!.
superimpose_machine([],[]).

:- mode superimpose_machine1(+,+,-,-).
superimpose_machine1((T1->S1),[(T2->S2)|M],C,M1) :-
	set_equalp(T1,T2),
	union(S1,S2,S3),
	superimpose_machine1((T1->S3),M,C,M1),!.
superimpose_machine1(C1,[C2|M],C,[C2|M1]) :-
	superimpose_machine1(C1,M,C,M1),!.
superimpose_machine1(C,[],C,[]).

:- mode base_case(+,+).
base_case(M,[ID|Path]:Clause) :-
%	( dumbly; (nl,write('Base Case:'),nl)),
	base_tests(M,Tests),
	formula_to_clauses([or|Tests],Cls1),
	append_cls(Cls1,Clause,Cls),
	cleanup(Cls,ClsC),
	( (ClsC=t,nl,write(trivial),nl);
	  pool_(simplification,[b(ID)|Path]:ClsC,z)),!.

:- mode append_cls(+,+,-).
append_cls([C1|Cls1],C2,[C3|Cls3]) :- append(C1,C2,C3),
	append_cls(Cls1,C2,Cls3),!.
append_cls([],_,[]).

:- mode base_tests(+,-).
base_tests([(Tests->_)|M],[BT|T]) :-
	((Tests=[BT1],or_form(BT1,BT));
	 (or_forms(Tests,BT2),BT=[and|BT2])),!,
	base_tests(M,T).
base_tests([],[]).

:- public or_forms/2.
:- mode or_forms(+,-).
or_forms([A|B],[OA|OB]) :- or_form(A,OA), or_forms(B,OB),!.
or_forms([],[]).

:- public or_form/2.
:- mode or_form(+,-).
or_form([T],T).
or_form(T,[or|T]).

:- mode induction_step(+,+).
induction_step((Tests->Substs),NPath:Clause) :-
%	(dumbly; (nl,write('Induction Step:'),nl)),
	neg_alls(Tests,NTests),
	neg_all(Clause,NClause),
	apply_substs(NClause,Substs,NIhyps),
	append(NTests,NIhyps,Hyps),
	andor_to_clauses(Hyps,HCls),
	append_cls(HCls,Clause,ICls),
	cleanup(ICls,ClsC),
	qsort(ClsC,[],CCC),
	pool_(simplification,NPath:CCC,z),!.

:- mode induction_steps(+,+).
induction_steps([C|M],[i(ID)-N|Path]:Clause) :-
	induction_step(C,[i(ID)-N|Path]:Clause),
	N1 is N+1,
	induction_steps(M,[i(ID)-N1|Path]:Clause),!.
induction_steps([],_).

:- mode apply_substs(+,+,-).
apply_substs(Conj,[S|Substs],[IHyp|IHyps]) :-
	apply_subst(Conj,S,IHyp),
	apply_substs(Conj,Substs,IHyps),!.
apply_substs(_,[],[]).

:- mode apply_subst(+,+,-).
apply_subst(X,S,XS) :- (variable(X);atomic(X)),!, subst_var(X,S,XS),!.
apply_subst([A|D],S,[AS|DS]) :-	apply_subst(A,S,AS), apply_subst(D,S,DS),!.
apply_subst(X,_,X).

:- mode subst_var(+,+,-).
subst_var(X,[(X->T)|_],T).
subst_var(X,[_|S],XS) :- subst_var(X,S,XS),!.
subst_var(X,[],X).

%
%	Printing Induction Schemes
%

pp_schemes.
pp_schemes :- listing(scheme),!.

:- mode pp_scheme(+).
pp_scheme([Cases,Terms,CV,_,_]) :-
	sort(CV,CVS),
	steps(Cases,CVS,BaseTest,Steps),
	(BaseTest=[BT]; BT=[and|BaseTest]),
	Scheme=[and,[implies,BT,['P'|CVS]]|Steps],
	nl,tab(8),pp(8,Scheme),nl,
	nl,write('    which accounts for'),nl,
	nl,tab(8),((Terms=[T],pp(8,T)); pp(8,[''|Terms])),!.

:- mode steps(+,+,-,-).
steps([(Test->Substs)|Cases],CV,[NT|BaseTest],
	[[implies,[and,T|Ihyps],['P'|CV]]|Steps]) :-
	((Test=[T1],or_form(T1,T)); (or_forms(Test,T1),T=[and|T1])),
	negate(T,NT),
	ihyps(Substs,CV,Ihyps),
	steps(Cases,CV,BaseTest,Steps),!.
steps([],_,[],[]).

:- mode ihyps(+,+,-).
ihyps([S|Substs],CV,[['P'|SCV]|Ihyps]) :-
	apply_subst(CV,S,SCV),
	ihyps(Substs,CV,Ihyps),!.
ihyps([],_,[]).

% EOF induct.pl
