% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public elim2/1.
:- mode elim2(+).
elim2([ID|Path]:Clause) :- !,
%	nl,wwrite('Eliminating Irrelevance...'),nl,!,
	abolish(part,2),!,
	partitioning(Clause),!,
	((setof(L,P^(falsifiable_part(P),one_of(L,P)),DL),
	  abolish(part,2),
	  delete_DL(Clause,DL,Cl),
	  Cl\==[],
	  expl_elim2(DL),
	  pool_(simplification,[l(ID)|Path]:[Cl],a),!);
	 (abolish(part,2),!,fail)).

:- mode partitioning(+).
partitioning([L|Ls]) :-
	(setof(V,var_in_term(V,L),Vs); Vs=[]),!,
	sharing_check([L],Vs),!,
	partitioning(Ls),!.
partitioning([]).

sharing_check(Ls1,Vs1) :-
	( (part(Ls2,Vs2),
	   sharing(Vs1,Vs2),
	   setof(V, (one_of(V,Vs1); one_of(V,Vs2)), Vs3),
	   retract(part(Ls2,Vs2)),
	   append(Ls1,Ls2,Ls3),
	   sharing_check(Ls3,Vs3)) ;
	  assertz(part(Ls1,Vs1)) ),!.

:- mode sharing(+,+).
sharing([V|_],[V|_]).
sharing([_|U],V) :- sharing(U,V).
sharing(U,[_|V]) :- sharing(U,V).

:- public falsifiable_part/1.
:- mode falsifiable_part(-).
falsifiable_part(Ls) :- part(Ls,_), falsifiable(Ls).

:- mode falsifiable(+).
falsifiable([L]) :- (L=[not,X]; L=X), recursive(X),!,X=[_|Args],!,
	distinct_variables(Args),!.
falsifiable(X) :- falsifiable1(X),!.

:- mode falsifiable1(+).
falsifiable1([X|Ls]) :- not_mention_recursive_function(X),!,falsifiable1(Ls),!.
falsifiable1([]).

:- mode not_mention_recursive_function(+).
not_mention_recursive_function(X) :- recursive(X),!,fail.
not_mention_recursive_function([_|Args]) :- !,
	not_mention_recursive_functions(Args),!.
not_mention_recursive_function(_).

:- mode not_mention_recursive_functions(+).
not_mention_recursive_functions([X|Xs]) :-
	not_mention_recursive_function(X),!,
	not_mention_recursive_functions(Xs),!.
not_mention_recursive_functions([]).

:- mode delete_DL(+,+,-).
delete_DL([L|Ls],D,Ls1) :- delete_DL(D,L),!,delete_DL(Ls,D,Ls1),!.
delete_DL([L|Ls],D,[L|Ls1]) :- delete_DL(Ls,D,Ls1),!.
delete_DL([],_,[]).

:- mode delete_DL(+,+).
delete_DL([X|_],X).
delete_DL([_|X],Y) :- delete_DL(X,Y),!.

:- mode expl_elim2(+).
expl_elim2(_) :- dumbly,!.
expl_elim2(Del) :-
	nl,wwrite('We eliminate the irrelevant term(s)'),nl,
	neg_all(Del,ND),
	nl,tab(8),((ND=[D],pp(8,D)); pp(8,[''|ND])),nl,!.

% EOF elim2.pl
