% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public elim1/1.
:- mode elim1(+).
elim1([ID|Path]:Clause) :- !,
%	nl,write('Eliminating Destructors...'),nl,!,
%	elimination_lemma(_,LemmaName,[implies,Hyp,[equal,[C|Ds],X]]),
	elimination_lemma(_,_,[implies,Hyp,[equal,[C|Ds],X]]),
	call_in_terms([D|Args],Clause),
	distinct_variables(Args),
	member_destructor_([D|Args],Ds),
	setof(T,destructor_term_(T,Ds),DTs),
	(elim1_no_loop(Path,Args); dt_in_not_eq(DTs,Clause)),
	assume_false(Clause,[],_,_,_,[],_,[],Context),
	negate(Hyp,NHyp),
	perform_generalization([NHyp|Clause],Context,DTs,Vars,C2),
	gen_subst(Ds,DTs,Vars,Ds1),
	apply_subst(C2,[(X->[C|Ds1])],C3),
	map_elim1_simp(C3,Cls2),
	expl_elim1(X,[C|Ds1],DTs),!,
	formula_to_clauses([or,Hyp|Clause],Cls1),
%	( dumbly; (nl,write('Generalization Base Case:'),nl)),
	pool_(simplification,[c(Vars,ID)|Path]:Cls1,z),
%	( dumbly; (nl,write('Generalization Case:'),nl)),
	pool_(simplification,[d(Vars,ID)|Path]:Cls2,z),!.

:- mode member_destructor(+,+).
member_destructor(X,X).
member_destructor(X,[_|A]) :- member_destructor_(X,A).
:- mode member_destructor_(+,+).
member_destructor_(X,[Y|_]) :- nonvar(Y),member_destructor(X,Y).
member_destructor_(X,[_|Y]) :- member_destructor_(X,Y).

:- mode destructor_term(-,+).
destructor_term([F|A],[F|A]) :- distinct_variables(A).
destructor_term(X,[_|A]) :- destructor_term_(X,A).
:- public destructor_term_/2.
:- mode destructor_term_(-,+).
destructor_term_(X,[Y|_]) :- nonvar(Y),destructor_term(X,Y).
destructor_term_(X,[_|Y]) :- destructor_term_(X,Y).

:- mode map_elim1_simp(+,-).
map_elim1_simp([C|Cs],[NC|NCs]) :- elim1_simp(C,NC),map_elim1_simp(Cs,NCs),!.
map_elim1_simp([],[]).

:- mode elim1_simp(+,-).
elim1_simp([[not,X]|C],C1) :- recognizer_constructor(X), elim1_simp(C,C1),!.
elim1_simp([X|C],C1) :- member(X,C), elim1_simp(C,C1),!.
elim1_simp([X|C],[X|C1]) :- elim1_simp(C,C1),!.
elim1_simp([],[]).

:- mode elim1_no_loop(+,+).
elim1_no_loop([d(Vars,_)-_|_],Args) :- one_of(V,Vars), member(V,Args),!,fail.
elim1_no_loop([d(Vars,_)|_],Args) :- one_of(V,Vars), member(V,Args),!,fail.
elim1_no_loop([b(_)-_|_],_).
elim1_no_loop([b(_)|_],_).
elim1_no_loop([i(_)-_|_],_).
elim1_no_loop([i(_)|_],_).
elim1_no_loop([_|Path],V) :- !,elim1_no_loop(Path,V),!.
elim1_no_loop(_,_).

:- mode dt_in_not_eq(+,+).
dt_in_not_eq([DT|_],Cl) :- dt_in_not_eq1(DT,Cl),!.
dt_in_not_eq([_|DTs],Cl) :- dt_in_not_eq(DTs,Cl),!.

:- mode dt_in_not_eq1(+,+).
dt_in_not_eq1(DT,[[not,[equal,L,R]]|_]) :-
	((explicit_value(R), call_in_term(DT,L));
	 (explicit_value(L), call_in_term(DT,R))),!.
dt_in_not_eq1(DT,[_|Cl]) :- dt_in_not_eq1(DT,Cl),!.

:- mode expl_elim1(+,+,+).
expl_elim1(_,_,_) :- dumbly,!.
expl_elim1(X,LHS,Destructors) :-
	nl,wwrite('We replace '),wwrite(X,reverse),wwrite(' by '),
	name(X,XL),length(XL,XN),I is XN+19,pp(I,LHS),nl,
	nl,wwrite('    to eliminate '),
	((Destructors=[D],!,pp(13,D));
	 (pp(13,[''|Destructors]))),nl,!.

% EOF elim1.pl
