% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- mode	definition_(+).
definition_(FA/J=B) :-
	assert(jtuples(J)), definition_(FA=B), abolish(jtuples,1),!.
definition_(FA:T=B) :-
	assert(tp(T)), definition_(FA=B), abolish(tp,1),!.
definition_(_=undefined).
definition_(FA=B) :-
	FA=..[F|Formals],length(Formals,N),mtos(B,Body),
	nl,pp_def(FA,Body),
	nl,write('Analyzing...'),nl,
	definition_principle_A([F|Formals]),
	definition_principle_B(Formals),
	definition_principle_C(Formals,Body),
	definition_principle_D(F/N,Formals,Body),
	p_vars(Formals,Body,P_Formals,P_Body),
	((tp(_),assert(type_prescription([F|P_Formals],tp(8'377777,[]))));
	 compute_TP([F|Formals],P_Formals,Body)),
	assertz(definition([F|P_Formals],P_Body)),
	((machine([F|Formals],_),
	  nl,write('    ... terminative recursive function'),nl,
	  assertz(recursive([F|P_Formals])));
	 assertz(nonrecursive([F|P_Formals]))),
	abolish(machine,2),
	nl,pp_TP([F|Formals]),nl,
	nl,pp_def(FA,Body),
	nl,write('    has been accepted.'),nl,!.
%definition_(_) :- nl,write('The definition is rejected.'),nl,!.
definition_(_) :- nl,write('rejected.'),nl,!.

%
%	The Definition Principle
%

:- mode	definition_principle_A(+).
definition_principle_A(FA) :-
	definition(FA,Body),stom(FA,FAm),
	error('The function has been already defined as:'),
	nl,pp_def(FAm,Body),nl,!,fail.
definition_principle_A(X) :-
	(constructor(X),error('Name confliction with the constructor.'));
	(recognizer(X),error('Name confliction with the recognizer.'));
	(accessor(X),error('Name confliction with the accessor.')),!,fail.
definition_principle_A(_).

:- mode	definition_principle_B(+).
definition_principle_B([F|Formals]) :- \+member(F,Formals),
	definition_principle_B(Formals),!.
definition_principle_B([]).
definition_principle_B(_) :-
	error('Formal variables should be distinct.'),!,fail.

:- mode	definition_principle_C(+,+).
definition_principle_C(Formals,Body) :- legal_body(Formals,Body),!.
definition_principle_C(_,_) :- error('Illegal definition body.'),!,fail.

:- mode	legal_body(+,+).
legal_body(_,t).
legal_body(_,f).
legal_body(_,X) :- integer(X),!.
legal_body(_,[pack,_]).
legal_body(_,[list,_]).
legal_body(_,[`,_]).
legal_body(_,Body) :- bottom_object(Body),!.
legal_body(Formals,Body) :- atomic(Body),!,
	(member(Body,Formals); constructor(Body)),!.
legal_body(Formals,[_|Args]) :- legal_body_args(Formals,Args),!.

:- mode legal_body_args(+,+).
legal_body_args(Formals,[A1|Args]) :- legal_body(Formals,A1),
	legal_body_args(Formals,Args),!.
legal_body_args(_,[]).

:- mode	definition_principle_D(+,+,+).
definition_principle_D(F/N,Formals,Body) :-
	machine_([F/N|Formals],[],[],Body),
%listing(machine),
	((\+machine([F|Formals],_),true);
         analysis_for_induction([F|Formals])),!.
definition_principle_D(_,_,_) :-
	error('Termination cannot be certified.'),!,fail.

%
%	Machine
%

:- mode machine_(+,+,+,+).
machine_(_,_,_,[`,_]).
machine_([F/N|Formals],C,G,[if,T,L,R]) :- negate(T,NT),
	(((recursive_call(F/N,T,_);
	   (setof(LC,recursive_call(F/N,L,LC),LCs),
	    setof(RC,recursive_call(F/N,R,RC),RCs),
	    union(LCs,RCs,U),
	    (U=LCs; U=RCs))),
	  machine_([F/N|Formals],C,G,T),
	  machine_([F/N|Formals],C,[T|G],L),
	  machine_([F/N|Formals],C,[NT|G],R));
	 (machine_([F/N|Formals],[T|C],[T|G],L),
	  machine_([F/N|Formals],[NT|C],[NT|G],R))),!.
machine_([F/N|Formals],C,G,T) :-
	setof(X, (recursive_call(F/N,T,X),
		  machine__([F|Formals],C,G,X)),_),!.
machine_(_,_,_,_).

:- public machine__/4.
:- mode machine__(+,+,+,+).
machine__([F|Formals],C,G,X) :-
	((C=[],CC=t); C=[CC]; (reverse(C,RC),CC=[and|RC])),!,
	((G=[],GG=t); G=[GG]; (reverse(G,RG),GG=[and|RG])),!,
	(machine([F|Formals],CC:(GG->X));
	 (p_vars(Formals,CC:(GG->X),P_Formals,P_X),
	  assertz(machine([F|P_Formals],P_X)))),!.

%
%	Definition Time Analysis for Induction
%

:- mode analysis_for_induction(+).
analysis_for_induction([F|Formals]) :-
	nastiness_check([F|Formals]),
	abolish(note,7),
	setof(Case,machine([F|Formals],Case),Cases),
	look_at_induction_lemmas([F|Formals]),
%listing(note),
	find_lexicographic_relations([F|Formals],Cases),
%listing(lexrel),
	setof(MS,R^(lexrel(R,MS), measured_subset_([F|Formals],MS)),
%	      MSs),
	      _),
%listing(measured_subset),
	make_templates([F|Formals],Cases),
%listing(induction_template),
	abolish(note,7),
	abolish(lexrel,2),!.

:- mode measured_subset_(+,+).
measured_subset_([F|Formals],MS) :-
	(measured_subset([F|Formals],MS);
	 (p_vars(Formals,MS,P_Formals,P_MS),
	  assertz(measured_subset([F|P_Formals],P_MS)))),!.

%
%	Nastiness of a Function
%

:- mode nastiness_check(+).
nastiness_check([F|Formals]) :- machine([F|Formals],_:(_->[F|Args])),
	\+primitive_recursive(Formals,Args),
	p_vars(Formals,[],P_Formals,_),
	assertz(nasty_function([F|P_Formals])),!.
nastiness_check(_).

:- public primitive_recursive/2.
:- mode primitive_recursive(+,+).
primitive_recursive([V|Vs],[V|As]) :- primitive_recursive(Vs,As).
primitive_recursive([_|Vs],[A|As]) :- accessor(A), primitive_recursive(Vs,As).
primitive_recursive([],[]).

%
%	Looking at Induction Lemmas
%

:- mode look_at_induction_lemmas(+).
look_at_induction_lemmas([F|Formals]) :-
	setof(J_tuple,j_tuple(Formals,J_tuple),J_tuples),
%nl,write(J_tuples),nl,
	setof(Case,machine([F|Formals],Case),Cases),
%nl,write(Cases),nl,
	lail(J_tuples,Cases,Formals),!.

:- mode lail(+,+,+).
lail([J|Js],C,F) :- lail1(J,C,F), lail(Js,C,F),!.
lail([],_,_).

:- mode lail1(+,+,+).
lail1(J,[C|Cs],F) :- lail2(J,C,F), lail1(J,Cs,F),!.
lail1(_,[],_).

:- mode lail2(+,+,+).
lail2(J,C,F) :- setof([WFR,M],not_increasing(C,F,J,WFR,M),_),!.
lail2(_,_,_).

:- public j_tuple/2.
:- mode j_tuple(+,-).
j_tuple(_,J) :- jtuples(Js),!,one_of(J,Js).
j_tuple(X,Z) :- j1(X,Y),j2(X,Y,Z),Z\==[].

:- mode j1(+,-).
j1([_|X],Y) :- j1(X,Y).
j1(X,X).

:- mode j2(+,+,-).
j2(X,[_|Ys],[Z|Zs]) :- j3(X,Z), j2(X,Ys,Zs), j4(Z,Zs).
j2(_,[],[]).

:- mode j3(+,-).
j3([X|_],X).
j3([_|X],Y) :- j3(X,Y).

:- mode j4(+,+).
j4(X,[Y|_]) :- X==Y,!,fail.
j4(X,[_|Z]) :- j4(X,Z).
j4(_,[]).

:- public not_increasing/5.
:- mode not_increasing(+,+,+,-,-).
not_increasing(Case:(Test->[_|Actuals]),Formals,J_tuple,WFR,M) :-
	subst_j_tuple(J_tuple,Formals,Actuals,S_tuple),!,
	transitive_rel(S_tuple,J_tuple,Hyp,WFR,M,Name),
	or_forms(Hyp,OH),
	prove_hyp(Test,OH),
%nl,write(note(J_tuple,Case:(Test->Actuals),S_tuple,Hyp,WFR,M,Name)),nl,
	assertz(note(J_tuple,Case:(Test->Actuals),S_tuple,Hyp,WFR,M,Name)).

:- mode subst_j_tuple(+,+,+,-).
subst_j_tuple([],_,_,[]).
subst_j_tuple([J1|J_tuple],Formals,Actuals,[S1|S_tuple]) :-
	sjt(J1,Formals,Actuals,S1),
	subst_j_tuple(J_tuple,Formals,Actuals,S_tuple).

:- mode sjt(+,+,+,-).
sjt(J,[F|_],[A|_],A) :- J==F.
sjt(J,[_|F],[_|A],S) :- sjt(J,F,A,S).

:- mode prove_hyp(+,+).
prove_hyp(_,P) :- has_free_var(P),!,fail.
prove_hyp(Test,[H|Hs]) :- jtuples(_),!,
	nl,tab(8),pp(8,[implies,Test,H]),nl,
	prove_hyp(Test,Hs).
prove_hyp(Test,[H|Hs]) :-
%	asserta(dumbly),
	prove_short(['induction lemma hypothesis']:[implies,Test,H]),!,
%	abolish(dumbly,0),
	prove_hyp(Test,Hs).
prove_hyp(Test,[H|Hs]) :-
	nl,write('The conjecture'),nl,
	nl,tab(8),pp(8,[implies,Test,H]),nl,
	nl,write('is provable? (y./n.) '),ttyflush,read(Ans),
	( (Ans=y, prove_hyp(Test,Hs)); !,fail).
prove_hyp(_,[]).
prove_hyp(_,_) :- abolish(dumbly,0),!,fail.

%
%	Transitive Closure of a Well Founded Relation
%

:- mode transitive_rel(+,+,-,-,-,-).
transitive_rel(S_tuple,S_tuple,[],equal,(@),(@)).
transitive_rel(S_tuple,J_tuple,Hyp,WFR,M,Name) :-
	induction_lemma([WFR1,[M1|S_tuple],[M1|M_tuple]],Hyp1,_,Name1),
	((M_tuple=J_tuple, Hyp=Hyp1, WFR=WFR1, M=M1, Name=[Name1]);
	 (transitive_rel(M_tuple,J_tuple,Hyp2,WFR2,M2,Name2),
	  append(Hyp1,Hyp2,Hyp),
	  ((WFR1=equal,WFR=WFR2);(WFR2=equal,WFR=WFR1);(WFR1=WFR2,WFR=WFR1)),
	  M1=M2, M=M1,
	  Name=[Name2|Name1])).

%
%	Lexicographic Relations
%

:- mode find_lexicographic_relations(+,+).
find_lexicographic_relations([F|Formals],Calls) :-
	setof(wfr(R,M,J_tuple),wfr_(J_tuple,R,M),WFRs),
%nl,write(WFRs),nl,
	setof(lexrel(LexRel,MS),
		(cover([F|Formals],Calls,WFRs,LexRel,MS),
		 assertz(lexrel(LexRel,MS))),
%		LexRels),!.
		_),!.

:- public wfr_/3.
wfr_(J_tuple,R,M) :- note(J_tuple,_,_,_,R,M,_), R\==equal.

:- public cover/6.
:- mode cover(+,+,+,+,-,-).
cover([F|Formals],Calls,WFRs,[R1|LexRel],MS) :-
	one_of_rels(R1,WFRs,Rs),
	not_decreasing(Calls,R1,Cs),
	Calls \== Cs,
	R1=wfr(_,_,J_tuple),
	cover([F|Formals],Cs,Rs,LexRel,MS1),
	merge_MS(Formals,J_tuple,MS1,MS).
cover(_,[],_,[],[]).

:- mode one_of_rels(-,+,-).
one_of_rels(X,[X|Y],Y).
one_of_rels(X,[W|Z],[W|Y]) :- one_of_rels(X,Z,Y).

:- mode not_decreasing(+,+,-).
%not_decreasing([Case:(Test->[F|Actuals])|Calls],wfr(R,M,J_tuple),Cs) :-
not_decreasing([Case:(Test->[_|Actuals])|Calls],wfr(R,M,J_tuple),Cs) :-
	note(J_tuple,Case:(Test->Actuals),_,_,R,M,_),
	not_decreasing(Calls,wfr(R,M,J_tuple),Cs),!.
not_decreasing([Case:(Test->[F|Actuals])|Calls],wfr(R,M,J_tuple),
		[Case:(Test->[F|Actuals])|Cs]) :-
	(note(J_tuple,Case:(Test->Actuals),_,_,equal,M,_);
	 note(J_tuple,Case:(Test->Actuals),_,_,equal,(@),(@))),
	not_decreasing(Calls,wfr(R,M,J_tuple),Cs),!.
not_decreasing([],_,[]).

:- mode merge_MS(+,+,+,-).
merge_MS([X|Xs],Y,Z,[X|Q]) :- (member(X,Y); member(X,Z)), merge_MS(Xs,Y,Z,Q),!.
merge_MS([_|Xs],Y,Z,Q) :- merge_MS(Xs,Y,Z,Q),!.
merge_MS([],_,_,[]).

%
%	Composing Induction Templates
%

:- mode make_templates(+,+).
%make_templates([F|Formals],Calls) :-
make_templates([F|Formals],_) :-
	setof(Case,TC^machine([F|Formals],Case:TC),Cases),
	setof((MS,RM,P_Formals,P_Template),
		(measured_subset([F|Formals],MS),
		 make_template1(Cases,[F|Formals],MS,RM),
		 p_vars(Formals,template(Formals/MS,RM),
			P_Formals,P_Template),
		 assertz(induction_template([F|P_Formals],P_Template))),
	_).

:- public make_template1/4.
:- mode make_template1(+,+,+,-).
make_template1([Case|Cases],[F|Formals],MS,RMout) :-
	lexrel(LexRel,MS),
	make_template([Case|Cases],[F|Formals],LexRel,MS,[],RMout),!.

:- mode make_template(+,+,+,+,+,-).
make_template([Case|Cases],[F|Formals],LexRel,MS,RMin,RMout) :-
	setof(Call,Test^machine([F|Formals],Case:(Test->Call)),Calls),
	mt(Case:Calls,LexRel,Formals,MS,[],Hyp,Substs),
	cleanup(Hyp,Hyp1),
	merge_RM_case(Hyp1,Substs,RMin,RM1),
	make_template(Cases,[F|Formals],LexRel,MS,RM1,RMout),!.
make_template([],_,_,_,RM,RM).

:- mode merge_RM_case(+,+,+,-).
merge_RM_case(Hyp,Substs,RMin,RM1) :-
	merge_RM_case1(Hyp,Substs,RMin,RM1),!.
merge_RM_case(Hyp,Substs,RMin,[(Hyp->Substs)|RMin]).

:- mode merge_RM_case1(+,+,+,-).
merge_RM_case1(Hyp,Substs,[(H1->S1)|RMin],[(H1->S2)|RMin]) :-
	set_equalp(Hyp,H1),append(Substs,S1,S2),!.
merge_RM_case1(Hyp,Substs,[(H1->S1)|RMin],[(H1->S1)|RMout]) :-
	merge_RM_case(Hyp,Substs,RMin,RMout),!.

:- mode mt(+,+,+,+,+,-,-).
mt(Case:[[_|Actuals]|Calls],LexRel,Formals,MS,Hin,Hout,[Actuals/S_tuple|S]) :-
	one_of(wfr(_,M,J_tuple),LexRel),
	note(J_tuple,Case:(_->Actuals),_,Hyp,_,M,_),
	append(Hyp,Hin,H1),
	subst_j_tuple(MS,Formals,Actuals,S_tuple),
	mt(Case:Calls,LexRel,Formals,MS,H1,Hout,S).
mt(_:[],_,_,_,H,H,[]).

%
%	Computing Definition Type Set
%

:- mode definition_type_set(+,-,+).

definition_type_set(X,DTS,Ass) :- dts_assumed(X,DTS,Ass),!.

:- mode dts_assumed(+,-,+).
dts_assumed(X,DTS,[X=DTS|_]).
dts_assumed(X,DTS,[_|Ass]) :- dts_assumed(X,DTS,Ass),!.

definition_type_set([equal,_,_],dts(3,[]),_) :- !.
definition_type_set(X,dts(TS,[]),_) :-
	(recognizer_constructor([R,X]);
	 recognizer_bottom([R,X]);
	 type_of_A([R,X]);
	 R=[X];
	 (rewrite_lemma([R,X],t,P,no,_,_),
	  establish(P,[[],[],[],0,tf],[],_,[],_,[],_))),
	bit_place(R,TS),!.	

definition_type_set(X,dts(TS,[]),_) :-
	rewrite_lemma([or,[R1,X]|Y],t,P,no,_,_),
	establish(P,[[],[],[],0,tf],[],_,[],_,[],_),
	tsa([[R1,X]|Y],0,X,TS),!.

definition_type_set([if,T,L,R],DTS,Ass) :- !,
	dts_assumption(T,Mustbe,Ass),!,
	((Mustbe=t,!,definition_type_set(L,DTS,Ass));
	 (Mustbe=f,!,definition_type_set(R,DTS,Ass));
	 (Mustbe=or(L_Ass,R_Ass),!,
	  definition_type_set(L,LDTS,L_Ass),!,LDTS=dts(LTS,LVars),!,
	  definition_type_set(R,RDTS,R_Ass),!,RDTS=dts(RTS,RVars),!,
	  ts_union(LTS,RTS,TS),!,
	  union(LVars,RVars,Vars),!,
	  DTS=dts(TS,Vars))),!.

definition_type_set(X,dts(TS,[]),Ass) :- recognizer(X),!,X=[R,Y],!,
	(bit_place(R,RTS);
	 (recognizer_constructor([R,C]),bit_place([C],RTS))),!,
	definition_type_set(Y,YDTS,Ass),!,
	(YDTS=dts(YTS,[]); YTS=8'377777),!,
	((RTS=YTS,!,TS=2);
	 (ts_intersection(RTS,YTS,0),!,TS=1);
	 TS=3),!.
%			[implies,[R,X],[not,[R',X]]]

definition_type_set([F|Args],dts(TS,Vars),Ass) :-
	type_prescription([F|Args],tp(TS_F,Terms)),!,
	dts_args(Terms,TS_F,[],TS,Vars,Ass),!.

	:- mode dts_args(+,+,+,-,-,+).
	dts_args([T1|Terms],TSp,Varsp,TS,Vars,Ass) :-
		definition_type_set(T1,DTS1,Ass),!,DTS1=dts(TS1,Vars1),!,
		ts_union(TSp,TS1,TSn),!,
		union(Varsp,Vars1,Varsn),!,
		dts_args(Terms,TSn,Varsn,TS,Vars,Ass),!.
	dts_args([],TS,Vars,TS,Vars,_).

definition_type_set(X,dts(0,[X]),_) :- variable(X),!.
definition_type_set(_,dts(8'377777,[]),_).

%
%	Assuming Expressions true or false
%

:- mode dts_assumption(+,-,+).

dts_assumption([not,X],A,Ass) :- !,dts_assumption(X,B,Ass),!,
	((B=t,!,A=f);
	 (B=f,!,A=t);
	 (B=or(L,R),!,A=or(R,L))),!.

dts_assumption([equal,T1,T2],Mustbe,Ass) :-
	definition_type_set(T1,DTS1,Ass),!,DTS1=dts(S1,V1),!,
	definition_type_set(T2,DTS2,Ass),!,DTS2=dts(S2,V2),!,
	((V1=[],SV1=S1); SV1=8'377777),!,
	((V2=[],SV2=S2); SV2=8'377777),!,
	ts_intersection(SV1,SV2,S),!,
	((S=0,!,Mustbe=f);
	 (SV1=SV2,bit_place([_],S),!,Mustbe=t);
	 (add_ts_assumption([[equal,T1,T2]=dts(2,[]),[equal,T2,T1]=dts(2,[]),
			     T1=dts(S,[]),T2=dts(S,[])],
			Ass,L_Ass),!,
	  ((SV1=S,bit_place([_],S),!,
	    ts_difference(SV2,SV1,S21),!,
	    add_ts_assumption([[equal,T1,T2]=dts(1,[]),[equal,T2,T1]=dts(1,[]),
			       T2=dts(S21,[])],
			Ass,R_Ass)) ;
	   (SV2=S,bit_place([_],S),!,
	    ts_difference(SV1,SV2,S12),!,
	    add_ts_assumption([[equal,T1,T2]=dts(1,[]),[equal,T2,T1]=dts(1,[]),
			       T1=dts(S12,[])],
			Ass,R_Ass)) ;
	   add_ts_assumption([[equal,T1,T2]=dts(1,[]),[equal,T2,T1]=dts(1,[])],
			Ass,R_Ass)),!,
	  Mustbe=or(L_Ass,R_Ass))),!.

dts_assumption(X,Mustbe,Ass) :- recognizer(X),!,X=[R,Y],!,
	(bit_place(R,RTS);
	 (recognizer_constructor([R,C]), bit_place([C],RTS))),!,
	definition_type_set(Y,DTS,Ass),!,
	(DTS=dts(YTS,[]); YTS=8'377777),!,
	((YTS=RTS,!,Mustbe=t);
	 (ts_intersection(YTS,RTS,0),!,Mustbe=f);
	 (ts_difference(YTS,RTS,Sd),!,
	  add_ts_assumption([Y=dts(RTS,[])],Ass,L_Ass),!,
	  add_ts_assumption([Y=dts(Sd,[])],Ass,R_Ass),!,
	  Mustbe=or(L_Ass,R_Ass))),!.

dts_assumption(X,Mustbe,Ass) :-
	definition_type_set(X,DTS,Ass),!,DTS=dts(TS,V),!,
	((TS=1,V=[],!,Mustbe=f);
	 (ts_intersection(TS,1,0),V=[],!,Mustbe=t);
	 (ts_difference(TS,1,Sd),!,
	  add_ts_assumption([X=dts(Sd,V)],Ass,L_Ass),!,
	  add_ts_assumption([X=dts(1,[])],Ass,R_Ass),!,
	  Mustbe=or(L_Ass,R_Ass))),!.

%
%	Computing Type Prescription
%

:- mode compute_TP(+,+,+).
compute_TP([F|Formals],P_Formals,Body) :-
	asserta(type_prescription([F|P_Formals],tp(0,[]))),
	expand_nonrecursive_test(Body,B1), if_expr(B1,B2), if_norms(B2,B3),
	if_norms2(B3,B4),
	compute_TP([F|Formals],B4),!.

:- mode if_norms2(+,-).
if_norms2([if,T,L,R],[if,TT,LL,RR]) :-
	if_norms2(T,T1),
	((T1=[if,TT,TL,TR],
	  if_norms2([if,TL,L,R],LL),
	  if_norms2([if,TR,L,R],RR));
	 (T1=TT,
	  if_norms2(L,LL),
	  if_norms2(R,RR))),!.
if_norms2(X,X).

:- mode expand_nonrecursive_test(+,-).
expand_nonrecursive_test([if,T,L,R],[if,TT,LL,RR]) :-
	expand_nonrecursive(T,TT),
	expand_nonrecursive_test(L,LL),
	expand_nonrecursive_test(R,RR),!.
expand_nonrecursive_test(X,X).

:- mode expand_nonrecursive(+,-).
expand_nonrecursive(X,Z) :- nonrecursive(X), definition(X,Y),
	expand_nonrecursive(Y,Z),!.
expand_nonrecursive([F|Args],[F|A]) :- expand_nonrecursive_args(Args,A),!.
expand_nonrecursive(X,X).

:- mode expand_nonrecursive_args(+,-).
expand_nonrecursive_args([X|Xs],[Y|Ys]) :-
	expand_nonrecursive(X,Y), expand_nonrecursive_args(Xs,Ys),!.
expand_nonrecursive_args([],[]).

:- mode compute_TP(+,+).
compute_TP([F|Formals],Body) :-
	definition_type_set(Body,dts(TS,Vars),[]),
	(type_prescription([F|Formals],tp(TS,Vars));
	 (p_vars(Formals,Vars,P_Formals,P_Vars),
	  retract(type_prescription([F|Formals],tp(_,_))),
	  asserta(type_prescription([F|P_Formals],tp(TS,P_Vars))),
	  compute_TP([F|Formals],Body))),!.

% EOF defun.pl
