% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

%
%	Converting a Formula into a Conjunction of Clauses
%

:- public formula_to_clauses/2.
:- mode formula_to_clauses(+,-). 
formula_to_clauses(F,C) :- if_expr(F,I),if_norms(I,A),if_elims([A],B),!,
	cleanup(B,C),!.

%
%	Converting Clauses into "implies" Formula
%

:- public clauses_to_implies/2.
:- mode clauses_to_implies(+,-).
clauses_to_implies([H|T],[HH|TT]) :- !,clause_to_implies(H,HH),
	clauses_to_implies(T,TT),!.
clauses_to_implies(X,X).

:- public clause_to_implies/2.
:- mode clause_to_implies(+,-).
clause_to_implies([X],X).
clause_to_implies(X,X) :- atomic(X),!. 
clause_to_implies(C,I) :- c2i([],C,I),!.

:- mode c2i(+,+,-).
c2i(H,[H1,H2|C],I) :- negate(H1,NH1),!,append(H,[NH1],NH),!,c2i(NH,[H2|C],I),!.
c2i([H],[C],[implies,H,C]).
c2i([],[C],C).
c2i(H,[C],[implies,[and|H],C]).

%
%	Expanding "not","implies","and" and "or"-term into "if"-term
%

:- public if_expr/2.
:- mode if_expr(+,-).

if_expr([`,X],[`,X]).

if_expr([not,X],Z) :- !,if_expr(X,Y),!,
	((Y=t,!,Z=f); (Y=f,!,Z=t); negate(Y,Z)),!.

if_expr([implies,P,Q],Z) :- !,if_expr(P,P1),!,if_expr(Q,Q1),!,
	((P1=f,!,Z=t);
	 (Q1=t,!,Z=t);
	 (P1=t,!,((Q1=f,!,Z=f);
		  Z=[if,Q1,t,f]));
	 (Q1=f,!,Z=[if,P1,f,t]);
	 Z=[if,P1,[if,Q1,t,f],t]),!.

if_expr([and,P],Z) :- !,if_expr(P,Z),!.
if_expr([and,P|Qs],Z) :- !,if_expr(P,P1),!,if_expr([and|Qs],Q1),!,
	((P1=f,!,Z=f);
	 (Q1=f,!,Z=f);
	 (P1=t,!,((Q1=t,!,Z=t);
		  Z=[if,Q1,t,f]));
	 (Q1=t,!,Z=[if,P1,t,f]);
	 Z=[if,P1,[if,Q1,t,f],f]),!.

if_expr([or,P],Z) :- !,if_expr(P,Z),!.
if_expr([or,P|Qs],Z) :- !,if_expr(P,P1),!,if_expr([or|Qs],Q1),!,
	((P1=t,!,Z=t);
	 (Q1=t,!,Z=t);
	 (P1=f,!,((Q1=f,!,Z=f);
		  Z=[if,Q1,t,f]));
	 (Q1=f,!,Z=[if,P1,t,f]);
	 Z=[if,P1,t,[if,Q1,t,f]]),!.

if_expr([if,t,L,_],Z) :- !,if_expr(L,Z),!.
if_expr([if,f,_,R],Z) :- !,if_expr(R,Z),!.
if_expr([if,T,L,R],Z) :- !,if_expr(T,TT),!,if_expr(L,LL),!,if_expr(R,RR),!,
	((T=t,!,Z=LL); (T=f,!,Z=RR); Z=[if,TT,LL,RR]),!.

if_expr([F|A],[F|B]) :- !,map_if_expr(A,B),!.
if_expr(X,X).

:- mode map_if_expr(+,-).
map_if_expr([A1|A],[B1|B]) :- if_expr(A1,B1),!,map_if_expr(A,B),!.
map_if_expr([],[]).

%
%	Repeat to apply the (wired-in-)rewrite rule:
%
%	[equal,[F,X1,...,[if,P,Q,R],...,Xn],
%	       [if,P,[F,X1,...,Q,...,Xn],
%		     [F,X1,...,R,...,Xn]]]
%
%	until all the "if"s are outside all other function symbols.
%

:- public if_norms/2.
:- mode if_norms(+,-).
if_norms(A,C) :- if_norm(A,B),!,((A=B,!,B=C); if_norms(B,C)),!.

:- mode if_norm(+,-).
if_norm([`,X],[`,X]).
if_norm([if,t,L,_],LL) :- !,if_norm(L,LL),!.
if_norm([if,f,_,R],RR) :- !,if_norm(R,RR),!.
if_norm([if,T,L,R],[if,TT,LL,RR]) :- !,
	if_norm(T,TT),!,if_norm(L,LL),!,if_norm(R,RR),!.
if_norm([F|A],C) :- !,map_if_norms(A,B),!,if_norm1([F],B,C),!.
if_norm(X,X).

:- mode if_norm1(+,+,-).
if_norm1(A,[[if,t,L,_]|Tail],B) :- !,if_norm1(A,[L|Tail],B),!.
if_norm1(A,[[if,f,_,R]|Tail],B) :- !,if_norm1(A,[R|Tail],B),!.
if_norm1(A,[[if,T,L,R]|Tail],[if,T,LL,RR]) :- !,
	reverse([L|A],L1),!,append(L1,Tail,LL),!,
	reverse([R|A],R1),!,append(R1,Tail,RR),!.
if_norm1(A,[X|Tail],B) :- if_norm1([X|A],Tail,B),!.
if_norm1([t,not],[],f).
if_norm1([f,not],[],t).
if_norm1(A,[],B) :- reverse(A,B),!.

:- mode map_if_norms(+,-).
map_if_norms([A1|A],[B1|B]) :- if_norms(A1,B1),!,map_if_norms(A,B),!.
map_if_norms([],[]).

%
%	Repeat to apply the (wired-in-)rewrite rule for a clause:
%
%	[L1', ..., L<n-1>', [if,P,Q,R], L<n+1>, ..., Lm]
%
%  ==>  [L1', ..., L<n-1>', [not,P], Q, L<n+1>, ..., Lm]
%	  AND
%	[L1', ..., L<n-1>',      P,  R, L<n+1>, ..., Lm]
%
%	until none of the "if"s introduced by literal Ln remain.
%

:- mode if_elims(+,-).
if_elims(Clause,Clauses) :- if_elim([[]],Clause,C),!,if_elims1(t,C,Clauses),!.

:- mode if_elims1(+,+,-).
if_elims1(_,[],t).
if_elims1(X,X,X).
if_elims1(_,Y,Z) :- map_if_elim(Y,Y1),!,if_elims1(Y,Y1,Z),!.

:- mode if_elim(+,+,-).
if_elim(_,[t|_],[]).
if_elim(Heads,[f|Tail],Clauses) :- !,if_elim(Heads,Tail,Clauses),!.
if_elim(Heads,[[if,t,L,_]|Tail],Clauses) :- !,
	if_elim(Heads,[L|Tail],Clauses),!.
if_elim(Heads,[[if,f,_,R]|Tail],Clauses) :- !,
	if_elim(Heads,[R|Tail],Clauses),!.
if_elim(Heads,[[if,T,L,R]|Tail],Clauses) :- !,
	if_norms([not,T],NT),!,if_expr(NT,N),!,
	new_heads(Heads,[N,L],[T,R],Heads1),!,
	((Heads1=[],!,Clauses=t);
	 (if_elim(Heads1,Tail,Clauses))),!.
if_elim(Heads,[X|Tail],Clauses) :-
	map_cons(X,Heads,Heads1),!,
	if_elim(Heads1,Tail,Clauses),!.
if_elim(A,[],C) :- map_reverse(A,C),!.

:- mode map_if_elim(+,-).
map_if_elim([C1|C],D) :- if_elim([[]],C1,C1s),!,map_if_elim(C,D1),!,
	append(C1s,D1,D),!.
map_if_elim([],[]).

:- mode new_heads(+,+,+,-).
new_heads(X,Y,Z,W) :- member(t,Y),!,new_heads(X,[],Z,W),!.
new_heads(X,Y,Z,W) :- member(t,Z),!,new_heads(X,Y,[],W),!.
new_heads(_,[],[],[]).
new_heads(X,Y,Z,W) :- new_heads1(X,Y,Z,W),!.

:- mode new_heads1(+,+,+,-).
new_heads1([X1|X],Y,[],[YY|W]) :- !,
	((Y=[f,Y1],!,YY=[Y1|X1]);
	 (Y=[Y1,f],!,YY=[Y1|X1]);
	 (Y=[Y1,Y2],!,YY=[Y2,Y1|X1])),!,
	new_heads1(X,Y,[],W),!.
new_heads1([X1|X],[],Y,[YY|W]) :- !,
	((Y=[f,Y1],!,YY=[Y1|X1]);
	 (Y=[Y1,f],!,YY=[Y1|X1]);
	 (Y=[Y1,Y2],!,YY=[Y2,Y1|X1])),!,
	new_heads1(X,[],Y,W),!.
new_heads1([X1|X],Y,Z,[YY,ZZ|W]) :-
	((Y=[f,Y1],!,YY=[Y1|X1]);
	 (Y=[Y1,f],!,YY=[Y1|X1]);
	 (Y=[Y1,Y2],!,YY=[Y2,Y1|X1])),!,
	((Z=[f,Z1],!,ZZ=[Z1|X1]);
	 (Z=[Z1,f],!,ZZ=[Z1|X1]);
	 (Z=[Z1,Z2],!,ZZ=[Z2,Z1|X1])),!,
	new_heads1(X,Y,Z,W),!.
new_heads1([],_,_,[]).

:- mode map_cons(+,+,-).
map_cons(f,X,X).
map_cons(X,[Y1|Y],[[X|Y1]|Z]) :- map_cons(X,Y,Z),!.
map_cons(_,[],[]).

:- mode map_reverse(+,-).
map_reverse([X1|X],[Y1|Y]) :- reverse(X1,Y1),!,map_reverse(X,Y),!.
map_reverse([],[]).

%
%	Logical Simplification of Clauses
%

:- public cleanup/2.
:- mode	cleanup(+,-).
cleanup(C1,C3) :- trivial_cleanup(C1,C2),!,
	( C2==f,C3=f ; C2==[],C3=t ; further_cleanup(C2,C3) ),!.
cleanup(X,X).

:- mode	trivial_cleanup(+,-).
trivial_cleanup(Cls,NCls) :- map_cleanup_clause(Cls,Cls1),
	( simply_false(Cls1),NCls=f ; remove_clauses(Cls1,NCls) ),!.

:- mode map_cleanup_clause(+,-).
map_cleanup_clause([C1|Clauses],[NC1|NC]) :- cleanup_clause(C1,NC1),
	map_cleanup_clause(Clauses,NC),!.
map_cleanup_clause([],[]).

:- mode simply_false(+).
simply_false([f|_]) :- !.
simply_false([[L]|Clauses]) :- negate(L,NL),member([NL],Clauses),!.
simply_false([_|Clauses]) :- simply_false(Clauses),!.

:- mode remove_clauses(+,-).
remove_clauses([t|Clauses],C) :- !,remove_clauses(Clauses,C),!.
remove_clauses([C1|Clauses],C) :- clause_member(C1,Clauses),!,
	remove_clauses(Clauses,C),!.
remove_clauses([C1|Clauses],[C1|C]) :- !,remove_clauses(Clauses,C),!.
remove_clauses([],[]).

:- mode	cleanup_clause(+,-).
cleanup_clause(C,NC) :- negin_all(C,C1),
	( simply_true(C1),NC=t ; remove_literals(C1,NC) ),!.

:- mode simply_true(+).
simply_true([t|_]) :- !.
simply_true([L|Lits]) :- negate(L,NL),member(NL,Lits),!.
simply_true([_|Lits]) :- simply_true(Lits),!.

:- mode remove_literals(+,-).
remove_literals([f|Lits],Cls) :- !,remove_literals(Lits,Cls),!.
remove_literals([L|Lits],Cls) :- member(L,Lits),!,remove_literals(Lits,Cls),!.
remove_literals([L|Lits],[L|Cls]) :- remove_literals(Lits,Cls),!.
remove_literals([],[]).

%
%	Further Reductions of Clauses
%

:- mode further_cleanup(+,-).
further_cleanup([Cl1|Cls],NewClauses) :- robinson_replace(Cl1,Cls,Cls1),!,
	further_cleanup(Cls1,NewClauses),!.
further_cleanup([Cl1|Cls],NewClauses) :- resolve(Cl1,Cls,Cls1),!,
	further_cleanup(Cls1,NewClauses),!.
further_cleanup([Cl1|Cls],[Cl1|NewClauses]) :- !,
	further_cleanup(Cls,NewClauses),!.
further_cleanup(X,X).

%	Robinson's "replacement principle"
%
%	[P,Q]
%	 and		==>	[P]
%	[P,[not,Q]]

:- mode robinson_replace(+,+,-).
robinson_replace(Cl1,[Cl2|Cls],[Qr|Cls]) :-
	one_and_rest(Cl1,P,Pr),one_and_rest(Cl2,Q,Qr),
	(negate(P,R),negin(Q,S) ; negin(P,R),negate(Q,S)),R==S,
	equ_clause(Pr,Qr),!.
robinson_replace(Cl1,[Cl2|Cls],[Cl2|Cls1]) :- robinson_replace(Cl1,Cls,Cls1),!.

%	Resolution
%
%	[P,Q]			[P,Q]
%	 and		==>	 and
%	[P,[not,Q],R]		[P,R] (resolvent)

:- mode resolve(+,+,-).
resolve(Cl1,[Cl2|Cls],NewCls) :-
	one_and_rest(Cl1,P,Pr),one_and_rest(Cl2,Q,Qr),
	(negate(P,R),negin(Q,S) ; negin(P,R),negate(Q,S)),R==S,
	( subset_literals(Pr,Qr),NewCls=[Cl1,Qr|Cls] ;
	  subset_literals(Qr,Pr),NewCls=[Pr,Cl2|Cls] ),!.
resolve(Cl1,[Cl2|Cls],[Cl2|Cls1]) :- resolve(Cl1,Cls,Cls1),!.

%
%	       i	       k
%	\/ /\ P	   ==>	/\ \/ Q
%	 i  j  j	 k  l  l
%

:- mode andor_to_clauses(+,-).
andor_to_clauses(Ors,Clauses) :-
	setof(Ands,distribution(Ors,Ands),Clauses).

:- public distribution/2.
:- mode distribution(+,-).
distribution([Ands|Ors],[L1|Literals]) :- one_of(L1,Ands),
	distribution(Ors,Literals).
distribution([],[]).

:- public negate/2.
:- mode negate(+,-).
negate(t,f).
negate(f,t).
negate([not,X],X) :- !,negin(X,_),!.
negate(X,[not,X]).

:- mode negin(+,-).
negin([not,X],X1) :- !,negate(X,X1),!.
negin(X,X).

:- public neg_all/2.
:- mode neg_all(+,-).
neg_all([T|Ts],[NT|NTs]) :- negate(T,NT),neg_all(Ts,NTs),!.
neg_all([],[]).

:- public negin_all/2.
:- mode negin_all(+,-).
negin_all([T|Ts],[NT|NTs]) :- negin(T,NT),negin_all(Ts,NTs),!.
negin_all([],[]).

:- public neg_alls/2.
:- mode neg_alls(+,-).
neg_alls([T|Ts],[NT|NTs]) :- neg_all(T,NT),neg_alls(Ts,NTs),!.
neg_alls([],[]).

:- public clause_member/2.
:- mode clause_member(+,+).
clause_member(A,[B|_]) :- equ_clause(A,B),!.
clause_member(A,[_|B]) :- clause_member(A,B),!.

:- public equ_clause/2.
:- mode equ_clause(+,+).
equ_clause([A1|A],B) :- !,delete_literal(B,A1,B1),B\==B1,equ_clause(A,B1),!.
equ_clause(X,X).

:- public delete_literal/3.
:- mode delete_literal(+,+,-).
delete_literal([A1|A],B,C) :- A1==B,!,delete_literal(A,B,C),!.
delete_literal([A1|A],B,[A1|C]) :- delete_literal(A,B,C),!.
delete_literal([],_,[]).

:- public subset_literals/2.
:- mode subset_literals(+,+).
subset_literals([A1|A],B) :- member(A1,B),subset_literals(A,B),!.
subset_literals([],_).

% EOF clause.pl
