%
%	(C)1992 Institute for New Generation Computer Technology
%	$@G[I[$=$NB>$O(JCOPYRIGHT$@%U%!%$%k$r;2>H$7$F2<$5$$(J
%	(Read COPYRIGHT for detailed information.)
%
class initiator has

instance

attribute
   result;


:initialize(Class,Obj):-
%    :new(Class,Initiator),  
    initialize(Class,Obj);


local

  initialize(Initiator,Obj):-
    set_my_node(Obj),
    set_init_cdntor(Obj),
    set_init_environment(Obj);

  set_my_node(Obj):-
      :get_my_node(#network_node_name,MyNode),
      :set_slot(Obj,my_node,MyNode),!;

  set_init_cdntor(Obj):-
      (:login_user_list(#network_login_user,Member,nil);
        Member = []),
      :create(#standard_scrolling_menu,[items_list([]),title("cordinator"),position(400,300),size(300,200)],Menu),
      set_menu_username(Menu,Member,0),
      :activate(Menu),
      :read(Menu,Cdntor),
      :kill(Menu),
      :set_slot(Obj,cdntor,Cdntor),!;

    set_menu_username(Menu,[],N):-!,
      :get_my_node(#network_node_name,My_Node),
      :add_item(Menu,{"me",common,My_Node,"me"},N);
    set_menu_username(Menu,[{Node,User}|Member],N):-
      :append(#string,[Node,"::",User],Item),
      :add_item(Menu,{Item,common,Node,Item},N),
      set_menu_username(Menu,Member,N+1);

  set_init_environment(Obj):-
    equal_string(Obj!my_node,Obj!cdntor),!,
    invoke_my_env_getter(Obj,Stream),
    my_node_env_setter(Obj,Stream);
  set_init_environment(Obj):-
    :spawn(#net_spawn_user,Obj!cdntor,"env_getter",Line,nil,_,Status),
    equal_string(Status,"success"),!,
    other_node_env_setter(Obj,Line);

    invoke_my_env_getter(Obj,Stream):-
      :create(#stream,Stream),
      :create(#my_env_getter,Env_getter),
      :create(#process,Proc),
      :activate(Proc,Env_getter),
      :set_slot(Env_getter,stream,Stream),!;

 my_node_env_setter(Obj,Stream):-!,
   :create(#standard_io_buffer,StringB),
   repeat,
    :get(Stream,SMsg),
    melt_string(StringB,SMsg,Msg),
    set_init_env(Obj,Msg);    
 other_node_env_setter(Obj,Line):-!,
    :create(#network_listener_buffer,Buf,1024,16),
    :create(#standard_io_buffer,StringB),
   (repeat,
    :receive(Line,Buf),
     :convert(Buf,String,R_size,_,_,_,_),
     substring(String,0,R_size/2,SMsg),
     :putt(StringB,SMsg),
     :getl(StringB,Msg),    
     set_init_env(OBJ,Msg)),
     (Msg==set_init_end;Msg==exit,cut_and_fail);


set_init_env(Obj,Msg):-
    Msg=set_init_env(Slot,Content),
    freeze(Content,FContent),
    :set_slot(Obj,Slot,FContent),
    cut_and_fail;
set_init_env(Obj,Msg):-
    Msg==set_init_end;
set_init_env(Obj,Msg):-
    Msg==exit;


melt_string(StringB,SMsg,Msg):-
    :putl(StringB,SMsg),
    :gett(StringB,Msg),!;

end.





