%
%	(C)1992 Institute for New Generation Computer Technology
%	$@G[I[$=$NB>$O(JCOPYRIGHT$@%U%!%$%k$r;2>H$7$F2<$5$$(J
%	(Read COPYRIGHT for detailed information.)
%
class env_getter has

nature
  as_server_program;

instance

  attribute

    line;


:goal(Obj):-
    :get_slot(Obj,line,Line),
    env_getter(Obj);

local
    env_getter(_);

end.

class my_env_getter has

nature
  as_program;

instance

  attribute

    stream,
    stringb,
    my;


:goal(Obj):-
    :get_slot(Obj,stream,Stream),
    :create(#standard_io_buffer,StringB),
    :set_slot(Obj,stringb,StringB),
    env_getter(Obj);

local

    env_getter(Obj):-
     decide_problem(Obj),
     decide_participants(Obj),
     :put(Obj!stream,"set_init_end"),!;
    env_getter(Obj):-
     :put(Obj!stream,"exit"),!;

decide_problem(Obj):-
     :new(#g_menu_pro,Decide_pro_menu),
     :new(#decide_problem,DPro),
     :decide_problem(DPro,Decide_pro_menu,Mode,Problem),
     set_init_env(Obj,pmode,Mode),
     set_init_env(Obj,problem,Problem);

decide_participants(Obj):-
     :new(#g_menu_par,Decide_par_menu),
     :new(#decide_participants,DPar),
     :decide_participants(DPar,Decide_par_menu,Party,Network),
     set_init_env(Obj,network,Network),
     set_init_env(Obj,party,Party);

set_init_env(Obj,Slot,Contents):-
     freeze_string(Obj!stringb,set_init_env(Slot,Contents),SData),
     :put(Obj!stream,SData);


freeze_string(StringB,Msg,SData):-
     :putt(StringB,Msg),
     :getl(StringB,SData);


decide_probrem(Mode,Problem):-
     :create(#standard_io_window,[size(300,400)],W),
     :activate(W),
     :gett(W,Mode),
     :gett(W,Problem),
     :kill(W);
decide_participant(Network,Party):-
     :create(#standard_io_window,[size(300,400)],W),
     :activate(W),
     :gett(W,Network),
     :gett(W,Party),
     :kill(W);






end.
