;; Major mode for editing CESP, and for running CESP under Emacs
;; Copyright (C) 1990 Free Software Foundation, Inc.
;; Copyright (C) 1990 AI LANGUAGE RESEARCH INSTITUTE

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

(defvar CESP-menu-buffer "*CESP-menu-")
(defvar CESP-menu-id "\C-j")
(defvar CESP-id "\C-c\C-e\C-s\C-p")
(defvar CESP-failure "\C-c\C-e\C-s\C-pf")
(defvar CESP-success "\C-c\C-e\C-s\C-ps")
(defvar CESP-menu-mode-map nil)

(defvar CESP-previous-string "")

(defun CESP-filter (process string)
  " CESP-filter    "
  (progn 
    ;;(set-buffer (process-buffer process))
    (let ((cat-string (concat CESP-previous-string string)))
      (setq CESP-previous-string "")
      (CESP-read-tag process cat-string) ))
  )

;; (funcall (aref CESP-dispatch-table CESP-output-switch) process string))


(defun CESP-string-match (regexp string &optional start)
  "string-match $B$HF1MM$@$,(B. 
string-match $B$O(B MSD $B$,N)$C$F$$$k$H$b$&(B 1byte $B$r8+$F$7$^$&$?$a(B
$B$3$N4X?t$G>e=q$-$7$F$*$/(B"
  (let ((index1 (string-match regexp string start))
	(index2 (string-match (concat "." regexp) string start)))
    (if (integerp index1)
	(if (integerp index2)
	    (if (< index1 index2) index1 (1+ index2))
	  index1)
      (if (integerp index2) (1+ index2)))))

(defvar CESP-insert-delimiter
  "\\(\\|\\|\\|\\|.\\|..\\)$")

;;
;;
;; "" --> 03 05 19 16 (decimal notation)
;; string $B$,(B "$B!&!&!&!&!&(B" $B$H$$$&2DG=@-$,$"$k!#(B
;; $B4pK\E*$K0lHV:G8e$K$"$k%3%^%s%I$O<!$N(B string $B$NF,$K$D$1$k!#(B
;;

;(get-buffer-create "deb")

(defun CESP-read-tag (process string)
  (let ((code1)
	(code2)
	(string1)
	(arg_string) )
    (while (not (string= string ""))
;      (save-excursion (set-buffer "deb") (insert string) (insert "\n\n"))
      (let ((posi (CESP-string-match CESP-id string))  ;;""
	    (len (length string)))
	(if posi 
	    nil
	  (setq posi (if (> (string-to-char string) ?\177)
			 (CESP-string-match CESP-id string 1))))
	(if (and posi (< 5 len))
	    (progn
	      (if (eq posi 0)
		  (let ((next-arg))
		    (setq code1 (aref string 4))
		    (setq code2 (aref string 5))
		    (setq string1 (substring string 6 nil))
		    (setq posi (CESP-string-match CESP-id string1))
		    (if posi
			(progn
			  (CESP-dispatch process code1 code2
					 (substring string1 0 posi))
			  (setq string (substring string1 posi nil)))
		      (if (and (= code1 0) (= code2 0))
			  (setq string string1)
			(setq CESP-previous-string string)
			(setq string ""))))
		;; $B%?%0$,@hF,$K$J$$$H$-(B
		(CESP-insert CESP-print-buffer (substring string 0 posi))
		(setq string (substring string posi nil))))
	      ;; $B%?%0$,$J$$$H$-(B
	  (if (CESP-string-match CESP-insert-delimiter string)
	      (setq CESP-previous-string string)
	    (CESP-insert CESP-print-buffer string))
	  (setq string ""))))))

(defun CESP-dispatch (process code1 code2 arg_string)
  (progn
    ;; $B%G%P%C%0MQ(B
;    (save-excursion
;      (set-buffer (get-buffer-create "deb"))
;      (insert (format "code1 = %d , " code1))
;      (insert (format "code2 = %d , " code2))
;      (insert arg_string)
;      (insert "\n"))

    (let ((c (logand code1 240)))
      (cond
       ((eq c 0)  ;0x00
	(CESP-base-dispatch   process code1 code2 arg_string))
       ((eq c 16) ;0x10
	(CESP-buffer-dispatch process code1 code2 arg_string))
       ((eq c 32) ;0x20
	(CESP-file-dispatch   process code1 code2 arg_string))
       ((eq c 48) ;0x30
	(CESP-cursor-dispatch process code1 code2 arg_string))
       ((eq c 64) ;0x40
	(CESP-window-dispatch process code1 code2 arg_string))
       ((eq c 80) ;0x50
	(CESP-completion-dispatch process code1 code2 arg_string))
       ((eq c 96) ;0x60 
	(CESP-window-dispatch2 process code1 code2 arg_string))
       ((eq c 112);0x70 = 112
	(CESP-misc-dispatch process code1 code2 arg_string))
       ((eq c 128);0x80 = 128
	(KWIC-dispatch process code1 code2 arg_string))
       ))))

(defun CESP-base-dispatch (process code1 code2 arg_string)
  ;; 0x00 $B4pK\@)8f(B
  "Arguments are PROCESS, CODE1, CODE2 and ARG_STRING.
Output ARG_STRING if CODE1 is 0x00.
    To standard buffer if CODE2 is 0x1*.
    To current buffer if CODE2 is 0x2*.
    To mini buffer if CODE2 is 0x3*.
Goto line ARG_STRING, counting from line 1 at beginning of current buffer
if CODE1 is 0x01.
Set CESP-set-marker to number which is converted ARG_STRING
if CODE1 is 0x02."
  (let ((c2 (ash code2 -4)))
    (cond
     ((eq code1 0)
      (cond
       ((eq c2 0)
	(CESP-insert CESP-print-buffer arg_string))
       ((eq c2 1)
	(CESP-insert CESP-current-buffer arg_string))
       ((eq c2 2)
	(CESP-insert CESP-sub-buffer arg_string))
       ((eq c2 3) 
	(message arg_string)) ))
     ((eq code1 1)
      (save-excursion
	(cond
	 ((eq c2 0)
	  (CESP-set-buffer process CESP-main-buffer))
	 ((eq c2 1)
	  (CESP-set-buffer process CESP-current-buffer))
	 ((eq c2 2)
	  (CESP-set-buffer process CESP-sub-buffer)))
	(goto-line (string-to-int arg_string))
	(set-marker CESP-insert-point (point))))
     ((eq code1 2)
      (save-excursion
	(cond
	 ((eq c2 0)
	  (CESP-set-buffer process CESP-main-buffer))
	 ((eq c2 1)
	  (CESP-set-buffer process CESP-current-buffer))
	 ((eq c2 2)
	  (CESP-set-buffer process CESP-sub-buffer)))
	(set-marker CESP-insert-point (string-to-int arg_string))))
      ((eq code1 3)
      (setq CESP-subsystem (intern arg_string)))
     ((eq code1 4) ;; $B=PNO@h$NJQ99(B
      (setq CESP-print-buffer arg_string))
     ((eq code1 5)
      (setq CESP-print-buffer CESP-main-buffer))
     ((eq code1 6)
      (let ((w (get-buffer-window (current-buffer))))
	(if w
	    (set-window-point w CESP-insert-point))
	(setq CESP-print-buffer CESP-main-buffer)))
     ((eq code1 7)
      (setq CESP-system-name arg_string))
     )))

;; 0x10 $B%P%C%U%!@)8f(B
(defun CESP-buffer-dispatch (process code1 code2 arg_string)
  "Control CESP buffer.
If CODE1 is 0x10, create buffer.
    	 is 0x11, set buffer.
    	 is 0x12, kill buffer.
    	 is 0x13, reset buffer.
    	 is 0x14, create io buffer.
    	 is 0x15, set compile-buffer.
"
  (cond
   ((eq code1 16)
    (if (get-buffer arg_string)
	nil
      (save-excursion
	(set-buffer (get-buffer-create arg_string ))
	(setq CESP-insert-point (make-marker))
	(set-marker CESP-insert-point 0)
	(local-set-key "\e\C-i" (quote CESP-complete-symbol)))))
   ((eq code1 17)
    (setq CESP-current-buffer (get-buffer-create arg_string)))
   ((eq code1 18) 
    (if (equal
	 arg_string
	 (buffer-name (process-buffer process)))
	nil
      (kill-buffer arg_string)
      (if (equal arg_string (buffer-name CESP-current-buffer))
	  (setq CESP-current-buffer
		(process-buffer process)))))
   ((eq code1 19)
    (setq CESP-current-buffer CESP-main-buffer))
   ((eq code1 20)
    (save-excursion
      (set-buffer (get-buffer arg_string))
      (CESP-user-mode)))
   ((eq code1 21)
    (print "Not Implement"))
   ((eq code1 22)
    (save-excursion
      (set-buffer (get-buffer-create arg_string))
      (setq CESP-insert-point (make-marker))
      (set-marker CESP-insert-point 0)
      (CESP-user-mode)))
   ((eq code1 23)
    (save-excursion
      (set-buffer CESP-current-buffer)
      (if (eq major-mode 'CESP-user-mode)
	  (setq shell-prompt-pattern arg_string))))
   ))
   
(defun CESP-file-dispatch (process code1 code2 arg_string)
     ;; 0x20 $B%U%!%$%k@)8f(B
  (cond
   ((eq code1 32)
    (save-excursion
      (set-buffer (find-file-noselect arg_string t))
      (setq CESP-insert-point (make-marker))
      (set-marker CESP-insert-point 0)
      (local-set-key "\e\C-i" (quote CESP-complete-symbol))))
   ((eq code1 33) 
    (save-excursion
      (set-buffer CESP-current-buffer)
      (write-file arg_string)))
   ((eq code1 34)
    (save-excursion
      (set-buffer (find-file-noselect arg_string t))
      (CESP-user-mode)))
   ))

;;(defun CESP-cursor-dispatch (process code1 code2 arg_string)
;;  (cond 
;;   ((eq code1 48) 
;;    (CESP-set-buffer process CESP-current-buffer)      
;;    (goto-line (string-to-int arg_string)))
;;   ((eq code1 49)
;;    (CESP-set-buffer process CESP-current-buffer)
;;    (goto-char (string-to-int arg_string)))
;;   ))

(defun CESP-window-dispatch (process code1 code2 arg_string) 
     ;; 0x40 $B%&%$%s%I%&@)8f(B
  (let
      ((window (get-buffer-window CESP-current-window))
       (previous-buffer (window-buffer))
       )
    (if window
	nil
      (if (get-buffer-window CESP-main-buffer)
	  (progn
	    (if (get-buffer CESP-current-window)
		nil
	      (setq CESP-current-window (buffer-name CESP-main-buffer)))
	    (setq window (display-buffer CESP-current-window) ))))
    (if window
	(save-excursion
	  ; (select-window window)
	  (cond
	   ((eq code1 64)
	    (display-buffer arg_string)
	    ;;(set-window-buffer (selected-window) arg_string)
	    (setq CESP-current-window arg_string)
	    ) 
	   ((eq code1 65)
	    (split-window-vertically))
	   ((eq code1 66)
	    (split-window-horizontally))
	   ((eq code1 67)
	    (other-window (string-to-int arg_string)))
	   ((eq code1 68)
	    (print "Not Implement"))
	   ((eq code1 69)
	    (delete-other-windows))
	   ((eq code1 70)
	    (enlarge-window (string-to-int arg_string)))
	   ((eq code1 71)
	    (enlarge-window-horizontally (string-to-int arg_string)))
	   ((eq code1 72)
	    (set-window-point window (string-to-int arg_string)))
	   ((eq code1 73)
	    (let ((pp (point))
		  (p (save-excursion
		       (set-buffer (get-buffer CESP-current-window))
		       (goto-line (string-to-int arg_string))
		       (point)) ))
	      (goto-char p)
	      (recenter -1)
	      (goto-char pp)
	      ))
	   ((eq code1 74)
	    (setq CESP-current-window CESP-main-buffer)
	    (set-window-buffer (selected-window) CESP-main-buffer))
	   ((eq code1 75)
	    (let* ((p) (pe) (buf))
	      (save-excursion
		       (set-buffer (get-buffer CESP-current-window))
		       (goto-line (string-to-int arg_string))
		       (beginning-of-line 1)
		       (setq p (point))
		       (end-of-line 1)
		       (setq pe (point))
		       (setq buf (buffer-substring p pe))
		       (save-excursion
			 (set-buffer "*CESP-tmp*")
			 (let ((b (point)))
			   (insert buf)
			   (untabify b (point))
			   (setq overlay-arrow-string 
				 (concat "=>" (buffer-substring b (point)))))
			 (delete-region (point-min) (point-max))))
	      (or overlay-arrow-position
		  (setq overlay-arrow-position (make-marker)))
	      (set-marker overlay-arrow-position p
			  (get-buffer CESP-current-window))
	      (set-window-point window p)))
	   ((eq code1 76)
	    (if overlay-arrow-string
		(progn (setq overlay-arrow-position nil)
		       (setq overlay-arrow-string nil))))
	   ((eq code1 77)
	    (if CESP-insert-point
		(set-window-point window CESP-insert-point))
	    (setq CESP-print-buffer CESP-main-buffer))
	   ((eq code1 78)
	    (let ((w (selected-window)))
	      (set-window-buffer (selected-window) arg_string)
	      (delete-other-window w)))
	   )
	  (select-window (get-buffer-window previous-buffer))
	  )
      (cond
       ((eq code1 64)
	(setq CESP-current-window arg_string))
       ((eq code1 77)
;	(if CESP-insert-point
;	    (set-window-point window CESP-insert-point))
	(setq CESP-print-buffer CESP-main-buffer))))
    ) )
;(defun CESP-completion-dispatch (process code1 code2 arg_string)  )


(defun CESP-window-dispatch2 (process code1 code2 arg_string)
  ;; 0x60 $B%&%$%s%I%&@)8f(B2
  (cond
   ((eq code1 96)  ;;select emacs window
    (setq CESP-current-window arg_string)
    )
   ((eq code1 97)  ;; show emacs window
    (let ((w (selected-window)))
      (set-window-buffer (selected-window) arg_string)
      (delete-other-windows))    
    )
   ((eq code1 98)   	    	;; expose emacs window     0x62
    (display-buffer arg_string))
   ((eq code1 99)   	    	;; split window vertically 0x63
    (let* ((bn1 (substring arg_string 0 code2))
	   (bn2 (substring arg_string code2 nil))
	   (b1 (get-buffer bn1))
	   (b2 (get-buffer bn2)))
      (if (and b1 b2)
	  (let ((w (get-buffer-window b1))
		(w1 (selected-window)))
	    (if w
		(save-excursion
		  (select-window w)
		  (set-window-buffer (split-window-vertically) b2)
		  (select-window w1)))))))
   ((eq code1 100)  	    	;; split window horizontally 0x64
    (let* ((bn1 (substring arg_string 0 code2))
	   (bn2 (substring arg_string code2 nil))
	   (b1 (get-buffer bn1))
	   (b2 (get-buffer bn2)))
      (if (and b1 b2)
	  (let ((w (get-buffer-window b1))
		(w1 (selected-window)))
	    (if w
		(save-excursion
		  (select-window w)
		  (set-window-buffer (split-window-horizontally) b2)
		  (select-window w1)) )))))
   ;; menu 
   ((= code1 101)   ; 0x65
    (CESP-menu-create arg_string))
    ))

;; menu-mode 

(if CESP-menu-mode-map
    nil
  (setq CESP-menu-mode-map (make-sparse-keymap))
  (define-key CESP-menu-mode-map " " 'CESP-menu-select)
  )

(defun CESP-menu-mode ()
  "CESP manu mode.
\\{CESP-mode-menu-map}"
  (interactive)
  (use-local-map CESP-menu-mode-map)
  (setq major-mode 'CESP-menu-mode)
  (setq mode-name "CESP-menu")
  (run-hooks 'CESP-menu-mode-hook))

(defun CESP-menu-create (string)
  (save-excursion
    (let (b big b-name end pos cha)
      (string-match CESP-menu-id string)
      (setq big (match-beginning 0))
      (setq b-name 
	    (concat CESP-menu-buffer (substring string 0 big)))
      (setq b (get-buffer b-name))
      (if b
	  (progn
	    (display-buffer b)
	    (set-buffer b))
	(setq b (get-buffer-create b-name))
	(display-buffer b)
	(set-buffer b)
	(local-set-key " " 'CESP-menu-select))
      (CESP-menu-mode)
      (setq buffer-read-only nil)
      (erase-buffer)
      (setq end (length string))
      (setq pos (1+ big))
      (while (< pos end)
	(setq cha (aref string pos))
	(if (= cha (string-to-char CESP-menu-id))
	    (newline)
	  (insert cha))
	(setq pos (1+ pos)))
      (setq buffer-read-only t))))

(defun CESP-menu-select ()
  (interactive)
  (save-excursion
    (let (e)
      (end-of-line nil)
      (setq e (point))
      (beginning-of-line nil)
      (send-string CESP-main-buffer-name
		   (format "%s.\n" (buffer-substring (point) e)) ))))


(defun CESP-misc-dispatch (process code1 code2 arg_string)
  ;; 0x70 $B3F<o=hM}$$$m$$$m(B
  (cond
   ((eq code1 112)
    (CESP-child arg_string))))

(defun KWIC-dispatch (process code1 code2 arg_string)
  ;; 0x80 $B3F<o=hM}$$$m$$$m(B
  (cond
   ((eq code1 128)
    (eval(car(read-from-string arg_string))))))

;; menu-mode 

(if CESP-menu-mode-map
    nil
  (setq CESP-menu-mode-map (make-sparse-keymap))
  (define-key CESP-menu-mode-map " " 'CESP-menu-select)
  )

(defun CESP-menu-mode ()
  "CESP manu mode.
\\{CESP-mode-menu-map}"
  (interactive)
  (use-local-map CESP-menu-mode-map)
  (setq major-mode 'CESP-menu-mode)
  (setq mode-name "CESP-menu")
  (run-hooks 'CESP-menu-mode-hook))

(defun CESP-menu-create (string)
  (save-excursion
    (let (b big b-name end pos cha)
      (string-match CESP-menu-id string)
      (setq big (match-beginning 0))
      (setq b-name 
	    (concat CESP-menu-buffer (substring string 0 big)))
      (setq b (get-buffer b-name))
      (if b
	  (progn
	    (display-buffer b)
	    (set-buffer b))
	(setq b (get-buffer-create b-name))
	(display-buffer b)
	(set-buffer b)
	(local-set-key " " 'CESP-menu-select))
      (CESP-menu-mode)
      (setq buffer-read-only nil)
      (erase-buffer)
      (setq end (length string))
      (setq pos (1+ big))
      (while (< pos end)
	(setq cha (aref string pos))
	(if (= cha (string-to-char CESP-menu-id))
	    (newline)
	  (insert cha))
	(setq pos (1+ pos)))
      (setq buffer-read-only t))))

(defun CESP-menu-select ()
  (interactive)
  (save-excursion
    (let (e)
      (end-of-line nil)
      (setq e (point))
      (beginning-of-line nil)
      (send-string CESP-main-buffer-name
		   (format "%s.\n" (buffer-substring (point) e)) ))))


; fork $B$7$?%W%m%;%9$NI8=`F~=PNO@ZBX$(MQ(B
(defvar CESP-write-process "write_pro")
(defvar CESP-read-process "read_pro")
(defvar CESP-write-buffer "w-CESP-child")
(defvar CESP-read-buffer "CESP-child")





(defun CESP-child (name-id)
  "Run an inferior CESP process, input and output via buffer *CESP*."
  (interactive)
  (let* ( read-pro
	  (pos (string-match "@@" name-id))
	  (socket-name (substring name-id 0 pos))
	  (read-buffer (generate-new-buffer CESP-read-buffer))
	  )
    (pop-to-buffer (get-buffer-create read-buffer))
    (CESP-child-mode)
    (setq process-id (substring name-id (+ pos 2) (length name-id)))
    (setq write-buffer (generate-new-buffer CESP-write-buffer))
    (setq read-process
	  (process-name
	   (setq read-pro
		 (start-process CESP-read-process read-buffer 
				(concat CESP-exec-directory 
					CESP-read-process)
				socket-name
				process-id
				))))
    (setq write-process
	  (process-name
	   (start-process CESP-write-process write-buffer 
			  (concat CESP-exec-directory 
				  CESP-write-process)
			  socket-name
			  process-id)))
    (set-process-sentinel read-pro 'CESP-process-sentinel)
    (goto-char (point-max))
    (set-marker (process-mark (get-buffer-process (current-buffer))) (point))
    ))

(defun CESP-process-sentinel (process event)
  (save-excursion
    (let ((b (process-buffer process)))
      (if (buffer-name b)
	  (progn
	    (set-buffer b)
	    (quit-process write-process)
	    (kill-buffer write-buffer))))))


(defvar CESP-child-mode-map nil)
(if CESP-child-mode-map
    nil
  (setq CESP-child-mode-map (make-sparse-keymap))
  (define-key CESP-child-mode-map "\C-m" 'CESP-child-send-input)
  (define-key CESP-child-mode-map "\C-c\C-w" 'backward-kill-word)
  (define-key CESP-child-mode-map "\C-c\C-c" 'interrupt-CESP-child-subjob)
  (define-key CESP-child-mode-map "\C-c\C-z" 'stop-shell-subjob)
  (define-key CESP-child-mode-map "\C-c\C-s" 'quit-CESP-subjob)
  (define-key CESP-child-mode-map "\C-c\C-k" 'quit-CESP-subjob)
  (define-key CESP-child-mode-map "\C-c\C-o" 'kill-output-from-shell)
  (define-key CESP-child-mode-map "\C-c\C-r" 'show-output-from-shell)
  (define-key CESP-child-mode-map "\C-c\C-y" 'copy-last-shell-input))

(defun interrupt-CESP-child-subjob ()
  (interactive)
  (start-process "kill" "kill-buf" "kill" "-2" process-id))

(defun quit-CESP-subjob ()
  (interactive)
  (start-process "kill" "kill-buf" "kill" "-15" process-id))


(defun CESP-child-mode ()
  (interactive)
  (kill-all-local-variables)
  (setq major-mode 'CESP-child-mode)
  (setq mode-name CESP-read-buffer)
  (setq mode-line-process '(": %s"))
  (use-local-map CESP-child-mode-map)
  (make-local-variable 'shell-directory-stack)
  (setq shell-directory-stack nil)
  (make-local-variable 'last-input-start)
  (setq last-input-start (make-marker))
  (make-local-variable 'last-input-end)
  (setq last-input-end (make-marker))
  (make-local-variable 'read-process)
  (make-local-variable 'write-process)
  (make-local-variable 'write-buffer)
  (make-local-variable 'process-id)
  (run-hooks 'CESP-child-mode-hook))
  
(defun CESP-child-send-input ()
  ""
  (interactive)
  (or (get-buffer-process (current-buffer))
      (error "Current buffer has no process"))
  (end-of-line)
  (if (eobp)
      (progn
	(move-marker last-input-start
		     (process-mark (get-buffer-process (current-buffer))))
	(insert ?\n)
	(move-marker last-input-end (point)))
    (beginning-of-line)
    ;; Exclude the shell prompt, if any.
    (re-search-forward shell-prompt-pattern
		       (save-excursion (end-of-line) (point))
		       t)
    (let ((copy (buffer-substring (point)
				  (progn (forward-line 1) (point)))))
      (goto-char (point-max))
      (move-marker last-input-start (point))
      (insert copy)
      (move-marker last-input-end (point))))
  ;; Even if we get an error trying to hack the working directory,
  ;; still send the input to the subshell.
  (condition-case ()
      (save-excursion
	(goto-char last-input-start)
	(shell-set-directory))
    (error (funcall shell-set-directory-error-hook)))
  (let ((process (get-buffer-process (current-buffer))))
    (process-send-region write-process last-input-start last-input-end)
    (set-marker (process-mark process) (point))))



; Emacs $B$G(B $B%]!<%H%U%!%$%k$r:o=|$9$k$H$-$K;HMQ$9$k(B
;    (if (file-exists-p CESP-write-port)
;	(delete-file CESP-write-port))
;    (if (file-exists-p CESP-read-port)
;	(delete-file CESP-read-port))

