%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

class assert_to_key has 
 

      :clear(Class,LIST):- !, 
          :clear(LIST); 
  
      :close(Class,LIST):- !, 
          :clear(LIST); 
 
      :asserta(Class,LIST,Key,Term):-  
          get_first(LIST,{Key,LIST2}), !,
          asserta(LIST2,Term);

      :asserta(Class,LIST,Key,Term):- !,
          :create(#list,LIST2), 
          asserta(LIST2,Term), 
          asserta(LIST,{Key,LIST2}); 
 
      :assertz(Class,LIST,Key,Term):- 
          get_first(LIST,{Key,LIST2}), !,
          assertz(LIST2,Term);

      :assertz(Class,LIST,Key,Term):- !,
          :create(#list,LIST2), 
          assertz(LIST2,Term), 
          assertz(LIST,{Key,LIST2}); 
 
      :retract(Class,LIST,Key,Term):- !, 
          get_first(LIST,{Key,LIST2}), 
          retract(LIST2,Term); 
 
      :get_first(Class,LIST,Key,Term):- !, 
          get_first(LIST,{Key,LIST2}), 
          get_first(LIST2,Term); 
 
      :get_last(Class,LIST,Key,Term):- !, 
          get_first(LIST,{Key,LIST2}), 
          get_last(LIST2,Term); 
 
      :update(Class,LIST,Key,Old,New):- !, 
          get_first(LIST,{Key,LIST2}), 
          update(LIST2,Old,New); 
 
      :get_contents(Class,LIST,Key,Contents):- !, 
          get_first(LIST,{Key,LIST2}), 
          listing(LIST2,Contents); 
 
      :all_contents(Class,LIST,Contents):- !, 
          listing(LIST,List), 
          all_contents(List,Contents); 
 
      :dump(Class,LIST,Contents):- !, 
          listing(LIST,List), 
          dump(List,Contents); 
 
      :get_key(Class,LIST,KeyList):- !, 
          listing(LIST,List), 
          get_key(List,KeyList); 
 
      :delete_key(Class,LIST,Key):- !, 
          retract(LIST,{Key,_}); 
 
      :sort_by_key(Class,LIST):- !, 
          listing(LIST,List), 
          qsort(List,List2), 
          :clear(LIST), 
          assertz_contents(LIST,List2); 
 
      :sort_by_key_reverse(Class,LIST):- !, 
          listing(LIST,List), 
          qsort_reverse(List,List2), 
          :clear(LIST), 
          assertz_contents(LIST,List2); 
 
local 
 
      asserta(LIST,Term):- !, 
          freeze(Term,TERM), 
          :add_first(LIST,TERM); 
 
      assertz(LIST,Term):- !, 
          freeze(Term,TERM), 
          :add_last(LIST,TERM); 
 
      assertz_contents(LIST,[Term|L]):- !, 
          freeze(Term,TERM), 
          :add_last(LIST,TERM), 
          assertz_contents(LIST,L); 
      assertz_contents(_,[]):- !; 
 
      retract(LIST,Term):- !, 
          :get_contents(LIST,H_List),   
          get_one(H,H_List),   
          melt(H,A),   
          A = Term ,   
          :remove(LIST,H);   
   
      get_first(LIST,Term):- !, 
          :get_contents(LIST,H_List),   
          get_one(H,H_List),   
          melt(H,A),   
          Term = A;   
   
      get_last(LIST,Term):-  !, 
          :get_contents(LIST,H_List),   
          reverse(H_List,H_List2),  
          get_one(H,H_List2),   
          melt(H,A),   
          Term = A;   
 
      update(LIST,A,B):- !,  
          :get_contents(LIST,H_List),  
          update(A,B, H_List,H_List2),  
          :put_contents(LIST,H_List2);  
 
      update(A,B,[H1|X],[H2|X]):-  
          melt(H1,A), !, freeze(B,H2);  
 
      update(A,B,[C|X],[C|Y]):- !,  
          update(A,B,X,Y);  
  
      listing(LIST,List):-  !, 
          :get_contents(LIST,H_List),  
          to_stack_list(H_List,List);  
 
      all_contents([{Key,LIST}|L],Ret):- !, 
          listing(LIST,List), 
          all_contents(L,R), 
          append(List,R,Ret); 
      all_contents([],[]):- !; 
 
      dump([{Key,LIST}|L],Ret):- !, 
          Ret =  [{Key,List}|R], 
          listing(LIST,List), 
          dump(L,R); 
      dump([],[]):- !; 
 
      get_key([{Key,_}|L],[Key|R]):- !, 
          get_key(L,R); 
      get_key([],[]):- !; 
 
      to_stack_list([H|X],[A|Y]):- !, 
          melt(H,A), to_stack_list(X,Y); 
      to_stack_list([],[]):- !; 
 
      get_one(A,[A|X]);   
      get_one(A,[B|X]):- get_one(A,X);   
  
      append([A|X],Y,[A|Z]):- !, 
          append(X,Y,Z); 
      append([],Y,Y):- !; 
 
      reverse(X,Y):- !,reverse(X,[],Y);   
   
      reverse([A|X],S,Y):- !,   
          reverse(X,[A|S],Y);   
      reverse([],Y,Y):- !;   
   
      qsort(X,Y):- !,qsort(X,Y,[]);      
   
      qsort([A|X],Y0,Y3):- !,   
          partition(X,A,S,L),   
          qsort(S,Y0,[A|Y2]),   
          qsort(L,Y2,Y3);   
      qsort([],Y,Y):- !;   
   
      qsort_reverse(X,Y):- !, 
          qsort_reverse(X,Y,[]);      
   
      qsort_reverse([A|X],Y0,Y3):- !,   
          partition(X,A,S,L),   
          qsort_reverse(L,Y0,[A|Y2]),   
          qsort_reverse(S,Y2,Y3);   
      qsort_reverse([],Y,Y):- !;   
   
      partition([B|X],A,S,L):-   
          A = {An,_}, 
          B = {Bn,_}, 
          Bn <  An, !,   
          S = [B|R],partition(X,A,R,L);   
   
      partition([B|X],A,S,L):-   
          A = {An,_}, 
          B = {Bn,_}, 
          Bn >= An, !,   
          L = [B|R],partition(X,A,S,R); 
      partition([],_,[],[]):- !;   
   
end.  
                                                                                                       