%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

class m_graph_win has 

      attribute 
         % (write_font := Font1 :- 
         %       :create(#font, "test_11",Font1)),
         % (label_font := Font2 :- 
         %       :create(#font,"kanji_16",Font2)),
           window;

      :test(Class,Sx,Sy):- !,
           :create(Class,W,Sx,Sy),
           :clear(W),
           :draw_line(W,20,40,120,40),
           :draw_line(W,120,40,120,200),
           :draw_line(W,120,200,20,200),
           :draw_line(W,20,200,20,40),
           :show(W);

      :create(Class,WIN,Sx,Sy):- !,
           :get_slot(#m_font_table,font_11,Write_Font),
           :get_slot(#m_font_table,font_16,Label_Font),
        %  Win_Para = [ font(Class!write_font), 
           Win_Para = [ font(Write_Font), 
                        position(500,400),
                      % size(140,240), 
                        size(Sx,Sy), 
                      % label_font(Class!label_font), 
                        label_font(Label_Font), 
                        title("  trace(MDL-Tree)") ],
           :create(#standard_io_window,Win_Para,WIN), 
           :set_slot(Class,window,WIN);

      :create(Class,Ins,Win_Para):- !,
           :new(Class,Ins), 
           :create_window(Ins,Win_Para); 

      :kill(Class):- !,
           :get_slot(Class,window,WIN), 
           :kill(WIN); 
 
instance 
 
      attribute 
           window;
 
 
      :create_window(Ins,Win_Para):- !,
           :create(#standard_io_window,Win_Para,WIN), 
           :set_slot(Ins,window,WIN), 
           :clear(Ins); 
 
      :get_window(Ins,WIN):- !,
           :get_slot(Ins,window,WIN); 
 
      :clear(Ins):- !,
           :get_slot(Ins,window,WIN), 
           :clear(WIN), 
           :unquote_atom(WIN), 
           :erase_cursor(WIN); 
 
      :reshape(Ins,X,Y,Width,Height):- !,
         debug(reshape(X,Y,Width,Height)),
           :get_slot(Ins,window,WIN), 
           :reshape(WIN,X,Y,Width,Height);

      :show(Ins):- !,
           :get_slot(Ins,window,WIN),
           :show(WIN), 
           :expose(WIN);
         % :show(WIN); 
 
      :unshow(Ins):- !, 
           :get_slot(Ins,window,WIN), 
           :deactivate(WIN); 
 
      :kill(Ins):- !,
           :get_slot(Ins,window,WIN), 
           :kill(WIN); 
 
local
      debug(A);
end. 
 
class m_graph_menu has 

      attribute 
           object := 0;

      :create(Class,Ins):-    
           :get_slot(Class,object,Ins),
           object(Ins,_,_), !, true ;

      :create(Class,Ins):- !,
           :new(Class,Ins),
           :set_slot(Class,object,Ins),
           :create(Ins);

instance

      attribute 
         % (font := Font :- 
         %       :create(#font,"font_13",Font)),
           menu := 0;


      :create(Ins):- 
           :get_slot(Ins,menu,MENU),
           object(MENU,_,_), !, true ;

      :create(Ins):- !,
           :get_slot(#m_font_table,font_13,Font),
           Menu_Para =  
                [ label_flag(on), 
                % label_font(Ins!font), 
                  label_font(Font),
                  position(500,800),
                  items_list(Menu) ], 
           Menu = [{"  ok  ",common,ok,_}], 
           :create(#standard_menu,Menu_Para,MENU), 
           :set_title(MENU,"  pause"),
           :set_slot(Ins,menu,MENU); 

      :pause(Ins):-
           :get_slot(Ins,menu,MENU),
           (MENU = 0, !, fail
              ;
            :activate(MENU),
            :read(MENU,_),
            :deactivate(MENU)); 

      :kill(Ins):-
           :set_slot(#m_graph_menu,object,0),
           :get_slot(Ins,menu,MENU),
           :set_slot(Ins,menu,0),
           :kill(MENU);
 
end.
                                                                                     