%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

class mdl_graphic has

attribute  
       % (font_8 := Font :- 
       %     :create(#font,"b_8_14",Font)),
       %  font_size_x_8 := 8,    
       %  font_size_y_8 := 20,
       %
       % (font_10 := Font :- 
       %     :create(#font,"test_10",Font)),
       %  font_size_x_10 := 10,    
       %  font_size_y_10 := 20,
       %
       % (font_11 := Font :- 
       %     :create(#font,"test_11",Font)),
       %  font_size_x_11 := 11,    
       %  font_size_y_11 := 20,
       %
       % (font_13 := Font :- 
       %     :create(#font,"font_13",Font)),
       %  font_size_x_13 := 13,    
       %  font_size_y_13 := 20,

          thickness_size_of_line := 2,
          cannot_draw_symbol     := ".",

          debug_mode := off ;


          :draw_line(Class,Window,X1,Y1,X2,Y2):- !,
              :get_slot(Class,thickness_size_of_line,Width),
              :draw_line(Window,X1,Y1,X2,Y2,Width,solid,set);
     
          :draw_circle(Class,Window,X,Y,Radius):- !,
              :get_slot(Class,thickness_size_of_line,LineWidth),
              :draw_circle(Window,X,Y,Radius,LineWidth,solid,set);

          :draw_circle(Class,Window,X,Y,Radius,PaintPattern,Operation):- !,
              :get_slot(Class,thickness_size_of_line,LineWidth),
              :draw_filled_circle(Window,X,Y,Radius,LineWidth,
                                  PaintPattern,Operation);

          :draw_string(_,_,_,_,_,_,"",_):- !,fail;
          :draw_string(Class,Window,X,Y,Area_Size_X,Area_Size_Y,
                                    String,FontSize):-
              string(String,String_Length,_), !, 
              :get_font(Class,FontSize,Font,Font_Size_X,Font_Size_Y),

              (Class!debug_mode = on, !,
                  :draw_line(Window,X,Y,X+Area_Size_X,Y,1,solid,set), 
                  :draw_line(Window,X+Area_Size_X,Y,X+Area_Size_X,
                                    Y+Area_Size_Y,1,solid,set), 
                  :draw_line(Window,X+Area_Size_X,Y+Area_Size_Y,X,
                                    Y+Area_Size_Y,1,solid,set), 
                  :draw_line(Window,X,Y+Area_Size_Y,X,Y,1,solid,set)
                    ;
                  true), 
              %%%% for Debug %%%%
              %%%% for Error %%%%
              (Area_Size_Y <  Font_Size_Y, !, 
                  fail(":draw_string/8","Size_Y < Font_Size_Y")
                    ;
                  true),
              %%%% for Error %%%%
              Length_Area_Size_X = Area_Size_X / Font_Size_X,
              Length_Area_Size_Y = Area_Size_Y / Font_Size_Y,
              Length_Area_Size_X_Y = Length_Area_Size_X * Length_Area_Size_Y,

              (String_Length =< Length_Area_Size_X, !, 
                   :draw_string(Window,X,Y,String,Font,exclusive_or)
                                    ;
               String_Length  > Length_Area_Size_X, !, 
                   (Length_Area_Size_X_Y >= String_Length, !,
                       draw_string_loop(Window,X,Y,Length_Area_Size_X,
                                        Font_Size_Y,String,Font)
                           ;
                    Length_Area_Size_X_Y <  String_Length, !,
                       substring(String,0,Length_Area_Size_X_Y,SubString),
                       Position = Length_Area_Size_X_Y - 1,
                       :get_slot(#mdl_graphic,cannot_draw_symbol,S),
                       copy_string_elements(SubString,Position,1,S,0),
                       draw_string_loop(Window,X,Y,Length_Area_Size_X,
                                        Font_Size_Y,SubString,Font)));

          :draw_string(_,_,_,_,"",_):- !,fail;
          :draw_string(Class,Window,X,Y,String,FontSize):-
              string(String,String_Length,_), !,
              :get_font(Class,FontSize,Font,Font_Size_X,_),

              (Class!debug_mode = on, !,
                  :draw_line(Window,X,Y,X+20,Y,1,solid,set), 
                  :draw_line(Window,X,Y,X,Y+20,1,solid,set) 
                    ;
                  true), 
              %%%% for Debug %%%%
              (String_Length mod 2 = 0, !, 
                  L =  String_Length / 2 - 1
                       ;
               String_Length mod 2 > 0, !, 
                  L = (String_Length + 1) / 2 - 1),
              XX = X - L * Font_Size_X,
              :draw_string(Window,XX,Y,String,Font,exclusive_or);
              
          :draw_inf_of_node(Class,Window,X,Y,Area_Size_X,
                                  Name,Rate_by_float,FontSize):-
              string(Name,Name_Length,_),
              Rate_by_float < 100.0 ,  !,
              :get_font(Class,FontSize,Font,Font_Size_X,Font_Size_Y),

              %%%% for Debug %%%%
              (Class!debug_mode = on, !,
                  :draw_line(Window,X,Y,X+Area_Size_X,Y,1,solid,set), 
                  :draw_line(Window,X,Y,X,Y+2*Font_Size_Y,1,solid,set),
                  :draw_line(Window,X+Area_Size_X,Y,X+Area_Size_X,
                                    Y+2*Font_Size_Y,1,solid,set) 
                    ;
                  true), 
              %%%% for Debug %%%%
              Length_Area_Size_X = Area_Size_X / Font_Size_X,

              (Name_Length > Length_Area_Size_X, !,
                  substring(Name,0,Length_Area_Size_X,NewName),
                  :get_slot(#mdl_graphic,cannot_draw_symbol,S),
                  copy_string_elements(NewName,Length_Area_Size_X-1,1,S,0),
                  :draw_string(Window,X,Y,NewName,Font,exclusive_or)
                     ;
               Name_Length = Length_Area_Size_X, !,
                  :draw_string(Window,X,Y,Name,Font,exclusive_or)
                     ;
               Name_Length < Length_Area_Size_X, !,
                  Name_Over_Size = Area_Size_X - Name_Length * Font_Size_X,
                  Name_Margin_Size = Name_Over_Size / 2,
                  :draw_string(Window,X+Name_Margin_Size,Y,Name,Font,exclusive_or)),

              YY = Y + Font_Size_Y - 7,
              float_to_string(Rate_by_float,Rate),
              string(Rate,Rate_Length,_),
              
              (Rate_Length > Length_Area_Size_X, !,
                  substring(Rate,0,Length_Area_Size_X,NewRate),
                  :draw_string(Window,X,YY,NewRate,Font,exclusive_or)
                     ;
               Rate_Length = Length_Area_Size_X, !,
                  :draw_string(Window,X,YY,Rate,Font,exclusive_or)
                     ;
               Rate_Length < Length_Area_Size_X, !,
                  Rate_Over_Size = Area_Size_X - Rate_Length * Font_Size_X,
                  Rate_Margin_Size = Rate_Over_Size / 2,
                  :draw_string(Window,X+Rate_Margin_Size,YY,Rate,Font,exclusive_or));


          :get_font(Class,FontSize,Font,Font_Size_X,Font_Size_Y):- 
              (FontSize = 8, !,
                  :get_slot(#m_font_table,font_8,Font), 
                  :get_slot(#m_font_table,font_size_x_8,Font_Size_X), 
                  :get_slot(#m_font_table,font_size_y_8,Font_Size_Y)
                        ;
               FontSize = 10, !,
                  :get_slot(#m_font_table,font_10,Font), 
                  :get_slot(#m_font_table,font_size_x_10,Font_Size_X), 
                  :get_slot(#m_font_table,font_size_y_10,Font_Size_Y)
                        ;
               FontSize = 11, !,
                  :get_slot(#m_font_table,font_11,Font), 
                  :get_slot(#m_font_table,font_size_x_11,Font_Size_X), 
                  :get_slot(#m_font_table,font_size_y_11,Font_Size_Y)
                        ;
               FontSize = 13, !,
                  :get_slot(#m_font_table,font_13,Font), 
                  :get_slot(#m_font_table,font_size_x_13,Font_Size_X), 
                  :get_slot(#m_font_table,font_size_y_13,Font_Size_Y)
                    ;
                  fail);

          :get_font_size(Class,FontSize,Font_Size_X,Font_Size_Y):- 
              (FontSize = 8, !,
                  :get_slot(#m_font_table,font_size_x_8,Font_Size_X), 
                  :get_slot(#m_font_table,font_size_y_8,Font_Size_Y)
                        ;
               FontSize = 10, !,
                  :get_slot(#m_font_table,font_size_x_10,Font_Size_X), 
                  :get_slot(#m_font_table,font_size_y_10,Font_Size_Y)
                        ;
               FontSize = 11, !,
                  :get_slot(#m_font_table,font_size_x_11,Font_Size_X), 
                  :get_slot(#m_font_table,font_size_y_11,Font_Size_Y)
                        ;
               FontSize = 13, !,
                  :get_slot(#m_font_table,font_size_x_13,Font_Size_X), 
                  :get_slot(#m_font_table,font_size_y_13,Font_Size_Y)
                    ;
                  fail);

local

          draw_string_loop(_,_,_,_,_,"",_):- !,true;
          draw_string_loop(WIN,X,Y,Length,Dy,String,Font):- !,              
              sub_string_tail(String,0,Length,Sub,Tail),
              :draw_string(WIN,X,Y,Sub,Font,exclusive_or),
              draw_string_loop(WIN,X,Y+Dy,Length,Dy,Tail,Font);

          sub_string_tail(String,Position,Length,Sub,Tail):- 
              string(String,String_Length,_), 
              Position + 1 =< Length, !,
              (Position + Length <  String_Length, !, 
                  substring(String,Position,Length,Sub),
                  NextPosition = Position + Length,
                  string_tail(String,NextPosition,Tail)
                        ;
               Position + Length >= String_Length, !, 
                  string_tail(String,Position,Sub),
                  Tail = "");

          float_to_string(Float,String):- 
              floating_point(Float), !, MaxFract = 5,
              float_to_string(Float,MaxFract,String);

          float_to_string(Float,Max,String):- 
              (:get_floating_number_string(#symbolizer,Float,Max,String), !,
               true
                 ;
               float_to_string(Float,Max-1,String));
               
          fail(A,B):- !,fail;
end.                                                      