%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

class main_mdl_graph has 
 
      attribute   
           (list := L :- :create(#list,L)),

         % language := english,
           language := japanese,

         % color := yes,
         % color := no,
           color := 0,

         % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
         % (write_font := Font :- 
         %     % :create(#font,"b_8_14",Font)),
         %       :get_slot(
         % (title_font_english  := Font :- 
         %       :create(#font,"kanji_16",Font)),
         % (title_font_japanese := Font :- 
         %       :create(#font,"kanji_16",Font)),
         % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %

           window_title_english  := "MDL-Tree",
           window_title_japanese := "$B?dDjLZ(B",

           display_max_x := 1270,
           display_max_y :=  939,           

           display_center_x := 639,
           display_center_y := 450,

           window_position_x := 640,
           window_position_y := 480,

           max_window_size_x := 800,
           max_window_size_y := 700,

           min_window_size_x := 350,
           min_window_size_y := 320,

           window_hosei_x := 10,
           window_hosei_y := 40,

           debug_mode := off; 


      :create(Class,ID):- 
           check_ID(ID),
           :unify(#k_prolog_I,Class,list,{ID,_}),  !, 
           error(Class,"create/2","aleady created."); 
 
      :create(Class,ID):- !,
           check_ID(ID),
           :get_slot(#m_window_manager,language,Language),
           (Language = japanese, !,
               :set_slot(Class,language,Language)
                 ;
            Language =  english, !,
               :set_slot(Class,language,Language)
                 ;
               true),

          % :get_slot(Class,color,Color), 
          % (Color = 0, !,
               :get_slot(#m_window_manager,color,SetColor),
               :set_slot(Class,color,SetColor),
          %        ;
          %  true),
           :set_window_para(Class,ID,Win_Para,{X0,Y0}), 
           :create(#m_graph_win,Win_Ins,Win_Para), 
           :assert(#k_prolog_I,Class,list,
                  {ID,[Win_Ins,{X0,Y0}]}); 

      :write_TreeInf(Class,ID,TreeInf):- 
           check_ID(ID),
           :unify(#k_prolog_I,Class,list,
                 {ID,[Win_Ins,{X0,Y0}]}), !, 
           :read_TreeInf(#tree,TreeInf),
           :get_slot(#tree,temp_window_size_x,Win_Size_X),
           :get_slot(#tree,temp_window_size_y,Win_Size_Y),
           :get_slot(Class,window_hosei_x,Hosei_X),
           :get_slot(Class,window_hosei_y,Hosei_Y),
           :clear(Win_Ins), 

           :get_slot(Class,display_max_x,Display_Max_X0),
           :get_slot(Class,display_max_y,Display_Max_Y0),
           Window_Size_X = Win_Size_X + Hosei_X,
           Window_Size_Y = Win_Size_Y + Hosei_Y,

         % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
           Display_Max_X = Display_Max_X0 - 100,
           Display_Max_Y = Display_Max_Y0 -  50,
         % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %

           (Display_Max_X - X0  < Window_Size_X, !,
               XX = X0 - (Window_Size_X - (Display_Max_X - X0))
                  ;
            Display_Max_X - X0 >= Window_Size_X, !,
               XX = X0),

           (Display_Max_Y - Y0  < Window_Size_Y, !,
               YY = Y0 - (Window_Size_Y - (Display_Max_Y - Y0))
                  ;
            Display_Max_Y - Y0 >= Window_Size_Y, !,
               YY = Y0),

           :reshape(Win_Ins,XX,YY,Window_Size_X,
                                  Window_Size_Y),
           :get_window(Win_Ins,WIN),
           :get_slot(Class,debug_mode,Mode),
           (Mode = on,  !, 
               :show(WIN)
                   ;
            Mode = off, !, true),
           :write_TreeInf(#tree,WIN);

      :write_TreeInf(Class,ID,TreeInf,Data_Name):- 
           check_ID(ID),
           :unify(#k_prolog_I,Class,list,
                 {ID,[Win_Ins,{X0,Y0}]}), !, 
           :read_TreeInf(#tree,TreeInf),
           :get_slot(#tree,temp_window_size_x,Win_Size_X),
           :get_slot(#tree,temp_window_size_y,Win_Size_Y),
           :get_slot(Class,window_hosei_x,Hosei_X),
           :get_slot(Class,window_hosei_y,Hosei_Y),
           :clear(Win_Ins), 

           :get_slot(Class,display_max_x,Display_Max_X0),
           :get_slot(Class,display_max_y,Display_Max_Y0),
           Window_Size_X = Win_Size_X + Hosei_X,
           Window_Size_Y = Win_Size_Y + Hosei_Y,

         % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
           Display_Max_X = Display_Max_X0 - 100,
           Display_Max_Y = Display_Max_Y0 -  50,
         % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %

           (Display_Max_X - X0  < Window_Size_X, !,
               XX = X0 - (Window_Size_X - (Display_Max_X - X0))
                  ;
            Display_Max_X - X0 >= Window_Size_X, !,
               XX = X0),

           (Display_Max_Y - Y0  < Window_Size_Y, !,
               YY = Y0 - (Window_Size_Y - (Display_Max_Y - Y0))
                  ;
            Display_Max_Y - Y0 >= Window_Size_Y, !,
               YY = Y0),

           :reshape(Win_Ins,XX,YY,Window_Size_X,
                                  Window_Size_Y),
           :get_window(Win_Ins,WIN),
           :get_slot(Class,debug_mode,Mode),
           (Mode = on,  !, 
               :show(WIN)
                   ;
            Mode = off, !, true),
           :write_TreeInf(#tree,WIN,Data_Name);

      :unshow_window(Class,ID):- 
           check_ID(ID),
           :unify(#k_prolog_I,Class, 
                   list,{ID,[Win_Ins|_]}), !,
           :unshow(Win_Ins); 
 
      :show_window(Class,ID):- 
           check_ID(ID),
           :unify(#k_prolog_I,Class, 
                   list,{ID,[Win_Ins|_]}), !, 
           :show(Win_Ins); 
 
      :clear_window(Class,ID):- 
           check_ID(ID),
           :unify(#k_prolog_I,Class, 
                   list,{ID,[Win_Ins|_]}), !, 
           :clear(Win_Ins); 
 
      :close_window(Class,ID):- 
           check_ID(ID),
           :unify(#k_prolog_I,Class, 
                   list,{ID,[Win_Ins|_]}), !, 
           :kill(Win_Ins), 
           :retract(#k_prolog_I,Class,list,{ID,_}); 
 
      :close_window(Class,ID):- 
           check_ID(ID), !;

      :close_window(Class,ID):- 
           check_ID(ID), !,
           error(Class,"close_window/2","not created."); 

      :get_window(Class,ID,WIN):-
           check_ID(ID),
           :unify(#k_prolog_I,Class, 
                   list,{ID,[Win_Ins|_]}), !, 
           :get_window(Win_Ins,WIN);
 
      :set_window_para(Class,ID,Win_Para,{X0,Y0}):- !,
           :get_slot(Class,display_center_x,Px0),
           :get_slot(Class,display_center_y,Py0),

         % %%%%%%%%%%%%%%% %
           Px = Px0 + 100,
           Py = Py0 + 50,
         % %%%%%%%%%%%%%%% %

           X0 = Px+(ID-1)*20, 
           Y0 = Py+(ID-1)*20,
         % :get_slot(Class,write_font,WriteFont),
           :get_slot(#m_font_table,font_8,WriteFont),
           :get_slot(Class,language,Language),
           (Language = english,  !, 
             % :get_slot(Class,title_font_english,TitleFont),
               :get_slot(#m_font_table,font_16,TitleFont),
               :get_slot(Class,window_title_english,Title)
                   ;
            Language = japanese, !, 
             % :get_slot(Class,title_font_japanese,TitleFont),
               :get_slot(#m_font_table,font_16,TitleFont),
               :get_slot(Class,window_title_japanese,Title)),

         % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
           :get_slot(#m_window_manager,parent_window,PWIN),
           :get_slot(Class,color,SetColor),
           (SetColor = yes, !,
               RGB_Node = {65280,32512,    0}, % coral
               RGB_Leaf = {32512,65280,    0}, 
               RGB_Win  = {65280,63310,46735}, 
               Color_Pairs = color_pairs_list(
                                     [{0,2},
                                  %% [{0,{RGB_Win ,{0,0,0}}},
                                    % {2,{RGB_Win,RGB_Node}},
                                    % {4,{RGB_Win,RGB_Leaf}}]),
                                   %% {2,{RGB_Node,RGB_Win}},
                                   %% {4,{RGB_Leaf,RGB_Win}}]),
                                      {2,6},
                                      {4,8}]),
               Win_Para = [ font(WriteFont),
                            margin_flag(off),
                            superior(PWIN), 
                            position(X0,Y0),
                            size(Class!min_window_size_x,
                                 Class!min_window_size_y),
                            Color_Pairs,
                            label_font(TitleFont),
                            title(WindowLabel) ]
                     ;
            SetColor = no,  !,
               Win_Para = [ font(WriteFont),
                            margin_flag(off),
                            superior(PWIN), 
                            position(X0,Y0),
                            size(Class!min_window_size_x,
                                 Class!min_window_size_y),
                            label_font(TitleFont),
                            title(WindowLabel) ]),
         % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
  
           :get_number_string(#symbolizer,ID,IDs), 
           :append(#string,[" ",Title,"(",IDs,")"],
                           WindowLabel); 

      :get_max_win_size(Class,Size_X,Size_Y):- !,
           :get_slot(Class,max_window_size_x,Size_X),
           :get_slot(Class,max_window_size_y,Size_Y);
          
local
      debug(A);
    % check_ID(ID):- !;
      check_ID(ID):- integer(ID), !, true;

      error(Class,Method,ErrorMessage):- !, fail;

end.            