%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% Window for monitoring  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

class m_general_window has 

    nature k_prolog_I;
    attribute (window_list := List :- :create(#list,List));



    :init_slot(Class):- 
        :create(#list,List),
        :set_slot(Class,window_list,List),!;


    :create_window(Class,Ins,ParaList):-
        :new(Class,Ins),
        :create_window(Ins,ParaList),
        :assert(Class,window_list,Ins),
        !;


    :close_window(Class):-
        (:retract(Class,window_list,Ins),
            :get_slot(Ins,window,Menu),
            :kill(Menu),
            fail
         ;  true
        ),!;


instance

    attribute window; 
    attribute (io_buffer:= Buf :- :create(#standard_io_buffer,Buf));

  
    :create_window(Ins,ParaList):- 
        :create(#standard_io_window,ParaList,Window),
        :erase_cursor(Window),
        :set_slot(Ins,window,Window); 
 

    :write_message(Ins,Message):-
        :get_slot(Ins,window,Window),
        :activate(Window),
        :show(Window),
        :expose(Window),
        :get_slot(Ins,io_buffer,Buf),
        write_message(Window,Buf,Message),!;


    :write_message_us(Ins,Message):-
        :get_slot(Ins,window,Window),
        :get_slot(Ins,io_buffer,Buf),
        write_message(Window,Buf,Message),!;

    :write_string_us(Ins,Str):-
        :get_slot(Ins,window,Window),
        :write_lines(Window,Str),
        !;

    :print(Ins,Term):-
        :get_slot(Ins,io_buffer,Buf),
        :putt(Buf,Term),
        :getl(Buf,Str),
        :get_slot(Ins,window,Window),
        :activate(Window),
        :show(Window),
        :expose(Window),
        :write_lines(Window,Str),!;

    :print_us(Ins,Term):-
        :get_slot(Ins,io_buffer,Buf),
        :putt(Buf,Term),
        :getl(Buf,Str),
        :get_slot(Ins,window,Window),
        :write_lines(Window,Str),!;


    :nl(Ins):-
        :get_slot(Ins,window,Window),
        :show(Window),
        :expose(Window),
        next_line(Window),
        !;

    :change_font(Ins,Font):-
        :get_slot(Ins,window,Window),
        :change_font(Window,Font),!;


    :set_size(Ins,X,Y):- 
        :get_slot(Ins,window,Window),
        :set_size(Window,X,Y),!;

    :expose(Ins):- 
        :get_slot(Ins,window,Window),
        :expose(Window),!;

    :unshow(Ins):- 
        :get_slot(Ins,window,Window),
        :deactivate(Window),!;

    :show(Ins):-
        :get_slot(Ins,window,Window),
        :activate(Window),
        :show(Window),
        :expose(Window),!;


    :clear(Ins):-
        :get_slot(Ins,window,Window),
        :show(Window),
        :expose(Window),
        :clear(Window),!;


    :locate(Ins,X,Y):-
        :get_slot(Ins,window,Window),
        :move_cursor(Window,X,Y),
        !;


    :draw_string(Ins,X,Y,STR,Font):-
        :get_slot(Ins,window,Window),
        :activate(Window),
        :show(Window),
        :expose(Window),
        :draw_string(Window,X,Y,STR,Font,set),
        !;

    :draw_string_us(Ins,X,Y,STR,Font):-
        :get_slot(Ins,window,Window),
        :draw_string(Window,X,Y,STR,Font,set),
        !;

    :draw_rect(Ins,PosX,PosY,SizeX,SizeY,Pat,How):-
        (Pat = fix ; Pat = light_pain ; Pat = vertical_stripe ),
        (How = set ; How = reset ; number(How)),
        :get_slot(Ins,window,Window),
        :activate(Window),
        :show(Window),
        :expose(Window),
        :draw_filled_rectangle(Window,PosX,PosY,SizeX,SizeY,0,Pat,How),
        !;


    :draw_rect_us(Ins,PosX,PosY,SizeX,SizeY,Pat,How):-
        (Pat = fix ; Pat = light_pain ; Pat = vertical_stripe ),
        (How = set ; How = reset ; number(How)),
        :get_slot(Ins,window,Window),
        :draw_filled_rectangle(Window,PosX,PosY,SizeX,SizeY,0,Pat,How),
        !;


    :draw_line(Ins,PosX,PosY,SizeX,SizeY,Width,Type,OP):-
        :get_slot(Ins,window,Window),
        :activate(Window),
        :show(Window),
        :expose(Window),
        :draw_line(Window,PosX,PosY,SizeX,SizeY,Width,Type,OP),
        !;

    :draw_line_us(Ins,PosX,PosY,SizeX,SizeY,Width,Type,OP):-
        :get_slot(Ins,window,Window),
        :draw_line(Window,PosX,PosY,SizeX,SizeY,Width,Type,OP),
        !;

    :beep(Ins):- 
        :get_slot(Ins,window,Window),
        :beep(Window),!;

    :close_window(Ins):- 
        :get_slot(Ins,window,Window), 
        (object(Window,_,_),!,
            :kill(Window), 
            :set_slot(Ins,window,0)
         ;
            true
        ),
        !; 
      


local
    
    write_message(Window,_,[]):- !;
    write_message(Window,Buf,[nl|R]):-
        next_line(Window),
        write_message(Window,Buf,R);
    write_message(Window,Buf,[Data|R]):- 
        ( (atom(Data); string(Data,_,_) ; number(Data) ),!,
            :convert_to_string(#m_converter,Data,Str) ;

            :putt(Buf,Data),
            :getl(Buf,Str)
        ),
        %
        :show(Window),
        :expose(Window),
        :write_lines(Window,Str), 
        write_message(Window,Buf,R);
    

    next_line(Window):-
        :write(Window,key#lf), :write(Window,key#cr),!;


         
end. 
                                                                                                                    