%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% Window for selecting items of distribution menu 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
class m_distribution_item_menu has 
    nature k_prolog_I;
    attribute (window_list:= List :- :create(#list,List));


    :init_slot(Class):- 
        :create(#list,List),
        :set_slot(Class,window_list,List),!;


    :create_window(Class,Ins,Para):- 
        default_distribution_item_menu(Para,ParaList,ChoiceList), 
        :get_slot(#m_window_manager,language,Lang),
        (Lang = japanese,!, FontType = kanji_16 ; FontType = font_13),
        :create_window(#m_std_matrix_menu,FontType,ParaList,ChoiceList,Ins,Menu),
        :erase_cursor(Menu),
        :set_slot(Ins,window,Menu),
        :assert(Class,window_list,Ins),
        !; 


    :close_window(Class):-
        (:retract(Class,window_list,Ins),
            :get_slot(Ins,window,Menu),
            :kill(Menu),
            fail
         ;  true
        ),!;

    :get_default_para(Class,Para,ParaList,ChoiceList):-
        default_distribution_item_menu(Para,ParaList,ChoiceList);


    :test(Class,A,B):-
        :create_window(Class,Ins,[1,[]]),
        :read_and_set(Ins,A),
        :set_table(Ins,pe_list([1,2,3,4])),
        :read_and_set(Ins,B),
        :close_window(Ins),!;


local 
     
    set_color_inf(R):- 
        :get_slot(#m_window_manager,color,Color),
        (Color = yes , !,
                R = [label_color(3), drawing_color(4)]
         ;
                R = []
        ),!;


    %* 0 * 1 * 2 * 3
    %* 4 * 5 * 6 * 7
    %* 8 * 9 *10 *11
    %*12 *13 *14 *15 
    default_distribution_item_menu(Para,DefaultParaList,ChoiceList):- 
        :get_slot(#m_window_manager,parent_window,Parent),
        :get_font(#m_window_manager,LabelFont,Font,Lang),
        get_parameter(distribution_item_menu,Para,N,ParaList),
        set_color_inf(InfList),
        :get_pe_list(#m_environment,Pes),
        
        length(Pes,PeN),
        (PeN =:= 64 ,!,
            choice_list64(ChoiceList,N)
            ;
            choice_list16(ChoiceList,N)
        ),
         
        :get_number_string(#symbolizer,N,Str),
        (Lang = english,!,
            :append(#string,["Distributed PE ",Str],Title),
            :get_font(#m_window_manager,LabelFont,Font,Lang),
            TempParaList = [ font(Font), label_font(Font),
                      %size(218,153),
                      %  size(277,170),
                      title(Title),
                      color_pairs_list(superior),superior(Parent)
                      |InfList],

            append(ParaList,TempParaList,DefaultParaList)
        ; 
        Lang = japanese,!,
            :append(#string,["$BIi2YJ,;6(B PE(",Str,")"],Title),
            :get_font(#m_window_manager,LabelFont,Font,Lang),
            TempParaList = [ 
                      font(LabelFont), label_font(LabelFont),
                      %size(218,153),
                      %size(277,170),
                      title(Title),
                     color_pairs_list(superior),superior(Parent)
                     |InfList],

            append(ParaList,TempParaList,DefaultParaList)
        ),!;

    choice_list16(ChoiceList,1):- !,
            ChoiceList = [[[" 0", " 1", " 2", " 3"],
                           [" 4", " 5", " 6", " 7"],
                           [" 8", " 9", "10", "11"],
                          ["12", "13", "14", "15"]],
                         [[on, off,off,off],
                          [off,off,off,off],
                          [off,off,off,off],
                          [off,off,off,off]],
                         [[ 0, 1, 2, 3],
                          [ 4, 5, 6, 7],
                          [ 8, 9,10,11],
                          [12,13,14,15]]];

      choice_list16(ChoiceList,N):- !,
            ChoiceList = [[[" 0", " 1", " 2", " 3"],
                           [" 4", " 5", " 6", " 7"],
                           [" 8", " 9", "10", "11"],
                          ["12", "13", "14", "15"]],
                         [[on,on,on,on],
                          [on,on,on,on],
                          [on,on,on,on],
                          [on,on,on,on]],
                         [[ 0, 1, 2, 3],
                          [ 4, 5, 6, 7],
                          [ 8, 9,10,11],
                          [12,13,14,15]]];
     
            
    choice_list64(ChoiceList,1):- !,
           ChoiceList = [[[" 0", " 1", " 2", " 3"," 4"," 5"," 6"," 7"],
                          [" 8", " 9", "10", "11","12","13","14","15"],
                          ["16", "17", "18", "19","20","21","22","23"],
                          ["24", "25", "26", "27","28","29","30","31"],
                          ["32", "33", "34", "35","36","37","38","39"],
                          ["40", "41", "42", "43","44","45","46","47"],
                          ["48", "49", "50", "51","52","53","54","55"],
                          ["56", "57", "58", "59","60","61","62","63"]],
                         [[on ,off,off,off,off,off,off,off],
                          [off,off,off,off,off,off,off,off],
                          [off,off,off,off,off,off,off,off],
                          [off,off,off,off,off,off,off,off],
                          [off,off,off,off,off,off,off,off],
                          [off,off,off,off,off,off,off,off],
                          [off,off,off,off,off,off,off,off],
                          [off,off,off,off,off,off,off,off]],
                        
                         [[ 0, 1, 2, 3, 4, 5, 6, 7],
                          [ 8, 9,10,11,12,13,14,15],
                          [16,17,18,19,20,21,22,23],
                          [24,25,26,27,28,29,30,31],
                          [32,33,34,35,36,37,38,39],
                          [40,41,42,43,44,45,46,47],
                          [48,49,50,51,52,53,54,55],
                          [56,57,58,59,60,61,62,63]]],!;

    choice_list64(ChoiceList,N):- 
           ChoiceList = [[[" 0", " 1", " 2", " 3"," 4"," 5"," 6"," 7"],
                          [" 8", " 9", "10", "11","12","13","14","15"],
                          ["16", "17", "18", "19","20","21","22","23"],
                          ["24", "25", "26", "27","28","29","30","31"],
                          ["32", "33", "34", "35","36","37","38","39"],
                          ["40", "41", "42", "43","44","45","46","47"],
                          ["48", "49", "50", "51","52","53","54","55"],
                          ["56", "57", "58", "59","60","61","62","63"]],
                         [[on,on,on,on,on,on,on,on],
                          [on,on,on,on,on,on,on,on],
                          [on,on,on,on,on,on,on,on],
                          [on,on,on,on,on,on,on,on],
                          [on,on,on,on,on,on,on,on],
                          [on,on,on,on,on,on,on,on],
                          [on,on,on,on,on,on,on,on],
                          [on,on,on,on,on,on,on,on]],
                         [[ 0, 1, 2, 3, 4, 5, 6, 7],
                          [ 8, 9,10,11,12,13,14,15],
                          [16,17,18,19,20,21,22,23],
                          [24,25,26,27,28,29,30,31],
                          [32,33,34,35,36,37,38,39],
                          [40,41,42,43,44,45,46,47],
                          [48,49,50,51,52,53,54,55],
                          [56,57,58,59,60,61,62,63]]],!;


    get_parameter(Key,[N,List|R],N,ParaList):-
        get_key_val(Key,List,ParaList),!;

    get_key_val(_,[],[position(100,100)]):- !;
    get_key_val(Key,[{Key,X,Y}|R],[position(X,Y)]):- !;
    get_key_val(Key,[{_,_,_}|R],Ret):-
        get_key_val(Key,R,Ret),!;


    append([],L2,L2):-!;
    append([A|R1],L2,L):-
        L = [A|LR],
        append(R1,L2,LR),!;

    length(List,L):- 
        length(List,0,L);

    length([],R,R):- !;
    length([_|Rest],C,Ret):-
        C1 is C + 1,
        length(Rest,C1,Ret),!;

            
end. 
 

                                                                                                                    