%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  CONVERTER
%    1 Term -> String
%    2 Str  -> Number
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

class m_converter has


    :convert_to_string(Class,Data,Str):- 
        (atom(Data) ,  :get_atom_string(#symbolizer,Data,Str) ;
         number(Data), :get_number_string(#symbolizer,Data,Str) ;
         string(Data,_,_), Str = Data                          ;
         :is_object(#symbolizer,Data), 
                       :get_object_string(#symbolizer,Data,Str)   ;
         stack_vector(Data,L),
                    convert_element(0,L,Data,"{",Str)            ;
         list(Data),  convert_element(1,Data,"[",Str)
        ),!;

    :convert_to_number(Class,Str,Number):-
        string(Str,L,Type),
        :get_ch_string_token(#symbolizer,Str,List),
        delete_space(List,List1),
        float_or_integer(List1,Status),
        (Status = integer,!,
            integer_to_number(List1,0,Number)
         ;  float_to_number(List1,0.0,Number)
        ),!;


local

    float_or_integer(List,Status):-
        include(8485,List),!,
        Status = float,!;
    float_or_integer(List,integer):- !;


    integer_to_number([8521],T,T):- !;
    integer_to_number([8521|Rest],S,T):- 
        integer_to_number(Rest,S,T),!;
    integer_to_number([Code|Rest],S,T):-
        Code > 9007, Code < 9018 ,!,
        N is Code - 9008,
        M is 10 * S,
        NextS is M + N,
        integer_to_number(Rest,NextS,T),!;


    float_to_number([8521|Rest],S,T):- 
        float_to_number(Rest,S,T),!;
    float_to_number([8485|Rest],S,T):-
        float_to_number1(Rest,0.1,S,T),!;
    float_to_number([Code|Rest],S,T):-
        Code > 9007, Code < 9018 ,!,
        N is Code - 9008,
        integer_to_floating_point(N,F),
        M is 10.0 * S,
        NextS is M + F,
        float_to_number(Rest,NextS,T),!;

    float_to_number1([8521],B,T,T):- !;
    float_to_number1([Code|Rest],B,S,T):- 
        Code > 9007, Code < 9018 ,!,
        N is Code - 9008,
        integer_to_floating_point(N,F),
        N1 is B * F,
        NextS is S + N1,
        NextB is B * 0.1,
        float_to_number1(Rest,NextB,NextS,T),!;

  
    convert_element(_,[],S,Str):-
        :append(#string,[S,"]"],Str),!;
    convert_element(1,[Data|R],S,Str):- 
        list(Data),
        convert_element(1,Data,"[",S1),
        :append(#string,[S,S1],SS),
        convert_element(2,R,SS,Str);
    convert_element(1,[Data|R],S,Str):-
        :convert_to_string(#m_converter,Data,S1),
        :append(#string,[S,S1],SS),
        convert_element(2,R,SS,Str);
    convert_element(N,[Data|R],S,Str):- 
        list(Data),
        convert_element(1,Data,"[",S1),
        :append(#string,[S,",",S1],SS),
        N1 is N + 1,
        convert_element(N1,R,SS,Str);
    convert_element(N,[Data|R],S,Str):-
        :convert_to_string(#m_converter,Data,S1),
        :append(#string,[S,S1],SS),
        N1 is N + 1,
        convert_element(N1,R,SS,Str);


    convert_element(N,N,_,S,Str):- 
        :append(#string,[S,"}"],Str),!;
    convert_element(0,L,Data,S,Str):-
        vector_element(Data,0,El),
        :convert_to_string(#m_converter,El,El_Str),
        :append(#string,[S,El_Str],New_S),
        convert_element(1,L,Data,New_S,Str);
    convert_element(N,L,Data,S,Str):-
        vector_element(Data,N,El),
        :convert_to_string(#m_converter,El,El_Str),
        :append(#string,[S,",",El_Str],New_S),
        N1 is N + 1,
        convert_element(N1,L,Data,New_S,Str);


    include(E1,[]):- !,fail;
    include(E1,[E2|R]):-
        E1 = E2,!;
    include(E1,[E2|R]):-
        include(E1,R),!;

    delete_space([],[]):-!;
    delete_space([8481|R],Ret):-
        delete_space(R,Ret),!;
    delete_space([Data|R],Ret):-
        Ret = [Data|RetR],
        delete_space(R,RetR),!;


end.
                                     