%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

class move_data has

attribute
(   buf := Buf :- :create(#standard_io_buffer,Buf));

:move_link(Class,Path,X,Y) :-
    :create(#standard_input_file,IFile,Path),
    :get_slot(Class,buf,Buf),
    :reset(Buf),
    get_data(IFile,Buf),
    :create(#standard_output_file,OFile,Path),
    :reread(Buf),
    move_link(Buf,X,Y,OFile);
    
local

move_link(Buf,X,Y,File) :-
    :end_of_input(Buf),!,
    :reset(Buf),
    :close_output(File);
move_link(Buf,X,Y,File) :-
    :gett(Buf,Term),
    mv_link(Term,X,Y,Term1),
    :putt(File,Term1),:putb(File,". ",2),
    :putl(File),
    move_link(Buf,X,Y,File);
move_link(Buf,_,_,File) :-
    :close_output(File);

mv_link({D1,P1,D2,P2,L},X,Y,Res) :-
    list(L),
    mv(L,X,Y,L1),
    Res = {D1,P1,D2,P2,L1};
mv_link(T,_,_,T) :- !;

mv([],_,_,[]) :- !;
mv([{X0,Y0}|T],X,Y,L) :- 
    X1 is X0 + X,
    Y1 is Y0 + Y,
    L = [{X1,Y1}|TT],
    mv(T,X,Y,TT);

get_data(File,Buf) :-
    :end_of_input(File),!,
    :close_input(File);
get_data(File,Buf) :-
    :gett(File,Term),!,
    :putt(Buf,Term),:putb(Buf,". ",2),
    get_data(File,Buf);    
get_data(File,_) :-
    :close_input(File);

end.