%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

%:- module fulladder_searcher.
%:- public stpg/2.
class fulladder_searcher_z has

:stpg(Class,Working,Result) :-
    stpg(Working,Result) ;
local

stpg(working(Dev,In,Opin,Oval,Time),Result) :-
    true ,!, 
    in_operational(InOperational),
    out_operational(OutOperational),
    working(Dev,In,Opin,Oval,Time,InOperational,OutOperational,[],Result) ;


%%% conn_data
conn(A,B,a1_1,in2):-true,!,A=f1,B=in3; 
conn(A,B,x2_4,in1):-true,!,A=x1_4,B=out; 
conn(A,B,x2_4,in2):-true,!,A=o1_3,B=out; 
conn(A,B,a1_1,in1):-true,!,A=f1,B=in2; 
conn(A,B,a1_4,in2):-true,!,A=f1,B=in9; 
conn(A,B,x1_4,in1):-true,!,A=f1,B=in8; 
conn(A,B,a1_4,in1):-true,!,A=f1,B=in8; 
conn(A,B,x1_3,in2):-true,!,A=f1,B=in7; 
conn(A,B,f1,out4):-true,!,A=x2_4,B=out; 
conn(A,B,x1_6,in2):-true,!,A=f1,B=in13; 
conn(A,B,a1_8,in2):-true,!,A=f1,B=in17; 
conn(A,B,f1,out8):-true,!,A=x2_8,B=out; 
conn(A,B,a1_8,in1):-true,!,A=f1,B=in16; 
conn(A,B,a1_2,in2):-true,!,A=f1,B=in5; 
conn(A,B,x1_3,in1):-true,!,A=f1,B=in6; 
conn(A,B,x1_2,in2):-true,!,A=f1,B=in5; 
conn(A,B,a2_4,in1):-true,!,A=o1_3,B=out; 
conn(A,B,a2_1,in1):-true,!,A=f1,B=in1; 
conn(A,B,f1,out9):-true,!,A=o1_8,B=out; 
conn(A,B,f1,out7):-true,!,A=x2_7,B=out; 
conn(A,B,x1_8,in1):-true,!,A=f1,B=in16; 
conn(A,B,f1,out6):-true,!,A=x2_6,B=out; 
conn(A,B,f1,out5):-true,!,A=x2_5,B=out; 
conn(A,B,x1_5,in2):-true,!,A=f1,B=in11; 
conn(A,B,x1_5,in1):-true,!,A=f1,B=in10; 
conn(A,B,f1,out3):-true,!,A=x2_3,B=out; 
conn(A,B,f1,out1):-true,!,A=x2_1,B=out; 
conn(A,B,x1_2,in1):-true,!,A=f1,B=in4; 
conn(A,B,x1_1,in1):-true,!,A=f1,B=in2; 
conn(A,B,x2_1,in2):-true,!,A=f1,B=in1; 
conn(A,B,a2_8,in1):-true,!,A=o1_7,B=out; 
conn(A,B,x2_8,in2):-true,!,A=o1_7,B=out; 
conn(A,B,a2_6,in1):-true,!,A=o1_5,B=out; 
conn(A,B,x2_6,in2):-true,!,A=o1_5,B=out; 
conn(A,B,a2_5,in1):-true,!,A=o1_4,B=out; 
conn(A,B,x2_5,in2):-true,!,A=o1_4,B=out; 
conn(A,B,a2_3,in1):-true,!,A=o1_2,B=out; 
conn(A,B,x2_3,in2):-true,!,A=o1_2,B=out; 
conn(A,B,a2_2,in1):-true,!,A=o1_1,B=out; 
conn(A,B,x2_2,in2):-true,!,A=o1_1,B=out; 
conn(A,B,x2_1,in1):-true,!,A=x1_1,B=out; 
conn(A,B,a2_1,in2):-true,!,A=x1_1,B=out; 
conn(A,B,o1_1,in2):-true,!,A=a1_1,B=out; 
conn(A,B,o1_1,in1):-true,!,A=a2_1,B=out; 
conn(A,B,x2_2,in1):-true,!,A=x1_2,B=out; 
conn(A,B,a2_2,in2):-true,!,A=x1_2,B=out; 
conn(A,B,o1_2,in2):-true,!,A=a1_2,B=out; 
conn(A,B,o1_2,in1):-true,!,A=a2_2,B=out; 
conn(A,B,x2_3,in1):-true,!,A=x1_3,B=out; 
conn(A,B,a2_3,in2):-true,!,A=x1_3,B=out; 
conn(A,B,o1_3,in2):-true,!,A=a1_3,B=out; 
conn(A,B,o1_3,in1):-true,!,A=a2_3,B=out; 
conn(A,B,a2_4,in2):-true,!,A=x1_4,B=out; 
conn(A,B,o1_4,in2):-true,!,A=a1_4,B=out; 
conn(A,B,o1_4,in1):-true,!,A=a2_4,B=out; 
conn(A,B,x2_5,in1):-true,!,A=x1_5,B=out; 
conn(A,B,a2_5,in2):-true,!,A=x1_5,B=out; 
conn(A,B,o1_5,in2):-true,!,A=a1_5,B=out; 
conn(A,B,o1_5,in1):-true,!,A=a2_5,B=out; 
conn(A,B,x2_6,in1):-true,!,A=x1_6,B=out; 
conn(A,B,a2_6,in2):-true,!,A=x1_6,B=out; 
conn(A,B,o1_6,in2):-true,!,A=a1_6,B=out; 
conn(A,B,o1_6,in1):-true,!,A=a2_6,B=out; 
conn(A,B,x2_7,in1):-true,!,A=x1_7,B=out; 
conn(A,B,a2_7,in2):-true,!,A=x1_7,B=out; 
conn(A,B,o1_7,in2):-true,!,A=a1_7,B=out; 
conn(A,B,o1_7,in1):-true,!,A=a2_7,B=out; 
conn(A,B,x2_8,in1):-true,!,A=x1_8,B=out; 
conn(A,B,a2_8,in2):-true,!,A=x1_8,B=out; 
conn(A,B,o1_8,in2):-true,!,A=a1_8,B=out; 
conn(A,B,o1_8,in1):-true,!,A=a2_8,B=out; 
conn(A,B,f1,out2):-true,!,A=x2_2,B=out; 
conn(A,B,x2_7,in2):-true,!,A=o1_6,B=out; 
conn(A,B,x1_7,in1):-true,!,A=f1,B=in14; 
conn(A,B,a1_2,in1):-true,!,A=f1,B=in4; 
conn(A,B,a1_5,in1):-true,!,A=f1,B=in10; 
conn(A,B,a1_5,in2):-true,!,A=f1,B=in11; 
conn(A,B,a1_7,in2):-true,!,A=f1,B=in15; 
conn(A,B,a1_3,in1):-true,!,A=f1,B=in6; 
conn(A,B,a1_3,in2):-true,!,A=f1,B=in7; 
conn(A,B,x1_8,in2):-true,!,A=f1,B=in17; 
conn(A,B,a2_7,in1):-true,!,A=o1_6,B=out; 
conn(A,B,x1_7,in2):-true,!,A=f1,B=in15; 
conn(A,B,a1_7,in1):-true,!,A=f1,B=in14; 
conn(A,B,x1_6,in1):-true,!,A=f1,B=in12; 
conn(A,B,a1_6,in2):-true,!,A=f1,B=in13; 
conn(A,B,x1_4,in2):-true,!,A=f1,B=in9; 
conn(A,B,x1_1,in2):-true,!,A=f1,B=in3; 
conn(A,B,a1_6,in1):-true,!,A=f1,B=in12; 

fconn(f1,in12,A):-true,!,A=[x1_6(in1),a1_6(in1)];
fconn(f1,in3,A):-true,!,A=[a1_1(in2),x1_1(in2)];
fconn(f1,in9,A):-true,!,A=[a1_4(in2),x1_4(in2)];
fconn(f1,in13,A):-true,!,A=[x1_6(in2),a1_6(in2)];
fconn(f1,in14,A):-true,!,A=[x1_7(in1),a1_7(in1)];
fconn(f1,in15,A):-true,!,A=[a1_7(in2),x1_7(in2)];
fconn(o1_6,out,A):-true,!,A=[x2_7(in2),a2_7(in1)];
fconn(f1,in17,A):-true,!,A=[a1_8(in2),x1_8(in2)];
fconn(f1,in7,A):-true,!,A=[x1_3(in2),a1_3(in2)];
fconn(f1,in6,A):-true,!,A=[x1_3(in1),a1_3(in1)];
fconn(f1,in11,A):-true,!,A=[x1_5(in2),a1_5(in2)];
fconn(f1,in10,A):-true,!,A=[x1_5(in1),a1_5(in1)];
fconn(f1,in4,A):-true,!,A=[x1_2(in1),a1_2(in1)];
fconn(x2_2,out,A):-true,!,A=[f1(out2)];
fconn(a2_8,out,A):-true,!,A=[o1_8(in1)];
fconn(a1_8,out,A):-true,!,A=[o1_8(in2)];
fconn(x1_8,out,A):-true,!,A=[x2_8(in1),a2_8(in2)];
fconn(a2_7,out,A):-true,!,A=[o1_7(in1)];
fconn(a1_7,out,A):-true,!,A=[o1_7(in2)];
fconn(x1_7,out,A):-true,!,A=[x2_7(in1),a2_7(in2)];
fconn(a2_6,out,A):-true,!,A=[o1_6(in1)];
fconn(a1_6,out,A):-true,!,A=[o1_6(in2)];
fconn(x1_6,out,A):-true,!,A=[x2_6(in1),a2_6(in2)];
fconn(a2_5,out,A):-true,!,A=[o1_5(in1)];
fconn(a1_5,out,A):-true,!,A=[o1_5(in2)];
fconn(x1_5,out,A):-true,!,A=[x2_5(in1),a2_5(in2)];
fconn(a2_4,out,A):-true,!,A=[o1_4(in1)];
fconn(a1_4,out,A):-true,!,A=[o1_4(in2)];
fconn(x1_4,out,A):-true,!,A=[x2_4(in1),a2_4(in2)];
fconn(a2_3,out,A):-true,!,A=[o1_3(in1)];
fconn(a1_3,out,A):-true,!,A=[o1_3(in2)];
fconn(x1_3,out,A):-true,!,A=[x2_3(in1),a2_3(in2)];
fconn(a2_2,out,A):-true,!,A=[o1_2(in1)];
fconn(a1_2,out,A):-true,!,A=[o1_2(in2)];
fconn(x1_2,out,A):-true,!,A=[x2_2(in1),a2_2(in2)];
fconn(a2_1,out,A):-true,!,A=[o1_1(in1)];
fconn(a1_1,out,A):-true,!,A=[o1_1(in2)];
fconn(x1_1,out,A):-true,!,A=[x2_1(in1),a2_1(in2)];
fconn(o1_1,out,A):-true,!,A=[a2_2(in1),x2_2(in2)];
fconn(o1_2,out,A):-true,!,A=[a2_3(in1),x2_3(in2)];
fconn(o1_4,out,A):-true,!,A=[a2_5(in1),x2_5(in2)];
fconn(o1_5,out,A):-true,!,A=[a2_6(in1),x2_6(in2)];
fconn(o1_7,out,A):-true,!,A=[a2_8(in1),x2_8(in2)];
fconn(f1,in1,A):-true,!,A=[a2_1(in1),x2_1(in2)];
fconn(f1,in2,A):-true,!,A=[a1_1(in1),x1_1(in1)];
fconn(x2_1,out,A):-true,!,A=[f1(out1)];
fconn(x2_3,out,A):-true,!,A=[f1(out3)];
fconn(x2_5,out,A):-true,!,A=[f1(out5)];
fconn(x2_6,out,A):-true,!,A=[f1(out6)];
fconn(f1,in16,A):-true,!,A=[a1_8(in1),x1_8(in1)];
fconn(x2_7,out,A):-true,!,A=[f1(out7)];
fconn(o1_8,out,A):-true,!,A=[f1(out9)];
fconn(o1_3,out,A):-true,!,A=[x2_4(in2),a2_4(in1)];
fconn(f1,in5,A):-true,!,A=[a1_2(in2),x1_2(in2)];
fconn(x2_8,out,A):-true,!,A=[f1(out8)];
fconn(x2_4,out,A):-true,!,A=[f1(out4)];
fconn(f1,in8,A):-true,!,A=[x1_4(in1),a1_4(in1)];

%%% working ( for snsr )

working(a1_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_1,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_1,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_1,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_1,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_1,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_1,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_1,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_1,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_1,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_1,out,V,T,Inval,Outval,List3,[],List5) ;

%%%% val

val(a1_1,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_1,in1,V1,T,Inval,Working,List1,List2),
        val(a1_1,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_1,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_1,in1,V1,T,Inval,Working,List1,List2),
        val(a2_1,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_1,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_1,in1,V1,T,Inval,Working,List1,List2),
        val(x1_1,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_1,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_1,in1,V1,T,Inval,Working,List1,List2),
        val(x2_1,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_1,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_1,in1,V1,T,Inval,Working,List1,List2),
        val(o1_1,in2,V2,T,Inval,Working,List2,List3) ;

%%% working ( for snsr )

working(a1_2,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_2,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_2,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_2,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_2,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_2,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_2,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_2,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_2,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_2,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_2,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_2,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_2,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_2,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_2,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_2,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_2,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_2,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_2,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_2,out,V,T,Inval,Outval,List3,[],List5) ;

%%%% val

val(a1_2,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_2,in1,V1,T,Inval,Working,List1,List2),
        val(a1_2,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_2,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_2,in1,V1,T,Inval,Working,List1,List2),
        val(a2_2,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_2,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_2,in1,V1,T,Inval,Working,List1,List2),
        val(x1_2,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_2,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_2,in1,V1,T,Inval,Working,List1,List2),
        val(x2_2,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_2,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_2,in1,V1,T,Inval,Working,List1,List2),
        val(o1_2,in2,V2,T,Inval,Working,List2,List3) ;

%%%%%%%%%%%%%%%%%%%

%%% working ( for snsr )

working(a1_3,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_3,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_3,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_3,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_3,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_3,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_3,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_3,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_3,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_3,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_3,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_3,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_3,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_3,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_3,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_3,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_3,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_3,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_3,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_3,out,V,T,Inval,Outval,List3,[],List5) ;

%%%% val

val(a1_3,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_3,in1,V1,T,Inval,Working,List1,List2),
        val(a1_3,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_3,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_3,in1,V1,T,Inval,Working,List1,List2),
        val(a2_3,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_3,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_3,in1,V1,T,Inval,Working,List1,List2),
        val(x1_3,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_3,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_3,in1,V1,T,Inval,Working,List1,List2),
        val(x2_3,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_3,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_3,in1,V1,T,Inval,Working,List1,List2),
        val(o1_3,in2,V2,T,Inval,Working,List2,List3) ;

%%%%%%%%%%%%%%%%%%

%%% working ( for snsr )

working(a1_4,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_4,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_4,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_4,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_4,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_4,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_4,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_4,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_4,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_4,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_4,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_4,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_4,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_4,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_4,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_4,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_4,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_4,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_4,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_4,out,V,T,Inval,Outval,List3,[],List5) ;

%%%% val

val(a1_4,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_4,in1,V1,T,Inval,Working,List1,List2),
        val(a1_4,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_4,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_4,in1,V1,T,Inval,Working,List1,List2),
        val(a2_4,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_4,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_4,in1,V1,T,Inval,Working,List1,List2),
        val(x1_4,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_4,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_4,in1,V1,T,Inval,Working,List1,List2),
        val(x2_4,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_4,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_4,in1,V1,T,Inval,Working,List1,List2),
        val(o1_4,in2,V2,T,Inval,Working,List2,List3) ;


%%% working ( for snsr )

working(a1_5,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_5,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_5,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_5,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_5,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_5,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_5,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_5,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_5,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_5,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_5,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_5,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_5,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_5,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_5,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_5,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_5,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_5,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_5,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_5,out,V,T,Inval,Outval,List3,[],List5) ;

%%%% val

val(a1_5,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_5,in1,V1,T,Inval,Working,List1,List2),
        val(a1_5,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_5,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_5,in1,V1,T,Inval,Working,List1,List2),
        val(a2_5,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_5,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_5,in1,V1,T,Inval,Working,List1,List2),
        val(x1_5,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_5,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_5,in1,V1,T,Inval,Working,List1,List2),
        val(x2_5,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_5,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_5,in1,V1,T,Inval,Working,List1,List2),
        val(o1_5,in2,V2,T,Inval,Working,List2,List3) ;

%%%%%%%%%%%%%%%%%%%

%%% working ( for snsr )

working(a1_6,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_6,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_6,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_6,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_6,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_6,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_6,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_6,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_6,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_6,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_6,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_6,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_6,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_6,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_6,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_6,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_6,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_6,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_6,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_6,out,V,T,Inval,Outval,List3,[],List5) ;

%%%% val

val(a1_6,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_6,in1,V1,T,Inval,Working,List1,List2),
        val(a1_6,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_6,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_6,in1,V1,T,Inval,Working,List1,List2),
        val(a2_6,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_6,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_6,in1,V1,T,Inval,Working,List1,List2),
        val(x1_6,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_6,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_6,in1,V1,T,Inval,Working,List1,List2),
        val(x2_6,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_6,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_6,in1,V1,T,Inval,Working,List1,List2),
        val(o1_6,in2,V2,T,Inval,Working,List2,List3) ;

%%%%%%%%%%%%%%%%%%

%%% working ( for snsr )

working(a1_7,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_7,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_7,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_7,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_7,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_7,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_7,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_7,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_7,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_7,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_7,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_7,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_7,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_7,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_7,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_7,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_7,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_7,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_7,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_7,out,V,T,Inval,Outval,List3,[],List5) ;

%%%% val

val(a1_7,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_7,in1,V1,T,Inval,Working,List1,List2),
        val(a1_7,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_7,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_7,in1,V1,T,Inval,Working,List1,List2),
        val(a2_7,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_7,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_7,in1,V1,T,Inval,Working,List1,List2),
        val(x1_7,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_7,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_7,in1,V1,T,Inval,Working,List1,List2),
        val(x2_7,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_7,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_7,in1,V1,T,Inval,Working,List1,List2),
        val(o1_7,in2,V2,T,Inval,Working,List2,List3) ;


%%%%%%%%%%%%%%%%%%

%%% working ( for snsr )

working(a1_8,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_8,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_8,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_8,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_8,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_8,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_8,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_8,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_8,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_8,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_8,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_8,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_8,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_8,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_8,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_8,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_8,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_8,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_8,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_8,out,V,T,Inval,Outval,List3,[],List5) ;

%%%% val

val(a1_8,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_8,in1,V1,T,Inval,Working,List1,List2),
        val(a1_8,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_8,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_8,in1,V1,T,Inval,Working,List1,List2),
        val(a2_8,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_8,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_8,in1,V1,T,Inval,Working,List1,List2),
        val(x1_8,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_8,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_8,in1,V1,T,Inval,Working,List1,List2),
        val(x2_8,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_8,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_8,in1,V1,T,Inval,Working,List1,List2),
        val(o1_8,in2,V2,T,Inval,Working,List2,List3) ;


%otherwise ;

val(Part2,Pin2,V,T,Inval,Outval,List1,List2):- 
    true ,!, 
        conn(Part1,Pin1,Part2,Pin2),
        connect(Part1,Pin1,V,T,Inval,Inval,Outval,List1,List2) ;

%%%% fval

fval(a1_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_1,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_1,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_1,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_1,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_1,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_1,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_1,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_1,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_1,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_1,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_1,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_1,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_1,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(o1_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_1,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_1,out,_,_,Inval,Outval,List2,List3,List4) ;

%%%% fval

fval(a1_2,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_2,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_2,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_2,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_2,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_2,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_2,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_2,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_2,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_2,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_2,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_2,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_2,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_2,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_2,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_2,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_2,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_2,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_2,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_2,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_2,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_2,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_2,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_2,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_2,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_2,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_2,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(o1_2,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_2,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_2,out,_,_,Inval,Outval,List2,List3,List4) ;

%%%% fval

fval(a1_3,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_3,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_3,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_3,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_3,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_3,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_3,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_3,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_3,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_3,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_3,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_3,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_3,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_3,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_3,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_3,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_3,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_3,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_3,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_3,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_3,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_3,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_3,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_3,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_3,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_3,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_3,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(o1_3,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_3,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_3,out,_,_,Inval,Outval,List2,List3,List4) ;

%%%% fval

fval(a1_4,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_4,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_4,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_4,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_4,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_4,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_4,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_4,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_4,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_4,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_4,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_4,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_4,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_4,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_4,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_4,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_4,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_4,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_4,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_4,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_4,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_4,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_4,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_4,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_4,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_4,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_4,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(o1_4,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_4,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_4,out,_,_,Inval,Outval,List2,List3,List4) ;

%%%% fval

fval(a1_5,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_5,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_5,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_5,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_5,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_5,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_5,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_5,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_5,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_5,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_5,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_5,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_5,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_5,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_5,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_5,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_5,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_5,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_5,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_5,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_5,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_5,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_5,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_5,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_5,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_5,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_5,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(o1_5,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_5,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_5,out,_,_,Inval,Outval,List2,List3,List4) ;

%%%% fval

fval(a1_6,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_6,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_6,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_6,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_6,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_6,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_6,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_6,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_6,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_6,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_6,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_6,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_6,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_6,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_6,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_6,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_6,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_6,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_6,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_6,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_6,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_6,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_6,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_6,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_6,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_6,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_6,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(o1_6,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_6,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_6,out,_,_,Inval,Outval,List2,List3,List4) ;


%%%% fval

fval(a1_7,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_7,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_7,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_7,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_7,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_7,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_7,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_7,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_7,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_7,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_7,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_7,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_7,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_7,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_7,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_7,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_7,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_7,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_7,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_7,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_7,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_7,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_7,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_7,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_7,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_7,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_7,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(o1_7,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_7,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_7,out,_,_,Inval,Outval,List2,List3,List4) ;


%%%% fval

fval(a1_8,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_8,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_8,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_8,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_8,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_8,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_8,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_8,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_8,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_8,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_8,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_8,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_8,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_8,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_8,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_8,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_8,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_8,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_8,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_8,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_8,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_8,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_8,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_8,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_8,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_8,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_8,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_8,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_8,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_8,out,_,_,Inval,Outval,List2,List3,List4) ;

%otherwise ;
fval(Part1,Pin1,V,T,Inval,Outval,List1,List2,List3):- 
    true ,!, 
        fconn(Part1,Pin1,Conn),
        fconnect(Conn,V,T,Inval,Outval,Outval,List1,List2,List3) ;

fconnect([{Part,Pin}|TT],V,T,Inval,[],Outval,List1,List2,List3) :-
    true ,!,  fval(Part,Pin,V,T,Inval,Outval,List1,List2,List4),
    fconnect(TT,V,T,Inval,Outval,Outval,List1,List4,List3) ;

fconnect([],V,T,Inval,Outval,Outval,List1,List2,List3) :-
    true ,!,  List2 = List3 ;

fconnect([{Part,Pin}|TT],V,T,Inval,[val(Part0,Pin0,_,_)|_],Outval,List1,List2,List3) :-
    Part = Part0,Pin = Pin0 ,!, 
    List4 = [output(Part,Pin,List1)|List2],
    fconnect(TT,V,T,Inval,Outval,Outval,List1,List4,List3) ;

%otherwise ;
fconnect(Conn,V,T,Inval,[H|Tail],Outval,List1,List2,List3) :-
    true ,!, 
    fconnect(Conn,V,T,Inval,Tail,Outval,List1,List2,List3) ;

connect(Part1,Pin1,V,T,[val(Part0,Pin0,_,_)|Tail],Inval,Outval,List1,List2) :-
    Part1 = Part0,Pin1 = Pin0 ,!, 
    assumable(Part1,Pin1,Data),
    uniap(in_val(Part1,Pin1,Data),List1,List2) ;

connect(Part1,Pin1,V,T,[],Inval,Outval,List1,List2) :-
    true ,!, 
    val(Part1,Pin1,V,T,Inval,Outval,List1,List2) ;    

%otherwise ;
connect(Part1,Pin1,V,T,[H|Tail],Inval,Outval,List1,List2) :-
    true ,!, 
    connect(Part1,Pin1,V,T,Tail,Inval,Outval,List1,List2) ;

uniap(Assumable,List1,List2) :-
    true ,!, 
    uniap(Assumable,List1,List1,List2) ;

uniap(Assumable,[H|List],List1,List2) :-
    Assumable = H ,!,  List2 = List1 ;
uniap(Assumable,[],List1,List2) :-
    true ,!,  List2 = [Assumable|List1] ;
%otherwise ;
uniap(Assumable,[H|List],List1,List2) :-
    true ,!,  uniap(Assumable,List,List1,List2) ;


%%%%%%%%%%% uniq


uniq([H|T],List2,List3) :-
    true ,!, 
    uniq1(H,List2,List2,Out),
    uniq(T,Out,List3) ;

uniq([],Aux,List) :-
    true ,!,  Aux = List ;

uniq1(H,[HH|TT],Aux,Out) :-
    H = HH ,!,  
    Out = Aux ;
uniq1(H,[],Aux,Out) :-
    true ,!,  Out = [H|Aux] ;
%otherwise ;
uniq1(H,[HH|TT],Aux,Out) :-
    true ,!,  
    uniq1(H,TT,Aux,Out) ;

%%%%%%%%%%%%%%%%%%

in_operational(Operational) :-
    true ,!,  
    Operational = [ val(f1,in1,_,_),val(f1,in2,_,_),val(f1,in3,_,_),
                    val(f1,in4,_,_),val(f1,in5,_,_),val(f1,in6,_,_),
                    val(f1,in7,_,_),val(f1,in8,_,_),val(f1,in9,_,_),
                    val(f1,in10,_,_),val(f1,in11,_,_),val(f1,in12,_,_),
                    val(f1,in13,_,_),val(f1,in14,_,_),val(f1,in15,_,_),
                    val(f1,in16,_,_),val(f1,in17,_,_)] ;

out_operational(Operational) :-
    true ,!, 
    Operational = [ val(f1,out1,_,_),val(f1,out2,_,_),
                    val(f1,out3,_,_),val(f1,out4,_,_),
                    val(f1,out5,_,_),val(f1,out6,_,_),
                    val(f1,out7,_,_),val(f1,out8,_,_),
                    val(f1,out9,_,_)] ;
     
assumable(f1,in1,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in2,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in3,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in4,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in5,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in6,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in7,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in8,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in9,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in10,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in11,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in12,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in13,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in14,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in15,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in16,Data) :-
    true ,!,  Data = [] ;
assumable(f1,in17,Data) :-
    true ,!,  Data = [] ;


append([H|T],Y,Z) :-
    true ,!,  Z = [H|ZZ],append(T,Y,ZZ) ;
append([],Y,Z) :-   
    true ,!,  Y = Z ;

end.