%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

%:- module fulladder_searcher.
%:- public stpg/2.
class fulladder_searcher_y has

:stpg(Class,Working,Result) :-
    stpg(Working,Result) ;
local

stpg(working(Dev,In,Opin,Oval,Time),Result) :-
    true ,!, 
    in_operational(InOperational),
    out_operational(OutOperational),
    working(Dev,In,Opin,Oval,Time,InOperational,OutOperational,[],Result) ;


%%% conn_data

conn(A,B,f1,out9):-true,!,A=fa_8,B=cout;
conn(A,B,f1,out8):-true,!,A=fa_8,B=sum;
conn(A,B,f1,out7):-true,!,A=fa_7,B=sum;
conn(A,B,f1,out6):-true,!,A=fa_6,B=sum;
conn(A,B,f1,out5):-true,!,A=fa_5,B=sum;
conn(A,B,f1,out3):-true,!,A=fa_3,B=sum;
conn(A,B,fa_8,cin):-true,!,A=fa_7,B=cout;
conn(A,B,fa_7,cin):-true,!,A=fa_6,B=cout;
conn(A,B,fa_6,cin):-true,!,A=fa_5,B=cout;
conn(A,B,fa_5,cin):-true,!,A=fa_4,B=cout;
conn(A,B,fa_4,cin):-true,!,A=fa_3,B=cout;
conn(A,B,f1,out4):-true,!,A=fa_4,B=sum;
conn(A,B,fa_3,in1):-true,!,A=f1,B=in6;
conn(A,B,fa_3,in2):-true,!,A=f1,B=in7;
conn(A,B,fa_4,in1):-true,!,A=f1,B=in8;
conn(A,B,fa_4,in2):-true,!,A=f1,B=in9;
conn(A,B,fa_5,in1):-true,!,A=f1,B=in10;
conn(A,B,fa_5,in2):-true,!,A=f1,B=in11;
conn(A,B,fa_6,in1):-true,!,A=f1,B=in12;
conn(A,B,fa_6,in2):-true,!,A=f1,B=in13;
conn(A,B,fa_7,in1):-true,!,A=f1,B=in14;
conn(A,B,fa_7,in2):-true,!,A=f1,B=in15;
conn(A,B,fa_8,in1):-true,!,A=f1,B=in16;
conn(A,B,fa_8,in2):-true,!,A=f1,B=in17;
conn(A,B,fa_3,cin):-true,!,A=fa_2,B=cout;
conn(A,B,fa_2,in2):-true,!,A=f1,B=in5;
conn(A,B,fa_2,cin):-true,!,A=o1_1,B=out;
conn(A,B,fa_2,in1):-true,!,A=f1,B=in4;
conn(A,B,x1_1,in2):-true,!,A=f1,B=in3;
conn(A,B,a1_1,in2):-true,!,A=f1,B=in3;
conn(A,B,x1_1,in1):-true,!,A=f1,B=in2;
conn(A,B,a1_1,in1):-true,!,A=f1,B=in2;
conn(A,B,x2_1,in1):-true,!,A=x1_1,B=out;
conn(A,B,o1_1,in1):-true,!,A=a2_1,B=out;
conn(A,B,o1_1,in2):-true,!,A=a1_1,B=out;
conn(A,B,a2_1,in1):-true,!,A=f1,B=in1;
conn(A,B,x2_1,in2):-true,!,A=f1,B=in1;
conn(A,B,a2_1,in2):-true,!,A=x1_1,B=out;
conn(A,B,f1,out1):-true,!,A=x2_1,B=out;
conn(A,B,f1,out2):-true,!,A=fa_2,B=sum;

%%% fcon

fconn(fa_2,sum,A):-true,!,A=[f1(out2)];
fconn(x2_1,out,A):-true,!,A=[f1(out1)];
fconn(x1_1,out,A):-true,!,A=[x2_1(in1),a2_1(in2)];
fconn(f1,in1,A):-true,!,A=[a2_1(in1),x2_1(in2)];
fconn(a1_1,out,A):-true,!,A=[o1_1(in2)];
fconn(a2_1,out,A):-true,!,A=[o1_1(in1)];
fconn(f1,in2,A):-true,!,A=[x1_1(in1),a1_1(in1)];
fconn(f1,in3,A):-true,!,A=[x1_1(in2),a1_1(in2)];
fconn(f1,in4,A):-true,!,A=[fa_2(in1)];
fconn(o1_1,out,A):-true,!,A=[fa_2(cin)];
fconn(f1,in5,A):-true,!,A=[fa_2(in2)];
fconn(fa_2,cout,A):-true,!,A=[fa_3(cin)];
fconn(f1,in17,A):-true,!,A=[fa_8(in2)];
fconn(f1,in16,A):-true,!,A=[fa_8(in1)];
fconn(f1,in15,A):-true,!,A=[fa_7(in2)];
fconn(f1,in14,A):-true,!,A=[fa_7(in1)];
fconn(f1,in13,A):-true,!,A=[fa_6(in2)];
fconn(f1,in12,A):-true,!,A=[fa_6(in1)];
fconn(f1,in11,A):-true,!,A=[fa_5(in2)];
fconn(f1,in10,A):-true,!,A=[fa_5(in1)];
fconn(f1,in9,A):-true,!,A=[fa_4(in2)];
fconn(f1,in8,A):-true,!,A=[fa_4(in1)];
fconn(f1,in7,A):-true,!,A=[fa_3(in2)];
fconn(f1,in6,A):-true,!,A=[fa_3(in1)];
fconn(fa_4,sum,A):-true,!,A=[f1(out4)];
fconn(fa_3,cout,A):-true,!,A=[fa_4(cin)];
fconn(fa_4,cout,A):-true,!,A=[fa_5(cin)];
fconn(fa_5,cout,A):-true,!,A=[fa_6(cin)];
fconn(fa_6,cout,A):-true,!,A=[fa_7(cin)];
fconn(fa_7,cout,A):-true,!,A=[fa_8(cin)];
fconn(fa_3,sum,A):-true,!,A=[f1(out3)];
fconn(fa_5,sum,A):-true,!,A=[f1(out5)];
fconn(fa_6,sum,A):-true,!,A=[f1(out6)];
fconn(fa_7,sum,A):-true,!,A=[f1(out7)];
fconn(fa_8,sum,A):-true,!,A=[f1(out8)];
fconn(fa_8,cout,A):-true,!,A=[f1(out9)];


%%% working 

working(a1_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a1_1,in1,V1,T,Inval,Outval,List1,List2),
        val(a1_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(a1_1,out,V,T,Inval,Outval,List3,[],List5) ;

working(x1_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x1_1,in1,V1,T,Inval,Outval,List1,List2),
        val(x1_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(x1_1,out,V,T,Inval,Outval,List3,[],List5) ;

working(a2_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(a2_1,in1,V1,T,Inval,Outval,List1,List2),
        val(a2_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(a2_1,out,V,T,Inval,Outval,List3,[],List5) ;

working(x2_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(x2_1,in1,V1,T,Inval,Outval,List1,List2),
        val(x2_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(x2_1,out,V,T,Inval,Outval,List3,[],List5) ;

working(o1_1,[V1,V2],out,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(o1_1,in1,V1,T,Inval,Outval,List1,List2),
        val(o1_1,in2,V2,T,Inval,Outval,List2,List3),
        fval(o1_1,out,V,T,Inval,Outval,List3,[],List5) ;


working(fa_2,[V1,V2,V3],sum,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_2,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_2,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_2,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_2,sum,V,T,Inval,Outval,List4,[],List5) ;

working(fa_2,[V1,V2,V3],cout,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_2,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_2,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_2,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_2,cout,V,T,Inval,Outval,List4,[],List5) ;

working(fa_3,[V1,V2,V3],sum,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_3,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_3,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_3,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_3,sum,V,T,Inval,Outval,List4,[],List5) ;

working(fa_3,[V1,V2,V3],cout,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_3,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_3,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_3,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_3,cout,V,T,Inval,Outval,List4,[],List5) ;

working(fa_4,[V1,V2,V3],sum,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_4,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_4,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_4,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_4,sum,V,T,Inval,Outval,List4,[],List5) ;

working(fa_4,[V1,V2,V3],cout,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_4,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_4,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_4,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_4,cout,V,T,Inval,Outval,List4,[],List5) ;

working(fa_5,[V1,V2,V3],sum,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_5,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_5,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_5,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_5,sum,V,T,Inval,Outval,List4,[],List5) ;

working(fa_5,[V1,V2,V3],cout,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_5,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_5,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_5,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_5,cout,V,T,Inval,Outval,List4,[],List5) ;

working(fa_6,[V1,V2,V3],sum,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_6,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_6,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_6,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_6,sum,V,T,Inval,Outval,List4,[],List5) ;

working(fa_6,[V1,V2,V3],cout,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_6,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_6,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_6,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_6,cout,V,T,Inval,Outval,List4,[],List5) ;

working(fa_7,[V1,V2,V3],sum,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_7,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_7,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_7,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_7,sum,V,T,Inval,Outval,List4,[],List5) ;

working(fa_7,[V1,V2,V3],cout,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_7,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_7,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_7,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_7,cout,V,T,Inval,Outval,List4,[],List5) ;

working(fa_8,[V1,V2,V3],sum,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_8,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_8,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_8,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_8,sum,V,T,Inval,Outval,List4,[],List5) ;

working(fa_8,[V1,V2,V3],cout,V,T,Inval,Outval,List1,List5) :-
    true ,!, 
        val(fa_8,in1,V1,T,Inval,Outval,List1,List2),
        val(fa_8,in2,V2,T,Inval,Outval,List2,List3),
        val(fa_8,cin,V3,T,Inval,Outval,List3,List4),
        fval(fa_8,cout,V,T,Inval,Outval,List4,[],List5) ;

%%%% val

val(a1_1,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a1_1,in1,V1,T,Inval,Working,List1,List2),
        val(a1_1,in2,V2,T,Inval,Working,List2,List3) ;

val(a2_1,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(a2_1,in1,V1,T,Inval,Working,List1,List2),
        val(a2_1,in2,V2,T,Inval,Working,List2,List3) ;

val(x1_1,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x1_1,in1,V1,T,Inval,Working,List1,List2),
        val(x1_1,in2,V2,T,Inval,Working,List2,List3) ;

val(x2_1,out,V,T,Inval,Working,List1,List3) :-
    true ,!, 
        val(x2_1,in1,V1,T,Inval,Working,List1,List2),
        val(x2_1,in2,V2,T,Inval,Working,List2,List3) ;

val(o1_1,out,V,T,Inval,Working,List1,List3) :- 
    true ,!, 
        val(o1_1,in1,V1,T,Inval,Working,List1,List2),
        val(o1_1,in2,V2,T,Inval,Working,List2,List3) ;


val(fa_2,sum,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_2,in1,V1,T,Inval,Working,List1,List2),
        val(fa_2,in2,V2,T,Inval,Working,List2,List3),
        val(fa_2,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_2,cout,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_2,in1,V1,T,Inval,Working,List1,List2),
        val(fa_2,in2,V2,T,Inval,Working,List2,List3),
        val(fa_2,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_3,sum,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_3,in1,V1,T,Inval,Working,List1,List2),
        val(fa_3,in2,V2,T,Inval,Working,List2,List3),
        val(fa_3,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_3,cout,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_3,in1,V1,T,Inval,Working,List1,List2),
        val(fa_3,in2,V2,T,Inval,Working,List2,List3),
        val(fa_3,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_4,sum,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_4,in1,V1,T,Inval,Working,List1,List2),
        val(fa_4,in2,V2,T,Inval,Working,List2,List3),
        val(fa_4,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_4,cout,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_4,in1,V1,T,Inval,Working,List1,List2),
        val(fa_4,in2,V2,T,Inval,Working,List2,List3),
        val(fa_4,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_5,sum,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_5,in1,V1,T,Inval,Working,List1,List2),
        val(fa_5,in2,V2,T,Inval,Working,List2,List3),
        val(fa_5,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_5,cout,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_5,in1,V1,T,Inval,Working,List1,List2),
        val(fa_5,in2,V2,T,Inval,Working,List2,List3),
        val(fa_5,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_6,sum,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_6,in1,V1,T,Inval,Working,List1,List2),
        val(fa_6,in2,V2,T,Inval,Working,List2,List3),
        val(fa_6,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_6,cout,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_6,in1,V1,T,Inval,Working,List1,List2),
        val(fa_6,in2,V2,T,Inval,Working,List2,List3),
        val(fa_6,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_7,sum,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_7,in1,V1,T,Inval,Working,List1,List2),
        val(fa_7,in2,V2,T,Inval,Working,List2,List3),
        val(fa_7,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_7,cout,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_7,in1,V1,T,Inval,Working,List1,List2),
        val(fa_7,in2,V2,T,Inval,Working,List2,List3),
        val(fa_7,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_8,sum,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_8,in1,V1,T,Inval,Working,List1,List2),
        val(fa_8,in2,V2,T,Inval,Working,List2,List3),
        val(fa_8,cin,V3,T,Inval,Working,List3,List4) ;

val(fa_8,cout,V,T,Inval,Working,List1,List4) :-
    true ,!, 
        val(fa_8,in1,V1,T,Inval,Working,List1,List2),
        val(fa_8,in2,V2,T,Inval,Working,List2,List3),
        val(fa_8,cin,V3,T,Inval,Working,List3,List4) ;


%otherwise ;

val(Part2,Pin2,V,T,Inval,Outval,List1,List2):- 
    true ,!, 
        conn(Part1,Pin1,Part2,Pin2),
        connect(Part1,Pin1,V,T,Inval,Inval,Outval,List1,List2) ;

%%%% fval

fval(a1_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_1,in2,_,_,Inval,Outval,List1,List2),
    fval(a1_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a1_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a1_1,in1,_,_,Inval,Outval,List1,List2),
    fval(a1_1,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(a2_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_1,in2,_,_,Inval,Outval,List1,List2),
    fval(a2_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(a2_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(a2_1,in1,_,_,Inval,Outval,List1,List2),
    fval(a2_1,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x1_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_1,in2,_,_,Inval,Outval,List1,List2),
    fval(x1_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x1_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x1_1,in1,_,_,Inval,Outval,List1,List2),
    fval(x1_1,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(x2_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_1,in2,_,_,Inval,Outval,List1,List2),
    fval(x2_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(x2_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(x2_1,in1,_,_,Inval,Outval,List1,List2),
    fval(x2_1,out,_,_,Inval,Outval,List2,List3,List4) ;

fval(o1_1,in1,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_1,in2,_,_,Inval,Outval,List1,List2),
    fval(o1_1,out,_,_,Inval,Outval,List2,List3,List4) ;
fval(o1_1,in2,V,T,Inval,Outval,List1,List3,List4) :-
    true ,!, 
    val(o1_1,in1,_,_,Inval,Outval,List1,List2),
    fval(o1_1,out,_,_,Inval,Outval,List2,List3,List4) ;


fval(fa_2,in1,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_2,in2,_,_,Inval,Outval,List1,List2),
    val(fa_2,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_2,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_2,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_2,in2,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_2,in1,_,_,Inval,Outval,List1,List2),
    val(fa_2,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_2,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_2,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_2,cin,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_2,in1,_,_,Inval,Outval,List1,List2),
    val(fa_2,in2,_,_,Inval,Outval,List2,List3),
    fval(fa_2,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_2,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_3,in1,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_3,in2,_,_,Inval,Outval,List1,List2),
    val(fa_3,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_3,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_3,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_3,in2,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_3,in1,_,_,Inval,Outval,List1,List2),
    val(fa_3,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_3,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_3,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_3,cin,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_3,in1,_,_,Inval,Outval,List1,List2),
    val(fa_3,in2,_,_,Inval,Outval,List2,List3),
    fval(fa_3,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_3,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_4,in1,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_4,in2,_,_,Inval,Outval,List1,List2),
    val(fa_4,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_4,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_4,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_4,in2,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_4,in1,_,_,Inval,Outval,List1,List2),
    val(fa_4,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_4,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_4,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_4,cin,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_4,in1,_,_,Inval,Outval,List1,List2),
    val(fa_4,in2,_,_,Inval,Outval,List2,List3),
    fval(fa_4,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_4,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_5,in1,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_5,in2,_,_,Inval,Outval,List1,List2),
    val(fa_5,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_5,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_5,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_5,in2,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_5,in1,_,_,Inval,Outval,List1,List2),
    val(fa_5,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_5,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_5,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_5,cin,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_5,in1,_,_,Inval,Outval,List1,List2),
    val(fa_5,in2,_,_,Inval,Outval,List2,List3),
    fval(fa_5,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_5,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_6,in1,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_6,in2,_,_,Inval,Outval,List1,List2),
    val(fa_6,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_6,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_6,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_6,in2,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_6,in1,_,_,Inval,Outval,List1,List2),
    val(fa_6,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_6,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_6,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_6,cin,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_6,in1,_,_,Inval,Outval,List1,List2),
    val(fa_6,in2,_,_,Inval,Outval,List2,List3),
    fval(fa_6,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_6,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_7,in1,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_7,in2,_,_,Inval,Outval,List1,List2),
    val(fa_7,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_7,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_7,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_7,in2,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_7,in1,_,_,Inval,Outval,List1,List2),
    val(fa_7,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_7,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_7,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_7,cin,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_7,in1,_,_,Inval,Outval,List1,List2),
    val(fa_7,in2,_,_,Inval,Outval,List2,List3),
    fval(fa_7,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_7,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_8,in1,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_8,in2,_,_,Inval,Outval,List1,List2),
    val(fa_8,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_8,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_8,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_8,in2,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_8,in1,_,_,Inval,Outval,List1,List2),
    val(fa_8,cin,_,_,Inval,Outval,List2,List3),
    fval(fa_8,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_8,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

fval(fa_8,cin,V,T,Inval,Outval,List1,List4,List7) :-
    true ,!, 

    val(fa_8,in1,_,_,Inval,Outval,List1,List2),
    val(fa_8,in2,_,_,Inval,Outval,List2,List3),
    fval(fa_8,sum,_,_,Inval,Outval,List3,List4,List5),
    fval(fa_8,cout,_,_,Inval,Outval,List3,List4,List6),
    append(List5,List6,List7);

%otherwise ;
fval(Part1,Pin1,V,T,Inval,Outval,List1,List2,List3):- 
    true ,!, 
        fconn(Part1,Pin1,Conn),
        fconnect(Conn,V,T,Inval,Outval,Outval,List1,List2,List3) ;

fconnect([{Part,Pin}|TT],V,T,Inval,[],Outval,List1,List2,List3) :-
    true ,!,  fval(Part,Pin,V,T,Inval,Outval,List1,List2,List4),
    fconnect(TT,V,T,Inval,Outval,Outval,List1,List4,List3) ;

fconnect([],V,T,Inval,Outval,Outval,List1,List2,List3) :-
    true ,!,  List2 = List3 ;

fconnect([{Part,Pin}|TT],V,T,Inval,[val(Part0,Pin0,_,_)|_],Outval,List1,List2,List3) :-
    Part = Part0,Pin = Pin0 ,!, 
    List4 = [output(Part,Pin,List1)|List2],
    fconnect(TT,V,T,Inval,Outval,Outval,List1,List4,List3) ;

%otherwise ;
fconnect(Conn,V,T,Inval,[H|Tail],Outval,List1,List2,List3) :-
    true ,!, 
    fconnect(Conn,V,T,Inval,Tail,Outval,List1,List2,List3) ;

connect(Part1,Pin1,V,T,[val(Part0,Pin0,_,_)|Tail],Inval,Outval,List1,List2) :-
    Part1 = Part0,Pin1 = Pin0 ,!, 
    assumable(Part1,Pin1,Data),
    uniap(in_val(Part1,Pin1,Data),List1,List2) ;

connect(Part1,Pin1,V,T,[],Inval,Outval,List1,List2) :-
    true ,!, 
    val(Part1,Pin1,V,T,Inval,Outval,List1,List2) ;    

%otherwise ;
connect(Part1,Pin1,V,T,[H|Tail],Inval,Outval,List1,List2) :-
    true ,!, 
    connect(Part1,Pin1,V,T,Tail,Inval,Outval,List1,List2) ;

uniap(Assumable,List1,List2) :-
    true ,!, 
    uniap(Assumable,List1,List1,List2) ;

uniap(Assumable,[H|List],List1,List2) :-
    Assumable = H ,!,  List2 = List1 ;
uniap(Assumable,[],List1,List2) :-
    true ,!,  List2 = [Assumable|List1] ;
%otherwise ;
uniap(Assumable,[H|List],List1,List2) :-
    true ,!,  uniap(Assumable,List,List1,List2) ;


%%%%%%%%%%% uniq


uniq([H|T],List2,List3) :-
    true ,!, 
    uniq1(H,List2,List2,Out),
    uniq(T,Out,List3) ;

uniq([],Aux,List) :-
    true ,!,  Aux = List ;

uniq1(H,[HH|TT],Aux,Out) :-
    H = HH ,!,  
    Out = Aux ;
uniq1(H,[],Aux,Out) :-
    true ,!,  Out = [H|Aux] ;
%otherwise ;
uniq1(H,[HH|TT],Aux,Out) :-
    true ,!,  
    uniq1(H,TT,Aux,Out) ;

%%%%%%%%%%%%%%%%%%

in_operational(Operational) :-
    true ,!,  
    Operational = [ val(f1,in1,_,_),val(f1,in2,_,_),val(f1,in3,_,_),
                    val(f1,in4,_,_),val(f1,in5,_,_),val(f1,in6,_,_),
                    val(f1,in7,_,_),val(f1,in8,_,_),val(f1,in9,_,_),
                    val(f1,in10,_,_),val(f1,in11,_,_),val(f1,in12,_,_),
                    val(f1,in13,_,_),val(f1,in14,_,_),val(f1,in15,_,_),
                    val(f1,in16,_,_),val(f1,in17,_,_)] ;

out_operational(Operational) :-
    true ,!, 
    Operational = [ val(f1,out1,_,_),val(f1,out2,_,_),
                    val(f1,out3,_,_),val(f1,out4,_,_),
                    val(f1,out5,_,_),val(f1,out6,_,_),
                    val(f1,out7,_,_),val(f1,out8,_,_),
                    val(f1,out9,_,_)] ;
     
assumable(f1,in1,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in2,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in3,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in4,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in5,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in6,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in7,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in8,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in9,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in10,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in11,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in12,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in13,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in14,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in15,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in16,Data) :-
    true ,!,  Data = [1,0] ;
assumable(f1,in17,Data) :-
    true ,!,  Data = [1,0] ;


append([H|T],Y,Z) :-
    true ,!,  Z = [H|ZZ],append(T,Y,ZZ) ;
append([],Y,Z) :-   
    true ,!,  Y = Z ;

end.