%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

%:- module fulladder_rtpg.
%:- public rtpg/4,residue/3.
class fulladder_rtpg_zx has

:rtpg(Class,Working,Output,Inval,Result):- 
    rtpg(Working,Output,Inval,Result) ;

:residue(Class,Output,Inval,Result):- 
    residue(Output,Inval,Result) ;

local

rtpg(Working,output(Dev,Pin,Val,Time),Inval,Result):- 
    true ,!, 
    val(Dev,Pin,[Val|Abnormal],Time,Inval,Working,[],Residue),
    outval_check(Val,Abnormal,Dev,Pin,Inval,Working,Residue,Result) ;


residue(output(Dev,Pin,Val,Time),Inval,Result):- 
    true ,!, 
    val(Dev,Pin,[Val|Abnormal],Time,Inval,residue,[],Result) ;

outval_check(Val,Abnormal,Dev,Pin,Inval,Working,Residue,Result) :-
    Val = Abnormal ,!, 
    Result = [] ;

%otherwise ;
outval_check(Val,Abnormal,Dev,Pin,Inval,Working,Residue,Result) :-
    true ,!, 
    Result = [Working,Inval,obs(Dev,Pin,[Val|Abnormal]),Residue] ;

function_call(Dev,Func,Out,Inval,_,V,VV,T,working(Part,Vallist,Pin,_,_),List0,List1) :-
    Dev = Part,Out = Pin,Inval = Vallist ,!, 
        function(Func,Inval,Out,V),
        descrepancy(Dev,Out,V,VV),
        Working = working(Dev,Inval,Out,V,T),
        List1 = [Working|List0] ;

%otherwise ;
function_call(Dev,Func,Out,Inval,Abnormal,V,VV,T,_,List0,List1) :-
     true ,!, 
        function(Func,Inval,Out,V),
        function(Func,Abnormal,Out,VV),
        Working = working(Dev,Inval,Out,V,T),
        List1 = [Working|List0] ;

connect(Part1,Pin1,[V|VV],T,[val(Part0,Pin0,Val0,Time)|Tail],Inval,_,List0,List1) :-
    Part1 = Part0,Pin1 = Pin0 ,!, 
    V = Val0,VV = Val0,T = Time,
    List0 = List1 ;

connect(Part1,Pin1,[V|VV],T,[],Inval,Working,List0,List1) :-
    true ,!, 
    val(Part1,Pin1,[V|VV],T,Inval,Working,List0,List1) ;    

%otherwise ;
connect(Part1,Pin1,[V|VV],T,[H|Tail],Inval,Working,List0,List1) :-
    true ,!, 
    connect(Part1,Pin1,[V|VV],T,Tail,Inval,Working,List0,List1) ;

%%%%%%%
%%%%%%% data
%%%%%%%

%%% val

%%%%%%%

val(a1_1,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a1_1,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a1_1,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a1_1,Func),
        function_call(a1_1,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a2_1,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a2_1,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a2_1,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a2_1,Func),
        function_call(a2_1,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x1_1,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x1_1,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x1_1,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x1_1,Func),
        function_call(x1_1,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x2_1,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x2_1,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x2_1,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x2_1,Func),
        function_call(x2_1,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(o1_1,out,[V|VV],T,Inval,Working,List1,List4) :- 
    true ,!, 
        val(o1_1,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(o1_1,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(o1_1,Func),
        function_call(o1_1,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a1_2,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a1_2,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a1_2,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a1_2,Func),
        function_call(a1_2,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a2_2,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a2_2,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a2_2,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a2_2,Func),
        function_call(a2_2,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x1_2,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x1_2,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x1_2,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x1_2,Func),
        function_call(x1_2,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x2_2,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x2_2,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x2_2,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x2_2,Func),
        function_call(x2_2,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(o1_2,out,[V|VV],T,Inval,Working,List1,List4) :- 
    true ,!, 
        val(o1_2,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(o1_2,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(o1_2,Func),
        function_call(o1_2,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a1_3,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a1_3,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a1_3,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a1_3,Func),
        function_call(a1_3,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a2_3,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a2_3,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a2_3,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a2_3,Func),
        function_call(a2_3,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x1_3,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x1_3,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x1_3,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x1_3,Func),
        function_call(x1_3,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x2_3,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x2_3,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x2_3,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x2_3,Func),
        function_call(x2_3,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(o1_3,out,[V|VV],T,Inval,Working,List1,List4) :- 
    true ,!, 
        val(o1_3,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(o1_3,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(o1_3,Func),
        function_call(o1_3,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;



val(a1_4,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a1_4,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a1_4,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a1_4,Func),
        function_call(a1_4,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a2_4,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a2_4,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a2_4,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a2_4,Func),
        function_call(a2_4,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x1_4,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x1_4,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x1_4,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x1_4,Func),
        function_call(x1_4,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x2_4,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x2_4,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x2_4,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x2_4,Func),
        function_call(x2_4,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(o1_4,out,[V|VV],T,Inval,Working,List1,List4) :- 
    true ,!, 
        val(o1_4,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(o1_4,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(o1_4,Func),
        function_call(o1_4,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a1_5,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a1_5,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a1_5,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a1_5,Func),
        function_call(a1_5,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a2_5,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a2_5,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a2_5,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a2_5,Func),
        function_call(a2_5,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x1_5,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x1_5,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x1_5,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x1_5,Func),
        function_call(x1_5,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x2_5,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x2_5,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x2_5,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x2_5,Func),
        function_call(x2_5,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(o1_5,out,[V|VV],T,Inval,Working,List1,List4) :- 
    true ,!, 
        val(o1_5,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(o1_5,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(o1_5,Func),
        function_call(o1_5,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a1_6,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a1_6,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a1_6,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a1_6,Func),
        function_call(a1_6,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a2_6,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a2_6,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a2_6,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a2_6,Func),
        function_call(a2_6,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x1_6,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x1_6,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x1_6,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x1_6,Func),
        function_call(x1_6,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x2_6,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x2_6,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x2_6,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x2_6,Func),
        function_call(x2_6,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(o1_6,out,[V|VV],T,Inval,Working,List1,List4) :- 
    true ,!, 
        val(o1_6,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(o1_6,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(o1_6,Func),
        function_call(o1_6,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;


val(a1_7,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a1_7,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a1_7,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a1_7,Func),
        function_call(a1_7,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a2_7,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a2_7,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a2_7,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a2_7,Func),
        function_call(a2_7,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x1_7,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x1_7,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x1_7,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x1_7,Func),
        function_call(x1_7,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x2_7,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x2_7,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x2_7,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x2_7,Func),
        function_call(x2_7,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(o1_7,out,[V|VV],T,Inval,Working,List1,List4) :- 
    true ,!, 
        val(o1_7,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(o1_7,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(o1_7,Func),
        function_call(o1_7,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a1_8,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a1_8,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a1_8,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a1_8,Func),
        function_call(a1_8,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(a2_8,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(a2_8,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(a2_8,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(a2_8,Func),
        function_call(a2_8,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x1_8,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x1_8,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x1_8,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x1_8,Func),
        function_call(x1_8,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(x2_8,out,[V|VV],T,Inval,Working,List1,List4) :-
    true ,!, 
        val(x2_8,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(x2_8,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(x2_8,Func),
        function_call(x2_8,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

val(o1_8,out,[V|VV],T,Inval,Working,List1,List4) :- 
    true ,!, 
        val(o1_8,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(o1_8,in2,[V2|VV2],T,Inval,Working,List2,List3),
        parts(o1_8,Func),
        function_call(o1_8,Func,out,[V1,V2],[VV1,VV2],V,VV,T,Working,List3,List4) ;

%otherwise ;
val(Part2,Pin2,[V|VV],T,Inval,Working,List1,List2) :-
    true ,!, 
        conn(Part1,Pin1,Part2,Pin2),
        connect(Part1,Pin1,[V|VV],T,Inval,Inval,Working,List1,List2) ;


%%%%% descrepancy data

descrepancy(_,_,Normal,Abnormal) :-
    Normal = 1 ,!,  Abnormal = 0 ;
descrepancy(_,_,Normal,Abnormal) :-
    Normal = 0 ,!,  Abnormal = 1 ;

%%%%% connect data
conn(A,B,a1_1,in2):-true,!,A=f1,B=in3; 
conn(A,B,x2_4,in1):-true,!,A=x1_4,B=out; 
conn(A,B,x2_4,in2):-true,!,A=o1_3,B=out; 
conn(A,B,a1_1,in1):-true,!,A=f1,B=in2; 
conn(A,B,a1_4,in2):-true,!,A=f1,B=in9; 
conn(A,B,x1_4,in1):-true,!,A=f1,B=in8; 
conn(A,B,a1_4,in1):-true,!,A=f1,B=in8; 
conn(A,B,x1_3,in2):-true,!,A=f1,B=in7; 
conn(A,B,f1,out4):-true,!,A=x2_4,B=out; 
conn(A,B,x1_6,in2):-true,!,A=f1,B=in13; 
conn(A,B,a1_8,in2):-true,!,A=f1,B=in17; 
conn(A,B,f1,out8):-true,!,A=x2_8,B=out; 
conn(A,B,a1_8,in1):-true,!,A=f1,B=in16; 
conn(A,B,a1_2,in2):-true,!,A=f1,B=in5; 
conn(A,B,x1_3,in1):-true,!,A=f1,B=in6; 
conn(A,B,x1_2,in2):-true,!,A=f1,B=in5; 
conn(A,B,a2_4,in1):-true,!,A=o1_3,B=out; 
conn(A,B,a2_1,in1):-true,!,A=f1,B=in1; 
conn(A,B,f1,out9):-true,!,A=o1_8,B=out; 
conn(A,B,f1,out7):-true,!,A=x2_7,B=out; 
conn(A,B,x1_8,in1):-true,!,A=f1,B=in16; 
conn(A,B,f1,out6):-true,!,A=x2_6,B=out; 
conn(A,B,f1,out5):-true,!,A=x2_5,B=out; 
conn(A,B,x1_5,in2):-true,!,A=f1,B=in11; 
conn(A,B,x1_5,in1):-true,!,A=f1,B=in10; 
conn(A,B,f1,out3):-true,!,A=x2_3,B=out; 
conn(A,B,f1,out1):-true,!,A=x2_1,B=out; 
conn(A,B,x1_2,in1):-true,!,A=f1,B=in4; 
conn(A,B,x1_1,in1):-true,!,A=f1,B=in2; 
conn(A,B,x2_1,in2):-true,!,A=f1,B=in1; 
conn(A,B,a2_8,in1):-true,!,A=o1_7,B=out; 
conn(A,B,x2_8,in2):-true,!,A=o1_7,B=out; 
conn(A,B,a2_6,in1):-true,!,A=o1_5,B=out; 
conn(A,B,x2_6,in2):-true,!,A=o1_5,B=out; 
conn(A,B,a2_5,in1):-true,!,A=o1_4,B=out; 
conn(A,B,x2_5,in2):-true,!,A=o1_4,B=out; 
conn(A,B,a2_3,in1):-true,!,A=o1_2,B=out; 
conn(A,B,x2_3,in2):-true,!,A=o1_2,B=out; 
conn(A,B,a2_2,in1):-true,!,A=o1_1,B=out; 
conn(A,B,x2_2,in2):-true,!,A=o1_1,B=out; 
conn(A,B,x2_1,in1):-true,!,A=x1_1,B=out; 
conn(A,B,a2_1,in2):-true,!,A=x1_1,B=out; 
conn(A,B,o1_1,in2):-true,!,A=a1_1,B=out; 
conn(A,B,o1_1,in1):-true,!,A=a2_1,B=out; 
conn(A,B,x2_2,in1):-true,!,A=x1_2,B=out; 
conn(A,B,a2_2,in2):-true,!,A=x1_2,B=out; 
conn(A,B,o1_2,in2):-true,!,A=a1_2,B=out; 
conn(A,B,o1_2,in1):-true,!,A=a2_2,B=out; 
conn(A,B,x2_3,in1):-true,!,A=x1_3,B=out; 
conn(A,B,a2_3,in2):-true,!,A=x1_3,B=out; 
conn(A,B,o1_3,in2):-true,!,A=a1_3,B=out; 
conn(A,B,o1_3,in1):-true,!,A=a2_3,B=out; 
conn(A,B,a2_4,in2):-true,!,A=x1_4,B=out; 
conn(A,B,o1_4,in2):-true,!,A=a1_4,B=out; 
conn(A,B,o1_4,in1):-true,!,A=a2_4,B=out; 
conn(A,B,x2_5,in1):-true,!,A=x1_5,B=out; 
conn(A,B,a2_5,in2):-true,!,A=x1_5,B=out; 
conn(A,B,o1_5,in2):-true,!,A=a1_5,B=out; 
conn(A,B,o1_5,in1):-true,!,A=a2_5,B=out; 
conn(A,B,x2_6,in1):-true,!,A=x1_6,B=out; 
conn(A,B,a2_6,in2):-true,!,A=x1_6,B=out; 
conn(A,B,o1_6,in2):-true,!,A=a1_6,B=out; 
conn(A,B,o1_6,in1):-true,!,A=a2_6,B=out; 
conn(A,B,x2_7,in1):-true,!,A=x1_7,B=out; 
conn(A,B,a2_7,in2):-true,!,A=x1_7,B=out; 
conn(A,B,o1_7,in2):-true,!,A=a1_7,B=out; 
conn(A,B,o1_7,in1):-true,!,A=a2_7,B=out; 
conn(A,B,x2_8,in1):-true,!,A=x1_8,B=out; 
conn(A,B,a2_8,in2):-true,!,A=x1_8,B=out; 
conn(A,B,o1_8,in2):-true,!,A=a1_8,B=out; 
conn(A,B,o1_8,in1):-true,!,A=a2_8,B=out; 
conn(A,B,f1,out2):-true,!,A=x2_2,B=out; 
conn(A,B,x2_7,in2):-true,!,A=o1_6,B=out; 
conn(A,B,x1_7,in1):-true,!,A=f1,B=in14; 
conn(A,B,a1_2,in1):-true,!,A=f1,B=in4; 
conn(A,B,a1_5,in1):-true,!,A=f1,B=in10; 
conn(A,B,a1_5,in2):-true,!,A=f1,B=in11; 
conn(A,B,a1_7,in2):-true,!,A=f1,B=in15; 
conn(A,B,a1_3,in1):-true,!,A=f1,B=in6; 
conn(A,B,a1_3,in2):-true,!,A=f1,B=in7; 
conn(A,B,x1_8,in2):-true,!,A=f1,B=in17; 
conn(A,B,a2_7,in1):-true,!,A=o1_6,B=out; 
conn(A,B,x1_7,in2):-true,!,A=f1,B=in15; 
conn(A,B,a1_7,in1):-true,!,A=f1,B=in14; 
conn(A,B,x1_6,in1):-true,!,A=f1,B=in12; 
conn(A,B,a1_6,in2):-true,!,A=f1,B=in13; 
conn(A,B,x1_4,in2):-true,!,A=f1,B=in9; 
conn(A,B,x1_1,in2):-true,!,A=f1,B=in3; 
conn(A,B,a1_6,in1):-true,!,A=f1,B=in12; 
%%%%% parts

parts(a1_1,Func):- true ,!, Func = and2_1 ;
parts(a2_1,Func):- true ,!, Func = and2_1 ;
%parts(x1_1,Func):- true ,!, Func = xor2_1 ;
parts(x1_1,Func):- true ,!, Func = xor2_1_x1 ;
parts(x2_1,Func):- true ,!, Func = xor2_1 ;
parts(o1_1,Func):- true ,!, Func = or2_1 ;
parts(a1_2,Func):- true ,!, Func = and2_1 ;
parts(a2_2,Func):- true ,!, Func = and2_1 ;
parts(x1_2,Func):- true ,!, Func = xor2_1 ;
parts(x2_2,Func):- true ,!, Func = xor2_1 ;
parts(o1_2,Func):- true ,!, Func = or2_1 ;
parts(a1_3,Func):- true ,!, Func = and2_1 ;
parts(a2_3,Func):- true ,!, Func = and2_1 ;
parts(x1_3,Func):- true ,!, Func = xor2_1 ;
parts(x2_3,Func):- true ,!, Func = xor2_1 ;
parts(o1_3,Func):- true ,!, Func = or2_1 ;
parts(a1_4,Func):- true ,!, Func = and2_1 ;
parts(a2_4,Func):- true ,!, Func = and2_1 ;
parts(x1_4,Func):- true ,!, Func = xor2_1 ;
parts(x2_4,Func):- true ,!, Func = xor2_1 ;
parts(o1_4,Func):- true ,!, Func = or2_1 ;
parts(a1_5,Func):- true ,!, Func = and2_1 ;
parts(a2_5,Func):- true ,!, Func = and2_1 ;
parts(x1_5,Func):- true ,!, Func = xor2_1 ;
parts(x2_5,Func):- true ,!, Func = xor2_1 ;
parts(o1_5,Func):- true ,!, Func = or2_1 ;
parts(a1_6,Func):- true ,!, Func = and2_1 ;
parts(a2_6,Func):- true ,!, Func = and2_1 ;
parts(x1_6,Func):- true ,!, Func = xor2_1 ;
parts(x2_6,Func):- true ,!, Func = xor2_1 ;
parts(o1_6,Func):- true ,!, Func = or2_1 ;
parts(a1_7,Func):- true ,!, Func = and2_1 ;
parts(a2_7,Func):- true ,!, Func = and2_1 ;
parts(x1_7,Func):- true ,!, Func = xor2_1 ;
parts(x2_7,Func):- true ,!, Func = xor2_1 ;
parts(o1_7,Func):- true ,!, Func = or2_1 ;
parts(a1_8,Func):- true ,!, Func = and2_1 ;
parts(a2_8,Func):- true ,!, Func = and2_1 ;
parts(x1_8,Func):- true ,!, Func = xor2_1 ;
parts(x2_8,Func):- true ,!, Func = xor2_1 ;
parts(o1_8,Func):- true ,!, Func = or2_1 ;

%%%% function

function(and2_1,[V1,V2],Pin,V):-
    true ,!, 
        and2_1(V1,V2,V) ;
function(xor2_1,[V1,V2],Pin,V):-
    true ,!, 
        xor2_1(V1,V2,V) ;
function(xor2_1_x1,[V1,V2],Pin,V):-
    true ,!, 
        xor2_1_x1(V1,V2,V) ;

function(or2_1,[V1,V2],Pin,V):-
    true ,!, 
        or2_1(V1,V2,V) ;

and2_1(1,1,Z):- true ,!, Z = 1 ;
and2_1(1,0,Z):- true ,!, Z = 0 ;
and2_1(0,1,Z):- true ,!, Z = 0 ;
and2_1(0,0,Z):- true ,!, Z = 0 ;

xor2_1(1,1,Z):- true ,!, Z = 0 ;
xor2_1(1,0,Z):- true ,!, Z = 1 ;
xor2_1(0,1,Z):- true ,!, Z = 1 ;
xor2_1(0,0,Z):- true ,!, Z = 0 ;

xor2_1_x1(0,0,V) :- true,!,V = 0 ;
xor2_1_x1(0,1,V) :- true,!,V = 0 ;
xor2_1_x1(1,0,V) :- true,!,V = 0 ;
xor2_1_x1(1,1,V) :- true,!,V = 0 ;

or2_1(1,1,Z):- true ,!, Z = 1 ;
or2_1(1,0,Z):- true ,!, Z = 1 ;
or2_1(0,1,Z):- true ,!, Z = 1 ;
or2_1(0,0,Z):- true ,!, Z = 0 ;

end.

