%
%	(C)1992 Institute for New Generation Computer Technology
%	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%	(Read COPYRIGHT for detailed information.)
%

%:- module fulladder_rtpg.
%:- public rtpg/4,residue/3.
class fulladder_rtpg_x has

:rtpg(Class,Working,Output,Inval,Result):- 
    rtpg(Working,Output,Inval,Result) ;

:residue(Class,Output,Inval,Result):- 
    residue(Output,Inval,Result) ;

local

rtpg(Working,output(Dev,Pin,Val,Time),Inval,Result):- 
    true ,!, 
    val(Dev,Pin,[Val|Abnormal],Time,Inval,Working,[],Residue),
    outval_check(Val,Abnormal,Dev,Pin,Inval,Working,Residue,Result) ;


residue(output(Dev,Pin,Val,Time),Inval,Result):- 
    true ,!, 
    val(Dev,Pin,[Val|Abnormal],Time,Inval,residue,[],Result) ;

outval_check(Val,Abnormal,Dev,Pin,Inval,Working,Residue,Result) :-
    Val = Abnormal ,!, 
    Result = [] ;

%otherwise ;
outval_check(Val,Abnormal,Dev,Pin,Inval,Working,Residue,Result) :-
    true ,!, 
    Result = [Working,Inval,obs(Dev,Pin,[Val|Abnormal]),Residue] ;

function_call(Dev,Func,Out,Inval,_,V,VV,T,working(Part,Vallist,Pin,_,_),List0,List1) :-
    Dev = Part,Out = Pin,Inval = Vallist ,!, 
        function(Func,Inval,Out,V),
        descrepancy(Dev,Out,V,VV),
        Working = working(Dev,Inval,Out,V,T),
        List1 = [Working|List0] ;

%otherwise ;
function_call(Dev,Func,Out,Inval,Abnormal,V,VV,T,_,List0,List1) :-
     true ,!, 
        function(Func,Inval,Out,V),
        function(Func,Abnormal,Out,VV),
        Working = working(Dev,Inval,Out,V,T),
        List1 = [Working|List0] ;

connect(Part1,Pin1,[V|VV],T,[val(Part0,Pin0,Val0,Time)|Tail],Inval,_,List0,List1) :-
    Part1 = Part0,Pin1 = Pin0 ,!, 
    V = Val0,VV = Val0,T = Time,
    List0 = List1 ;

connect(Part1,Pin1,[V|VV],T,[],Inval,Working,List0,List1) :-
    true ,!, 
    val(Part1,Pin1,[V|VV],T,Inval,Working,List0,List1) ;    

%otherwise ;
connect(Part1,Pin1,[V|VV],T,[H|Tail],Inval,Working,List0,List1) :-
    true ,!, 
    connect(Part1,Pin1,[V|VV],T,Tail,Inval,Working,List0,List1) ;

%%%%%%%
%%%%%%% data
%%%%%%%

%%% val

%%%%%%%

val(fa_1,sum,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_1,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_1,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_1,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_1,Func),
        function_call(fa_1,Func,sum,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_1,cout,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_1,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_1,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_1,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_1,Func),
        function_call(fa_1,Func,cout,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_2,sum,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_2,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_2,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_2,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_2,Func),
        function_call(fa_2,Func,sum,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_2,cout,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_2,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_2,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_2,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_2,Func),
        function_call(fa_2,Func,cout,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_3,sum,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_3,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_3,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_3,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_3,Func),
        function_call(fa_,Func,sum,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_3,cout,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_3,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_3,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_3,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_3,Func),
        function_call(fa_3,Func,cout,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_4,sum,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_4,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_4,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_4,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_4,Func),
        function_call(fa_4,Func,sum,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_4,cout,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_4,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_4,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_4,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_4,Func),
        function_call(fa_4,Func,cout,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_5,sum,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_5,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_5,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_5,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_5,Func),
        function_call(fa_5,Func,sum,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_5,cout,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_5,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_5,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_5,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_5,Func),
        function_call(fa_5,Func,cout,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_6,sum,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_6,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_6,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_6,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_6,Func),
        function_call(fa_6,Func,sum,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_6,cout,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_6,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_6,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_6,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_6,Func),
        function_call(fa_6,Func,cout,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_7,sum,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_7,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_7,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_7,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_7,Func),
        function_call(fa_7,Func,sum,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_7,cout,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_7,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_7,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_7,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_7,Func),
        function_call(fa_7,Func,cout,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_8,sum,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_8,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_8,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_8,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_8,Func),
        function_call(fa_8,Func,sum,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

val(fa_8,cout,[V|VV],T,Inval,Working,List1,List5) :-
    true ,!, 
        val(fa_8,in1,[V1|VV1],T,Inval,Working,List1,List2),
        val(fa_8,in2,[V2|VV2],T,Inval,Working,List2,List3),
        val(fa_8,cin,[V3|VV3],T,Inval,Working,List3,List4),
        parts(fa_8,Func),
        function_call(fa_8,Func,cout,[V1,V2,V3],[VV1,VV2,VV3],V,VV,T,Working,List4,List5) ;

%otherwise ;
val(Part2,Pin2,[V|VV],T,Inval,Working,List1,List2) :-
    true ,!, 
        conn(Part1,Pin1,Part2,Pin2),
        connect(Part1,Pin1,[V|VV],T,Inval,Inval,Working,List1,List2) ;


%%%%% descrepancy data

descrepancy(_,_,Normal,Abnormal) :-
    Normal = 1 ,!,  Abnormal = 0 ;
descrepancy(_,_,Normal,Abnormal) :-
    Normal = 0 ,!,  Abnormal = 1 ;

%%%%% connect data

conn(A,B,fa_1,cin):-true,!,A=f1,B=in1;
conn(A,B,fa_8,in2):-true,!,A=f1,B=in17;
conn(A,B,fa_8,in1):-true,!,A=f1,B=in16;
conn(A,B,fa_7,in2):-true,!,A=f1,B=in15;
conn(A,B,fa_7,in1):-true,!,A=f1,B=in14;
conn(A,B,fa_6,in2):-true,!,A=f1,B=in13;
conn(A,B,fa_6,in1):-true,!,A=f1,B=in12;
conn(A,B,fa_5,in2):-true,!,A=f1,B=in11;
conn(A,B,fa_5,in1):-true,!,A=f1,B=in10;
conn(A,B,fa_4,in2):-true,!,A=f1,B=in9;
conn(A,B,fa_4,in1):-true,!,A=f1,B=in8;
conn(A,B,fa_3,in2):-true,!,A=f1,B=in7;
conn(A,B,fa_3,in1):-true,!,A=f1,B=in6;
conn(A,B,fa_2,in2):-true,!,A=f1,B=in5;
conn(A,B,fa_2,cin):-true,!,A=fa_1,B=cout;
conn(A,B,fa_2,in1):-true,!,A=f1,B=in4;
conn(A,B,fa_1,in2):-true,!,A=f1,B=in3;
conn(A,B,fa_1,in1):-true,!,A=f1,B=in2;
conn(A,B,f1,out4):-true,!,A=fa_4,B=sum;
conn(A,B,fa_3,cin):-true,!,A=fa_2,B=cout;
conn(A,B,fa_4,cin):-true,!,A=fa_3,B=cout;
conn(A,B,fa_5,cin):-true,!,A=fa_4,B=cout;
conn(A,B,fa_6,cin):-true,!,A=fa_5,B=cout;
conn(A,B,fa_7,cin):-true,!,A=fa_6,B=cout;
conn(A,B,fa_8,cin):-true,!,A=fa_7,B=cout;
conn(A,B,f1,out1):-true,!,A=fa_1,B=sum;
conn(A,B,f1,out2):-true,!,A=fa_2,B=sum;
conn(A,B,f1,out3):-true,!,A=fa_3,B=sum;
conn(A,B,f1,out5):-true,!,A=fa_5,B=sum;
conn(A,B,f1,out6):-true,!,A=fa_6,B=sum;
conn(A,B,f1,out7):-true,!,A=fa_7,B=sum;
conn(A,B,f1,out8):-true,!,A=fa_8,B=sum;
conn(A,B,f1,out9):-true,!,A=fa_8,B=cout;

%%%%% parts

parts(fa_1,Func):- true ,!, Func = full_adder3_2_c;
parts(fa_2,Func):- true ,!, Func = full_adder3_2_c;
parts(fa_3,Func):- true ,!, Func = full_adder3_2_c;
parts(fa_4,Func):- true ,!, Func = full_adder3_2_c;
parts(fa_5,Func):- true ,!, Func = full_adder3_2_c;
parts(fa_6,Func):- true ,!, Func = full_adder3_2_c;
parts(fa_7,Func):- true ,!, Func = full_adder3_2_c;
parts(fa_8,Func):- true ,!, Func = full_adder3_2_c;

%%%% function

function(full_adder3_2_c,[V1,V2,V3],Pin,V):-
    true ,!, 
        full_adder3_2_c(V1,V2,V3,Pin,V) ;

full_adder3_2_c(1,1,1,sum,Z):- true ,!, Z = 1 ;
full_adder3_2_c(0,0,0,sum,Z):- true ,!, Z = 0 ;
full_adder3_2_c(0,1,1,sum,Z):- true ,!, Z = 0 ;
full_adder3_2_c(1,0,1,sum,Z):- true ,!, Z = 0 ;
full_adder3_2_c(1,1,0,sum,Z):- true ,!, Z = 0 ;
full_adder3_2_c(0,0,1,sum,Z):- true ,!, Z = 1 ;
full_adder3_2_c(0,1,0,sum,Z):- true ,!, Z = 1 ;
full_adder3_2_c(1,0,0,sum,Z):- true ,!, Z = 1 ;

full_adder3_2_c(1,1,1,cout,Z):- true ,!, Z = 1 ;
full_adder3_2_c(0,0,0,cout,Z):- true ,!, Z = 0 ;
full_adder3_2_c(0,1,1,cout,Z):- true ,!, Z = 1 ;
full_adder3_2_c(1,0,1,cout,Z):- true ,!, Z = 1 ;
full_adder3_2_c(1,1,0,cout,Z):- true ,!, Z = 1 ;
full_adder3_2_c(0,0,1,cout,Z):- true ,!, Z = 0 ;
full_adder3_2_c(0,1,0,cout,Z):- true ,!, Z = 0 ;
full_adder3_2_c(1,0,0,cout,Z):- true ,!, Z = 0 ;

end.