/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char treeio_c_rcsid[]="$Id: treeio.c,v 2.6 1993/04/22 07:39:12 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: treeio.c,v $
 * Revision 2.6  1993/04/22  07:39:12  gpc-avc
 * Removed old log messages
 *
 * Revision 2.5  1993/04/14  04:40:17  gpc-avc
 * Added pop[p].format instead of pop[p].terminal_table[pop[p].terminal_table_size].printname
 * to store the formatting string
 *
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include "gpc.h"



#ifdef ANSI_FUNC

int read_terminal_set_values(
  pop_struct 	*pop,
  int 		p,
  FILE 		*f
  )
#else

int read_terminal_set_values(pop,p,f)
  pop_struct	*pop;
  int		p;
  FILE		*f;
#endif
{
  int	i;

  for (i=0; i<pop[p].terminal_table_size; i++) {
    if (fscanf(f,pop[p].format, &(pop[p].terminal_table[i].val)) == EOF) 
      return EOF;
  }
  return 1;
}

#ifdef ANSI_FUNC

VOID load_terminal_set_values(
  pop_struct	*pop,
  int 		p,
  GENERIC 	*v
)
#else

VOID load_terminal_set_values(pop,p,v)
  pop_struct	*pop;
  int		p;
  GENERIC 	*v;
#endif
{
  int	i;

  for (i=0; i<pop[p].terminal_table_size; i++) {
    pop[p].terminal_table[i].val = v[i];
  }
}

#define TRACE 0
#ifdef ANSI_FUNC

tree *read_tree(
  pop_struct 	*pop,
  int 		p,
  FILE 		*f
  )
#else

tree *read_tree(pop,p,f)
  pop_struct 	*pop;
  int		p;
  FILE		*f;
#endif
{
  int	i;
  tree 	*t;
  char	buf[80];
  
  if (fscanf(f,"%1s",buf) == EOF) return (tree *) EOF;
  if (buf[0] == '(') {

    if (TRACE) printf("(");

    fscanf(f,"%1s", buf);
    ungetc(buf[0],f);
    get_next_token(buf, f);

    if (TRACE) printf("%s ",buf);

    t = create_tree_node(p,FUNCTION, lookup_function_name(pop,p,buf));
    for (i=0; i < function_arity(t); i++) {
      t->type.func->arg[i] = read_tree(pop,p,f);
    }

    fscanf(f,")");
    if (TRACE) printf(")\n");

  } else {
    ungetc(buf[0], f);
    get_next_token(buf, f);

    if (TRACE) printf("%s ",buf);

    t = create_tree_node(p,TERMINAL, lookup_terminal_name(pop,p,buf));
    if (terminal_is_constant(t)) {
      sscanf(buf, pop[p].format, (t->type.term->valptr));
    }
  }
  return(t);
}

#ifdef ANSI_FUNC

VOID write_tree(
  pop_struct	*pop,
  tree 		*t,
  char		*format,
  FILE 		*f
  )
#else

VOID write_tree(pop, t, format, f)
  pop_struct 	*pop;
  tree		*t;
  char		*format;
  FILE		*f;
#endif
{
  pprint_tree(pop, t, format, f, 0);
}

#ifdef ANSI_FUNC

VOID pprint_tree(
  pop_struct	*pop,
  tree 		*t,
  char		*format,
  FILE 		*f,
  int 		level
  )
#else

VOID pprint_tree(pop, t, format, f, level)
  pop_struct 	*pop;
  tree		*t;
  char		*format;
  FILE		*f;
  int		level;
#endif
{
  int	i;
    
  blanks(level,f);
  if (t->nodetype == FUNCTION) {
    fprintf(f,"(%s\n",function_printname(t));
    for (i=0; i<function_arity(t); i++) {
      pprint_tree(pop, t->type.func->arg[i], format, f, level+INDENT);
      if (i == (function_arity(t)-1))
	fprintf(f,")");  
      else 
	fprintf(f,"\n");
    }
  } else if (t->nodetype == TERMINAL) {
    if (t->id == pop[t->pop].terminal_table_size) { /* a constant */
      fprintf(f, format, *(t->type.term->valptr));
    } else {
      fprintf(f,"%s",terminal_printname(t));
    }
  } else {
    fprintf(stderr,
	    "nodetype %d must be %d or %d in pprint_tree() <treeio.c>\n",
	    t->nodetype, FUNCTION, TERMINAL);
  }
  if (!level) fprintf(f,"\n");
}

#ifdef ANSI_FUNC

int lookup_function_name(
  pop_struct 	*pop,
  int 		p,
  char 		*buf
  )
#else

int lookup_function_name(pop,p,buf)
  pop_struct	*pop;
  int		p;
  char		*buf;
#endif
{
  int	i;

  for (i=0; i<pop[p].function_table_size; i++) {
    if (!strcasecmp(buf, pop[p].function_table[i].printname)) {
      return(i);
    }
  }

  fprintf(stderr,"%s not found in function_table[%d]\n",buf,p);
  exit(1);
  return(-1); /* make lint happy */
}

#ifdef ANSI_FUNC

int lookup_terminal_name(
  pop_struct	*pop,
  int 		p,
  char 		*buf
  )
#else

int lookup_terminal_name(pop,p,buf)
  pop_struct 	*pop;
  int		p;
  char		*buf;
#endif
{
  int	i;

  for (i=0; i<pop[p].terminal_table_size; i++) {
    if (!strcasecmp(buf, pop[p].terminal_table[i].printname)) {
      return(i);
    }
  }
  /* Assume that buf is a constant value */
  return(pop[p].terminal_table_size);
}

#ifdef ANSI_FUNC

VOID get_next_token(
	char *buf,
	FILE *f
	)
#else

VOID get_next_token(buf,f)
  char 	*buf;
  FILE	*f;
#endif
{
  int	ibuf;
  int	i = 0;

  while ((ibuf = getc(f)) != EOF) {
    if (isspace((char) ibuf)) {
      buf[i] = '\0';
      break;
    } else if (((char) ibuf) == ')') {
      ungetc((char) ibuf, f);      
      buf[i] = '\0';
      break;
    } else {
      buf[i++] = (char) ibuf;
    }
  }
}

#ifdef ANSI_FUNC

VOID blanks(
	int n,
	FILE *f
	)
#else

VOID blanks(n,f)
  int	n;
  FILE	*f;
#endif
{
  int	i;

  for (i=0; i<n; i++) fprintf(f," ");
}

