/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef _RANDOM_H_
#define _RANDOM_H_

#ifndef lint
static char random_h_rcsid[]="$Id: random.h,v 1.4 1993/04/22 07:39:12 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: random.h,v $
 * Revision 1.4  1993/04/22  07:39:12  gpc-avc
 * Removed old log messages
 *
 * Revision 1.3  1993/04/14  04:04:56  gpc-avc
 * Finished mods for checkpointing
 *
 * 
 */

/* main program should define extern to be empty string */

#ifdef _MAIN_
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN int 	gaussian_noise_toggle;
EXTERN float 	gaussian_noise_uniform1, gaussian_noise_uniform2;
EXTERN float	gaussian_noise_temp;

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* random.c */

float random_float P_((
  float f
  ));

int random_int P_((
  int i
  ));

void set_seed P_((
  unsigned long s
  ));

unsigned long get_seed P_((void));

float park_miller_randomizer P_((void));

long PMrand P_((
  long *s
  ));

float gaussian_noise P_((
		     float mean,
		     float sigma
		     ));

#endif
