/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char eval_c_rcsid[]="$Id: eval.c,v 2.5 1993/04/29 20:39:23 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: eval.c,v $
 * Revision 2.5  1993/04/29  20:39:23  gpc-avc
 * Added checks for NaN and infinity for results of eval
 *
 * Revision 2.4  1993/04/22  07:39:12  gpc-avc
 * Removed old log messages
 *
 * Revision 2.3  1993/04/14  05:03:32  gpc-avc
 * Just a change to revision number
 *
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <math.h>
#include <values.h>
#include "gpc.h"


#ifdef ANSI_FUNC

GENERIC eval(
  tree *t
  )
#else

GENERIC eval(t)
  tree	*t;
#endif
{	
  GENERIC val;
  
  val = evaluate_tree(t);
  if (isnan(val)) val = (GENERIC)0.0;
  if (isinf(val)) val = (GENERIC)MAXINT;
  return(val);
}


#ifdef ANSI_FUNC

GENERIC evaluate_tree(
  tree *t
  )
#else

GENERIC evaluate_tree(t)
  tree	*t;
#endif
{	
  int 	i;
  pop_struct *pop = POP;

  if (t != (tree *) NULL) {
    if (t->nodetype == TERMINAL) {
      return (*(t->type.term->valptr));
    } 	
    else if (t->nodetype == FUNCTION) {
      if (function_is_macro(t)) {
	/* function must call eval in it's own definition code to eval
	   arguments in proper order. */
	return (*(function_code(t)))(t->type.func->arg);
      } else {
	for (i=0; i<function_arity(t); i++) {
	  t->type.func->argvals[i] = evaluate_tree(t->type.func->arg[i]);
	}
	return (*(function_code(t)))(t->type.func->argvals);
      }
    }
    else {
      fprintf(stderr, 
	      "Erorr: nodetype %d must be %d or %d in evaluate_tree() <eval.c>\n",
	      t->nodetype, FUNCTION, TERMINAL);
      return ((GENERIC) 0); /* make lint happy */
    }
  }
  else {
    fprintf(stderr,
	    "Error: tree is NULL in evaluate_tree() <eval.c>\n");
    return ((GENERIC) 0);
  }
}
