/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char setup_c_rcsid[]="$Id: setup.c,v 1.7 1993/05/14 21:41:18 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: setup.c,v $
 * Revision 1.7  1993/05/14  21:41:18  gpc-avc
 * Changed pdif to reurn 1 on div by zero (per Koza)
 *
 * Revision 1.6  1993/04/30  05:10:02  gpc-avc
 * Restructured directories and Makefile
 *
 * Revision 1.4  1993/04/14  04:04:56  gpc-avc
 * Finished mods for checkpointing
 *
 *
 */

#include <stdio.h>
#include <math.h>
#include "gpc.h"
#include "prob.h"


#ifdef ANSI_FUNC

VOID make_function_table(
  int 	numpops,
  pop_struct *pop
  )
#else

VOID make_function_table(numpops,pop)
  int		numpops;
  pop_struct	*pop;
#endif

{

  /* 
    Assigns function pointers, print names, arity, macro-flag, etc, to 
    function table entries for all populations.  In this case all 
    populations share the same function set.
  */

  int	p;

  for (p=0; p<numpops; p++) {
    pop[p].function_table_size = 6;
    pop[p].function_table =
      (function_table_entry *) malloc(pop[p].function_table_size *
				      sizeof(function_table_entry));

    pop[p].function_table[0].arity = 2;
    pop[p].function_table[0].macro = FALSE;
    pop[p].function_table[0].enabled = TRUE;
    pop[p].function_table[0].printname = "+";
    pop[p].function_table[0].code = plus;
    
    pop[p].function_table[1].arity = 2;
    pop[p].function_table[1].macro = FALSE;
    pop[p].function_table[1].enabled = TRUE;
    pop[p].function_table[1].printname = "-";
    pop[p].function_table[1].code = minus;
    
    pop[p].function_table[2].arity = 2;
    pop[p].function_table[2].macro = FALSE;
    pop[p].function_table[2].enabled = TRUE;
    pop[p].function_table[2].printname = "*";
    pop[p].function_table[2].code = xtimes;
    
    pop[p].function_table[3].arity = 2;
    pop[p].function_table[3].macro = FALSE;
    pop[p].function_table[3].enabled = TRUE;
    pop[p].function_table[3].printname = "%";
    pop[p].function_table[3].code = pdiv;
    
    pop[p].function_table[4].arity = 4;
    pop[p].function_table[4].macro = TRUE;
    pop[p].function_table[4].enabled = TRUE;
    pop[p].function_table[4].printname = "IFLTE";
    pop[p].function_table[4].code = iflte;
    
    pop[p].function_table[5].arity = 2;
    pop[p].function_table[5].macro = FALSE;
    pop[p].function_table[5].enabled = TRUE;
    pop[p].function_table[5].printname = "ATG";
    pop[p].function_table[5].code = atg;
    
  }
}


#ifdef ANSI_FUNC

VOID make_terminal_table(
  int		numpops,
  pop_struct 	*pop
  )
#else

VOID make_terminal_table(numpops,pop)
  int		numpops;
  pop_struct 	*pop;
#endif
{
  /* 
     IMPORTANT NOTE: terminal_table_size should be equal to the number of
     terminals, but there should be (terminal_table_size+1) entries to allow
     for reading/printing actual constants
   */


  int p;

  for (p=0; p<numpops; p++) {
    pop[p].terminal_table_size = 1;
    pop[p].terminal_table =
      (terminal_table_entry *) malloc((pop[p].terminal_table_size+1) *
				      sizeof(terminal_table_entry));
    pop[p].terminal_table[0].val = 0;
    pop[p].terminal_table[0].printname = "X";
    pop[p].terminal_table[0].constant_generator = random_constant;

    pop[p].terminal_table[pop[p].terminal_table_size].val = 0;
    pop[p].terminal_table[pop[p].terminal_table_size].printname = FORMAT;
    pop[p].terminal_table[pop[p].terminal_table_size].constant_generator =
      random_constant;

    pop[p].format = FORMAT;
    pop[p].ckpt_format = CKPT_FORMAT;

  }
}
   
#ifdef ANSI_FUNC

GENERIC plus(
  GENERIC *args
  )
#else

GENERIC plus(args)
  GENERIC *args;
#endif
{
  return args[0]+args[1];
}

#ifdef ANSI_FUNC

GENERIC minus(
  GENERIC *args
  )
#else

GENERIC minus(args)
  GENERIC *args;
#endif
{
  return args[0]-args[1];
}

#ifdef ANSI_FUNC

GENERIC xtimes(
  GENERIC *args
  )
#else

GENERIC xtimes(args)
  GENERIC *args;
#endif
{
  return args[0]*args[1];
}

#ifdef ANSI_FUNC

GENERIC pdiv(
  GENERIC *args
  )
#else

GENERIC pdiv(args)
  GENERIC *args;
#endif
{
  return (args[1] ? args[0]/args[1] : 1);
}


/* this is an example of a macro: arguments are evaluated conditionally */
/* note that args are unevaluated trees, not GENERIC values */

#ifdef ANSI_FUNC

GENERIC iflte(
  tree **args
  )
#else

GENERIC iflte(args)
  tree 	**args;
#endif
{
  return ((eval(args[0]) < eval(args[1])) ? eval(args[2]) : eval(args[3]));
}

#ifdef ANSI_FUNC

GENERIC atg(
  GENERIC *args
  )
#else

GENERIC atg(args)
  GENERIC *args;
#endif
{
  /* the damn thing does not like atan2(0.0,0.0) eventhough the man page
     for atan says: "atan2(0.0,0.0) is +-0.0 or +-pi, in conformance
     with 4.3BSD, as discussed in the Floating-Point Programmers Guide.
   */

  if ((args[0] == 0.0) && (args[1] == 0.0)) return (GENERIC)0.0;
  return (GENERIC)atan2((double)args[0], (double)args[1]);
}

#ifdef ANSI_FUNC

GENERIC random_constant(void)
#else

GENERIC random_constant()
#endif
{
  return ((GENERIC)random_float(10.0) - (GENERIC)5.0);
}

