#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <stdlib.h>
#include <math.h>

#define _MAIN_
#include "random.h"
#undef _MAIN_

float optclass(); 

#define dtor(theta) (((theta)*M_PI)/180.0)
main() {
  FILE *df,*tmp;
  char donutfile[80], buffy[200];
  float theta1, theta2, r, x, y, z;  
  int numpts, i, bites, numdeleted = 0, nummisclass = 0;
  float sigma;
  unsigned long xseed;
  
  printf("Enter name of donut file to create: ");
  scanf("%s",donutfile);
  printf("Enter number of points for each donut: ");
  scanf("%d",&numpts);
  printf("Enter sigma for donuts: ");
  scanf("%f",&sigma);
  printf("Enter number of bites (0-3): ");
  scanf("%d",&bites);
  printf("Enter random seed: ");
  scanf("%ld",&xseed);

  set_seed(xseed);

  df = fopen("delete.me.temp","w");
  for (i=0; i<numpts; i++) {
    theta1 = random_float(2.0*M_PI);
    if ((bites >= 1)&&(theta1 > dtor(45.0))&&(theta1 < dtor(75.0))) {
      numdeleted++;
      continue;
    }
    if ((bites >= 2)&&(theta1 > dtor(165.0))&&(theta1 < dtor(195.0))) {
      numdeleted++;
      continue;
    }
    if ((bites == 3)&&(theta1 > dtor(285.0))&&(theta1 < dtor(315.0))) {
      numdeleted++;
      continue;
    }
    theta2 = random_float(2.0*M_PI);
    r = gaussian_noise(0.0, sigma);
    x = ((float) cos((double)theta1))*(1.0 + r*((float)cos((double)theta2)));
    y = ((float) sin((double)theta1))*(1.0 + r*((float)cos((double)theta2)));
    z = r*((float)sin((double)theta2));
    if (optclass(x,y,z) <= 0.0) nummisclass++;
    fprintf(df,"%d\t%f\t%f\t%f\n",0,x,y,z);
  }
  for (i=0; i<numpts; i++) {
    theta1 = random_float(2.0*M_PI);
    if ((bites >= 1)&&(theta1 > dtor(45.0))&&(theta1 < dtor(75.0))) {
      numdeleted++;
      continue;
    }
    if ((bites >= 2)&&(theta1 > dtor(165.0))&&(theta1 < dtor(195.0))) {
      numdeleted++;
      continue;
    }
    if ((bites == 3)&&(theta1 > dtor(285.0))&&(theta1 < dtor(315.0))) {
      numdeleted++;
      continue;
    }
    theta2 = random_float(2.0*M_PI);
    r = gaussian_noise(0.0, sigma);
    x =
      1.0+((float) sin((double)theta1))*(1.0 + r*((float)cos((double)theta2)));
    y = r*((float)sin((double)theta2));
    z = ((float) cos((double)theta1))*(1.0 + r*((float)cos((double)theta2)));
    if (optclass(x,y,z) > 0.0) nummisclass++;
    fprintf(df,"%d\t%f\t%f\t%f\n",1,x,y,z);
  }
  printf("%f%% will be misclassified by the optimal classifier\n",
	 100.0*((float)nummisclass)/((float)(2*numpts-numdeleted)));
  
  fprintf(df,"seed = %ld, sigma = %f\n", xseed, sigma);
  fclose(df);
  df = fopen(donutfile,"w");
  tmp = fopen("delete.me.temp","r");
  fprintf(df,"%d\n",(2*numpts)-numdeleted);
  while (fgets(buffy,200,tmp) != NULL) fputs(buffy,df);
  fclose(df);
  fclose(tmp);
  unlink("delete.me.temp");
  exit(0);
}


float optclass(x,y,z) 
float	x,y,z;
{
  return (float)
    (2.0*(sqrt((double)(x*x+y*y))-sqrt((double)((x-1.0)*(x-1.0)+z*z))-x)+1.0);
}
