/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char setup_c_rcsid[]="$Id: setup.c,v 2.8 1993/06/10 19:25:46 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: setup.c,v $
 * Revision 2.8  1993/06/10  19:25:46  gpc-avc
 * Fixed bug in index of function_table[].enabled
 *
 * Revision 2.7  1993/05/14  21:40:55  gpc-avc
 * Changed pdiv to return 1 on div by zero (per Koza)
 *
 * Revision 2.6  1993/04/30  05:08:38  gpc-avc
 * Restructured directories and Makefile
 *
 * Revision 2.4  1993/04/15  09:16:52  gpc-avc
 * Added proto.h plus minor chages to bring inline with rest of code
 *
 *
 */

#include <stdio.h>
#include "gpc.h"
#include "prob.h"


#ifdef ANSI_FUNC

VOID make_function_table(
     int	numpops,
     pop_struct *pop
     )
#else

VOID make_function_table(numpops, pop)
  int		numpops;
  pop_struct	*pop;
#endif
{
  int p;

  for (p=0; p<numpops; p++) {
    pop[p].function_table_size = 5;
    pop[p].function_table =
      (function_table_entry *) malloc(pop[p].function_table_size *
				      sizeof(function_table_entry));
    
    pop[p].function_table[0].arity = 2;
    pop[p].function_table[0].macro = FALSE;
    pop[p].function_table[0].enabled = TRUE;
    pop[p].function_table[0].printname = "+";
    pop[p].function_table[0].code = plus;
    
    pop[p].function_table[1].arity = 2;
    pop[p].function_table[1].macro = FALSE;
    pop[p].function_table[1].enabled = TRUE;
    pop[p].function_table[1].printname = "-";
    pop[p].function_table[1].code = minus;
    
    pop[p].function_table[2].arity = 2;
    pop[p].function_table[2].macro = FALSE;
    pop[p].function_table[2].enabled = TRUE;
    pop[p].function_table[2].printname = "*";
    pop[p].function_table[2].code = xtimes;
    
    pop[p].function_table[3].arity = 2;
    pop[p].function_table[3].macro = FALSE;
    pop[p].function_table[3].enabled = TRUE;
    pop[p].function_table[3].printname = "%";
    pop[p].function_table[3].code = pdiv;
    
    pop[p].function_table[4].arity = 4;
    pop[p].function_table[4].macro = TRUE;
    pop[p].function_table[4].enabled = TRUE;
    pop[p].function_table[4].printname = "IFLTE";
    pop[p].function_table[4].code = iflte;
  }
}

#ifdef ANSI_FUNC

VOID make_terminal_table(
  int		numpops,
  pop_struct 	*pop
  )
#else

VOID make_terminal_table(numpops,pop)
  int		numpops;
  pop_struct 	*pop;
#endif
{
  /* IMPORTANT NOTE: terminal_table_size should be equal to the number of
     terminals, but there should be (terminal_table_size+1) entries to allow
     for reading/printing actual constants 
   */

  int p;

  /*
    NOTE: all populations are the same for this case
  */

  for (p=0; p<numpops; p++) {

    pop[p].terminal_table_size = 7;

    pop[p].terminal_table =
      (terminal_table_entry *) malloc((pop[p].terminal_table_size+1) *
				      sizeof(terminal_table_entry));
    pop[p].terminal_table[0].val = 0;
    pop[p].terminal_table[0].printname = "F00";
    pop[p].terminal_table[0].constant_generator = random_constant;
    
    pop[p].terminal_table[1].val = 0;
    pop[p].terminal_table[1].printname = "F01";
    pop[p].terminal_table[1].constant_generator = random_constant;

    pop[p].terminal_table[2].val = 0;
    pop[p].terminal_table[2].printname = "F02";
    pop[p].terminal_table[2].constant_generator = random_constant;
    
    pop[p].terminal_table[3].val = 0;
    pop[p].terminal_table[3].printname = "F03";
    pop[p].terminal_table[3].constant_generator = random_constant;
    
    pop[p].terminal_table[4].val = 0;
    pop[p].terminal_table[4].printname = "F04";
    pop[p].terminal_table[4].constant_generator = random_constant;
    
    pop[p].terminal_table[5].val = 0;
    pop[p].terminal_table[5].printname = "F05";
    pop[p].terminal_table[5].constant_generator = random_constant;
    
    pop[p].terminal_table[6].val = 0;
    pop[p].terminal_table[6].printname = "F06";
    pop[p].terminal_table[6].constant_generator = random_constant;
    
    pop[p].terminal_table[pop[p].terminal_table_size].val = 0;
    pop[p].terminal_table[pop[p].terminal_table_size].printname = FORMAT;
    pop[p].terminal_table[pop[p].terminal_table_size].constant_generator =
      random_constant;

    pop[p].format = FORMAT;
    pop[p].ckpt_format = CKPT_FORMAT;

  }
}
   
#ifdef ANSI_FUNC

GENERIC plus(
	GENERIC *args
	)
#else

GENERIC plus(args)
  GENERIC *args;
#endif
{
  return args[0]+args[1];
}

#ifdef ANSI_FUNC

GENERIC minus(
	GENERIC *args
	)
#else

GENERIC minus(args)
  GENERIC *args;
#endif
{
  return args[0]-args[1];
}

#ifdef ANSI_FUNC

GENERIC xtimes(
	GENERIC *args
	)
#else

GENERIC xtimes(args)
  GENERIC *args;
#endif
{
  return args[0]*args[1];
}

#ifdef ANSI_FUNC

GENERIC pdiv(
	GENERIC *args
	)
#else

GENERIC pdiv(args)
  GENERIC *args;
#endif
{
  return (args[1] ? args[0]/args[1] : 1);
}

/* this is an example of a macro: arguments are evaluated conditionally */
/* note that args are unevaluated trees, not GENERIC values */

#ifdef ANSI_FUNC

GENERIC iflte(
	tree **args
  )
#else

GENERIC iflte(args)
/* not that args are unevaluated trees, not GENERIC values */
  tree 	**args;
#endif
{
  return ((eval(args[0]) < eval(args[1])) ? eval(args[2]) : eval(args[3]));
}

#ifdef ANSI_FUNC

GENERIC random_constant(void)
#else

GENERIC random_constant()
#endif
{
  return ((GENERIC)random_float(10.0) - (GENERIC)5.0);
}






