/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef lint
static char treegen_c_rcsid[]="$Id: treegen.c,v 2.5 1993/04/14 04:38:08 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: treegen.c,v $
 * Revision 2.5  1993/04/14  04:38:08  gpc-avc
 * Fixed side effect of read_tree() so it does not change random seed
 *
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include "gpc.h"

#ifdef ANSI_FUNC

tree *create_random_tree(
  pop_struct 	*pop,
  int 		p,
  int 		max_depth,
  int 		root_p,
  int 		full_p
  )
#else

tree *create_random_tree(pop, p, max_depth, root_p, full_p)
  pop_struct 	*pop;
  int		p;
  int		max_depth;
  int		root_p;
  int		full_p;
#endif
{
  tree	*t;
  int	i, choice;

  if (max_depth <= 0) {
    t = create_tree_node(p, TERMINAL,
			  random_int(pop[p].terminal_table_size+ALLOW_CONST));
    *(t->type.term->valptr) = (*(terminal_constant_generator(t)))();
    return t;
  } else if (root_p || full_p) {
    while (!pop[p].function_table[choice = 
                              random_int(pop[p].function_table_size)].enabled);
    t = create_tree_node(p, FUNCTION, choice);
    for (i=0; i<function_arity(t); i++) {
      t->type.func->arg[i] =
	create_random_tree(pop, p, (max_depth-1), 0, full_p);
    }
    return t;
  } else {
    choice =  random_int(pop[p].function_table_size +
			 pop[p].terminal_table_size+ALLOW_CONST);
    if (choice < pop[p].function_table_size) {
      while (!pop[p].function_table[choice].enabled)
	 choice = random_int(pop[p].function_table_size);
      t = create_tree_node(p, FUNCTION, choice);
      for (i=0; i<function_arity(t); i++) {
	t->type.func->arg[i] =
	  create_random_tree(pop, p, (max_depth-1), 0, full_p);
      }
      return t;
    } else {
      t = create_tree_node(p, TERMINAL, choice-pop[p].function_table_size);
      *(t->type.term->valptr) = (*(terminal_constant_generator(t)))();
      return t;
    }
  }
}
