// imview.h : interface of the CImView class
// Copyright 1993 by Harley Davis

/////////////////////////////////////////////////////////////////////////////

class CImView : public CView
{
protected: // create from serialization only
	CImView();
	DECLARE_DYNCREATE(CImView)

// Attributes
protected:
	int		m_nRow;			// view's row
	int		m_nColumn;		// view's column
	int		m_nHeight;		// height of view bitmap
	int		m_nWidth;		// width of view bitmap
	int		m_nWHeight;		// height of view window
	int		m_nWWidth;		// width of view window
	BOOL	m_bActive;		// view activated?
	BOOL	m_bComputed;	// view already done?
	BOOL	m_bComputing;	// view being computed now?
	CBitmap* m_pBitmap;		// the computed bitmap
	CBitmap* m_pOldBitmap;	// previous bitmap
	int		m_nClicks;		// # of times clicked on.
	CImOrganism* m_pOrganism; // the organism
	CString m_sLastFile;	// last file saved
	
public:
	CImDoc* GetDocument();
	void SetRow(int x) { m_nRow = x; }
	void SetColumn(int y) { m_nColumn = y; }
	void SetHeight(int h) { m_nHeight = h; }
	void SetWidth(int w) { m_nWidth = w; }
	void SetWHeight(int h) { m_nWHeight = h; }
	void SetWWidth(int w) { m_nWWidth = w; }
	void SetActive(BOOL a) { m_bActive = a; }
	void ComputeImage(CDC* pDC, CDC* pMemDC);
	void ShowRegion(CDC* pDC, CDC* pMemDC, int nXOrg, int nYOrg, int nWidth, int nHeight,
					int nWWidth, int nWHeight);
	void SetOrganism(CImOrganism* pOrg) { m_pOrganism = pOrg; }
	CImOrganism* GetOrganism() { return m_pOrganism; }
	BOOL MsgLoop();
	

// Operations
public:
	void ShowActive(BOOL);

// Implementation
public:
	virtual ~CImView();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnUpdate(CView* pSender, LPARAM lHint = 0L, CObject* pHint = NULL); 
	virtual void OnActivateView(BOOL, CView*, CView*);
	void InstallPalette(CDC* pDC);
	CPalette* GetPalette();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Printing support
protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);

// Generated message map functions
protected:
	//{{AFX_MSG(CImView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnSaveasBmp();
	afx_msg void OnFileSetwallpaper();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG	// debug version in imview.cpp
inline CImDoc* CImView::GetDocument()
   { return (CImDoc*) m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
