// imview.cpp : implementation of the CImView class
// Copyright 1993 by Harley Davis

#include <math.h> 
#include <time.h> 
#include <sys\types.h>
#include <sys\stat.h>
#include "stdafx.h"
#include "iminl.h"
#include "imobj.h"
#include "imogene.h"
#include "imframe.h"
#include "imdoc.h"
#include "imview.h"
#include "imorgdes.h" 
#include "imsave.h"
#include "showdib.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CImView

IMPLEMENT_DYNCREATE(CImView, CView)

BEGIN_MESSAGE_MAP(CImView, CView)
	//{{AFX_MSG_MAP(CImView)
	ON_WM_SIZE()
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_SAVEAS_BMP, OnSaveasBmp)
	ON_COMMAND(ID_FILE_SETWALLPAPER, OnFileSetwallpaper)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImView construction/destruction

CImView::CImView()
{
	m_bComputed = FALSE;
	m_bComputing = FALSE;
	m_nClicks = 0;
	m_pBitmap = NULL;
	m_sLastFile = "";
}

CImView::~CImView()
{
	delete m_pBitmap;
}

/////////////////////////////////////////////////////////////////////////////
// CImView drawing 

void CImView::InstallPalette(CDC* pDC)
{
	pDC->SelectPalette(GetPalette(), FALSE);
	int nColors = pDC->RealizePalette();
}

void CImView::OnDraw(CDC* pDC)
{ 
	if((m_nWWidth==0)||(m_nWHeight==0)) return;

	ASSERT_VALID(pDC);

	CDC* pMemDC = new CDC;
	if(!(pMemDC->CreateCompatibleDC(pDC)))
		TRACE("** Couldn't create compatible DC!");
	ASSERT_VALID(pMemDC);
	ASSERT_VALID(pDC);

	InstallPalette(pDC);
	InstallPalette(pMemDC);
	
	if(!m_bComputed)
		ComputeImage(pDC, pMemDC);
	else
	{
		m_pOldBitmap=pMemDC->SelectObject(m_pBitmap);
		ShowRegion(pDC, pMemDC, 0, 0, m_nWidth, m_nHeight, m_nWWidth, m_nWHeight);
	}
		
	// clean up
	pMemDC->SelectObject(m_pOldBitmap);
	ASSERT_VALID(pMemDC);
	ASSERT_VALID(pDC);
	ASSERT_VALID(m_pBitmap);
	ASSERT_VALID(m_pOldBitmap);
	
	delete pMemDC;
    
    /*
    TRACE("Showing active...\n");
	ShowActive(m_bActive);
	TRACE("Show active done.\n");
	*/		
}

void CImView::ShowRegion(CDC* pDC, CDC* pMemDC, int nXOrg, int nYOrg, int nWidth,
							int nHeight, int nWWidth, int nWHeight)
{
	if(!(pDC->StretchBlt(nXOrg, nYOrg, nWWidth, nWHeight, pMemDC, 
						nXOrg, nYOrg, nWidth, nHeight, SRCCOPY)))
		{
			TRACE("** Couldn't do the StretchBlt!");
			AfxThrowUserException();
		}
	ASSERT_VALID(pDC);
	ASSERT_VALID(pMemDC);
}

static BOOL show_interpreted = FALSE;
	

void CImView::ComputeImage(CDC* pDC, CDC* pMemDC)
{   
	if ((m_nWWidth==0)||(m_nWHeight==0)) return;
	if (m_bComputing) return;
	m_bComputing = TRUE;
	// Process any pending messages.  Returns true if a quit message is sent.
	if (MsgLoop()) 
	{
		TRACE("Returning without computing!\n");
		m_bComputing = FALSE;
		m_bComputed = FALSE;
		return;
	}
	
	ByteCodeProgram Program;
	
	if(m_pBitmap!=NULL)
	{   
		TRACE("Deleting old bitmap.\n");
		delete m_pBitmap;	
	}
	m_pBitmap = new CBitmap;
	if(!(m_pBitmap->CreateCompatibleBitmap(pDC, m_nWWidth, m_nWHeight)))
		{
			TRACE("** Couldn't create bitmap!");
			AfxThrowUserException();
		}
	ASSERT_VALID(m_pBitmap);
	ASSERT_VALID(pDC);
	
	m_pOldBitmap = pMemDC->SelectObject(m_pBitmap);
	ASSERT_VALID(pMemDC);
	ASSERT_VALID(pDC);
	
	m_nWidth = m_nWWidth;
	m_nHeight = m_nWHeight;
	Program.Load(m_pOrganism->GetGenome());

	// draw pixels...
	TRACE("Dimensions: w: %d, h: %d\n", m_nWidth, m_nHeight);
	TRACE("Doing %d, %d...", m_nRow, m_nColumn);
	BeginWaitCursor();
	TRACE("Compiled version...\n");
	clock_t start, finish;
	long duration;
	start = clock();
	Program.Run(0, 0, m_nWidth, m_nHeight, pDC, pMemDC, this);
	
	finish = clock();
	duration = finish - start;
	TRACE("Compiled version in %d milliseconds.\n", duration);
	
	if(show_interpreted)
	{
		start = clock();
		for (long x = 0; x < m_nWidth; x++)
		{	
			long sx = lScale(x, m_nWidth);
			for (long y = 0; y < m_nHeight; y++)
			{
				long sy = lScale(y, m_nHeight);
				long nPalIndex = m_pOrganism->Eval(sx, sy, m_pBitmap);
				// long nPalIndex = Program.Run(sx, sy);
				long ScaledPI = lScale(nPalIndex, lResultMax, nPalSize);
				// long ScaledPI = nPalIndex%nPalSize;
				COLORREF nPalRes = PALETTEINDEX((WORD)ScaledPI);
				pMemDC->SetPixel(int(x), int(y), nPalRes);
			}
			// show line-by-line progress.
			ShowRegion(pDC, pMemDC, int(x), 0, 1, m_nHeight, m_nWWidth, m_nWHeight);	
		}
		finish = clock();
		char buffer[50];
		sprintf(buffer, "comp: %ld", duration);
		pDC->TextOut(5, 5, buffer, strlen(buffer));
		sprintf(buffer, "inte:   %ld", finish - start);
		pDC->TextOut(5, 25, buffer, strlen(buffer));
	}

	// AfxMessageBox(buffer);
	// TRACE("Time for interpreted version: %ld\n", finish - start);
	EndWaitCursor();
	ASSERT_VALID(pMemDC);
	TRACE("done.\n");
	
	m_bComputing = FALSE;
	m_bComputed = TRUE;
}

BOOL CImView::MsgLoop ()
{
	// process pending Windows messages.
	// This code modified from the MFC FAQ, q. 24
	MSG msg;
	while (::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
	{
		TRACE("Got a message: %d\n", msg.message);
		if (msg.message == WM_PAINT)
		{
			// normal, just return.
			return FALSE;
		} 
		if (msg.message == WM_QUIT)
		{
			m_bComputing = FALSE;
			::PostQuitMessage(msg.wParam);
			return TRUE;
		}
		if (!AfxGetApp()->PreTranslateMessage(&msg))
		{
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}
	}
	TRACE("Idling.\n");
	AfxGetApp()->OnIdle(0);
	AfxGetApp()->OnIdle(1);
	return FALSE;
}

void CImView::OnActivateView(BOOL bActivate, CView*, CView*)
{
	ShowActive(bActivate);
	m_bActive = bActivate;
}

void CImView::ShowActive(BOOL bActivate)
{
	// draw or undraw a rectangle.
	// TRACE("Showing active %d: %d clicks.\n", bActivate, m_nClicks);
	if ((m_nWWidth==0)||(m_nWHeight==0)) return;
	
	CImFrame* pFrame = (CImFrame*)GetParentFrame();
	ASSERT(pFrame);
	
	int nColors = pFrame->GetColors();
	COLORREF newColor;
	if (bActivate) 
	{
		newColor = PALETTEINDEX(m_nClicks%nColors);
	}
	else
	{
		newColor = RGB(255,255,255);
	}
	
	CRect clientRect;
	GetClientRect(&clientRect);
	CBrush* pBrush = new CBrush(newColor);
	{
		TRACE("Creating client dc.\n");
		CDC* pDC = GetDC();
		ASSERT(pDC!=NULL);
		ASSERT_VALID(pDC);
		pDC->FrameRect(clientRect,pBrush);
		ReleaseDC(pDC);
	}
	delete pBrush;
}

/////////////////////////////////////////////////////////////////////////////
// CImView printing

BOOL CImView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CImView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CImView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CImView::OnPrint(CDC* pDC, CPrintInfo* pInfo)
{
	CPalette* pPal = GetPalette();
	HPALETTE hOrigPal = (HPALETTE)(pPal->m_hObject);
	HBITMAP hBmp = (HBITMAP)(m_pBitmap->m_hObject);
	HDC hDC = pDC->m_hDC;
	CRect rect = pInfo->m_rectDraw;
	HANDLE hDib = DibFromBitmap(hBmp, hOrigPal, BI_RGB, 0);
	
	if(!hDib)
	{
		TRACE("Couldn't create DIB\n");
		return;
	}
	
	// print the image in the middle of the page.
	int l = rect.left;
	int r = rect.right;
	int b = rect.bottom;
	int t = rect.top;
	
	int il = (r-l)/4;
	int ir = (3*(r-l))/4;
	int it = (b-t)/4;
	int ib = (3*(b-t))/4;          

	InstallPalette(pDC);
	PrintDIB(hDC, hDib, il, it, (ir-il), (ib-it));
	return;
	
}





/////////////////////////////////////////////////////////////////////////////
// CImView diagnostics

#ifdef _DEBUG
void CImView::AssertValid() const
{
	CView::AssertValid();
}

void CImView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CImDoc* CImView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CImDoc)));
	return (CImDoc*) m_pDocument;
}

#endif //_DEBUG

CPalette* CImView::GetPalette()
{
	CImFrame* pFrame = (CImFrame*)GetParentFrame();
	ASSERT(pFrame->IsKindOf(RUNTIME_CLASS(CImFrame)));
	return pFrame->GetPalette();
}	

/////////////////////////////////////////////////////////////////////////////
// CImView message handlers

void CImView::OnUpdate(CView*, LPARAM, CObject*)
{   
	m_bComputed = FALSE;
	Invalidate();
}

void CImView::OnSize(UINT nType, int cx, int cy)
{
	TRACE("CImView::OnSize:  Setting size: h = %d, w = %d\n", cy, cx);
	
	CView::OnSize(nType, cx, cy);
	
	SetWHeight(cy);
	SetWWidth(cx);
	// \\ could just StretchBlt bitmaps.  It would be much faster, but uglier.
	// m_bComputed = FALSE;
	// Invalidate();
	
}


void CImView::OnRButtonDown(UINT nFlags, CPoint point)
{   
	char *lpcFormula = m_pOrganism->PrintToString();
	CString sFormula = CString((const char*)lpcFormula);
	CImOrgDescDlg dlg;
	// init dialog data
	dlg.m_sFormula = sFormula;
	dlg.m_lComplexity = m_pOrganism->Complexity();
	dlg.m_nFitness = m_pOrganism->GetFitness();
	
	dlg.DoModal();
	
	CView::OnRButtonDown(nFlags, point);
	
	delete[] lpcFormula;
}

void CImView::OnLButtonDown(UINT nFlags, CPoint point)
{
	m_pOrganism->SetFitness(++m_nClicks);
	
	CView::OnLButtonDown(nFlags, point);
}

void CImView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	m_nClicks+=2;
	m_pOrganism->SetFitness(m_nClicks);
	
	CView::OnLButtonDblClk(nFlags, point);
}

static int count = 0;
static const LPCSTR bmp_filter = "Bitmap files (*.bmp) | *.bmp | All files (*.*) | *.* ||";

void CImView::OnSaveasBmp()
{
	// Save current image as a .BMP file
	
	// find empty file
	struct _stat buf;
	char fbuf[10];
	char fbuf2[15];
	for(int count = 0; count<100; count++)
	{
		sprintf(fbuf, "IMOGE%d", count);
		sprintf(fbuf2, "%s.BMP", fbuf);
		if(_stat(fbuf2, &buf)==-1) // file not found, count OK
			break;
	}	
	
	// Present the default information & get file name
	CFileDialog dlg(FALSE, "BMP", fbuf, OFN_HIDEREADONLY, bmp_filter);
	
	if(dlg.DoModal()==IDOK)
	{
		// save the image.
		CString sPath = dlg.GetPathName();
		BOOL bSaved = SaveBMPFile((HBITMAP)(m_pBitmap->m_hObject), sPath, 
									GetPalette());
		m_sLastFile = CString(sPath);
		ASSERT(bSaved);
	}
}

static const int wp_flags = OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_PATHMUSTEXIST; 

void CImView::OnFileSetwallpaper()
{
	CFileDialog dlg(TRUE, "BMP", m_sLastFile, wp_flags, bmp_filter);
	
	if(dlg.DoModal()==IDOK)
	{
		CString sPath = dlg.GetPathName();
		SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, (void *)((LPCSTR)sPath), 
							 SPIF_UPDATEINIFILE);
	} 
	
}
