// IMSAVE2: Saving images.
// 			Based on capture2.c in Ezzell, "Windows 3.1 Graphics Programming"
// Copyright 1993 by Harley Davis

// This code is not used.  See IMSAVE.CPP.

#include "stdafx.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <direct.h>
#include <showdib.h>

// static   char     szFName[64];
// HANDLE            hInst;
BITMAPFILEHEADER  bmFH;
BITMAPINFOHEADER  bmIH;
BITMAPINFO        bmInfo;

int ErrorMsg( HWND hwnd, char *Error )
{
	MessageBox( hwnd, Error, "Warning",
					MB_ICONASTERISK | MB_OK );
	return(0);
}

int SaveBMPFile( HWND hwnd, const char* szFName, int Width, int Height, CPalette* pPal, int CRes )
{
	HDC     	  hdc, hdcMem;
	HANDLE   	  hMem;
	HBITMAP  	  hBitmap;
	// HPALETTE      hPal;
	HGLOBAL		  ghPal;
	HPALETTE	  hOrigPal = (HPALETTE)(pPal->m_hObject);
	LPLOGPALETTE  lp;
	FILE     	  *Bf;
	LPSTR    	  lpBits;
	DWORD		  ImgSize, plSize;
	BYTE     	  RVal, GVal, BVal;
    int   i, j, LnWidth, LnPad = 0;
    
    TRACE("Saving file '%s' (%d, %d) w/%d colors.\n", szFName, Width, Height, CRes);
    
    ASSERT((CRes==16)||(CRes==256));

	if( ( Bf = fopen( szFName, "wt" ) ) == NULL )
		return( ErrorMsg( hwnd, "Can't open file" ) );
//=== get the palette information ========================
	hdc = GetDC( hwnd );
	// CRes = GetDeviceCaps( hdc, SIZEPALETTE );
	if( CRes == 16 )
	{
		bmIH.biBitCount = 4;             // 2^4 colors = 16
		LnWidth = Width / 2;
	}
	else
	{
		bmIH.biBitCount = 8;             // 2^8 colors = 256
		LnWidth = Width;
	}
	if( LnWidth % sizeof( DWORD ) )
		LnPad = sizeof(DWORD) - ( LnWidth % sizeof(DWORD) );
					  // scan line width must be DWORD multiple
	ImgSize = (DWORD)( (DWORD)( LnWidth + LnPad ) *
							 (DWORD) Height );	// image size
	plSize = CRes * sizeof( RGBQUAD );		// palette size 
	TRACE("Image size: %ld; Pal Size: %ld\n", ImgSize, plSize);
	TRACE("Line width: %d, Line pad: %d\n", LnWidth, LnPad);
//=== initialize bitmap file header structure ============
	bmFH.bfType      = 0x4D42;             // Type is "BF"
	bmFH.bfReserved1 = 0L;
	bmFH.bfReserved2 = 0L;
	bmFH.bfOffBits   = plSize +            // bitmap offset
							 sizeof( BITMAPINFO ) +
							 sizeof( BITMAPFILEHEADER );
	bmFH.bfSize      = ImgSize +           // file size
							 bmFH.bfOffBits;
	fwrite( &bmFH, sizeof( bmFH ), 1, Bf );
												  // write file header
//=== initialize bitmap info header structure ============
	bmIH.biSize = (DWORD) sizeof( BITMAPINFOHEADER );
	bmIH.biWidth         = Width;
	bmIH.biHeight        = Height;
	bmIH.biPlanes        = 1;
	bmIH.biCompression   = BI_RGB;
	bmIH.biSizeImage     = 0L;
	bmIH.biXPelsPerMeter = 0L;
	bmIH.biYPelsPerMeter = 0L;
	bmIH.biClrUsed       = 0L;
	bmIH.biClrImportant  = 0L;
	fwrite( &bmIH, sizeof( bmIH ), 1, Bf );
												  // write info header
	//=== add the palette color information ==================
	DWORD lPalSize = sizeof(LOGPALETTE) + (CRes * sizeof(PALETTEENTRY));
	ghPal = GlobalAlloc(GHND, lPalSize);
	lp = (LPLOGPALETTE) GlobalLock( ghPal );
	lp->palNumEntries = CRes;
	lp->palVersion    = 0x0300;

	int nEntries = GetPaletteEntries( hOrigPal, 0, CRes, lp->palPalEntry );
	ASSERT(nEntries==CRes);
								// and get the palette information
//========= Structure definitions ========================
//    Palette Entry          RGB Quad for Bitmap
//
//		typedef struct {       typedef struct tagRGBQUAD {
//			BYTE  peRed;           BYTE  rgbBlue;
//			BYTE  peGreen;         BYTE  rgbGreen;
//			BYTE  peBlue;          BYTE  rgbRed;
//			BYTE  peFlags;         BYTE  rgbReserved;
//		} PALETTEENTRY;        } RGBQUAD;
//
//========================================================
			// record each PALETTEENTRY as RGBQUAD format
		for( i=0; i<CRes; i++ )
		{
			RVal = lp->palPalEntry[i].peRed;
			GVal = lp->palPalEntry[i].peGreen;
			BVal = lp->palPalEntry[i].peBlue;
			TRACE("Palette #%d: %d, %d, %d\n", i, (int)RVal, (int)GVal, (int)BVal);
			fputc( BVal, Bf );  		 // put blue first,
			fputc( GVal, Bf ); 			 // green second,
			fputc( RVal, Bf ); 			 // red third,
			fputc( 0x00, Bf ); 			 // and null last
		}
		GlobalUnlock( ghPal );     // don't forget to unlock
		GlobalFree( ghPal );       // and release the memory

//=== now store the actual image information =============
	if( CRes == 16 )                 // for 16-color image
	{                                // write image bits
		for( i=Height-1; i>=0; i-- )
		{
			for( j=0; j<Width; j+=2 )
			{
				COLORREF pix1 = GetPixel(hdc, j,   i);
				COLORREF pix2 = GetPixel(hdc, j+1, i);
				fputc((int)((pix1 << 4) + pix2), Bf);
			}
			for(j=0; j<LnPad; j++) fputc(0x00, Bf);
	}  }
	else                             // for 256-color image
	{											// create bitmap image
		// hdcMem = CreateCompatibleDC(hdc);
		hBitmap = CreateCompatibleBitmap(hdc, Width, 1);
		if(hBitmap)
		{
			hMem = GlobalAlloc(GHND, Width);
			lpBits = (char*)GlobalLock(hMem);
			// SelectObject(hdcMem, hBitmap);
			for(i=Height-1; i>=0; i--)
			{
				// BitBlt(hdcMem, 0, 0, Width, 1, hdc, 0, i, SRCCOPY);
				GetDIBits(hdc, hBitmap, i, 1, lpBits, &bmInfo, DIB_PAL_COLORS);
				for(j=0; j<LnWidth; j++)
					fputc(lpBits[j], Bf);
				for(j=0; j<LnPad;   j++)
					fputc(0x00, Bf );
			}
			GlobalUnlock(hMem);   	// again, unlock memory
			GlobalFree(hMem);     	// and release to heap
		}
		// DeleteDC(hdcMem);        	// delete memory context
		ReleaseDC(hwnd, hdc);    	// release device context
	}
	fclose(Bf);                 	// and close the file ...
	return(0);
}


