// imdoc.h : interface of the CImDoc class
//
/////////////////////////////////////////////////////////////////////////////

class CImDoc : public CDocument
{
protected: // create from serialization only
	CImDoc();
	DECLARE_DYNCREATE(CImDoc)

// Attributes
protected:
	int m_nGeneration;			// Generation number
	CImEvolution* m_pEvolution;	// an evolution

// Operations
public:

// Implementation
public:
	virtual ~CImDoc();
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif
protected:
	virtual	BOOL	OnNewDocument();
	void UpdateGeneration(int nGeneration = -1);

// Generated message map functions
protected:
	//{{AFX_MSG(CImDoc)
	afx_msg void OnNewGeneration();
	afx_msg void OnSetParameters();
	afx_msg void OnRndGeneration();
	afx_msg void OnShowGen();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
