AutoScrollingView subclass: #TreeBrowserView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TBrowser'!


!TreeBrowserView methodsFor: 'displaying'!

displayOn: gc 
	gc clear.
	model displayOn: gc offset: scrollOffset value! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

TreeBrowserView class
	instanceVariableNames: ''!


!TreeBrowserView class methodsFor: 'creation'!

openOn: aTree 
	^self openOn: aTree withLabel: 'Hierarchy Browser'.!

openOn: aTree withLabel: aString
	| top tree view scroller resolutionRequired extraSpaceInX extraSpaceInY valueHolder |
	top := TreeBrowserWindow new.
	top model: aTree.

	view := DependentComposite new.
	top component: view.
	tree := self new model: aTree.
	resolutionRequired := aTree limits.
	scroller := SimpleScrollWrapper on: tree.
	top scroller: scroller.
	((extraSpaceInX :=  resolutionRequired x - self size x) > 0) ifFalse: [extraSpaceInX := 0].
	((extraSpaceInY :=  resolutionRequired y - self size y) > 0) ifFalse: [extraSpaceInY := 0].
	valueHolder := (ValueHolder with: (0@0 corner: extraSpaceInX @ extraSpaceInY)).
	top extraSpaceRequired: resolutionRequired.
	scroller setScrollRegion: valueHolder.
	view add: (LookPreferences edgeDecorator onScroller: scroller) noMenuBar useHorizontalScrollBar in: (0 @ 0 corner: 1 @ 1).
	top openWithExtent: self size.
	top label: aString.
	^top.! !

!TreeBrowserView class methodsFor: 'class constants'!

size
	"This is the size of the initial window."
	^600 @  600.! !

ScrollWrapper subclass: #SimpleScrollWrapper
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TBrowser'!
SimpleScrollWrapper comment:
'SlaveScrollWrapper implements ScollWrapper without redisplay optimization.'!


!SimpleScrollWrapper methodsFor: 'private - scrolling'!

scrollHorizontallyBy: widthToMove on: aGraphicsContext grid: grid
	"Scroll the receiver by width modulo the grid."

	| clippingBox |
	clippingBox := self clippingBounds intersect: aGraphicsContext clippingBounds.
	self redisplayRectangle: clippingBox on: aGraphicsContext!

scrollVerticallyBy: heightToMove on: aGraphicsContext grid: grid
	"Scroll the receiver by width modulo the grid."

	| clippingBox |
	clippingBox := self clippingBounds intersect: aGraphicsContext clippingBounds.
	self redisplayRectangle: clippingBox on: aGraphicsContext! !

!SimpleScrollWrapper methodsFor: 'scrolling'!

setScrollRegion: aPoint
	"This updates the extra space associated with the scroll bars in order that
	we can ensure that we have enough space for the display of the whole tree"
	^self origin extraSpace: aPoint.! !

!SimpleScrollWrapper methodsFor: 'accessing'!

origin
	"Returns the origin instance variable that is to be used to compute the extra
	space associated with the display of the tree."
	^origin.! !

ScheduledWindow subclass: #TreeBrowserWindow
	instanceVariableNames: 'scroller extraSpaceRequired '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TBrowser'!


!TreeBrowserWindow methodsFor: 'event processing'!

processEvent: anEvent
	"Dispatch the event to the appropriate method."

	super processEvent: anEvent.
	anEvent key == #resize ifTrue: [
		self scroller setScrollRegion:  (ValueHolder with: (0@0 corner: extraSpaceRequired))
	].! !

!TreeBrowserWindow methodsFor: 'accessing'!

extraSpaceRequired
	"Returns the extra space required instance variable associated with the window"
	^extraSpaceRequired.!

extraSpaceRequired: aPoint
	"Sets the extra space required instance variable associated with the window"
	^extraSpaceRequired := aPoint.!

scroller
	"Returns the ScrollValueHolder instance associated with the window"
	^scroller.!

scroller: aValueHolder
	"Sets the ScrollValueHolder instance associated with the window"
	^scroller := aValueHolder.! !

Model subclass: #TreeBrowser
	instanceVariableNames: 'label sons x y labelText labelWidth width depth '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TBrowser'!


!TreeBrowser methodsFor: 'access'!

addSon: aSon
	sons add: aSon!

depth
	^depth!

depth: anInteger
	^depth := anInteger.!

label: l 
	sons := OrderedCollection new.
	label := l.
	(l isKindOf: String) ifTrue: [
		labelText := ComposedText withText: (Text fromString: l)
				style: (TextAttributes styleNamed: #systemDefault).
	]
	ifFalse: [
		labelText := ComposedText withText: (Text fromString: l printString)
				style: (TextAttributes styleNamed: #systemDefault).
	].
	labelWidth := labelText asParagraph width!

labelWidth
	^labelWidth!

labelWidth: anInteger
	^labelWidth := anInteger.!

limits
	"This method computes the limits required to display the tree"

	| maxX maxY maxLimits |
	maxX := self x.
	maxY := self y.
	sons do: [ :son |
		maxLimits := son limits.
		maxLimits x > maxX ifTrue: [ maxX := maxLimits x].
		maxLimits y > maxY ifTrue: [ maxY := maxLimits y].
	].
	^maxX @ maxY.!

width
	^width!

width: anInteger
	^width := anInteger.!

x
	^x!

y
	^y! !

!TreeBrowser methodsFor: 'exploration'!

computeTree: anObject

	"This method computes the width and depth of the tree and forms the

	basis by which the screen positions are calculated."
	|  son |
	depth := 1.
	width := 0.


	(anObject respondsTo: #functor) ifTrue: [
		self label: anObject functor.
		(anObject respondsTo: #arguments) ifTrue: [		
			anObject arguments do: [:child | 
				son := TreeBrowser new.
				son computeTree: child.
				width := width + son width.
				(depth < (son depth + 1)) ifTrue: [depth := son depth + 1].
				self addSon: son.
			]
		].
	]
	ifFalse: [ self label: anObject].
	width = 0 ifTrue: [width := 1].!

x: x1 y: y1 
	| z myOffset |
	x := x1.
	y := width * 5 + y1.
	z := y1.
	myOffset := (labelWidth * 1.1) rounded max: 100.
	sons
		do: 
			[:son | 
			son x: x + myOffset y: z.
			z := z + (son width * 10)]! !

!TreeBrowser methodsFor: 'displaying'!

displayOn: gc
	"This displays the tree on a Graphics context"
	self displayOn: gc offset: Point zero.!

displayOn: gc offset: offset 

	| myOffset |
	labelText displayOn: gc at: x @ y + offset.
	myOffset := (labelWidth * 1.1) rounded max: 100.
	sons
		do: 
			[:son | 
			gc displayLineFrom: x + labelWidth + 2 @ (y + 8) + offset to: x + myOffset - 2 @ (son y + 8) + offset.
			son displayOn: gc offset: offset].! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

TreeBrowser class
	instanceVariableNames: ''!


!TreeBrowser class methodsFor: 'creation'!

label: l
	^super new label: l!

newOn: anObject
	^(self label: 'root')
		computeTree: anObject;
		x: 0
		y: 0.!

openOn: anObject
	self openOn: anObject withLabel: 'Hierarchy Browser'.!

openOn: anObject withLabel: aString
	| view |
	view := TreeBrowserView openOn: (self newOn: anObject) withLabel: aString.
	^view.! !
