ControllerWithMenu subclass: #GeneticChartController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticChartController methodsFor: 'initialization'!

initialize
	"This initializes the controller"
	super initialize.
	self menuHolder value: self pullDownMenu.! !

!GeneticChartController methodsFor: 'menu specification'!

pullDownMenu
	"This specifies the structure of the menu"
	| mb |
	mb := MenuBuilder new.
	mb beginSubMenuLabeled: 'Mean'.
		mb add: 'Fitness'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 2) type: 1].
		mb add: 'Raw Fitness'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 3) type: 1].
		mb add: 'Program Depth'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 5) type: 1].
		mb add: 'Program Size'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 6) type: 1].
	mb endSubMenu.
	mb beginSubMenuLabeled: 'Variance'.
		mb add: 'Fitness'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 2) type: 2].
		mb add: 'Raw Fitness'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 3) type: 2].
		mb add: 'Program Depth'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 5) type: 2].
		mb add: 'Program Size'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 6) type: 2].
	mb endSubMenu.
	mb beginSubMenuLabeled: 'Bounds'.
		mb add: 'Minimum Raw Fitness'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 4) type: 1].
		mb add: 'Maximum Raw Fitness'->[:obj | view chartedSymbol: (GeneticStatistics statisticsStored at: 4) type: 2].
	mb endSubMenu.
	mb line.
	mb add: 'Hardcopy'->#hardcopy.
	^mb menu.! !

ControllerWithMenu subclass: #GeneticAntAnimationController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticAntAnimationController methodsFor: 'menu specification'!

pullDownMenu
	"This specifies the structure of the menu"
	| mb |
	mb := MenuBuilder new.
	mb	add: 'Animate'->#animate; 
		add: 'Reset'->#reset; 
		line;
		add: 'Hardcopy'->#hardcopy.
	^mb menu.! !

!GeneticAntAnimationController methodsFor: 'initialization'!

initialize
	"This initializes the controller"
	super initialize.
	self menuHolder value: self pullDownMenu.! !

AutoScrollingView subclass: #GeneticProgramView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticProgramView methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This ensures that the current model is updated and redisplayed"

	aSymbol == #output ifTrue: [
		self updateModel: anObject.
	].!

updateModel: anObject 
	"This ensures that the current model is updated"

	| aTree |
	aTree := TreeBrowser newOn: anObject object.
	self model: aTree.
	scrollOffset value: Point zero.
	scrollOffset extraSpace: (Point zero corner: (aTree limits max: Screen default bounds corner)) asValue.
	self invalidate.! !

!GeneticProgramView methodsFor: 'displaying'!

displayOn: aGC
	"This displays the model on the viewPane of the GeneticProgramViewer"
	aGC clear.
	self model displayOn: aGC! !

!GeneticProgramView methodsFor: 'bounds'!

limits
	"A program may be bigger than than the page. Hence we
	need to calculate a size in order to have the scaling computed
	correctly"
	^self model limits.! !

View subclass: #GeneticAntAnimationView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticAntAnimationView methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This allows us to deal with trail-specific animation"

	aSymbol == #output ifTrue: [self invalidate].
	aSymbol == #trail ifTrue: [self updateTrail. aSender continue].
	aSymbol == #position ifTrue: [self updatePosition. aSender continue].! !

!GeneticAntAnimationView methodsFor: 'displaying'!

displayOn: aGC
	"This displays the model on the viewPane of the GeneticAntAnimationView"
	aGC clear.
	self model displayOn: aGC.! !

!GeneticAntAnimationView methodsFor: 'animation'!

updatePosition	
	"This causes the ant's position on the board to be updated"
	self model displayAntOn: self graphicsContext.!

updateTrail
	"This causes the ant's trail on the board to be updated"
	self model displayTrailOn: self graphicsContext at: self model position.! !

!GeneticAntAnimationView methodsFor: 'bounds'!

limits
	"Answer the size of an A4 page in landscape" 
	^792@612.! !

ApplicationModel subclass: #GASTEUI
	instanceVariableNames: 'dialog experiment isFinished '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!
GASTEUI comment:
'This is a meta class and is used as a repository for behaviour common

to all elements of the GASTE UI.



Instance variable	Meaning

==============	=======

application		An instance of GeneticProgramming.'!


!GASTEUI methodsFor: 'accessing'!

dialog
	"This returns the instance variable"

	^dialog.!

dialog: anApplicationModel
	"This sets the instance variable"

	^dialog := anApplicationModel.!

experiment
	"This returns the instance variable"

	^experiment.!

experiment: aGeneticAlgorithm
	"This sets the instance variable, and ensures that I am a dependent 
	of it."

	self experiment isNil ifFalse: [self experiment removeDependent: self].
	aGeneticAlgorithm addDependent: self.
	^experiment := aGeneticAlgorithm.!

isFinished
	"This returns the instance variable"
	^isFinished.!

isFinished: aBoolean
	"This sets the instance variable"
	^isFinished := aBoolean.!

value
	"This is required for modal dialogs"
	^self isFinished.! !

!GASTEUI methodsFor: 'testing'!

isQueuedObject: anObject
	"Catch all, do nothing"! !

!GASTEUI methodsFor: 'updating'!

changeRequest
	"Say that it's okay to close"
	self isFinished ifFalse: [self clickedClose].
	^self isFinished: true.!

isNormalCursor
	"This changes the cursor to its normal shape"
	Cursor currentCursor: Cursor normal.!

isWaitCursor
	"This changes the cursor to its wait shape"
	Cursor currentCursor: Cursor wait.!

update: aSymbol with: anObject from: aSender
	"This processes update messages which are received from the
	current experiment."

	"Make sure other messages are processed correctly"
	super update: aSymbol with: anObject from: aSender.

	"Experiment has changed, so all browsers should now be dependents of this object"
	aSymbol == #experiment
		ifTrue: [self experiment: anObject].

	(self myDependents respondsTo: #do:)
		ifTrue: [self myDependents do: [:anObj | anObj update: aSymbol with: anObject from: aSender]]
		ifFalse: [self myDependents update: aSymbol with: anObject from: aSender].! !

!GASTEUI methodsFor: 'actions'!

clickedClose
	"This ensures that the dialog now terminates"
	self isFinished: true.
	self dialog removeDependent: self.
	self experiment removeDependent: self.
	self experiment population isNil ifFalse: [
		self experiment population statisticalMeasures removeDependent: self
	].
	self closeRequest.! !

!GASTEUI methodsFor: 'initialization'!

initialize
	"This sets the isFinished flag"
	self isFinished: false.
	self experiment: (GeneticProgramming new).!

initializeAll
	"This initializes the object and environment lists, and their selections."
	self initializeLists.
	self initializeSelections.!

initializeDialogAndExperiment: aGASTEUI
	"This stores away experiment and dialog information"
	self dialog: aGASTEUI.
	self experiment: aGASTEUI experiment.!

initializeLists
	"This initializes the object class and environment lists"

	self objectClassListHolder list: (GeneticProgram allSubclasses asOrderedCollection collect: [:aclass | aclass name]).
	self environmentListHolder list: (GeneticEnvironment allSubclasses asOrderedCollection collect: [:aclass | aclass name]).!

initializeSelections
	"This initializes the object class and environment selections"

	self objectClassListHolder selection: self dialog objectClass.
	self environmentListHolder selection: self dialog environmentClass.! !

!GASTEUI methodsFor: 'class list'!

selectedClass: aSymbol
	"This returns a class (or nil) given a symbol"

	aSymbol isNil ifTrue: [^nil].
	^Smalltalk at: aSymbol asSymbol ifAbsent: [nil].! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTEUI class
	instanceVariableNames: ''!


!GASTEUI class methodsFor: 'interface opening'!

openDialogWith: aGASTEUI

	"This opens a dialog interface with an instance to a GeneticAlgorithm"

	| aNewGASTEUI aBuilder |
	aNewGASTEUI := self new.
	aNewGASTEUI initializeDialogAndExperiment: aGASTEUI.
	aBuilder := aNewGASTEUI allButOpenInterface: #windowSpec.
	aNewGASTEUI builder: aBuilder.

	aGASTEUI addDependent: aNewGASTEUI.
	aBuilder openDialog.
	^aNewGASTEUI.!

openWith: aGASTEUI
	"This opens the interface with an instance to a GeneticAlgorithm"

	| aNewGASTEUI |
	aNewGASTEUI := self new.
	aNewGASTEUI initializeDialogAndExperiment: aGASTEUI.
	self openOn: aNewGASTEUI.
	aGASTEUI addDependent: aNewGASTEUI.
	^aNewGASTEUI.! !

GASTEUI subclass: #GASTEClassDefinitionDialog
	instanceVariableNames: 'classNameHolder classListHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEClassDefinitionDialog methodsFor: 'aspects'!

classListHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^classListHolder isNil ifTrue: [classListHolder := SelectionInList new] ifFalse: [classListHolder]!

classNameHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^classNameHolder isNil ifTrue: [classNameHolder := String new asValue] ifFalse: [classNameHolder]! !

!GASTEClassDefinitionDialog methodsFor: 'accessing'!

className
	"This returns the class name entered"
	^self classNameHolder value!

subclassName
	"This returns the parent class name selected"
	^self classListHolder selection.! !

!GASTEClassDefinitionDialog methodsFor: 'closing'!

changeRequest
	"This asks the user to confirm illegal data fields, if they exist"

	self className isEmpty ifTrue: [^self isFinished: (Dialog confirm: 'A class name has not been provided.\Continue anyway?' withCRs)].
	self subclassName isNil ifTrue: [^self isFinished: (Dialog confirm: 'A parent class name has not been selected.\Continue anyway?' withCRs)].
	^self isFinished: true.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTEClassDefinitionDialog class
	instanceVariableNames: ''!


!GASTEClassDefinitionDialog class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'Class Definition' #min: #(#Point 289 248 ) #max: #(#Point 289 248 ) #bounds: #(#Rectangle 316 128 605 376 ) ) #component: #(#SpecCollection #collection: #(#(#InputFieldSpec #layout: #(#Rectangle 102 20 270 48 ) #name: #className #model: #classNameHolder ) #(#SequenceViewSpec #layout: #(#Rectangle 22 77 271 193 ) #name: #classList #model: #classListHolder ) #(#LabelSpec #layout: #(#Point 19 54 ) #label: 'Subclass of' ) #(#LabelSpec #layout: #(#Point 21 23 ) #label: 'Class name:' ) #(#ActionButtonSpec #layout: #(#Rectangle 108 206 163 236 ) #model: #clickedClose #label: 'Close' #defaultable: true ) ) ) )! !

GASTEClassDefinitionDialog subclass: #GASTEEnvironmentDefinitionDialog
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEEnvironmentDefinitionDialog methodsFor: 'initialization'!

postBuildWith: aBuilder
	"This ensures the selection is set up correctly"
	self classListHolder selection: self dialog environmentClass.!

preBuildWith: aBuilder
	"This initializes the list widget"
	| aCollection |
	aCollection := GeneticEnvironment allSubclasses asOrderedCollection collect: [:aclass | aclass name].
	aCollection add: GeneticEnvironment name.
	self classListHolder list: aCollection.! !

GASTEClassDefinitionDialog subclass: #GASTEObjectClassDefinitionDialog
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEObjectClassDefinitionDialog methodsFor: 'initialization'!

postBuildWith: aBuilder
	"This ensures the selection is set up correctly"
	self classListHolder selection: self dialog objectClass.!

preBuildWith: aBuilder
	"This initializes the object class"
	| aCollection |
	aCollection := GeneticProgram allSubclasses asOrderedCollection collect: [:aclass | aclass name].
	aCollection add: GeneticProgram name.
	self classListHolder list: aCollection.! !

GASTEUI subclass: #GeneticPopulationInspector
	instanceVariableNames: 'populationListHolder viewPane '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticPopulationInspector methodsFor: 'aspects'!

populationListHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^populationListHolder isNil ifTrue: [populationListHolder := SelectionInList new] ifFalse: [populationListHolder]!

viewPane

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^viewPane.!

viewPane: aView

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^viewPane := aView.! !

!GeneticPopulationInspector methodsFor: 'updating'!

selectionChanged
	"This method is invoked when the user selectes a new member of the list"

	| index |

	index := self populationListHolder selectionIndex.
	index isZero ifFalse: [
		self viewPane updateModel: (self experiment population members at: index)
	].!

update: aSymbol with: anObject from: aSender
	"This allows us to update a couple of the fields on the viewer"
	super update: aSymbol with: anObject from: aSender.
	aSymbol == #output ifTrue: [

		self initializePopulationList.
		aSender continue.
	].! !

!GeneticPopulationInspector methodsFor: 'initialization'!

initialize
	"This initializes the instance of the Genetic Program viewer"
	super initialize.
	self viewPane: self viewAndModel.
	self addDependent: self viewPane.!

initializePopulationList
	"This initializes the list of population members"

	(self experiment isNil or: [self experiment population isNil]) ifFalse: [
		self populationListHolder list: (self experiment population members collect: [:obj | obj object printString]).

	].

	self populationListHolder selectionIndexHolder onChangeSend: #selectionChanged to: self.

	self populationListHolder selectionIndexHolder value: 1.!

postBuildWith: aBuilder
	"This updates the view, if possible"

	super postBuildWith: aBuilder.
	(self experiment isNil or: [self experiment population isNil or: [self experiment population fittestMember isNil]]) ifFalse: [

		self initializePopulationList.
	].! !

!GeneticPopulationInspector methodsFor: 'view definition'!

viewAndModel
	"This returns an initializing view and Model"
	| view controller |
	view := GeneticProgramView new.
	controller := (GeneticProgramController new) performer: self.
	view model: (TreeBrowser newOn: (GeneticProgramTerminal new: '')); controller: controller.
	^view.! !

!GeneticPopulationInspector methodsFor: 'private'!

getPopulation: aString
	"This actually retrieves the definition of the population from disk -- in BOSS format"
	| aStream obj aGP wantToContinue |
	aStream := BinaryObjectStorage onOld: (Filename named: aString) readStream.
	[Cursor read showWhile: [obj := aStream next]]
		valueNowOrOnUnwindDo: [aStream close].

	(obj isKindOf: GeneticPopulation)
		ifFalse: [Dialog warn: 'The file ', aString, ' does not contain a population of genetic programs.']
		ifTrue: [ 
			aGP := obj members at: 1.
			(aGP isKindOf: GeneticPopulationMember) ifFalse: [
				Dialog warn: 'The file ', aString, ' does not contain a population of genetic programs.'.
				^self.
			].

			wantToContinue := false.
			(aGP object class  = (self selectedClass: self experiment objectClass)) ifFalse: [
				(Dialog confirm: ('The population is of the class ', 
							aGP object class name, 
							' not ', 
							self experiment objectClass, 
							' as expected.\Do you want to continue?') withCRs) ifTrue: [
					wantToContinue := true.
				].
			]
			ifTrue: [wantToContinue := true].

			wantToContinue ifTrue: [
				self dialog checkChanged.
				self experiment removeDependent: self experiment population statisticalMeasures.
				self experiment objectClass: aGP object class name asSymbol.
				self experiment population sizeOfPopulation: obj members size.
				self experiment population: obj.
				self experiment addDependent: self experiment population statisticalMeasures.
				[self experiment updateDependents] fork.
			]
		].

	self experiment isChanged: false.!

getProgram: aString
	"This actually retrieves the definition of the program from disk -- in ASCII format"
	|  obj index |
	obj := (Filename named: aString) fileIn.

	(obj isKindOf: GeneticPopulationMember)
		ifFalse: [Dialog warn: 'The file ', aString, ' does not contain a member of a genetic program population.']
		ifTrue: [ 
			(obj object class = (self selectedClass: self experiment objectClass)) ifFalse: [
				Dialog warn: 'The file ', aString, ' contains a Genetic Program of class ', obj object class name, '.'.
				^self.
			].
			index := self populationListHolder selectionIndex.
			index isZero ifTrue: [^self].
			
			self experiment population members at: index put: obj.
			self experiment updateDependents.
		].

	self experiment isChanged: true.!

savePopulation: aString
	"This actually saves the definition of the population to disk -- in BOSS format"
	| aStream |
	aStream := BinaryObjectStorage onNew: (Filename named: aString) writeStream.
	[Cursor write showWhile: [aStream nextPut: self experiment population]]
		valueNowOrOnUnwindDo: [aStream close].!

saveSelected: aString
	"This actually saves the definition of a Genetic Program to disk -- in ASCII format"
	| aStream index |
	aStream := (Filename named: aString) writeStream.
	index := self populationListHolder selectionIndex.
	[Cursor write showWhile: [(self experiment population members at: index) storeOn: aStream]]
		valueNowOrOnUnwindDo: [aStream close].! !

!GeneticPopulationInspector methodsFor: 'menu processing'!

filePopulationAs

	"This stores a population on disk"
	| file fileChosen prompt dir canBeWritten |
	fileChosen := (GASTEFileListBrowser openDialogWith: self) fileChosen.
	fileChosen = '' ifFalse: [
		file := Filename named: fileChosen.
		dir := Filename named: file head.
		(dir exists and: [dir isWritable]) ifFalse: [
			Dialog warn: 'You do not have write access for directory: \' withCRs, dir asString.
		]
		ifTrue: [
			canBeWritten := true.
			file exists ifTrue: [
				file isWritable ifFalse: [
					canBeWritten := false.
					Dialog warn: 'You do not have write access for: \' withCRs,file asString.
				]
				ifTrue: [
					prompt := 'Do you want to overwrite: ', '\' withCRs, fileChosen, '?'.
					canBeWritten := Dialog confirm: prompt initialAnswer: false.
				]
			].
			canBeWritten ifTrue: [self savePopulation: fileChosen]
		]
	].!

fileSelectedAs

	"This stores a selected population member on disk"
	| file fileChosen prompt dir canBeWritten |
	self populationListHolder selectionIndex isZero ifTrue: [^self].
	fileChosen := (GASTEFileListBrowser openDialogWith: self) fileChosen.
	fileChosen = '' ifFalse: [
		file := Filename named: fileChosen.
		dir := Filename named: file head.
		(dir exists and: [dir isWritable]) ifFalse: [
			Dialog warn: 'You do not have write access for directory: \' withCRs, dir asString.
		]
		ifTrue: [
			canBeWritten := true.
			file exists ifTrue: [
				file isWritable ifFalse: [
					canBeWritten := false.
					Dialog warn: 'You do not have write access for: \' withCRs,file asString.
				]
				ifTrue: [
					prompt := 'Do you want to overwrite: ', '\' withCRs, fileChosen, '?'.
					canBeWritten := Dialog confirm: prompt initialAnswer: false.
				]
			].
			canBeWritten ifTrue: [self saveSelected: fileChosen]
		]
	].!

hardcopy
	"This creates a hard copy of whatever is on the view pane. This is currently a chart,
	a genetic program, or a picture of the ant trail."
	|  gc limits xScale yScale |

	Cursor write showWhile: [
		limits := self viewPane limits.
		gc := PSGraphicsContext fileName: 'gpeist.ps'.
		gc setLandscape.
		xScale  := ((gc medium height - (gc pageOffset x * 4))/ limits x) min: 1.0.
		yScale := ((gc medium width - (gc pageOffset y * 4)) / limits y) min: 1.0.
		gc putScale: (xScale @ yScale negated).
		gc putTranslation.
		gc setLimits: (limits * 2).
		self viewPane displayOn: gc.
		gc close.
		'gpeist.ps' asFilename printPSFile.
	].!

hardcopyOld
	"This creates a hard copy of whatever is in the DISPLAYED window"
	| document windowOrigin p1 p2 image |
	document := Document new.
	document setLandscape.
	document setBottomMargin: 0.5.
	document setTopMargin: 0.5.
	document setLeftMargin: 0.5.
	document setRightMargin: 0.5.
	document startParagraph.
	windowOrigin := self viewPane topComponent globalOrigin.
	p1 := windowOrigin + (self viewPane localPointToGlobal: self viewPane bounds origin).
	p2 := windowOrigin + (self viewPane localPointToGlobal: self viewPane bounds corner).
	image := Screen default completeContentsOfArea: (p1 corner: p2).
	document addImage: image.
	document close.
	document toPrinter.!

loadPopulation

	"This loads a population from disk"

	| file filename dir canBeRead directory prompt   |

	file := (GASTEFileListBrowser openDialogWith: self) fileChosen.
	file = '' ifFalse: [
		canBeRead := true.
		filename := Filename named: file.
		dir := filename head.
		directory := Filename named: dir.
		(directory exists and: [directory isReadable]) ifFalse: [
			prompt := 'You do not have read access for directory: \' withCRs, dir.
			Dialog warn: prompt.
			canBeRead := false.
		]
		ifTrue: [
			(filename exists and: [filename isReadable]) ifFalse: [
				prompt := 'You do not have read access for file: \' withCRs, filename asString.
				Dialog warn: prompt.
				canBeRead := false.
			]
		].
		canBeRead ifTrue: [self getPopulation: file]
	].!

loadProgram
	"This loads a program from disk"

	| file filename dir canBeRead directory prompt   |
	self populationListHolder selectionIndex isZero ifTrue: [^self].
	file := (GASTEFileListBrowser openDialogWith: self) fileChosen.
	file = '' ifFalse: [
		canBeRead := true.
		filename := Filename named: file.
		dir := filename head.
		directory := Filename named: dir.
		(directory exists and: [directory isReadable]) ifFalse: [
			prompt := 'You do not have read access for directory: \' withCRs, dir.
			Dialog warn: prompt.
			canBeRead := false.
		]
		ifTrue: [
			(filename exists and: [filename isReadable]) ifFalse: [
				prompt := 'You do not have read access for file: \' withCRs, filename asString.
				Dialog warn: prompt.
				canBeRead := false.
			]
		].
		canBeRead ifTrue: [self getProgram: file]
	].!

redisplay
	"This resets the display."
	self viewPane invalidate.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GeneticPopulationInspector class
	instanceVariableNames: ''!


!GeneticPopulationInspector class methodsFor: 'interface specs'!

windowSpec

	"UIPainter new openOnClass: self andSelector: #windowSpec"



	^#(#FullSpec #window: #(#WindowSpec #label: 'Population inspector' #min: #(#Point 50 50 ) #bounds: #(#Rectangle 166 93 735 528 ) ) #component: #(#SpecCollection #collection: #(#(#SequenceViewSpec #layout: #(#LayoutFrame 0 0.0175747 0 0.0643678 0 0.281195 0 0.97931 ) #name: #populationList #flags: 15 #model: #populationListHolder #menu: #populationInspectorMenu ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0175747 0 0.0206897 ) #label: 'Population' ) #(#ArbitraryComponentSpec #layout: #(#LayoutFrame 0 0.29877 0 0.0643678 0 0.980668 0 0.896552 ) #flags: 11 #component: #viewPane ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.29877 0 0.016092 ) #label: 'Genetic Program' ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.574692 0 0.921839 0 0.657293 0 0.97931 ) #model: #clickedClose #label: 'Close' #defaultable: true ) ) ) )! !

!GeneticPopulationInspector class methodsFor: 'resources'!

populationInspectorMenu
	"UIMenuEditor new openOnClass: self andSelector: #populationInspectorMenu"

	^#(#PopUpMenu #('Load' 'File' ) #() #(#(#PopUpMenu #('Population...' 'Program...' ) #() #(#loadPopulation #loadProgram ) ) #(#PopUpMenu #('Population as...' 'Selected as...' ) #() #(#filePopulationAs #fileSelectedAs ) ) ) ) decodeAsLiteralArray! !

GASTEUI subclass: #GASTE
	instanceVariableNames: 'fileNameHolder currentDirectoryHolder objectClass environmentClass progressSliderHolder runProcess statusTextHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTE methodsFor: 'parameters menu'!

editParameters

	"This opens the Parameters dialog for editing"

	GASTEParameters openWith: self.! !

!GASTE methodsFor: 'initialization'!

initialize
	"This initializes the instance after creation"

	super initialize.
	self experiment: GeneticProgramming new.!

postBuildWith: aBuilder
	"This sets up dependencies"
	self progressSliderHolder onChangeSend: #progressSliderChanged to: self.! !

!GASTE methodsFor: 'run menu'!

continueExperiment
	"This causes the current experiment to continue"

	self objectClass isNil 
		ifFalse: [	
			self isWaitCursor.
			self runProcess: ([self experiment continueExperiment] forkAt: Processor systemRockBottomPriority).
		]
		ifTrue: [self selectAClassWarning].!

runExperiment
	"This causes the current experiment to start"
	self objectClass isNil 
		ifFalse: [	
			self isWaitCursor.
			self runProcess: ([self experiment runExperiment] forkAt: Processor systemRockBottomPriority).
		]
		ifTrue: [self selectAClassWarning].!

stopExperiment
	"This causes the current experiment to stop. The associated process is terminated"
	self runProcess isNil 
		ifFalse: [	
			self isNormalCursor.
			self runProcess terminate.
			self runProcess: nil.
		]
		ifTrue: [Dialog warn: 'No active run.'].! !

!GASTE methodsFor: 'updating'!

clickedClose
	"This is invoked when the window closes"
	self checkChanged.
	super clickedClose.!

progressSliderChanged
	"This is invoked whenever the progress slider value changes"
	| percentage |
	percentage := (self experiment evaluations * 100.0 /  self experiment maxEvaluations) truncated.
	(percentage = self progressSliderHolder value) ifFalse: [self progressSliderHolder value: percentage].!

update: aSymbol with: anObject from: aSender
	"This processes update messages which are received from the
	current experiment."

	aSymbol == #endOfRun ifTrue: [
		self isNormalCursor.
		self runProcess: nil.
		aSender continue.
	].
	aSymbol == #status ifTrue: [
		self status: anObject.
	].
	aSymbol == #output ifTrue: [
		self progressSliderChanged.
		aSender continue.
	].! !

!GASTE methodsFor: 'private'!

checkChanged
	"This actually retrieves the definition of the experiment from disk"
	self isChanged ifTrue: [
		(Dialog confirm: 'The GP experiment is unsaved.\Do you wish to save it?' withCRs) ifTrue: [
			self isChanged: false.
			self saveExperiment.
		]
	].!

getExperiment
	"This actually retrieves the definition of the experiment from disk"
	| aStream objectFromFile oldStatistics |

	self checkChanged.
	aStream := (Filename named: (self fileNameHolder value)) readStream.
	[Cursor read showWhile: [objectFromFile := aStream fileIn]]
		valueNowOrOnUnwindDo: [aStream close].

	(objectFromFile isKindOf: GeneticProgramming) ifTrue: [
		oldStatistics := self experiment population statisticalMeasures.
		self experiment: objectFromFile.
		"Now set up the correct object and environment classes"
		self synchronizeClasses.
		self changed: #experiment with: self experiment.
		self experiment population resetStatistics: self experiment.
		oldStatistics changed: #newStatistics with: self experiment population statisticalMeasures.
		self isChanged: false.
		^true.
	]
	ifFalse: [
		Dialog warn: 'The file ', self fileNameHolder value, ' does not contain a Genetic Programming experiment.'.
		^false.
	].!

getPopulation
	"This actually retrieves the definition of the population from disk"
	| aStream |
	aStream := (Filename named: (self fileNameHolder value)) readStream.
	Cursor read showWhile: [self experiment population: aStream fileIn].
	aStream close.
	self isChanged: false.!

saveExperiment
	"This saves the definition of an experiment from to disk"
	| aStream |
	self checkChanged.
	aStream := (Filename named: (self fileNameHolder value)) writeStream.
	[Cursor write showWhile: [self experiment storeOn: aStream]]
		valueNowOrOnUnwindDo: [aStream close].
	self isChanged: false.!

selectAClassWarning
	"This just tells the user to select an object class before proceeding"
	^Dialog warn: 'An object class has not been selected.'.!

selectAnEnvironmentClassWarning
	"This just tells the user to select an environment class before proceeding"
	^Dialog warn: 'An environment class has not been selected.'.!

status: anObject
	"This causes updates to appear in the status window"
	self statusTextHolder value: (self statusTextHolder value, anObject printString, '\' withCRs).!

synchronizeClasses
	"This actually synchronizes the experiment and the object and environment classes"
	self objectClass: self experiment objectClass.
	self environmentClass: self experiment env.!

tidyUp
	"This just tidies up before ending the application"
	self isNormalCursor.
	self closeRequest.! !

!GASTE methodsFor: 'file menu'!

closeExperiment
	"This closes the definition of an experiment from disk"
	self checkChanged.
	self experiment: (GeneticProgramming new).
	self fileNameHolder value: 'Untitled'.!

newExperiment
	"This chucks the existing experiment and creates a new one."
	self closeExperiment.!

openExperiment
	"This obtains the definition of an experiment from disk"
	| file filename dir canBeRead directory prompt oldFilename oldDirname |

	file := (GASTEFileListBrowser openDialogWith: self) fileChosen.
	file = '' ifFalse: [
		canBeRead := true.
		filename := Filename named: file.
		dir := filename head.
		directory := Filename named: dir.
		(directory exists and: [directory isReadable]) ifFalse: [
			prompt := 'You do not have read access for directory: \' withCRs, dir.
			Dialog warn: prompt.
			canBeRead := false.
		]
		ifTrue: [
			(filename exists and: [filename isReadable]) ifFalse: [
				prompt := 'You do not have read access for file: \' withCRs, filename asString.
				Dialog warn: prompt.
				canBeRead := false.
			]
		].
		canBeRead ifTrue: [
			oldFilename := self fileNameHolder value.
			oldDirname := self currentDirectoryHolder value.
			self fileNameHolder value: filename tail.
			self currentDirectoryHolder value: dir.
			self getExperiment ifFalse: [
				self fileNameHolder value: oldFilename.
				self currentDirectoryHolder value: oldDirname.
			]
		]
	].!

quit
	"This just terminates the application"
	self runProcess isNil ifFalse: [
		(Dialog confirm: 'A run is in progress.\Do you still wish to quit?' withCRs) ifTrue: [
			self runProcess terminate.
			self isNormalCursor.
			self closeRequest.
		]
	]
	ifTrue: [
		self isNormalCursor.
		self closeRequest.
	]!

saveAsExperiment
	"This saves the definition of an experiment to disk"
	| file fileChosen prompt dir canBeWritten |
	fileChosen := (GASTEFileListBrowser openDialogWith: self) fileChosen.
	fileChosen = '' ifFalse: [
		file := Filename named: fileChosen.
		dir := Filename named: file head.
		(dir exists and: [dir isWritable]) ifFalse: [
			Dialog warn: 'You do not have write access for directory: \' withCRs, dir asString.
		]
		ifTrue: [
			canBeWritten := true.
			file exists ifTrue: [
				file isWritable ifFalse: [
					canBeWritten := false.
					Dialog warn: 'You do not have write access for: \' withCRs,file asString.
				]
				ifTrue: [
					prompt := 'Do you want to overwrite: ', '\' withCRs, fileChosen, '?'.
					canBeWritten := Dialog confirm: prompt initialAnswer: false.
				]
			].
			canBeWritten ifTrue: [
				self currentDirectoryHolder value: file head.
				self fileNameHolder value: file tail.
				self saveExperiment.
			]
		]
	].!

saveCurrentExperiment
	"This saves the definition of an experiment to disk"
	self isChanged: false.
	self saveExperiment.! !

!GASTE methodsFor: 'aspects'!

currentDirectoryHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^currentDirectoryHolder isNil ifTrue: [currentDirectoryHolder := String asValue] ifFalse: [currentDirectoryHolder]!

fileNameHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^fileNameHolder isNil ifTrue: [fileNameHolder := String new asValue] ifFalse: [fileNameHolder]!

progressSliderHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^progressSliderHolder isNil ifTrue: [progressSliderHolder := 0 asValue] ifFalse: [progressSliderHolder]!

statusTextHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^statusTextHolder isNil ifTrue: [statusTextHolder := String new asValue] ifFalse: [statusTextHolder]! !

!GASTE methodsFor: 'testing'!

isChanged
	"This determines if the experiment has changed at all"
	^self experiment isChanged.!

isChanged: aBoolean
	"This resets the experiment changed flag"
	^self experiment isChanged: aBoolean.! !

!GASTE methodsFor: 'define menu'!

editEnvironment
	"This allows the user to edit the environment"
	| classSelected |
	classSelected := self selectedClass: self environmentClass.
	classSelected isNil 
		ifFalse: [Browser newOnClass: classSelected]
		ifTrue: [self selectAnEnvironmentClassWarning].!

editEvalMethod
	"This allows the user to edit the function set"

	self objectClass isNil 
		ifFalse: [GASTEEvalEditor openWith: self]
		ifTrue: [self selectAClassWarning].!

editFunctions
	"This allows the user to edit the function set"

	self objectClass isNil 
		ifFalse: [GASTEFunctionsEditor openWith: self]
		ifTrue: [self selectAClassWarning].!

editPostEvalMethod
	"This allows the user to edit the postEvalMethod"

	self objectClass isNil 
		ifFalse: [GASTEPostEvalEditor openWith: self]
		ifTrue: [self selectAClassWarning].!

editPreEvalMethod
	"This allows the user to edit the function set"

	self objectClass isNil 
		ifFalse: [GASTEPreEvalEditor openWith: self]
		ifTrue: [self selectAClassWarning].!

editTerminals
	"This allows the user to edit the terminals set"

	self objectClass isNil 
		ifFalse: [GASTETerminalsEditor openWith: self]
		ifTrue: [self selectAClassWarning].!

objectDefinition
	"This allows the user to set up class and environment for editing"

	GASTEObjectDefinitionDialog openWith: self.! !

!GASTE methodsFor: 'accessing'!

environmentClass
	"This returns the instance variable"
	^environmentClass.!

environmentClass: aSymbolOrNil
	"This sets the instance variable"
	^environmentClass := aSymbolOrNil.!

objectClass
	"This returns the instance variable"
	^objectClass.!

objectClass: aSymbolOrNil
	"This returns the instance variable"
	^objectClass := aSymbolOrNil.!

runProcess
	"This returns the instance variable"
	^runProcess.!

runProcess: aProcess
	"This sets the instance variable"
	^runProcess := aProcess.! !

!GASTE methodsFor: 'open menu'!

openAnimationBrowser
	"This generates a GeneticAntAnimationViewer browser"
	| animationViewerClass |
	self experiment objectClass isNil ifFalse: [
		animationViewerClass := self selectedClass: (self experiment objectClass, GeneticProgramming animationViewerClass).
		animationViewerClass isNil ifFalse: [animationViewerClass openWith: self].
	].!

openChartBrowser
	"This generates a chart browser"
	GeneticChartViewer openWith: self.!

openFittestProgramBrowser
	"This generates a GeneticFittestProgram browser"
	GeneticFittestProgramBrowser openWith: self.!

openPopulationBrowser
	"This generates a GeneticPopulation browser"
	GeneticPopulationBrowser openWith: self.!

openProgramBrowser
	"This generates a GeneticProgram browser"
	GeneticProgramViewer openWith: self.!

openReportBrowser
	"This generates a Report browser (which is text)"
	GeneticReportBrowser openWith: self.! !

!GASTE methodsFor: 'inspect menu'!

inspectParameters

	"This inspects the underlying experiment"

	self experiment inspect.!

inspectPopulation

	"This opens a population inspector"

	Cursor wait showWhile: [GeneticPopulationInspector openWith: self].! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTE class
	instanceVariableNames: ''!


!GASTE class methodsFor: 'resources'!

windowMenu
	"UIMenuEditor new openOnClass: self andSelector: #windowMenu"

	^#(#PopUpMenu #('File' 'Define' 'Run' 'Parameters' 'Output' 'Inspect' ) #() #(#(#PopUpMenu #('New' 'Open...' 'Close' 'Save' 'Save as...' 'Quit' ) #(5 ) #(#newExperiment #openExperiment #closeExperiment #saveCurrentExperiment #saveAsExperiment #quit ) ) #(#PopUpMenu #('Objects...' 'Behaviour' 'Evaluation...' 'Environment...' ) #() #(#objectDefinition #(#PopUpMenu #('Functions...' 'Terminals...' ) #() #(#editFunctions #editTerminals ) ) #(#PopUpMenu #('eval:...' 'preEval:...' 'postEval:...' ) #() #(#editEvalMethod #editPreEvalMethod #editPostEvalMethod ) ) #editEnvironment ) ) #(#PopUpMenu #('New run' 'Continue run' 'Stop run' ) #() #(#runExperiment #continueExperiment #stopExperiment ) ) #(#PopUpMenu #('Parameters...' ) #() #(#editParameters ) ) #(#PopUpMenu #('Program...' 'Fittest program...' 'Population...' 'Report...' 'Chart...' 'Animation...' ) #() #(#openProgramBrowser #openFittestProgramBrowser #openPopulationBrowser #openReportBrowser #openChartBrowser #openAnimationBrowser ) ) #(#PopUpMenu #('Experiment...' 'Population...' ) #() #(#inspectParameters #inspectPopulation ) ) ) ) decodeAsLiteralArray! !

!GASTE class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'GPEIST' #min: #(#Point 340 249 ) #max: #(#Point 397 250 ) #bounds: #(#Rectangle 428 220 768 469 ) #flags: 4 #menu: #windowMenu ) #component: #(#SpecCollection #collection: #(#(#RegionSpec #layout: #(#LayoutFrame 0 0.00882353 0 0.0135747 0 0.988235 0 0.153846 ) #name: #topBar #lineWidth: 1 ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0323529 0 0.0440529 ) #label: 'Name:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.15 0 0.040724 0 0.964706 0 0.131222 ) #model: #fileNameHolder #isReadOnly: true ) #(#SliderSpec #layout: #(#LayoutFrame 0 0.00882353 0 0.80543 0 0.988235 0 0.886878 ) #model: #progressSliderHolder #orientation: #horizontal #start: 0 #stop: 100 #step: 1 ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0117647 0 0.886878 ) #label: '0%' ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.894118 0 0.891403 ) #label: '100%' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.408823 0 0.900452 0 0.541176 0 0.9819 ) #model: #progressSliderHolder #alignment: #center #isReadOnly: true #type: #number ) #(#TextEditorSpec #layout: #(#LayoutFrame 0 0.00882353 0 0.176471 0 0.988235 0 0.782805 ) #flags: 15 #model: #statusTextHolder ) ) ) )! !

GASTEUI subclass: #GASTEFileListBrowser
	instanceVariableNames: 'currentDirectoryHolder directoryListHolder fileListHolder fileNameHolder currentFilterHolder '
	classVariableNames: 'CurrentDIrectory CurrentFilter '
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEFileListBrowser methodsFor: 'actions'!

changeRequest
	"This is where we intercept the close message to the window."
	^true!

closeRequest
	"This is where we intercept the close message to the window."
	^true!

directoryChanged
	"When the directory changes, we first set the directory appropriately. Then we get
	the updates current directory. Finally, we save the result in a class variable"
	| selection dir |
	selection := self directoryListHolder selection.
	selection isNil ifFalse: [
		selection = '..'
			ifTrue: [dir := (Filename named: currentDirectoryHolder value) head]
			ifFalse: [dir := currentDirectoryHolder value, self class separator, selection].
		self class currentDirectory: dir.
		self currentDirectoryHolder value: dir.
		self fileNameHolder value: ''.
		self findFiles: dir.
	].
	^self!

fileChanged
	self fileListHolder selection isNil ifFalse: [
		self fileNameHolder value: self fileListHolder selection.
	].
	^self!

filterChanged
	self findFiles: currentDirectoryHolder value.
	self class currentFilter: self currentFilterHolder value.
	^self! !

!GASTEFileListBrowser methodsFor: 'initialization'!

initialize
	"This method initializes the instance variables associated with the GASTEUI"	
	super initialize.
	self findFiles: self currentDirectoryHolder value.
	self fileNameHolder value: ''.
	^self.! !

!GASTEFileListBrowser methodsFor: 'aspects'!

currentDirectoryHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	currentDirectoryHolder isNil ifTrue: [
		currentDirectoryHolder := String new asValue.
		currentDirectoryHolder value: self class currentDirectory.
	].
	^currentDirectoryHolder!

currentFilterHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^currentFilterHolder isNil ifTrue: [
		currentFilterHolder := String new asValue.
		currentFilterHolder value: self class currentFilter.
		currentFilterHolder onChangeSend: #filterChanged to: self.
	] ifFalse: [currentFilterHolder]!

directoryListHolder
	directoryListHolder isNil ifTrue: [(directoryListHolder := SelectionInList new) selectionIndexHolder onChangeSend: #directoryChanged to: self].
	^directoryListHolder!

fileListHolder
	fileListHolder isNil ifTrue: [(fileListHolder := SelectionInList new) selectionIndexHolder onChangeSend: #fileChanged to: self].
	^fileListHolder!

fileNameHolder
	fileNameHolder isNil ifTrue: [^fileNameHolder := String new asValue].
	^fileNameHolder! !

!GASTEFileListBrowser methodsFor: 'private'!

fileChosen
	"This method ensures that a file name conforms to the expected syntax."
	| filename |
	filename := self fileNameHolder value.
	filename size = 0 
		ifFalse: [
			(filename indexOfSubCollection: Filename separator startingAt: 1) > 0 "Absolute filename, which user may have typed"
				ifTrue: [^filename]
				ifFalse: [^self currentDirectoryHolder value, self class separator, filename].
		].
	^''.!

findFiles
	self findFiles: Filename currentDirectory.!

findFiles: aString
	| directoryContents listOfDirectories dir absoluteListOfFiles relativeToDirFiles |
	Cursor wait showWhile: [
		dir := Filename named: aString.
		directoryContents := dir directoryContents.
		(listOfDirectories := OrderedCollection new) add: '..'.
		directoryContents do: 
			[:t | 
			(Filename named: (aString, self class separator, t)) isDirectory
				ifTrue: [listOfDirectories add: t]
				ifFalse: [nil]].
		absoluteListOfFiles := dir filesMatching: self currentFilterHolder value.
		relativeToDirFiles := OrderedCollection new.
		absoluteListOfFiles do: [:f |
			relativeToDirFiles add: (Filename named: f) tail
		].
		(self directoryListHolder) list: listOfDirectories; selection: nil.
		(self fileListHolder) list: relativeToDirFiles; selection: nil.].
	^self! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTEFileListBrowser class
	instanceVariableNames: ''!


!GASTEFileListBrowser class methodsFor: 'interface specs'!

windowSpec

	"UIPainter new openOnClass: self andSelector: #windowSpec"



	^#(#FullSpec #window: #(#WindowSpec #label: 'Files Browser' #min: #(#Point 397 354 ) #max: #(#Point 397 354 ) #bounds: #(#Rectangle 194 123 591 477 ) ) #component: #(#SpecCollection #collection: #(#(#LabelSpec #layout: #(#LayoutOrigin 12 0 10 0 ) #label: 'Current Directory:' ) #(#SubCanvasSpec #layout: #(#LayoutFrame 0 0.0100756 0 0.00564972 0 0.974811 0 0.107345 ) ) #(#InputFieldSpec #layout: #(#LayoutFrame 131 0 9 0 380 0 32 0 ) #model: #currentDirectoryHolder #tabable: false #isReadOnly: true ) #(#InputFieldSpec #layout: #(#LayoutFrame 132 0 51 0 381 0 74 0 ) #model: #currentFilterHolder #tabable: true #isReadOnly: false ) #(#LabelSpec #layout: #(#Point 14 53 ) #label: 'Current Filter:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 131 0 9 0 380 0 32 0 ) #model: #currentDirectoryHolder #tabable: false #isReadOnly: true ) #(#SubCanvasSpec #layout: #(#LayoutFrame 0 0.0125945 0 0.124294 0 0.97733 0 0.231638 ) ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0151134 0 0.248588 ) #label: 'Directories' ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.413098 0 0.242938 ) #label: 'Files' ) #(#SequenceViewSpec #layout: #(#LayoutFrame 0 0.415617 0 0.310734 0 0.979849 0 0.782486 ) #model: #fileListHolder ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0151134 0 0.810734 ) #label: 'File name:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.178841 0 0.80791 0 0.982368 0 0.864407 ) #model: #fileNameHolder ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.423174 0 0.887006 0 0.561713 0 0.971751 ) #model: #clickedClose #label: 'Close' #isDefault: false #defaultable: true ) #(#SequenceViewSpec #layout: #(#LayoutFrame 0 0.0176322 0 0.310734 0 0.403023 0 0.782486 ) #model: #directoryListHolder ) ) ) )! !

!GASTEFileListBrowser class methodsFor: 'accessing'!

currentDirectory
	^CurrentDIrectory!

currentDirectory: t1 
	^CurrentDIrectory := t1!

currentFilter
	"Returns the value of the current filter class variable."
	^CurrentFilter!

currentFilter: aString
	"Sets the value of the current filter class variable."
	^CurrentFilter := aString.! !

!GASTEFileListBrowser class methodsFor: 'initialization'!

initialize
	"GASTEFileListBrowser initialize"
	self currentDirectory: (Filename currentDirectory) asString.
	self currentFilter: self defaultFilter.
	^self! !

!GASTEFileListBrowser class methodsFor: 'class constants'!

defaultExtension
	"The default extension for CAPTAN applications is nothing"
	^''!

defaultFilter
	"The default filter for CAPTAN applications is .session."
	^'gp*',self defaultExtension!

separator
	"This returns a string representing the OS's separator string"
	| sep |

	sep := String new: 1.

	sep at: 1 put: (Filename separator).

	^sep.! !

!GASTEFileListBrowser class methodsFor: 'facilities'!

bundle: aString from: aDirName
	"This bundles all files in a directory to a given file. Each file is separated
	by a blank line."
	| dir absoluteListOfFiles aStream contents  |
	Cursor write showWhile: [
		dir := Filename named: aDirName.
		absoluteListOfFiles := dir filesMatching: '*.st'.

		"Open output file"
		aStream := (Filename named: aString) writeStream.
		"Now output everything to disk in one file"
		absoluteListOfFiles do: [:file | 
			contents := (Filename named: file) contentsOfEntireFile.
			aStream nextPutAll: contents.
			aStream nextPut: Character cr.
		].
	].
	aStream close.! !

GASTEUI subclass: #GASTEBitStringWindow
	instanceVariableNames: 'bitString '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEBitStringWindow methodsFor: 'aspects'!

bitString
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^bitString isNil ifTrue: [bitString := String new asValue] ifFalse: [bitString]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTEBitStringWindow class
	instanceVariableNames: ''!


!GASTEBitStringWindow class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'Bit String' #min: #(#Point 396 42 ) #max: #(#Point 396 42 ) #bounds: #(#Rectangle 241 183 637 225 ) ) #component: #(#SpecCollection #collection: #(#(#InputFieldSpec #layout: #(#Rectangle 8 10 388 29 ) #model: #bitString ) ) ) )! !

GASTEUI subclass: #GASTEObjectDefinitionDialog
	instanceVariableNames: 'objectClassListHolder environmentListHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEObjectDefinitionDialog methodsFor: 'aspects'!

environmentClassListHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^environmentClassListHolder isNil ifTrue: [environmentClassListHolder := SelectionInList new] ifFalse: [environmentClassListHolder]!

environmentListHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^environmentListHolder isNil ifTrue: [environmentListHolder := SelectionInList new] ifFalse: [environmentListHolder]!

objectClassListHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^objectClassListHolder isNil ifTrue: [objectClassListHolder := SelectionInList new] ifFalse: [objectClassListHolder]! !

!GASTEObjectDefinitionDialog methodsFor: 'initialization'!

postBuildWith: aBuilder
	"This updates the various fields once the dialog has been created"
	self initializeSelections.!

preBuildWith: aBuilder
	"This updates the various fields once the dialog has been created"
	self initializeLists.! !

!GASTEObjectDefinitionDialog methodsFor: 'accessing'!

environmentClass
	"This returns the current selected environment class"
	^self environmentListHolder selection.!

objectClass
	"This returns the current selected object class"
	^self objectClassListHolder selection.! !

!GASTEObjectDefinitionDialog methodsFor: 'class definition'!

classDefinition: aString subclass: anotherString
	"This returns a string which will compile to define a new subclass"
	self classDefinition: aString subclass: anotherString category: 'GAObj'.!

classDefinition: aString1 subclass: aString2 category: aString3
	"This returns a string which will compile to define a new subclass"
	| emptyQuotes |
	aString1 at: 1 put: (aString1 at: 1) asUppercase.	"Ensure class has upper case 1st character"
	emptyQuotes := '' printString.
	^aString2,' subclass: #', aString1, 
		' instanceVariableNames: ', emptyQuotes,
		' classVariableNames: ', emptyQuotes,
		' poolDictionaries: ', emptyQuotes,
		' category: ', aString3 printString.! !

!GASTEObjectDefinitionDialog methodsFor: 'private'!

createComment: aClass
	"This adds a comment to a newly-created class"
	aClass comment: 'This class was created by using GASTE'.! !

!GASTEObjectDefinitionDialog methodsFor: 'menu processing'!

addEnvironmentClass
	"This permits the user to add a new environment class"
	| tdialog newClass |
	tdialog := GASTEEnvironmentDefinitionDialog openDialogWith: self.
	(self selectedClass: tdialog className) isNil ifFalse: [
		Dialog warn: 'The class named ', tdialog className, ' already exists'.
		^self.
	].
	(tdialog className isEmpty or: [tdialog subclassName isNil]) ifFalse: [
		newClass := (self selectedClass: tdialog subclassName) subclassDefinerClass 
				evaluate: (self classDefinition: tdialog className subclass: tdialog subclassName category: 'GAEnv') 
				notifying: Controller
				logged: true.
		self createComment: newClass.
	].
	self initializeAll.!

addObjectClass
	"This permits the user to add a new object class"
	| tdialog newClass |
	tdialog := GASTEObjectClassDefinitionDialog openDialogWith: self.
	(self selectedClass: tdialog className) isNil ifFalse: [
		Dialog warn: 'The class named ', tdialog className, ' already exists'.
		^self.
	].
	(tdialog className isEmpty or: [tdialog subclassName isNil]) ifFalse: [
		newClass := (self selectedClass: tdialog subclassName) subclassDefinerClass 
					evaluate: (self classDefinition: tdialog className subclass: tdialog subclassName category: 'GAObj') 
					notifying: Controller
					logged: true.
		self createComment: newClass.
		newClass := (self selectedClass: (tdialog subclassName, GeneticProgramming terminalsClass)) subclassDefinerClass 
					evaluate: (self classDefinition: (tdialog className, GeneticProgramming terminalsClass)
					subclass: (tdialog subclassName, GeneticProgramming terminalsClass) 
					category: 'GAObj') 
					notifying: Controller
					logged: true.
		self createComment: newClass.
	].
	self initializeAll.!

browseEnvironmentClass
	"This permits the user to delete an existing object class"
	self environmentClass isNil ifFalse: [
		Browser newOnClass: (self selectedClass: self environmentClass).
		self initializeAll.
	]!

browseObjectClass
	"This permits the user to delete an existing object class"
	self objectClass isNil ifFalse: [
		Browser newOnClass: (self selectedClass: self objectClass).
		self initializeAll.
	]!

deleteEnvironmentClass
	"This permits the user to delete an existing environment class"
	(self environmentClass isNil not and: [Dialog confirm: 'Are you certain that you want to remove the class ', self environmentClass, '?']) ifTrue: [
		(self selectedClass: self environmentClass) removeFromSystem.
		self initializeAll.
	]!

deleteObjectClass
	"This permits the user to delete an existing object class"
	(self objectClass isNil not and: [Dialog confirm: 'Are you certain that you want to remove the class ', self objectClass, '?']) ifTrue: [
		(self selectedClass: self objectClass) removeFromSystem.
		(self selectedClass: (self objectClass, GeneticProgramming terminalsClass)) removeFromSystem.
		self initializeAll.
	]! !

!GASTEObjectDefinitionDialog methodsFor: 'actions'!

clickedClose
	"This is invoked when the close button is pressed"
	self dialog objectClass: self objectClass.
	self dialog environmentClass: self environmentClass.
	^super clickedClose.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTEObjectDefinitionDialog class
	instanceVariableNames: ''!


!GASTEObjectDefinitionDialog class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'Object Definition Dialog' #min: #(#Point 374 216 ) #max: #(#Point 374 216 ) #bounds: #(#Rectangle 324 301 698 517 ) ) #component: #(#SpecCollection #collection: #(#(#LabelSpec #layout: #(#LayoutOrigin 0 0.0427807 0 0.0416667 ) #name: #objectClass #label: 'Object class' ) #(#SequenceViewSpec #layout: #(#LayoutFrame 0 0.0481283 0 0.148148 0 0.497326 0 0.717593 ) #name: #objectClassList #model: #objectClassListHolder #menu: #objectClassMenu ) #(#SequenceViewSpec #layout: #(#LayoutFrame 0 0.510695 0 0.148148 0 0.959893 0 0.717593 ) #name: #environmentList #model: #environmentListHolder #menu: #environmentClassMenu ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.516043 0 0.0416667 ) #name: #environment #label: 'Environment' ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.382353 0 0.805556 0 0.553476 0 0.967593 ) #name: #closeButton #model: #clickedClose #label: 'Close' #defaultable: true ) ) ) )! !

!GASTEObjectDefinitionDialog class methodsFor: 'resources'!

environmentClassMenu
	"UIMenuEditor new openOnClass: self andSelector: #environmentClassMenu"

	^#(#PopUpMenu #('Add' 'Delete' 'Browse') #() #(#addEnvironmentClass #deleteEnvironmentClass #browseEnvironmentClass) ) decodeAsLiteralArray!

objectClassMenu
	"UIMenuEditor new openOnClass: self andSelector: #objectClassMenu"

	^#(#PopUpMenu #('Add' 'Delete' 'Browse' ) #() #(#addObjectClass #deleteObjectClass #browseObjectClass) ) decodeAsLiteralArray! !

GASTEUI subclass: #GeneticGraphicalViewer
	instanceVariableNames: 'viewPane objectTextHolder fitnessHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticGraphicalViewer methodsFor: 'updating'!

updateFields
	"This updates the general graphical view fields"

	((self experiment isNil) or: [self experiment population isNil or: [self experiment population fittestMember isNil]]) ifFalse: [
		self updateFields: self experiment population fittestMember.
	].!

updateFields: anObject
	"This updates the general graphical view fields"

	self objectTextHolder value: (anObject object printString).
	self fitnessHolder value: (anObject rawFitness).! !

!GeneticGraphicalViewer methodsFor: 'aspects'!

fitnessHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^fitnessHolder isNil ifTrue: [fitnessHolder := String new asValue] ifFalse: [fitnessHolder]!

objectTextHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^objectTextHolder isNil ifTrue: [objectTextHolder := String new asValue] ifFalse: [objectTextHolder]!

viewPane
	"This returns the instance variable"
	^viewPane.!

viewPane: aView
	"This sets the instance variable"
	^viewPane := aView.! !

!GeneticGraphicalViewer methodsFor: 'initialization'!

initialize
	"This initializes the instance of the Genetic Program viewer"
	super initialize.
	self fitnessHolder value: 0.
	viewPane := self viewAndModel.
	self addDependent: viewPane.!

postOpenWith: aBuilder
	"This updates the general fields, if possible"
	self updateFields.! !

!GeneticGraphicalViewer methodsFor: 'actions'!

hardcopy
	"This creates a hard copy of whatever is on the view pane. This is currently a chart,
	a genetic program, or a picture of the ant trail."
	|  gc limits xScale yScale |

	Cursor write showWhile: [
		limits := self viewPane limits.
		gc := PSGraphicsContext fileName: 'gpeist.ps'.
		gc setLandscape.
		xScale  := ((gc medium height - (gc pageOffset x * 4))/ limits x) min: 1.0.
		yScale := ((gc medium width - (gc pageOffset y * 4)) / limits y) min: 1.0.
		gc putScale: (xScale @ yScale negated).
		gc putTranslation.
		gc setLimits: (limits * 2).
		self viewPane displayOn: gc.
		gc close.
		'gpeist.ps' asFilename printPSFile.
	].!

hardcopyOld
	"This creates a hard copy of whatever is in the DISPLAYED window"
	| document windowOrigin p1 p2 image |
	document := Document new.
	document setLandscape.
	document setBottomMargin: 0.5.
	document setTopMargin: 0.5.
	document setLeftMargin: 0.5.
	document setRightMargin: 0.5.
	document startParagraph.
	windowOrigin := self viewPane topComponent globalOrigin.
	p1 := windowOrigin + (self viewPane localPointToGlobal: self viewPane bounds origin).
	p2 := windowOrigin + (self viewPane localPointToGlobal: self viewPane bounds corner).
	image := Screen default completeContentsOfArea: (p1 corner: p2).
	document addImage: image.
	document close.
	document toPrinter.! !

GeneticGraphicalViewer subclass: #GeneticChartViewer
	instanceVariableNames: 'yMinHolder xMinHolder yTicsHolder xMaxHolder yMaxHolder xTicsHolder yLabelHolder titleHolder xLabelHolder preferenceHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticChartViewer methodsFor: 'view definition'!

viewAndModel
	"This returns an initializing view and Model"
	| view controller |
	view := GeneticChartView new.
	controller := (GeneticChartController new) performer: self.
	view model: (GeneticStatistics new); controller: controller.
	^view.! !

!GeneticChartViewer methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This allows us to update a couple of the fields on the viewer"

	super update: aSymbol with: anObject from: aSender.
	aSymbol == #output ifTrue: [
		self updateFields: anObject.
		aSender continue.
	].! !

!GeneticChartViewer methodsFor: 'actions'!

clickedApply
	"This stub method was generated by UIDefiner"

	^self limitsChanged.!

clickedCancel
	"This stub method was generated by UIDefiner"

	self xMaxHolder value: (self viewPane xMax).
	self xMinHolder value: (self viewPane xMin).
	self xTicsHolder value: (self viewPane xTics).
	self yMaxHolder value: (self viewPane yMax).
	self yMinHolder value: (self viewPane yMin).
	self yTicsHolder value: (self viewPane yTics).

	self xLabelHolder value: (self viewPane xLabel).
	self yLabelHolder value: (self viewPane yLabel).
	self titleHolder value: (self viewPane title).

	self preferenceHolder value: (self viewPane preference).

	^self!

limitsChanged
	"This is invoked whenever the user updates one of the Y or X values"
	self viewPane xMax: self xMaxHolder value xMin: self xMinHolder value xTics: self xTicsHolder value.
	self viewPane yMax: self yMaxHolder value yMin: self yMinHolder value yTics: self yTicsHolder value.
	self viewPane title: self titleHolder value xLabel: self xLabelHolder value yLabel: self yLabelHolder value.
	self viewPane preference: self preferenceHolder value.
	self viewPane invalidate.! !

!GeneticChartViewer methodsFor: 'private'!

setupLimits
	"This allows us to modify the limits used in the chart. It's done 
	in order that we can pick up the maxEvaluations parameter 
	from the experiment. By doing this, the chart should fit into
	the basic window"

	self xMaxHolder value: self experiment maxEvaluations.
	self limitsChanged.! !

!GeneticChartViewer methodsFor: 'initialization'!

initialize
	"This initializes the instance of the Genetic Program viewer"
	super initialize.
	self fitnessHolder value: 0.
	viewPane := self viewAndModel.
	self addDependent: viewPane.!

postOpenWith: aBuilder
	"This updates the general fields, if possible"

	| statistics |
	super postOpenWith: aBuilder.
	(self experiment isNil or: [self experiment population isNil]) ifFalse: [
		self setupLimits.
		statistics := self experiment population statisticalMeasures.
		self viewPane updateChart: statistics.
	].! !

!GeneticChartViewer methodsFor: 'aspects'!

fitnessHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^fitnessHolder isNil ifTrue: [fitnessHolder := 0 asValue] ifFalse: [fitnessHolder]!

objectTextHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^objectTextHolder isNil ifTrue: [objectTextHolder := String new asValue] ifFalse: [objectTextHolder]!

preferenceHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^preferenceHolder isNil ifTrue: [preferenceHolder := GeneticChartView preference asValue] ifFalse: [preferenceHolder]!

titleHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^titleHolder isNil ifTrue: [titleHolder := GeneticChartView title asValue] ifFalse: [titleHolder]!

xLabelHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^xLabelHolder isNil ifTrue: [xLabelHolder := GeneticChartView xLabel asValue] ifFalse: [xLabelHolder]!

xMaxHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^xMaxHolder isNil ifTrue: [xMaxHolder := GeneticChartView xMax asValue] ifFalse: [xMaxHolder]!

xMinHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^xMinHolder isNil ifTrue: [xMinHolder := GeneticChartView xMin asValue] ifFalse: [xMinHolder]!

xTicsHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^xTicsHolder isNil ifTrue: [xTicsHolder := GeneticChartView xTics asValue] ifFalse: [xTicsHolder]!

yLabelHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^yLabelHolder isNil ifTrue: [yLabelHolder := GeneticChartView yLabel asValue] ifFalse: [yLabelHolder]!

yMaxHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^yMaxHolder isNil ifTrue: [yMaxHolder := GeneticChartView yMax  asValue] ifFalse: [yMaxHolder]!

yMinHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^yMinHolder isNil ifTrue: [yMinHolder := GeneticChartView yMin asValue] ifFalse: [yMinHolder]!

yTicsHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^yTicsHolder isNil ifTrue: [yTicsHolder := GeneticChartView yTics asValue] ifFalse: [yTicsHolder]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GeneticChartViewer class
	instanceVariableNames: ''!


!GeneticChartViewer class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'Genetic Programming Chart viewer' #min: #(#Point 524 480 ) #bounds: #(#Rectangle 313 143 837 623 ) ) #component: #(#SpecCollection #collection: #(#(#ArbitraryComponentSpec #layout: #(#LayoutFrame 0 0.0305344 0 0.40625 0 0.967557 0 0.927083 ) #flags: 11 #component: #viewPane ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.432377 0 0.933202 0 0.545082 0 0.992141 ) #name: #closeButton #model: #clickedClose #label: 'Close' #defaultable: true ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0307377 0 0.0157171 ) #label: 'Fitness:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.151639 0 0.0157171 0 0.247951 0 0.0569745 ) #name: #fitness #model: #fitnessHolder #isReadOnly: true #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.254098 0 0.0157171 ) #label: 'Object:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.352459 0 0.0157171 0 0.967213 0 0.0569745 ) #name: #objectText #model: #objectTextHolder ) #(#GroupBoxSpec #layout: #(#LayoutFrame 0 0.0307377 0 0.0628684 0 0.967213 0 0.392927 ) #label: 'Chart parameters' ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0433884 0 0.102083 ) #label: 'Y max:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.154959 0 0.102083 0 0.419421 0 0.147917 ) #model: #yMaxHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0454545 0 0.15625 ) #label: 'Y min:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.154959 0 0.15625 0 0.419421 0 0.202083 ) #model: #yMinHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0433884 0 0.2125 ) #label: 'Y tics:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.154959 0 0.210417 0 0.419421 0 0.25625 ) #model: #yTicsHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.440083 0 0.104167 ) #label: 'X max:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.553719 0 0.104167 0 0.791322 0 0.15 ) #model: #xMaxHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.442149 0 0.160417 ) #label: 'X min:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.553719 0 0.158333 0 0.791322 0 0.204167 ) #model: #xMinHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.440083 0 0.214583 ) #label: 'X tics:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.553719 0 0.2125 0 0.793388 0 0.258333 ) #model: #xTicsHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0433884 0 0.26875 ) #label: 'Y label:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.154959 0 0.264583 0 0.419421 0 0.310417 ) #model: #yLabelHolder #type: #string ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.440083 0 0.270833 ) #label: 'X label:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.553719 0 0.266667 0 0.793388 0 0.3125 ) #model: #xLabelHolder #type: #string ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0516529 0 0.329167 ) #label: 'Title:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.152893 0 0.33125 0 0.795455 0 0.377083 ) #model: #titleHolder ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.824427 0 0.129167 0 0.935114 0 0.189583 ) #model: #clickedApply #label: 'Apply' #defaultable: true ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.824427 0 0.185417 0 0.935114 0 0.24375 ) #model: #clickedCancel #label: 'Cancel' #defaultable: true ) #(#RadioButtonSpec #layout: #(#LayoutOrigin 0 0.796545 0 0.266112 ) #model: #preferenceHolder #label: 'Auto scale' #select: #scale ) #(#RadioButtonSpec #layout: #(#LayoutOrigin 0 0.798464 0 0.324324 ) #model: #preferenceHolder #label: 'Auto scroll' #select: #scroll ) #(#GroupBoxSpec #layout: #(#LayoutFrame 0 0.805344 0 0.0875 0 0.954198 0 0.254167 ) #label: 'Actions' ) ) ) )! !

GeneticGraphicalViewer subclass: #GeneticAntAnimationViewer
	instanceVariableNames: 'animationProcess '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticAntAnimationViewer methodsFor: 'actions'!

changeRequest
	"Make sure that we terminate the animation process"
	self terminateAnimation.
	^super changeRequest.!

closeRequest
	"Make sure that we terminate the animation process"
	self terminateAnimation.
	^super closeRequest.! !

!GeneticAntAnimationViewer methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This allows us to update a couple of the fields on the viewer"

	super update: aSymbol with: anObject from: aSender.
	aSymbol == #output ifTrue: [
		self updateFields: anObject.
		self animate.
	].

	aSymbol == #endOfAnimation ifTrue: [
		aSender removeDependent: self.
		self experiment continue.
		self terminateAnimation.
	].! !

!GeneticAntAnimationViewer methodsFor: 'initialization'!

preBuildWith: aBuilder
	"Set up the correct trail for this animation"
	viewPane model: ((self selectedClass: self experiment env) new)! !

!GeneticAntAnimationViewer methodsFor: 'view definition'!

viewAndModel
	"This returns an initializing view and Model"
	| view controller |
	view := GeneticAntAnimationView new.
	controller := (GeneticAntAnimationController new) performer: self.
	view model: ((self selectedClass: self experiment env) new); controller: controller.
	^view.! !

!GeneticAntAnimationViewer methodsFor: 'animation'!

animate
	"This performs the animation for the object"
	| aGP anEnv aGPrun |

	aGPrun := self experiment.
	aGP := aGPrun population fittestMember object.
	anEnv := aGP preEval: aGPrun env.
	anEnv addDependent: self.
	self viewPane model: anEnv.
	animationProcess := [aGP eval: anEnv] fork.!

reset
	"This resets the trail display. It can then be reanimated"
	self updateFields.
	self viewPane model: ((self selectedClass: self experiment env) new).
	self viewPane invalidate.! !

!GeneticAntAnimationViewer methodsFor: 'accessing'!

animationProcess

	"This returns the instance variable"

	^animationProcess.!

animationProcess: aProcess

	"This sets the instance variable"

	^animationProcess := aProcess.! !

!GeneticAntAnimationViewer methodsFor: 'termination'!

terminateAnimation
	"This returns true, if the animationProcess is non-nil"

	self animationProcess isNil ifFalse: [
		self animationProcess terminate.
		self animationProcess: nil.
	].! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GeneticAntAnimationViewer class
	instanceVariableNames: ''!


!GeneticAntAnimationViewer class methodsFor: 'view definition'!

viewAndModel
	"This returns an initializing view and Model"
	^(GeneticAntAnimationView new) model: (JohnMuirTrailEnv new).! !

!GeneticAntAnimationViewer class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'Animation viewer' #min: #(#Point 380 436 ) #max: #(#Point 380 436 ) #bounds: #(#Rectangle 333 231 713 667 ) ) #component: #(#SpecCollection #collection: #(#(#ArbitraryComponentSpec #layout: #(#LayoutFrame 0 0.024 0 0.0818182 0 0.978667 0 0.879545 ) #component: #viewPane ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.419525 0 0.902273 0 0.551451 0 0.965909 ) #name: #closeButton #model: #clickedClose #label: 'Close' #defaultable: true ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.020202 0 0.0181818 ) #label: 'Fitness:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.152 0 0.0181818 0 0.258667 0 0.0636364 ) #name: #fitness #model: #fitnessHolder #isReadOnly: true #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.258575 0 0.0204545 ) #label: 'Object:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.378788 0 0.0204545 0 0.974747 0 0.0636364 ) #name: #objectText #model: #objectTextHolder ) ) ) )! !

GeneticGraphicalViewer subclass: #GeneticProgramViewer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticProgramViewer methodsFor: 'initialization'!

initialize
	"This initializes the instance of the Genetic Program viewer"
	super initialize.
	self fitnessHolder value: 0.
	viewPane := self viewAndModel.
	self addDependent: viewPane.!

postOpenWith: aBuilder
	"This updates the general fields, if possible"

	super postOpenWith: aBuilder.
	(self experiment isNil or: [self experiment population isNil or: [self experiment population fittestMember isNil]]) ifFalse: [
		self viewPane updateModel: (self experiment population fittestMember).
	].! !

!GeneticProgramViewer methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This allows us to update a couple of the fields on the viewer"

	super update: aSymbol with: anObject from: aSender.
	aSymbol == #output ifTrue: [
		self updateFields: anObject.
		aSender continue.
	].! !

!GeneticProgramViewer methodsFor: 'view definition'!

viewAndModel
	"This returns an initializing view and Model"
	| view controller |
	view := GeneticProgramView new.
	controller := (GeneticProgramController new) performer: self.
	view model: (TreeBrowser newOn: (GeneticProgramTerminal new: '')); controller: controller.
	^view.! !

!GeneticProgramViewer methodsFor: 'menu processing'!

redisplay
	"This resets the display."
	self updateFields.
	self viewPane invalidate.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GeneticProgramViewer class
	instanceVariableNames: 'viewPane '!


!GeneticProgramViewer class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'GeneticProgram viewer' #min: #(#Point 488 443 ) #bounds: #(#Rectangle 175 85 663 528 ) ) #component: #(#SpecCollection #collection: #(#(#ArbitraryComponentSpec #layout: #(#LayoutFrame 0 0.0204918 0 0.0812641 0 0.981557 0 0.880361 ) #flags: 11 #component: #viewPane ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.426229 0 0.89842 0 0.538934 0 0.96614 ) #name: #closeButton #model: #clickedClose #label: 'Close' #defaultable: true ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.0163934 0 0.0158014 ) #label: 'Fitness:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.137295 0 0.0158014 0 0.233607 0 0.0632054 ) #name: #fitness #model: #fitnessHolder #isReadOnly: true #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 0 0.254098 0 0.0180587 ) #label: 'Object:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 0 0.352459 0 0.0180587 0 0.979508 0 0.0609481 ) #name: #objectText #model: #objectTextHolder ) ) ) )! !

GASTEUI subclass: #GeneticBrowser
	instanceVariableNames: 'textHolder outputBlock counter '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticBrowser methodsFor: 'accessing'!

counter
	"This returns the instance variable"
	^counter!

counter: anInteger
	"This sets the instance variable"
	^counter := anInteger.!

outputBlock
	"This returns the instance variable"
	^outputBlock.!

outputBlock: aBlock
	"This sets the instance variable"
	^outputBlock := aBlock.!

text
	"This returns the text in the text holder"
	^self textHolder value.!

text: aString
	"This sets the text in the text holder"
	^self textHolder value: aString.! !

!GeneticBrowser methodsFor: 'aspects'!

textHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^textHolder isNil ifTrue: [textHolder := String new asValue] ifFalse: [textHolder]! !

!GeneticBrowser methodsFor: 'scrolling'!

scrollCheck
	"This checks to see if we should scroll the window"
	| textPane content difference |
	textPane := (self builder componentAt: #text) widget.
	content := textPane displayContents.

	"See if the content height exceeds the pane size"
	difference := textPane bounds corner y - content height.
	difference < 0 ifTrue: [ textPane scrollTo: 0@difference].! !

!GeneticBrowser methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This allows us to update a couple of the fields on the viewer"

	super update: aSymbol with: anObject from: aSender.
	aSymbol == #output ifTrue: [
		counter := counter + 1.
		self outputBlock isNil ifFalse: [
			self text: (self text, (self outputBlock value: anObject)).
			aSender continue.

		]
	].! !

!GeneticBrowser methodsFor: 'initialization'!

initialize
	"Initialize the new instance"
	super initialize.
	self counter: 0.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GeneticBrowser class
	instanceVariableNames: ''!


!GeneticBrowser class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'Genetic Browser' #min: #(#Point 314 120 ) #bounds: #(#Rectangle 241 489 555 609 ) ) #component: #(#SpecCollection #collection: #(#(#TextEditorSpec #layout: #(#LayoutFrame 0 0.0382166 0 0.0666667 0 0.977707 0 0.683333 ) #name: #text #model: #textHolder #isReadOnly: true ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.388535 0 0.691667 0 0.570064 0 0.983333 ) #name: #closeButton #model: #clickedClose #label: 'Close' #defaultable: true ) ) ) )! !

!GeneticBrowser class methodsFor: 'interface opening'!

openWith: aGASTEUI outputBlock: aBlock
	"This opens a generic browser which performs the block whenever
	the #output message is sent from the underlying experiment"
	| aGeneticBrowser |
	aGeneticBrowser := self new.
	aGeneticBrowser outputBlock: aBlock.
	aGeneticBrowser initializeDialogAndExperiment: aGASTEUI.
	self openOn: aGeneticBrowser.
	aGASTEUI addDependent: aGeneticBrowser.
	^aGeneticBrowser.! !

!GeneticBrowser class methodsFor: 'resources'!

textHolderMenu

	"UIMenuEditor new openOnClass: self andSelector: #textHolderMenu"



	^#(#PopUpMenu #('Hardcopy' ) #() #(#hardcopy ) ) decodeAsLiteralArray! !

GeneticBrowser subclass: #GeneticFittestProgramBrowser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticFittestProgramBrowser methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This allows us to update a couple of the fields on the viewer"

	| aStream filename |
	super update: aSymbol with: anObject from: aSender.
	aSymbol == #output ifTrue: [
		filename := self dialog fileNameHolder value, counter printString, '.gpf'.
		aStream := (Filename named: filename) writeStream.
		[Cursor write showWhile: [anObject storeOn: aStream]]

			valueNowOrOnUnwindDo: [aStream close].
		self text: ('Program written to ', filename, ' at: ', Time now printString,'.').

		aSender continue.
	].! !

GeneticBrowser subclass: #GeneticReportBrowser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticReportBrowser methodsFor: 'private'!

createReport
	"This queries the statistics server for report information"

	| statistics p trials fitness bounds size depth txt |
	statistics := self experiment population statisticalMeasures.
	p := self class padding.

	trials := statistics at: #evaluations.
	fitness := statistics at: #statisticalRawFitnessMeasures.
	bounds := statistics at: #statisticalRawMinMaxFitnessMeasures.
	size := statistics at: #statisticalSizeMeasures.
	depth := statistics at: #statisticalDepthMeasures.

	txt := ''.
	1 to: trials size do: [ :i |
		txt := txt, (((trials at: i) printString padded: p),
		(((fitness at: i) at: 1) printString padded: p), 
		(((fitness at: i) at: 2) printString padded: p), 
		(((bounds at: i) at: 1) printString padded: p), 
		(((bounds at: i) at: 2) printString padded: p), 
		(((size at: i) at: 1) printString padded: p), 
		(((size at: i) at: 2) printString padded: p),
		(((depth at: i) at: 1) printString padded: p), 
		(((depth at: i) at: 2) printString padded: p), '\' withCRs).
	].
	"Now update the report"
	self text: (self text, txt).!

fileAs
	"This saves the report (as text) to disk"
	| file fileChosen prompt dir canBeWritten  |
	fileChosen := (GASTEFileListBrowser openDialogWith: self) fileChosen.
	fileChosen = '' ifFalse: [
		file := Filename named: fileChosen.
		dir := Filename named: file head.
		(dir exists and: [dir isWritable]) ifFalse: [
			Dialog warn: 'You do not have write access for directory: \' withCRs, dir asString.
		]
		ifTrue: [
			canBeWritten := true.
			file exists ifTrue: [
				file isWritable ifFalse: [
					canBeWritten := false.
					Dialog warn: 'You do not have write access for: \' withCRs,file asString.
				]
				ifTrue: [
					prompt := 'Do you want to overwrite: ', '\' withCRs, fileChosen, '?'.
					canBeWritten := Dialog confirm: prompt initialAnswer: false.
				]
			].
			canBeWritten ifTrue: [
				^file writeStream.
			]
		]
	].
	^nil.!

statistics
	"This gets the latest statistics and builds a string"
	| fitness size depth p trials bounds |
	p := self class padding.

	trials := self experiment evaluations.
	fitness := self experiment statisticalRawFitnessMeasures.
	bounds := self experiment statisticalRawMinMaxFitnessMeasures.
	size := self experiment statisticalSizeMeasures.
	depth := self experiment statisticalDepthMeasures.


	^((trials printString padded: p),
	((fitness at: 1) printString padded: p), 
	((fitness at: 2) printString padded: p), 
	((bounds at: 1) printString padded: p), 
	((bounds at: 2) printString padded: p), 
	((size at: 1) printString padded: p), 
	((size at: 2) printString padded: p),
	((depth at: 1) printString padded: p), 
	((depth at: 2) printString padded: p), '\' withCRs).!

textAsCSVprintOn: aStream
	"This prints the text pane contents in CSV format on the stream"
	| readStream aLine scanner tokens size |

	scanner := Scanner new.
	readStream := ReadStream on: self text.
	[readStream atEnd] whileFalse: [
		aLine := readStream through: Character cr.
		tokens := scanner scanTokens: aLine.
		size := tokens size.
		1 to: size do: [ :i |
			(tokens at: i) printOn: aStream.
			i < size 
				ifTrue: [aStream nextPut: $,]
				ifFalse: [aStream nextPut: Character cr].
		].
	].! !

!GeneticReportBrowser methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This allows us to update a couple of the fields on the viewer"
	super update: aSymbol with: anObject from: aSender.
	aSymbol == #output ifTrue: [
		Cursor execute showWhile: [self text: (self text, self statistics)].
		self scrollCheck.
		aSender continue.
	].
	aSymbol == #newStatistics ifTrue: [
		(aSender isKindOf: GeneticStatistics) ifTrue: [
			aSender removeDependent: self.
		].
		anObject addDependent: self.
		self text: self class title.
	].! !

!GeneticReportBrowser methodsFor: 'initialize'!

initialize
	"This sets up the title"
	super initialize.
	self text: self class title.!

postOpenWith: aBuilder
	"This ensures that we're advised of changes to the statistics variable"
	self experiment population statisticalMeasures addDependent: self.
	self createReport.! !

!GeneticReportBrowser methodsFor: 'menu processing'!

fileAsCSV
	"This saves the report (in Comma Separated Variable format) to disk"
	| aStream |
	aStream := self fileAs.
	aStream isNil ifFalse: [
		[self textAsCSVprintOn: aStream] valueNowOrOnUnwindDo: [aStream close].
	].!

fileAsText
	"This saves the report (in ASCII format) to disk"
	| aStream |
	aStream := self fileAs.
	aStream isNil ifFalse: [
		[self text printOn: aStream] valueNowOrOnUnwindDo: [aStream close].
	].!

hardcopy
	"This creates a hard copy of the report. For customization of the
	hardcopy, please consult the methods in the Document class"
	| document |

	Document defaultLeftMargin: 0.5.
	Document defaultRightMargin: 0.5.
	Document defaultTopMargin: 0.5.
	Document defaultBottomMargin: 0.5.

	document := Document new.
	document startParagraph.
	document addText: self text under: (TextAttributes styleNamed: #fixed).
	document close.
	document toPrinter! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GeneticReportBrowser class
	instanceVariableNames: ''!


!GeneticReportBrowser class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'Genetic Reporter' #min: #(#Point 714 469 ) #bounds: #(#Rectangle 433 178 1147 647 ) ) #component: #(#SpecCollection #collection: #(#(#TextEditorSpec #layout: #(#LayoutFrame 0 0.0203125 0 0.0229167 0 0.976562 0 0.908333 ) #name: #text #model: #textHolder #menu: #textHolderMenu #style: #fixed #isReadOnly: false ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.413428 0 0.920833 0 0.565371 0 0.983333 ) #name: #closeButton #model: #clickedClose #label: 'Close' #defaultable: true ) ) ) )! !

!GeneticReportBrowser class methodsFor: 'class constants'!

padding
	^10.!

title
	"Report title"
	^(self title1, '\' withCRs, self title2, '\' withCRs).!

title1
	"First line of title"
	| p |
	p := self padding * 2.
	^('' padded: self padding), ('     Fitness' padded: p), ('   Raw Fitness' padded: p),('      Size' padded: p), ('      Depth' padded: p).!

title2
	"Second line of title"
	| p q |
	p := self padding.
	q := (' Mean' padded: p), ('Variance' padded: p).
	^('Trials' padded: p), q,  ('Minimum' padded: p), ('Maximum' padded: p), q, q.! !

!GeneticReportBrowser class methodsFor: 'resources'!

textHolderMenu
	"UIMenuEditor new openOnClass: self andSelector: #textHolderMenu"

	^#(#PopUpMenu #('Hardcopy' 'File as' ) #() #(#hardcopy #(#PopUpMenu #('Text...' 'CSV...' ) #() #(#fileAsText #fileAsCSV ) ) ) ) decodeAsLiteralArray! !

GeneticBrowser subclass: #GeneticPopulationBrowser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticPopulationBrowser methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This allows us to update a couple of the fields on the viewer"

	| aStream filename |
	super update: aSymbol with: anObject from: aSender.
	aSymbol == #output ifTrue: [
		filename := self dialog fileNameHolder value, counter printString, '.gpp'.
		aStream := BinaryObjectStorage onNew: (Filename named: filename) writeStream.
		[Cursor write showWhile: [aStream nextPut: self experiment population]]

			valueNowOrOnUnwindDo: [aStream close].
		self text: ('Population written to ', filename, ' at: ', Time now printString,'.').

		aSender continue.
	].! !

GASTEUI subclass: #GASTEParameters
	instanceVariableNames: 'populationSizeHolder objectClassListHolder maximumEvaluationsHolder environmentListHolder crossoverProbabilityHolder selectionMechanismHolder mutationProbabilityHolder outputFrequencyHolder randomSeedHolder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEParameters methodsFor: 'initialization'!

initializeFields
	"This allows the various fields to be updated"

	self mutationProbabilityHolder value: self experiment pMutation.
	self crossoverProbabilityHolder value: self experiment pCrossover.
	self maximumEvaluationsHolder value: self experiment maxEvaluations.
	self outputFrequencyHolder value: self experiment outputFrequency.
	self populationSizeHolder value: self experiment population sizeOfPopulation.
	self selectionMechanismHolder value: self experiment sMechanism.
	self randomSeedHolder value: self experiment seed.
	self initializeLists.!

initializeSelections
	"This allows the various fields to be updated"

	self experiment objectClass isNil ifFalse: [
		self objectClassListHolder selection: (self experiment objectClass).
	].

	self experiment env isNil ifFalse: [
		self environmentListHolder selection: (self experiment env).
	].!

postOpenWith: aBuilder
	"This updates the various fields once the dialog has been created"

	self initializeSelections.!

preBuildWith: aBuilder
	"This updates the various fields once the dialog has been created"

	self initializeFields.! !

!GASTEParameters methodsFor: 'testing'!

isOK

	"Performs a test on all fields in order to ensure that everything is ok"

	(self mutationProbabilityHolder value < 0.0 or: [self mutationProbabilityHolder value > 1.0]) ifTrue: [^false].

	(self crossoverProbabilityHolder value < 0.0 or: [self crossoverProbabilityHolder value > 1.0]) ifTrue: [^false].

	self objectClassListHolder selection isNil ifTrue: [^false].

	^true.! !

!GASTEParameters methodsFor: 'updating'!

updateExperiment

	"This updates the experiment with the new values"

	| objectSelection |

	self experiment pMutation: self mutationProbabilityHolder value.

	self experiment pCrossover: self crossoverProbabilityHolder value.

	self experiment maxEvaluations: self maximumEvaluationsHolder value.

	self experiment outputFrequency: self outputFrequencyHolder value.

	self experiment population sizeOfPopulation: self populationSizeHolder value.

	self experiment sMechanism: self selectionMechanismHolder value.

	self experiment seed: self randomSeedHolder value truncated.

	objectSelection := self objectClassListHolder selection.

	objectSelection isNil ifFalse: [

		self experiment objectClass: objectSelection

	].

	objectSelection := self environmentListHolder selection.

	objectSelection isNil ifFalse: [

		self experiment env: objectSelection

	].! !

!GASTEParameters methodsFor: 'actions'!

clickedCancel
	"This stub method was generated by UIDefiner"
	^self closeRequest.!

clickedOK
	"This stub method was generated by UIDefiner"

	self isOK ifTrue: [
		self updateExperiment.
		self closeRequest.
	]
	ifFalse: [Dialog warn: 'Input errors detected, please correct'].
	^self! !

!GASTEParameters methodsFor: 'aspects'!

crossoverProbabilityHolder

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^crossoverProbabilityHolder isNil ifTrue: [crossoverProbabilityHolder := 0 asValue] ifFalse: [crossoverProbabilityHolder]!

environmentListHolder

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^environmentListHolder isNil ifTrue: [environmentListHolder := SelectionInList new] ifFalse: [environmentListHolder]!

maximumEvaluationsHolder

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^maximumEvaluationsHolder isNil ifTrue: [maximumEvaluationsHolder := 0 asValue] ifFalse: [maximumEvaluationsHolder]!

mutationProbabilityHolder

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^mutationProbabilityHolder isNil ifTrue: [mutationProbabilityHolder := 0 asValue] ifFalse: [mutationProbabilityHolder]!

objectClassListHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^objectClassListHolder isNil ifTrue: [objectClassListHolder := SelectionInList new] ifFalse: [objectClassListHolder]!

outputFrequencyHolder

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^outputFrequencyHolder isNil ifTrue: [outputFrequencyHolder := 0 asValue] ifFalse: [outputFrequencyHolder]!

populationSizeHolder

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^populationSizeHolder isNil ifTrue: [populationSizeHolder := 0 asValue] ifFalse: [populationSizeHolder]!

randomSeedHolder

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^randomSeedHolder isNil ifTrue: [randomSeedHolder := 0 asValue] ifFalse: [randomSeedHolder]!

selectionMechanismHolder

	"This method was generated by UIDefiner. The initialization provided 

	below may have been preempted by an initialize method."



	^selectionMechanismHolder isNil ifTrue: [selectionMechanismHolder := nil asValue] ifFalse: [selectionMechanismHolder]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTEParameters class
	instanceVariableNames: ''!


!GASTEParameters class methodsFor: 'interface specs'!

windowSpec

	"UIPainter new openOnClass: self andSelector: #windowSpec"



	^#(#FullSpec #window: #(#WindowSpec #label: 'Parameters' #min: #(#Point 471 314 ) #max: #(#Point 471 314 ) #bounds: #(#Rectangle 102 70 573 384 ) ) #component: #(#SpecCollection #collection: #(#(#SequenceViewSpec #layout: #(#Rectangle 285 32 457 121 ) #name: #objectClassList #model: #objectClassListHolder ) #(#SequenceViewSpec #layout: #(#Rectangle 287 147 456 247 ) #name: #environmentClassList #model: #environmentListHolder ) #(#LabelSpec #layout: #(#Point 285 10 ) #label: 'Object class' ) #(#LabelSpec #layout: #(#Point 284 126 ) #label: 'Environment' ) #(#ActionButtonSpec #layout: #(#Rectangle 293 265 356 293 ) #name: #okButton #model: #clickedOK #label: 'OK' #defaultable: true ) #(#ActionButtonSpec #layout: #(#Rectangle 394 264 457 292 ) #name: #cancelButton #model: #clickedCancel #label: 'Cancel' #defaultable: true ) #(#GroupBoxSpec #layout: #(#LayoutFrame 12 0 6 0 272 0 248 0 ) #name: #controlParametersBox #label: 'Control Parameters' ) #(#LabelSpec #layout: #(#LayoutOrigin 24 0 30 0 ) #name: #pMutation #label: 'Mutation Probability:' ) #(#LabelSpec #layout: #(#LayoutOrigin 24 0 67 0 ) #name: #pCrossover #label: 'Crossover Probability:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 160 0 29 0 260 0 50 0 ) #name: #mutationProbability #model: #mutationProbabilityHolder #type: #number ) #(#InputFieldSpec #layout: #(#LayoutFrame 160 0 65 0 260 0 86 0 ) #name: #crossoverProbability #model: #crossoverProbabilityHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 24 0 105 0 ) #label: 'Maximum evaluations:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 160 0 103 0 260 0 124 0 ) #name: #maximumEvaluations #model: #maximumEvaluationsHolder #type: #number ) #(#InputFieldSpec #layout: #(#LayoutFrame 160 0 142 0 260 0 163 0 ) #name: #populationSize #model: #populationSizeHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 24 0 143 0 ) #name: #sizeOfPopulation #label: 'Population size:' ) #(#LabelSpec #layout: #(#LayoutOrigin 24 0 180 0 ) #name: #outputFreq #label: 'Output frequency:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 160 0 179 0 260 0 200 0 ) #name: #outputFrequency #model: #outputFrequencyHolder #type: #number ) #(#LabelSpec #layout: #(#LayoutOrigin 24 0 213 0 ) #name: #randomSeed #label: 'Random Seed:' ) #(#InputFieldSpec #layout: #(#LayoutFrame 160 0 212 0 260 0 233 0 ) #name: #randomSeed #model: #randomSeedHolder #type: #number ) #(#CompositeSpecCollection #collection: #(#(#GroupBoxSpec #layout: #(#LayoutFrame 0 0 0 0 259 0 45 0 ) #label: 'Selection Mechanism' ) #(#RadioButtonSpec #layout: #(#LayoutOrigin 10 0 20 0 ) #name: #selectionMechanism #model: #selectionMechanismHolder #label: 'Roulette Wheel' #select: #roulette ) #(#RadioButtonSpec #layout: #(#LayoutOrigin 162 0 21 0 ) #name: #selectionMechanism #model: #selectionMechanismHolder #label: 'Tournament' #select: #tournament ) ) #compositeSpec: #(#CompositeSpec #layout: #(#Rectangle 13 254 272 299 ) ) ) ) ) )! !

GASTEUI subclass: #GASTEBehaviourEditor
	instanceVariableNames: 'behaviourHolder behaviourClass tokenIncrement '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEBehaviourEditor methodsFor: 'aspects'!

behaviourHolder
	"This method was generated by UIDefiner. The initialization provided 
	below may have been preempted by an initialize method."

	^behaviourHolder isNil ifTrue: [behaviourHolder := String new asValue] ifFalse: [behaviourHolder]! !

!GASTEBehaviourEditor methodsFor: 'initialization'!

setupFunctionsOrTerminals: aString arityRequired: aBoolean
	"This causes the behaviourHolder to be initialized correctly"
	| listOfFunctions arity behaviourText |

	listOfFunctions := (self selectedClass: aString) organization listAtCategoryNamed: (GeneticProgramming functionsProtocol).

	aBoolean ifTrue: [
		arity := (self selectedClass: aString) perform: (GeneticProgramming arityMethod).
		behaviourText := ''.
		listOfFunctions with: arity do: [:fn :ar | 
			behaviourText := behaviourText, (fn asString, ' ',  ar printString, '\' withCRs).
		].
	]

	ifFalse: [behaviourText := listOfFunctions inject: '' into: [:textSoFar :fn | textSoFar, fn asString, '\' withCRs]].
	self behaviourHolder value: behaviourText.! !

!GASTEBehaviourEditor methodsFor: 'compilation'!

commentText
	"This just returns the comment text used for all compiled methods"
	^'	"This method was created by GASTE"'.!

compileBehaviour: tokens
	"This compiles the tokens to stubs in the appropriate behaviour protocol 
	of the selected class"
	tokens isNil ifFalse: [
		1 to: tokens size by: self tokenIncrement do: [:i |
			self compiledProgramFunctionOrTerminal: (tokens at: i)
		].
	].!

compiledProgramFunctionOrTerminal: aByteSymbol
	"This first determines whether the method is already defined. If it is not,
	a new method is added to the behaviour protocol for the instance"
	self compiledProgramFunctionOrTerminal: aByteSymbol classified: (GeneticProgramming functionsProtocol).!

compiledProgramFunctionOrTerminal: aByteSymbol classified: aSymbol
	"This first determines whether the method is already defined. If it is not,
	a new method is added to the behaviour protocol for the instance"

	| classBeingCoded wantToContinue size methodName |

	"Make sure that the method name is terminated in a colon"
	size := aByteSymbol size.
	((aByteSymbol at: size) = $:)
			ifFalse: [methodName := (aByteSymbol, ':') asSymbol]
			ifTrue: [methodName := aByteSymbol].

	classBeingCoded := self selectedClass: self behaviourClass.
	wantToContinue := true.
	(classBeingCoded canUnderstand: methodName) ifTrue: [
		wantToContinue := Dialog confirm: 'Do you want to modify the behaviour of the method ', methodName asString, '?'.
	].
	wantToContinue ifTrue: [
		classBeingCoded compile: (self defineFunction: methodName asString)  classified: aSymbol
	].!

defineFunction: aByteSymbol
	"This just creates the text for the compiled method"
	^(aByteSymbol asString, ' anEnv\', self commentText, '\',  '	^self') withCRs.!

tokenizeText
	"This returns the tokens in the input text"
	| tokens |
	tokens := (Scanner new) scanTokens: self behaviourHolder value.
	^tokens! !

!GASTEBehaviourEditor methodsFor: 'menu processing'!

buildBehaviour
	"This just does the compilation of the text -- stubs are not created"
	| tokens |
	tokens := self tokenizeText.
	^(self checkTokens: tokens) 
		ifFalse: [Dialog warn: 'Build errors detected, please correct'. nil.]
		ifTrue: [tokens].!

defineBehaviour
	"This just does the compilation of the text -- stubs are created"
	self compileBehaviour: self buildBehaviour.!

editBehaviour
	"This allows a user to browse the behaviour of the chosen class"
	Browser newOnClass: (self selectedClass: self dialog objectClass).!

editBehaviour: aString
	"This allows the user to browse the chosen class"
	Browser newOnClass: (self selectedClass: aString).! !

!GASTEBehaviourEditor methodsFor: 'accessing'!

behaviourClass
	"This returns the instance variable"
	^behaviourClass.!

behaviourClass: aString
	"This sets the instance variable"
	^behaviourClass := aString.!

tokenIncrement
	"This returns the instance variable"
	^tokenIncrement.!

tokenIncrement: anInteger
	"This sets the instance variable"
	^tokenIncrement := anInteger.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTEBehaviourEditor class
	instanceVariableNames: ''!


!GASTEBehaviourEditor class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	^#(#FullSpec #window: #(#WindowSpec #label: 'Behaviour Editor' #min: #(#Point 344 311 ) #max: #(#Point 344 311 ) #bounds: #(#Rectangle 270 230 614 541 ) ) #component: #(#SpecCollection #collection: #(#(#LabelSpec #layout: #(#LayoutOrigin 0 0.0473934 0 0.0558376 ) #name: #listLabel #label: 'List of functions or terminals' ) #(#TextEditorSpec #layout: #(#LayoutFrame 0 0.0336134 0 0.106509 0 0.97479 0 0.778106 ) #name: #behaviourText #model: #behaviourHolder #menu: #behaviourMenu ) #(#ActionButtonSpec #layout: #(#LayoutFrame 0 0.337209 0 0.819936 0 0.593023 0 0.945338 ) #name: #closeButton #model: #clickedClose #label: 'Close' #defaultable: true ) ) ) )! !

!GASTEBehaviourEditor class methodsFor: 'resources'!

behaviourMenu
	"UIMenuEditor new openOnClass: self andSelector: #behaviourMenu"

	^#(#PopUpMenu #('Build' 'Define' 'Edit') #() #(#buildBehaviour #defineBehaviour #editBehaviour) ) decodeAsLiteralArray! !

GASTEBehaviourEditor subclass: #GASTEFunctionsEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEFunctionsEditor methodsFor: 'initialization'!

postBuildWith: aBuilder
	"This changes the label on the list"
	(aBuilder componentAt: #listLabel) labelString: 'Functions'.!

preBuildWith: aBuilder
	"This changes the label on the list and fills the list correctly"
	self tokenIncrement: 2.
	self behaviourClass: self dialog objectClass.
	self setupFunctionsOrTerminals: self dialog objectClass arityRequired: true.! !

!GASTEFunctionsEditor methodsFor: 'compilation'!

arityMethod: aString
	"This creates the arity method string, which is then compiled"

	^('arity\', self commentText, '\	^', aString, '.') withCRs.!

checkTokens: tokens
	"This checks the tokenized text for syntactic correctness"
	| size errorCheck i |
	size := tokens size.
	size even ifTrue: [
		errorCheck := true.
		i := 1.
		[errorCheck and: [i < size]] whileTrue: [
			errorCheck := ((tokens at: i) isKindOf: ByteSymbol) and: [(tokens at: (i+1)) isKindOf: Integer].
			i := i + 2.
		].
		^errorCheck.
	].
	^false.!

compileBehaviour: tokens
	"This compiles the tokens to stubs in the appropriate behaviour protocol 
	of the selected class"

	super compileBehaviour: tokens.
	self defineArity: tokens.!

defineArity: tokens
	"This creates the arity method in the appropriate behaviour protocol 
	of the selected class"

	| size arityArray |
	size := tokens size.
	arityArray := '#( '.
	2 to: size by: 2 do: [:i |
		arityArray := arityArray, (tokens at: i) printString, ' '.
	].
	arityArray := arityArray, ')'.
	"Array string is created, so now define the method"
	(self selectedClass: self dialog objectClass) class compile: (self arityMethod: arityArray)  classified: (GeneticProgramming arityProtocol).! !

GASTEBehaviourEditor subclass: #GASTEEvaluationEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEEvaluationEditor methodsFor: 'menu processing'!

defineBehaviour
	"This compiles the eval:, preEval: and postEval: methods"
	(self selectedClass: self dialog objectClass) compile: (self behaviourHolder value) classified: (GeneticProgramming evalProtocol).
	(self selectedClass: (GeneticProgramming terminalsClass: self dialog objectClass)) compile: (self behaviourHolder value) classified: (GeneticProgramming evalProtocol).! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GASTEEvaluationEditor class
	instanceVariableNames: ''!


!GASTEEvaluationEditor class methodsFor: 'resources'!

behaviourMenu
	"UIMenuEditor new openOnClass: self andSelector: #behaviourMenu"

	^#(#PopUpMenu #( 'Define' 'Edit') #() #(#defineBehaviour #editBehaviour) ) decodeAsLiteralArray! !

GASTEEvaluationEditor subclass: #GASTEPostEvalEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEPostEvalEditor methodsFor: 'private'!

defaultPostEvalSource
	"This returns the default postEval: source"
	^((GeneticProgramming postEvalMethod), ' anEnv\	"Default postEval: source "\', self commentText, '\	^self') withCRs.! !

!GASTEPostEvalEditor methodsFor: 'initialization'!

postBuildWith: aBuilder
	"This changes the label on the list"
	(aBuilder componentAt: #listLabel) labelString: 'Post evaluation method'.!

preBuildWith: aBuilder
	"This gets the source for the preEval: method"
	| classSelected methodInClass |
	classSelected := self selectedClass: self dialog objectClass.
	methodInClass := classSelected selectorAtMethod: GeneticProgramming postEvalMethod ifAbsent: [nil].
	methodInClass isNil 
		ifFalse: [self behaviourHolder value: (classSelected sourceCodeAt: (GeneticProgramming postEvalMethod))]
		ifTrue: [self behaviourHolder value: self defaultPostEvalSource copy].! !

GASTEEvaluationEditor subclass: #GASTEEvalEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEEvalEditor methodsFor: 'private'!

defaultEvalSource
	"This returns the default eval: source"
	^((GeneticProgramming evalMethod), ' anEnv\	"Default eval: source "\', self commentText, '\	^self') withCRs.! !

!GASTEEvalEditor methodsFor: 'initialization'!

postBuildWith: aBuilder
	"This changes the label on the list"
	(aBuilder componentAt: #listLabel) labelString: 'Evaluation method'.!

preBuildWith: aBuilder
	"This gets the source for the eval: method"
	| classSelected methodInClass |
	classSelected := self selectedClass: self dialog objectClass.
	methodInClass := classSelected selectorAtMethod: GeneticProgramming evalMethod ifAbsent: [nil].
	methodInClass isNil 
		ifFalse: [self behaviourHolder value: (classSelected sourceCodeAt: (GeneticProgramming evalMethod))]
		ifTrue: [self behaviourHolder value: self defaultEvalSource copy].! !

GASTEEvaluationEditor subclass: #GASTEPreEvalEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTEPreEvalEditor methodsFor: 'initialization'!

postBuildWith: aBuilder
	"This changes the label on the list"
	(aBuilder componentAt: #listLabel) labelString: 'Pre-evaluation method'.!

preBuildWith: aBuilder
	"This gets the source for the preEval: method"
	| classSelected methodInClass |
	classSelected := self selectedClass: self dialog objectClass.
	methodInClass := classSelected selectorAtMethod: GeneticProgramming preEvalMethod ifAbsent: [nil].
	methodInClass isNil 
		ifFalse: [self behaviourHolder value: (classSelected sourceCodeAt: (GeneticProgramming preEvalMethod))]
		ifTrue: [self behaviourHolder value: self defaultPreEvalSource copy].! !

!GASTEPreEvalEditor methodsFor: 'private'!

defaultPreEvalSource
	"This returns the default preEval: source"
	^((GeneticProgramming preEvalMethod), ' anEnv\	"Default preEval: source "\', self commentText, '\	^(Smalltalk at: anEnv) new.') withCRs.! !

GASTEBehaviourEditor subclass: #GASTETerminalsEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GASTETerminalsEditor methodsFor: 'initialization'!

postBuildWith: aBuilder
	"This changes the label on the list and fills the list correctly"
	(aBuilder componentAt: #listLabel) labelString: 'Terminals'.!

preBuildWith: aBuilder
	"This changes the label on the list and fills the list correctly"
	self tokenIncrement: 1.
	self behaviourClass: (GeneticProgramming terminalsClass: self dialog objectClass).
	self setupFunctionsOrTerminals: (GeneticProgramming terminalsClass: self dialog objectClass) arityRequired: false.! !

!GASTETerminalsEditor methodsFor: 'compilation'!

checkTokens: tokens
	"This checks the tokenized text for syntactic correctness"
	| size errorCheck i |
	size := tokens size.
	errorCheck := true.
	i := 0.
	[errorCheck and: [i < size]] whileTrue: [
		i := i + 1.
		errorCheck := (tokens at: i) isKindOf: ByteSymbol.
	].
	^errorCheck.! !

AutoScrollingView subclass: #GeneticChartView
	instanceVariableNames: 'chartedSymbol chartedType xMax xMin xTics yMax yMin yTics scale chartOrigin title xLabel yLabel preference '
	classVariableNames: 'ChartedSymbol ChartedType Preference Title Xlabel Xmax Xmin Xtics Ylabel Ymax Ymin Ytics '
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticChartView methodsFor: 'updating'!

update: aSymbol with: anObject from: aSender
	"This ensures that the current model is updated and redisplayed. If
	the message refers to a non-charted variable, we ignore it"

	aSymbol == chartedSymbol ifTrue: [
		self updateChart: aSender.
		self scrollCheck.
	].
	aSymbol == #newStatistics ifTrue: [
		self updateChart: anObject.
	].!

updateChart: aSender
	"This updates the displayed chart"
	self model: aSender.
	self boundsCheck.
	self invalidate.! !

!GeneticChartView methodsFor: 'accessing'!

chartedSymbol
	"This returns the instance variable"
	^chartedSymbol.!

chartedSymbol: aSymbol
	"This sets the instance variable"
	self class chartedSymbol: aSymbol.
	^chartedSymbol := aSymbol.!

chartedType
	"This returns the instance variable"
	^chartedType.!

chartedType: anInteger
	"This sets the instance variable"
	self class chartedType: anInteger.
	^chartedType := anInteger.!

chartOrigin
	"This returns the instance variable"
	^chartOrigin isNil ifTrue: [self setChartOrigin] ifFalse: [chartOrigin].!

chartOrigin: aPoint
	"This sets the instance variable"
	^chartOrigin := aPoint!

preference
	"This returns the instance variable"
	^preference.!

preference: aSymbol
	"This sets the instance variable"
	self class preference: aSymbol.
	^preference := aSymbol.!

scale
	"This returns the instance variable"
	^scale isNil ifTrue: [self setScale] ifFalse: [scale].!

scale: anIntegerOrNil
	"This sets the instance variable"
	^scale := anIntegerOrNil.!

title
	"This returns the instance variable"
	^title.!

xLabel
	"This returns the instance variable"
	^xLabel.!

xMax
	"This returns the instance variable"
	^xMax.!

xMax: aFloat
	"This sets the instance variable"
	^xMax := aFloat.!

xMin
	"This returns the instance variable"
	^xMin.!

xMin: aFloat
	"This sets the instance variable"
	^xMin := aFloat.!

xTics
	"This returns the instance variable"
	^xTics.!

yLabel
	"This returns the instance variable"
	^yLabel.!

yMax
	"This returns the instance variable"
	^yMax.!

yMax: aFloat
	"This sets the instance variable"
	^yMax := aFloat.!

yMin
	"This returns the instance variable"
	^yMin.!

yMin: aFloat
	"This sets the instance variable"
	^yMin := aFloat.!

yTics
	"This returns the instance variable"
	^yTics.! !

!GeneticChartView methodsFor: 'scaling'!

setChartOrigin
	"This computes the chart origin."

	| text x y maxWidth |
	maxWidth := 0.
	yMin to: yMax by: yTics do: [:ticVal |
		text := ComposedText withText: ticVal printString.
		maxWidth < text width ifTrue: [maxWidth := text width]
	].
	x := maxWidth + (self class separation * 2) + self class ticLength + 1.
	y := text height + (self class separation * 2) + self class ticLength.
	self chartOrigin: (x @ y).
	^self chartOrigin.!

setOrigin
	"This computes the chart origin."

	| text x y |
	text := ComposedText withText: self yMax printString.
	x := text width + self class separation + 1.
	y := text height + self class separation.
	self chartOrigin: (x @ y).
	^self chartOrigin.!

setScale
	"This computes the chart scale. The size of the window is used to provide
	the mapping between (x,y) positions and screen coordinates."
	| size heightOfXLabel |
	heightOfXLabel := (ComposedText withText: self xLabel) height.
	size := self bounds corner - (self chartOrigin * 2).
	(yMax = yMin) ifTrue: [yMax := yMin + 1.0].
	^scale := (size x asFloat / (xMax - xMin)) @ ((size y - heightOfXLabel) asFloat / (yMax - yMin)).!

transform: aPoint
	"This transforms a chart point into view coordinates. The scale
	will be recomputed automatically, if necessary"
	| x y scalePt |
	scalePt := self scale.
	x := (aPoint x - xMin) * scalePt x.
	y := (yMax - aPoint y) * scalePt y.
	^x @ y + self chartOrigin.! !

!GeneticChartView methodsFor: 'scrolling'!

scrollCheck
	"This determines whether we should scroll the graph"
	|  yValues xValues pt |
	
	self preference == #scroll ifTrue: [

		yValues := self model at: self chartedSymbol.
		xValues := self model at: #evaluations.
		pt := self transform: xValues last @ (yValues last at: self chartedType).
		(self bounds containsPoint: pt) ifFalse: [
			self positionTo: (self bounds corner - self bounds origin - pt - self class separation)
		].
	]
	ifFalse: ["Force recalculation of scale"
		self scale: nil.
		self chartOrigin: nil.
	].! !

!GeneticChartView methodsFor: 'displaying'!

displayAxesOn: aGC
	"Display the chart axes"

	self displayXaxisOn: aGC.
	self displayYaxisOn: aGC.!

displayChartOn: aGC
	"Display the whole chart"
	|  index yValues xValues  newChartPoint lastChartPoint |

	yValues := self model at: self chartedSymbol.
	xValues := self model at: #evaluations.
	index := self chartedType.

	lastChartPoint := nil.
	xValues with: yValues do: [:x :y |
		newChartPoint := self transform: x@(y at: index).
		(Circle center: newChartPoint radius: self class pointSize) displayFilledOn: aGC.
		lastChartPoint isNil 
			ifFalse: [(LineSegment from: lastChartPoint to: newChartPoint) displayStrokedOn: aGC].
		lastChartPoint := newChartPoint.
	].!

displayLabelsOn: aGC
	"Display the chart labels"

	self displayXlabelOn: aGC.
	self displayYlabelOn: aGC.!

displayOn: aGC
	"Display the whole chart, including axes, labels and title"

	self displayAxesOn: aGC.
	self displayLabelsOn: aGC.
	self displayChartOn: aGC.
	self displayTitleOn: aGC.!

displayTitleOn: aGC
	"Display the chart title"
	| bottom top text x y |
	bottom := self transform: xMin @ yMin.
	top := self transform: xMax @ yMin.

	text := ComposedText withText: self title.
	x := ((top x - bottom x - (text width / 2) truncated) / 2) truncated.
	y := self class separation.
	text displayOn: aGC at: x @ y.!

displayXaxisOn: aGC
	"Display the chart X axis"

	| bottom top pt text |
	bottom := self transform: xMin @ yMin.
	top := self transform: xMax @ yMin.

	(LineSegment from: top to: bottom) displayStrokedOn: aGC.

	"Display the tics and labels"
	xMin to: xMax by: xTics do: [ :ticPt |
		pt := self transform: ticPt @ yMin.
		(LineSegment from: pt to: (pt+(0 @ self class ticLength))) displayStrokedOn: aGC.
		text := ComposedText withText: ticPt printString.
		text displayOn: aGC at: ((pt x - (text width / 2) truncated) @ (pt y + self class ticLength + self class separation)).
	].!

displayXlabelOn: aGC
	"Display the chart x axis label"
	| bottom top text x y |
	bottom := self transform: xMin @ yMin.
	top := self transform: xMax @ yMin.

	text := ComposedText withText: self xLabel.
	x := ((top x - bottom x - (text width / 2) truncated) / 2) truncated.
	y := top y + self class separation + self class ticLength + text height.
	text displayOn: aGC at: x @ y.!

displayYaxisOn: aGC
	"Display the chart Y axis"

	| bottom top pt text |
	bottom := self transform: xMin @ yMin.
	top := self transform: xMin @ yMax.

	(LineSegment from: top to: bottom) displayStrokedOn: aGC.

	"Display the tics and labels"
	yMin to: yMax by: yTics do: [ :ticPt |
		pt := self transform: xMin @ ticPt.
		(LineSegment from: pt to: (pt-(self class ticLength @ 0))) displayStrokedOn: aGC.
		text := ComposedText withText: ticPt printString.
		text displayOn: aGC at: (self class separation @ (pt y - (text height / 2) truncated)).
	].!

displayYlabelOn: aGC
	"Display the chart x axis label"

	| text |
	text := ComposedText withText: self yLabel.
	text displayOn: aGC at: self class separation @ self class separation.! !

!GeneticChartView methodsFor: 'private'!

boundsCheck
	"This checks to see if we have enough space defined
	for xMax, etc."

	| yValues xValues index y |
	yValues := self model at: self chartedSymbol.
	xValues := self model at: #evaluations.
	index := self chartedType.

	xValues do: [:x |		
		x > xMax ifTrue: [self xMax: (((x / self xTics) truncated + 1) * self xTics)].
		x < xMin ifTrue: [self xMin: (((x / self xTics) truncated - 1) * self xTics)].
	].
	yValues do: [:yv |
		y := yv at: index.	
		y > yMax ifTrue: [self yMax: (((y / self yTics) truncated + 1) * self yTics)].
		y < yMin ifTrue: [self yMin: (((y / self yTics) truncated - 1) * self yTics)].
	].

	"Ensure that we have enough space for the chart"
	scrollOffset isNil ifFalse: [
		scrollOffset extraSpace: (scrollOffset value corner: (((xMax @ yMax) max: Screen default bounds corner) - scrollOffset value)) asValue.
	]! !

!GeneticChartView methodsFor: 'initialization'!

initialize
	"This initializes the newly-created instance"

	self chartOrigin: self class chartOrigin.
	self chartedSymbol: self class chartedSymbol.
	self chartedType: self class chartedType.
	self xMax: self class xMax xMin: self class xMin xTics: self class xTics.
	self yMax: self class yMax yMin: self class yMin yTics: self class yTics.
	self title: self class title xLabel: self class xLabel yLabel: self class yLabel.
	self preference: self class preference.! !

!GeneticChartView methodsFor: 'actions'!

chartedSymbol: aSymbol type: anInteger
	"This resets the view charted symbol and type"
	self chartedSymbol: aSymbol.
	self chartedType: anInteger.
	self invalidate.!

title: aString1 xLabel: aString2 yLabel: aString3
	"This updates the view variables"
	self class title: aString1 copy.
	self class xLabel: aString2 copy.
	self class yLabel: aString3 copy.

	title := aString1 copy.
	xLabel := aString2 copy.
	yLabel := aString3 copy.!

xMax: aFloat1 xMin: aFloat2 xTics: aFloat3
	"This updates the stored X values"
	xMax := aFloat1.
	xMin := aFloat2.
	xTics := aFloat3.

	self class xMax: xMax.
	self class xMin: xMin.
	self class xTics: xTics.

	"Force recalculation of scale and origin"
	self scale: nil.
	self chartOrigin: nil.!

yMax: aFloat1 yMin: aFloat2 yTics: aFloat3
	"This updates the stored Y values"
	yMax := aFloat1.
	yMin := aFloat2.
	yTics := aFloat3.

	self class yMax: yMax.
	self class yMin: yMin.
	self class yTics: yTics.

	"Force recalculation of scale and origin"
	self scale: nil.
	self chartOrigin: nil.! !

!GeneticChartView methodsFor: 'bounds'!

limits
	"Answer the size of an A4 page in landscape" 
	^792@612.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

GeneticChartView class
	instanceVariableNames: ''!


!GeneticChartView class methodsFor: 'instance creation'!

new
	"This creates an initializes a view instance"
	^super new initialize.! !

!GeneticChartView class methodsFor: 'accessing'!

chartedSymbol
	"This returns the class variable"
	^ChartedSymbol.!

chartedSymbol: aSymbol
	"This sets the class variable"
	^ChartedSymbol := aSymbol.!

chartedType
	"This returns the class variable"
	^ChartedType.!

chartedType: anInteger
	"This sets the class variable"
	^ChartedType := anInteger.!

preference
	"This returns the class variable"
	^Preference!

preference: aSymbol
	"This sets the class variable"
	^Preference := aSymbol.!

title
	"This returns the instance variable"
	^Title!

title: aString
	"This sets the instance variable"
	^Title := aString!

xLabel
	"This returns the instance variable"
	^Xlabel.!

xLabel: aString
	"This sets the instance variable"
	^Xlabel := aString!

xMax
	"This returns the instance variable"
	^Xmax.!

xMax: aFloat
	"This sets the instance variable"
	^Xmax := aFloat.!

xMin
	"This returns the instance variable"
	^Xmin.!

xMin: aFloat
	"This sets the instance variable"
	^Xmin := aFloat.!

xTics
	"This returns the instance variable"
	^Xtics.!

xTics: aFloat
	"This sets the instance variable"
	^Xtics := aFloat.!

yLabel
	"This returns the instance variable"
	^Ylabel.!

yLabel: aString
	"This sets the instance variable"
	^Ylabel := aString!

yMax
	"This returns the instance variable"
	^Ymax.!

yMax: aFloat
	"This sets the instance variable"
	^Ymax := aFloat.!

yMin
	"This returns the instance variable"
	^Ymin.!

yMin: aFloat
	"This sets the instance variable"
	^Ymin := aFloat.!

yTics
	"This returns the instance variable"
	^Ytics.!

yTics: aFloat
	"This sets the instance variable"
	^Ytics := aFloat.! !

!GeneticChartView class methodsFor: 'class initialization'!

initialize
	"GeneticChartView initialize"
	ChartedSymbol := GeneticStatistics statisticsStored at: 2.
	ChartedType := 1.

	Preference := #scale.

	Ytics := 0.1.
	Ymax := 1.0.
	Ymin := 0.0.
	
	Xtics := 100.
	Xmax := 1000.
	Xmin := 0.

	Ylabel := 'Fitness'.
	Xlabel := 'Trials'.
	Title := 'Fitness vs Trials'.! !

!GeneticChartView class methodsFor: 'class constants'!

chartOrigin
	"This is the offset of the chart start from the edge"
	^20@20.!

pointSize
	"This is the radius of the circle defining a point"
	^2!

separation
	"This is the separation between items"
	^2!

ticLength
	"This is the length of a tic mark"
	^2! !

ControllerWithMenu subclass: #GeneticProgramController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAUI'!


!GeneticProgramController methodsFor: 'menu specification'!

pullDownMenu
	"This specifies the structure of the menu"
	| mb |
	mb := MenuBuilder new.
	mb add: 'Hardcopy'->#hardcopy.
	^mb menu.! !

!GeneticProgramController methodsFor: 'initialization'!

initialize
	"This initializes the controller"
	super initialize.
	self menuHolder value: self pullDownMenu.! !
GASTEFileListBrowser initialize!

GeneticChartView initialize!

