// gpv.hpp

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


#ifndef __GPV

#define __GPV

#include "gp.hpp"
#include <fstream.h>

struct GPVariables
{
  unsigned int PopulationSize,
	       NumberOfGenerations,
	       NumberOfADFs,
	       CreationType,
	       NumberOfEvaluations,
	       MaximumFitness,
	       MaximumDepthForCreation,
	       MaximumDepthForCrossover,
	       NumberToMutate;
	unsigned long MaximumSumFitness;

// Functions
  friend ostream& operator << (ostream&, GPVariables* );

  GPVariables(int, int);
  void Save( ostream& );
  void Load( istream& );
};
#endif
