// cross.cc -> crosses two gps together to produce resulting child

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// 10 November 93 apf
// v0.4 21 May 1994

// Cross is made up of two components cut and splice. One ADF of the mother
// GP is cut and the SAME ADF is cut on the father.  The beginning of mother
// and end of the father's cut are then spliced together because of closure
// property in GP all this works, surprising isnt it.  While this may seem
// easy to explain in english in compure code this was a bit of a bugger and
// is quite complicated.. by the by I have Eurovision Song Contest on in the
// background (1994 with Terry Wogan) and it is really, really bad.

#include "gp.hpp"
// for random number generator
#include "gprand.hpp"


// Mum and Dad gps are crossed and result but in the object connected to the system
void GP::Cross( GP *mum, GP *dad, int maxdepthforcrossover )
{
	Gene *cutchild, *cutdad;
	unsigned int MaxDepth = 0;

// work out which adf branch we are going to cut from......
	int randtree = gp_rand() % RootandADF;

	do
	{
// copy the gp of mother into genetic tree of child
		Copy( mum );

// select cut position of child from this new copied tree 
		cutchild = (*(ppgHeader + randtree))->Choose();

// select cut point from the same tree on the father...
		cutdad = (*( (dad->ppgHeader) + randtree ))->Choose();

// Basically these next components are a splice operation for the GP
// We copy into cutpoint of new child so this must be deleted if it exists
		if ( cutchild->pgChild ) delete cutchild->pgChild;

// if dad had any children....
		if ( cutdad->pgChild )
		{
// copy this into new child
			if ( !(cutchild->pgChild = new Gene(cutdad->pgChild)) )
				ExitSystem( "GP::Cross" );
		}
// otherwise set child to NULL
		else cutchild->pgChild = NULL;

// copy dads value into mother....
		cutchild->iValue = cutdad->iValue;

// Note we do not change pgNext value as this must stay the same...

// Here I calculate the maximum depth of this new tree and only that tree
// as other adf trees I assume to be under the maximum depth of crossover
		MaxDepth = 0;
		(*(ppgHeader + randtree))->Depth( 0, MaxDepth );

//  make sure that max depth is not mad depth of crossover
	} while ( MaxDepth > maxdepthforcrossover );

// calculate the total length of this new string there is quicker way of
// doing this by remembering things at the top and subtracting and adding
// values together but frankly length is a very fast operation so....
	Length();
}

// cross.cc
