// trail.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------



/*                        Santa Fe Trail Builder
													\\\\\\\\\\\//////////

	 This is the trail in John Koza's paper in ALife II.....
	 Designs and builds santa fe trail.......................
	 Version 0.10
		APF 7/03/93
	 Version 0.2
		apf 7 June 1994
*/


#include "trail.hpp"
#include <fstream.h>

/*  Function Prototypes..............................................*/
void CreateWorld( void );
void CreateTrail( void );

/* GLOBAL variables..................................................*/
unsigned short int World[World_Horizontal][World_Vertical];
unsigned short int ConstantWorld[World_Horizontal][World_Vertical];

// external definitions ( this is quicker than calling whole gene header )
extern void ExitSystem( char * );

/* Making the array sub routine......................................*/
void CreateWorld( void )
{
	ifstream ifs( "santafe.trl" );
	if ( !(ifs) ) ExitSystem( "CreateWorld()::There is no trail data file" );
	else
	{
	  int i = 0, j = 0;
		char ch = '0';

// Move to the correct position in the data file. The area below hash   
	  while ( ch != '#' ) ifs >> ch;
	
	  while ( i < World_Horizontal )
	  {
	    ifs >> ch;
// the subtraction of 48 converts the character string to a numerical value....
			ConstantWorld[i][j] = ch - 48;
			j++;

	    if (j == World_Vertical) 
	    {
	 i++;
	       j=0;
	    }
		}
	}
}

void CreateTrail( void )
{
	int i,j;
	for ( i = 0; i < World_Horizontal; i++ )
		for ( j = 0; j < World_Vertical; j++ )
			World[i][j] = ConstantWorld[i][j];

}

// trail.cc 
