// gp.cpp
// By Adam Fraser 14/10/93

// Genetic Program definitions for Class system...

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/


#include "gp.hpp"

#include <stdlib.h>   // for rand()

// Print functions..... using iostream

ostream& operator << ( ostream& os, GP *pgp )
{
	if ( pgp ) os << "(" << pgp->pgHeader << endl;
	else       os << "NULL" << endl;

	return os;
}

// Class function definitions


GP::GP()
{
	pgHeader = NULL;
	iFitness = 0;
	iLength = 0;
	pgpNext = NULL;
}

// Destroys a GP would  be stupid to misuse....   07/06/93

GP::~GP()
{
	if ( this ) {	if ( pgHeader )	delete pgHeader; }
}

// Copies a genetic program from one place to another with NO links to old
// gp...................     APF 09/06/93

// Also sets copy fitness to old fitness and length to old length

GP::GP(GP *pgp)
{
	if ( pgp->pgHeader )
	{
		if ( !(pgHeader = new Gene( pgp->pgHeader )) )
			ExitSystem("GP::GP( GP* )");

		iLength  = pgp->iLength;
		iFitness = pgp->iFitness;
	}
	else pgHeader = NULL;
}

// Copy GP leaving the GP header memory at the same location used in the
// reproduction operation...
// another way of explaining this is that is an overwrite copy....

void GP::Copy( GP *pgp )
{
	if ( pgHeader )	delete pgHeader;

	if ( pgp->pgHeader )
	{
		if ( !(pgHeader = new Gene( pgp->pgHeader )) ) ExitSystem( "GP::Copy" );
	}
	else pgHeader = NULL;

	iFitness = pgp->iFitness;
	iLength  = pgp->iLength;
}


// Returns length of a genetic program     APF 08/06/93
// This is, of course, also the structural complexity of the system.....

int GP::Length()
{
	int iLen = 0;

	if ( this ) {	if ( pgHeader ) pgHeader->Length( iLen ); }

	iLength = iLen;

	return iLength;
}

//Returns maximum depth, useful for crossover and maybe elsewhere APF 10/06/93

int GP::Depth()
{
	int iDepth = 0;
	int iMaxdepth = 0;

	if ( this ) {	if ( pgHeader )	pgHeader->Depth( iDepth, iMaxdepth ); }

	return iMaxdepth;
}

// Returns the Nth gene of the GP AND all its further ancestors. This function
// is useful  for crossover...........					APF 9/06/93

static int iLengthCount;

Gene* GP::Nth( int n )
{
	if ( ( n == 0 ) || (!(this)) || (!(pgHeader)) ) ExitSystem( "GP::Nth" );
	iLengthCount = n;
	return pgHeader->Nth();
}

Gene* Gene::Nth()
{
	if ( --iLengthCount == 0 ) return this;

	Gene *pg = NULL;

	if ( pgChild ) pg = pgChild->Nth();

	if ( ( pgNext ) && ( pg == NULL ) ) pg = pgNext->Nth();
											// checks if found in child
	return pg;
}

// returns the a random gene selected by random number generator
// obviously it is quite important to know the length of the gp
//  before calling this function..

// this also adds a component laid down by Koza that there will be a 90%
//   chance of getting a function. This is produced by going through a loop
//   10 times and returning ONLY if a function is found. This should give a
//   greater chance of getting a function. Note that if you have a single node
//   this function will not hang unlike other components I have written (!).

Gene* GP::Choose()
{
	if ( (!(this)) || (!(pgHeader)) ) ExitSystem( "GP::Choose" );
	else if ( iLength == 0 ) ExitSystem( "GP::Choose" );

	Gene *pg;

	for ( int i = 0; i < 10; i++ )
	{
		pg = Nth( ( rand() % iLength ) + 1 );
		if ( pg->pgChild ) return pg;
	}

	return pg;     // if after 10 loops still don't have function o/p terminal
}


