#!/usr/sww/bin/perl

%nameMap = (
	'ajm', 'antJohnMuir',
	'ala', 'antLosAltos',
	'asf', 'antSantaFe',
	'blb', 'blobSample',
	'dgc', 'discrGameCo',
	'dgx', 'discrGameX',
	'dgo', 'discrGameO',
	'm03', 'multi03',
	'm06', 'multi06',
	'm11', 'multi11',
	'neu', 'neural',
	'rnd', 'rand',
	'sym', 'symregress',
);

@order = ('m03', 'dgx', 'dgo', 'dgc', 'neu', 'blb', 'sym', 'ajm', 'asf', 'm06', 'm11', 'ala', 'rnd');

select(STDOUT); $| = 1; select(STDERR);

foreach $i (@order) {
  if (!open(RUN, "tools/longrun -n 5 $nameMap{$i} > longrun.$i 2>&1 |")) {
    print STDERR "Couldn't fork longrun process for $nameMap{$i}\n";
  } else {
    print "tools/longrun $nameMap{$i} > longrun.$i\n";
    while (<RUN>) {
      print $_;
    }
    close(RUN);
  }
}
