/*
 * Copyright (C) 1993 by Dave Glowacki
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#include "resultlist.h"
#include "proto.h"

int
resultListCompare(rlp1, rlp2)
const resultList *rlp1, *rlp2;
{
  int i;

  /* make sure they're the same length */
  if (resultListLength(rlp1) != resultListLength(rlp2))
    return(0);

  /* compare results in each list */
  for (i = 0; i < resultListLength(rlp1); i++)
    if (resultCompare(resultListEntry(rlp1, i),
		      resultListEntry(rlp2, i)) == 0)
      return(0);
          
  /* must be identical */
  return(1);
}

int
resultListToString(rlp, cstr)
const resultList *rlp;
charString *cstr;
{
  int rval = 0;
  char buffer[16];
  int i;

  rval = charStringCatenate(cstr, "<");
  if (resultListLength(rlp) <= 0) {
    if (!rval)
      rval = charStringCatenate(cstr, "**empty list**");
  } else {
    for (i = 0; !rval && i < resultListLength(rlp); i++) {
      sprintf(buffer, "%s%d: ", (i == 0 ? "" : " "), i);
      rval = charStringCatenate(cstr, buffer);
      if (!rval)
        resultToString(resultListEntry(rlp, i), cstr);
    }
  }  
   
  if (!rval)
    rval = charStringCatenate(cstr, ">");
  return(rval);
}

void
resultListFree(rlp)
resultList *rlp;
{
  int i;

  for (i = 0; i < resultListLength(rlp); i++)
    resultFree(resultListEntry(rlp, i));
  genericListFree(rlp);
}

#ifdef DEBUG_RESULTLIST

#define TEST_LENGTH	10

int main P((NOARGS));

int
main()
{
  resultList *rlp, *nrlp;
  int i, ival[TEST_LENGTH];
  charString *cstr;
  result *rp;
  char buffer[32];

#ifdef _DEBUG_MALLOC_INC
  {
    union dbmalloptarg    moa;
i
    moa.i = 1;
    dbmallopt(MALLOC_CKCHAIN, &moa);
  }
#endif

  rlp = resultListCreate(TEST_LENGTH-1);
  if (!rlp) {
    printf("resultList creation failed\n");
    exit(1);
  }

  cstr = charStringCreate();
  for (i = 0; i < TEST_LENGTH; i++) {
    ival[i] = TEST_LENGTH - i;
    rp = resultCreate(dtInteger, ival[i]);
    charStringSet(cstr, "Result is '");
    resultToString(rp, cstr);
    charStringCatenate(cstr, "'");
    charStringPrint(cstr);

    if (!rp)
      printf("result creation failed (#%d)\n", i);
    else {
      if (resultListAdd(rlp, rp)) {
        printf("Add failed for %d\n", i);
	fflush(stdout);
	resultFree(rp);
      } else {
	sprintf(buffer, "%d elements in list: ", resultListLength(rlp));
	charStringSet(cstr, buffer);
	resultListToString(rlp, cstr);
	charStringPrint(cstr);
      }
    }
  }

  nrlp = resultListCopy(rlp);
  sprintf(buffer, "%d elements in list: ", resultListLength(nrlp));
  charStringSet(cstr, buffer);
  resultListToString(nrlp, cstr);
  charStringPrint(cstr);

  resultListFree(nrlp);
  resultListFree(rlp);

#ifdef _DEBUG_MALLOC_INC
  malloc_dump(1);
#endif

  return(0);
}
#endif /* DEBUG_RESULTLIST */
