/*
 * Copyright (C) 1993 by Dave Glowacki
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#include <stdio.h>
#include "constant.h"
#include "variable.h"
#include "operator.h"
#include "result.h"
#include "constntsrc.h"
#include "operatrsrc.h"
#include "object.h"
#include "proto.h"

object *
objectCopy(ob, everything)
const object *ob;
int everything;
{
  /* make sure there's something to copy */
  if (ob)
    switch (objectType(ob)) {
    case otConstant:
      return((object *)constantCopy((const constant *)ob));
    case otVariable:
      return((object *)variableCopy((const variable *)ob));
    case otSimpleOperator:
    case otComplexOperator:
      return((object *)operatorCopy((const operator *)ob, everything));
    case otResult:
      return((object *)resultCopy((const result *)ob));
    case otConstantSrc:
      return((object *)constantSrcCopy((const constantSrc *)ob));
    case otSimpleOperatorSrc:
    case otComplexOperatorSrc:
      return((object *)operatorSrcCopy((const operatorSrc *)ob));
    }
  return(0);
}

result *
objectEval(ob, envp)
const object *ob;
void *envp;
{
  if (ob)
    switch (objectType(ob)) {
    case otConstant:
      return(constantEval((const constant *)ob));
    case otVariable:
      return(variableEval((const variable *)ob));
    case otSimpleOperator:
      return(simpleOperatorEval((const operator *)ob, envp));
    case otComplexOperator:
      return(complexOperatorEval((const operator *)ob, envp));
    case otResult:
      return(resultCopy((const result *)ob));
    case otConstantSrc:
      return(constantSrcEval((const constantSrc *)ob));
    case otSimpleOperatorSrc:
    case otComplexOperatorSrc:
      return(operatorSrcEval((const operatorSrc *)ob));
    }
  return(0);
}

int
objectCount(ob, internal)
const object *ob;
int internal;
{
  if (ob)
    switch (objectType(ob)) {
    case otConstant:
      return(constantCount((const constant *)ob, internal));
    case otVariable:
      return(variableCount((const variable *)ob, internal));
    case otSimpleOperator:
    case otComplexOperator:
      return(operatorCount((const operator *)ob, internal));
    case otResult:
      return(resultCount((const result *)ob, internal));
    case otConstantSrc:
      return(constantSrcCount((const constantSrc *)ob, internal));
    case otSimpleOperatorSrc:
    case otComplexOperatorSrc:
      return(operatorSrcCount((const operatorSrc *)ob, internal));
    }
  return(0);
}

int
objectDepth(ob, currentDepth)
const object *ob;
int currentDepth;
{
  if (ob)
    switch (objectType(ob)) {
    case otConstant:
      return(constantDepth((const constant *)ob, currentDepth));
    case otVariable:
      return(variableDepth((const variable *)ob, currentDepth));
    case otSimpleOperator:
    case otComplexOperator:
      return(operatorDepth((const operator *)ob, currentDepth));
    case otResult:
      return(resultDepth((const result *)ob, currentDepth));
    case otConstantSrc:
      return(constantSrcDepth((const constantSrc *)ob, currentDepth));
    case otSimpleOperatorSrc:
    case otComplexOperatorSrc:
      return(operatorSrcDepth((const operatorSrc *)ob, currentDepth));
    }
  return(0);
}

int
objectCompare(ob1, ob2)
const object *ob1, *ob2;
{
  if (ob1 && ob2 && (objectType(ob1) == objectType(ob2)))
    switch (objectType(ob1)) {
    case otConstant:
      return(constantCompare((const constant *)ob1, (const constant *)ob2));
    case otVariable:
      return(variableCompare((const variable *)ob1, (const variable *)ob2));
    case otSimpleOperator:
    case otComplexOperator:
      return(operatorCompare((const operator *)ob1, (const operator *)ob2));
    case otResult:
      return(resultCompare((const result *)ob1, (const result *)ob2));
    case otConstantSrc:
      return(constantSrcCompare((const constantSrc *)ob1, (const constantSrc *)ob2));
    case otSimpleOperatorSrc:
    case otComplexOperatorSrc:
      return(operatorSrcCompare((const operatorSrc *)ob1, (const operatorSrc *)ob2));
    }
  return(0);
}

object **
objectNodePtr(obp, count, nodeNumber, internal, typeptr)
const object **obp;
int *count;
int nodeNumber, internal;
datatype *typeptr;
{
  if (obp && *obp)
    switch (objectType(*obp)) {
    case otConstant:
      return((object **)constantNodePtr((const constant **)obp, count,
					nodeNumber, internal, typeptr));
    case otVariable:
      return((object **)variableNodePtr((const variable **)obp, count,
					nodeNumber, internal, typeptr));
    case otSimpleOperator:
    case otComplexOperator:
      return((object **)operatorNodePtr((const operator **)obp, count,
					nodeNumber, internal, typeptr));
    case otResult:
      return((object **)resultNodePtr((const result **)obp, count,
				      nodeNumber, internal, typeptr));
    case otConstantSrc:
      return((object **)constantSrcNodePtr((const constantSrc **)obp, count,
					   nodeNumber, internal, typeptr));
    case otSimpleOperatorSrc:
    case otComplexOperatorSrc:
      return((object **)operatorSrcNodePtr((const operatorSrc **)obp, count,
					   nodeNumber, internal, typeptr));
    }
  return(0);
}

int
objectStrChkpt(ob, checkpoint, cstr)
const object *ob;
bool checkpoint;
charString *cstr;
{
  if (ob)
    switch (objectType(ob)) {
    case otConstant:
      return(constantToString((const constant *)ob, cstr));
    case otVariable:
      return(variableToString((const variable *)ob, cstr));
    case otSimpleOperator:
    case otComplexOperator:
      if (checkpoint)
	return(operatorCheckpoint((const operator *)ob, cstr));
      else
	return(operatorToString((const operator *)ob, cstr));
    case otResult:
      return(resultToString((const result *)ob, cstr));
    case otConstantSrc:
      return(constantSrcToString((const constantSrc *)ob, cstr));
    case otSimpleOperatorSrc:
    case otComplexOperatorSrc:
      return(operatorSrcToString((const operatorSrc *)ob, cstr));
    }
  return(1);
}

void
objectFree(ob)
object *ob;
{
  if (ob)
    switch (objectType(ob)) {
    case otConstant:
      constantFree((constant *)ob);
      break;
    case otVariable:
      variableFree((variable *)ob);
      break;
    case otSimpleOperator:
    case otComplexOperator:
      operatorFree((operator *)ob);
      break;
    case otResult:
      resultFree((result *)ob);
      break;
    case otConstantSrc:
      constantSrcFree((constantSrc *)ob);
      break;
    case otSimpleOperatorSrc:
    case otComplexOperatorSrc:
      operatorSrcFree((operatorSrc *)ob);
      break;
    }
}
